/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilterList;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDetailFilterList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLAbstractBooleanFunction;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLBetween;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLIn;
import com.cognos.xqe.ast.sql.SQLIsNull;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.TransformationEngine;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.ApplyJoinFilterOptimization;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Pair;
import com.cognos.xqemoser.MoserRelationship;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

public class ApplyForceJoinFilterOptimization
extends RQPTransformation {
    public static final String APPLIED = "forceFJO";
    public static final String ORG_FLT_EXP = "orgFltExpr";
    public static final String PROP_FROM_DETAILFILTER = "fromV5Filter";

    public ApplyForceJoinFilterOptimization() {
        this.mName = "ApplyForceJoinFilterOptimization";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{301011};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        SQLJoin join = (SQLJoin)node;
        node.setPropertyValue(APPLIED, Boolean.TRUE);
        IRelationship relationship = (IRelationship)node.getPropertyValue("joinRelationship");
        if (!(relationship instanceof MoserRelationship)) {
            return;
        }
        IRelationship.JoinFilterType jft = (IRelationship.JoinFilterType)((Object)node.getPropertyValue("joinFilterType"));
        MoserRelationship moserRelationship = (MoserRelationship)relationship;
        List<MoserRelationship.MoserLink> links = moserRelationship.getLinks();
        if (links == null || links.isEmpty()) {
            return;
        }
        IQuerySubject leftQS = (IQuerySubject)relationship.getLeftRefObject();
        IQuerySubject rightQS = (IQuerySubject)relationship.getRightRefObject();
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(environment.getRequestEnvironment());
        PlanningEnvironment subPlanEnv = V5SubQueryBuilder.createPlanningEnvironment((ExecutionEnvironment)environment.getExecutionEnvironment(), planEnv);
        List<IXQEQueryNode> applicableFilters = this.getApplicableFilters(node, subPlanEnv.getNodeFactory(), leftQS, environment);
        Pair v5QueryAndQRD = new Pair();
        Pair v5SelectAndGroupBody = new Pair();
        V5QuerySet v5QuerySet = this.createSubV5QuerySet(environment, subPlanEnv.getNodeFactory(), applicableFilters, v5QueryAndQRD, v5SelectAndGroupBody);
        V5Query v5Query = (V5Query)v5QueryAndQRD.getFirst();
        V5QueryResultDefinition v5QueryResultDefiniton = (V5QueryResultDefinition)v5QueryAndQRD.getSecond();
        ArrayList<ColumnMapping> mapping = new ArrayList<ColumnMapping>();
        int[] pos = new int[]{1};
        for (MoserRelationship.MoserLink lnk : links) {
            List<ColumnMapping> mp = this.addDataItemForLink(environment, join, lnk, jft, leftQS, pos, subPlanEnv, v5SelectAndGroupBody, rightQS);
            if (mp == null) {
                return;
            }
            mapping.addAll(mp);
        }
        RSAPIDataset dataset = this.getDataset(node, v5Query, environment, v5QueryResultDefiniton, v5QuerySet, subPlanEnv);
        int absoluteLimit = node.getGovernors().getFJOMaxKeys();
        boolean bNotEmpty = this.getValues(dataset, environment, subPlanEnv, mapping, absoluteLimit);
        HashSet<RQPQuery> seen = new HashSet<RQPQuery>();
        for (ColumnMapping mp : mapping) {
            IXQEQueryNode fltExpr = null;
            if (!bNotEmpty) {
                if (seen.contains(mp.rightRQPQuery)) continue;
                seen.add(mp.rightRQPQuery);
                fltExpr = this.getDummyFilterExpr(environment.getNodeFactory());
            } else {
                fltExpr = this.getFJOExpression(environment.getNodeFactory(), mp);
            }
            if (fltExpr == null) continue;
            RQPDetailFilterList dfl = mp.rightRQPQuery.getOrCreateDetailFilters(environment);
            IXQEQueryNode df = environment.getNodeFactory().createNode(101008);
            df.addChild(fltExpr);
            dfl.addChild(df);
        }
    }

    protected IXQEQueryNode getDummyFilterExpr(XQENodeFactory nodeFactory) {
        SQLComparison comp = (SQLComparison)nodeFactory.createNode(301026);
        comp.setSubType(SQLComparison.SubType.EQUAL);
        V5LiteralValue value1 = this.createV5LiteralValueForInt(nodeFactory, 1);
        comp.addChild(value1);
        V5LiteralValue value2 = this.createV5LiteralValueForInt(nodeFactory, 0);
        comp.addChild(value2);
        return comp;
    }

    protected List<ColumnMapping> addDataItemForLink(PlanningEnvironment env, SQLJoin join, MoserRelationship.MoserLink lnk, IRelationship.JoinFilterType jft, IQuerySubject leftQS, int[] pos, PlanningEnvironment subPlanEnv, Pair v5SelectAndGroupBody, IQuerySubject rQS) {
        IMetadata leftQI = this.getQueryItemForLink(leftQS, lnk.getLeftRefId());
        if (leftQI == null) {
            return null;
        }
        String sOp = lnk.getComparisonOperator();
        if ("lessThan".equalsIgnoreCase(sOp) || "lessThanOrEqualTo".equalsIgnoreCase(sOp)) {
            ColumnMapping mp = this.createMixMaxDataItem(env, join, lnk, leftQI, pos, subPlanEnv, v5SelectAndGroupBody, 8, rQS);
            if (mp == null) {
                return null;
            }
            ArrayList<ColumnMapping> rt = new ArrayList<ColumnMapping>();
            rt.add(mp);
            return rt;
        }
        if ("greaterThan".equalsIgnoreCase(sOp) || "greaterThanOrEqualTo".equalsIgnoreCase(sOp)) {
            ColumnMapping mp = this.createMixMaxDataItem(env, join, lnk, leftQI, pos, subPlanEnv, v5SelectAndGroupBody, 9, rQS);
            if (mp == null) {
                return null;
            }
            ArrayList<ColumnMapping> rt = new ArrayList<ColumnMapping>();
            rt.add(mp);
            return rt;
        }
        List<ColumnMapping> rt = this.addDataItemForEqualLink(env, join, lnk, jft, leftQS, leftQI, pos, subPlanEnv, v5SelectAndGroupBody, rQS);
        if (rt.size() == 1) {
            ColumnMapping mp = rt.get(0);
            if ("notEqualTo".equals(sOp) || "notEqualToOrOneNull".equals(sOp)) {
                mp.bNegative = true;
            }
            if ("equalToOrBothNull".equals(sOp) || "notEqualToOrOneNull".equals(sOp)) {
                mp.bAllowNull = true;
            }
        }
        return rt;
    }

    protected List<ColumnMapping> addDataItemForEqualLink(PlanningEnvironment env, SQLJoin join, MoserRelationship.MoserLink lnk, IRelationship.JoinFilterType jft, IQuerySubject leftQS, IMetadata leftQI, int[] pos, PlanningEnvironment subPlanEnv, Pair v5SelectAndGroupBody, IQuerySubject rQS) {
        ColumnMapping mp = new ColumnMapping();
        mp.leftValues = new TreeSet();
        this.addDataItem(subPlanEnv.getNodeFactory(), pos[0], leftQI, 0, v5SelectAndGroupBody);
        pos[0] = pos[0] + 1;
        mp.sqlOp = (SQLAbstractFunction)env.getNodeFactory().createNode(301076);
        this.setRightRQPQuery(this.getRangeVar(join, rQS), lnk.getRightRefId(), mp);
        ArrayList<ColumnMapping> rt = new ArrayList<ColumnMapping>();
        rt.add(mp);
        return rt;
    }

    protected IXQEQueryNode getRangeVar(SQLJoin join, IQuerySubject rQS) {
        List<IXQEQueryNode> sqlVars = join.getDescendantsOfTypeOrdered(301007, false);
        String qsId = rQS.getV5UniqueName();
        for (IXQEQueryNode a : sqlVars) {
            SQLRangeVar var = (SQLRangeVar)a;
            if (!qsId.equals(var.getPropertyValue("fullQSName"))) continue;
            return var;
        }
        return null;
    }

    protected ColumnMapping createMixMaxDataItem(PlanningEnvironment env, SQLJoin join, MoserRelationship.MoserLink lnk, IMetadata leftQI, int[] pos, PlanningEnvironment subPlanEnv, Pair v5SelectAndGroupBody, int aggr, IQuerySubject rQS) {
        ColumnMapping mp = new ColumnMapping();
        mp.leftSingleValue = new Value[1];
        this.addDataItem(subPlanEnv.getNodeFactory(), pos[0], leftQI, aggr, v5SelectAndGroupBody);
        pos[0] = pos[0] + 1;
        SQLComparison comp = (SQLComparison)env.getNodeFactory().createNode(301026);
        if (aggr == 8) {
            comp.setSubType(SQLComparison.SubType.GREATEREQUAL);
        } else {
            comp.setSubType(SQLComparison.SubType.LESSEQUAL);
        }
        this.setRightRQPQuery(this.getRangeVar(join, rQS), lnk.getRightRefId(), mp);
        mp.sqlOp = comp;
        return mp;
    }

    protected List<IXQEQueryNode> getApplicableFilters(IXQEQueryNode node, XQENodeFactory nf, IQuerySubject qs, PlanningEnvironment environment) {
        RMQuery rmQuery;
        RMQueryList rmQueryList;
        ArrayList<IXQEQueryNode> applicableFilters = new ArrayList<IXQEQueryNode>();
        RQPQuery rqpQuery = (RQPQuery)node.getAncestorOfCategory(801017);
        RQPDetailFilterList filters = rqpQuery.getDetailFilterList();
        if (filters != null) {
            for (IXQEQueryNode filter : filters.getChildren()) {
                this.addFilter(nf, filter, qs, environment, applicableFilters, null);
            }
        }
        if ((rmQueryList = RQPUtilities.getRMQueryList(node)) != null && (rmQuery = rmQueryList.getRMQuery(qs)) != null) {
            IXQEQueryNode[] embeddedFilterLists;
            for (IXQEQueryNode embeddedFilterListForQS : embeddedFilterLists = rmQuery.getChildrenOfType(801036)) {
                if (!qs.equals(((RMEmbeddedFilterList)embeddedFilterListForQS).getQuerySubject())) continue;
                for (IXQEQueryNode embedFlt : embeddedFilterListForQS.getChildren()) {
                    Boolean bFromV5Filter = (Boolean)embedFlt.getPropertyValue(PROP_FROM_DETAILFILTER);
                    if (!Boolean.TRUE.equals(bFromV5Filter)) continue;
                    this.addFilter(nf, embedFlt, qs, environment, applicableFilters, null);
                }
                List lst = (List)embeddedFilterListForQS.getPropertyValue("pushedList");
                if (lst == null) continue;
                for (Object o : lst) {
                    this.addFilter(nf, null, qs, environment, applicableFilters, o);
                }
            }
        }
        return applicableFilters;
    }

    protected void addFilter(XQENodeFactory nf, IXQEQueryNode obj, IQuerySubject qs, PlanningEnvironment environment, List<IXQEQueryNode> applicableFilters, Object rawExpr) {
        String exprStr;
        IXQEQueryNode expr = null;
        if (obj != null) {
            expr = (IXQEQueryNode)obj.getPropertyValue(ORG_FLT_EXP);
            if (expr == null) {
                exprStr = (String)obj.getPropertyValue("originalExpression");
                if (exprStr == null || exprStr.isEmpty()) {
                    return;
                }
                expr = RQPUtilities.createV5ValueExpression(exprStr, environment, obj, ((RequestEnvironment)environment.getRequestEnvironment()).getExpressionLocale());
                RQPUtilities.unwindAndBindModelIdentifiers(environment, expr);
            }
        } else if (rawExpr != null) {
            if (rawExpr instanceof IXQEQueryNode) {
                expr = (IXQEQueryNode)rawExpr;
            } else if (rawExpr instanceof String) {
                exprStr = (String)rawExpr;
                if (exprStr == null || exprStr.isEmpty()) {
                    return;
                }
                expr = RQPUtilities.createV5ValueExpression(exprStr, environment, obj, ((RequestEnvironment)environment.getRequestEnvironment()).getExpressionLocale());
                RQPUtilities.unwindAndBindModelIdentifiers(environment, expr);
            }
        }
        if (expr == null) {
            return;
        }
        boolean applyFilter = ApplyJoinFilterOptimization.allModelReferencesFromOneSide(expr, qs, null, environment);
        if (!applyFilter) {
            return;
        }
        if (ApplyJoinFilterOptimization.hasMasterDetailLinkParameterUnresolved(expr, environment)) {
            return;
        }
        V5DetailFilter detailFilter = (V5DetailFilter)nf.createNode(101008);
        IXQEQueryNode fexpr = nf.deepCopyNode(expr);
        detailFilter.addChild(fexpr);
        applicableFilters.add(detailFilter);
        detailFilter.setPropertyValue("doNotValidate", Boolean.TRUE);
    }

    protected V5LiteralValue createV5LiteralValueForInt(XQENodeFactory nodeFactory, int v) {
        String sV = String.valueOf(v);
        V5LiteralValue value = (V5LiteralValue)nodeFactory.createNode(201026);
        value.setDataType(IntegerType.INTEGERTYPE);
        value.setValue(sV);
        value.setNativeName(sV);
        value.setInclusive(true);
        return value;
    }

    protected IXQEQueryNode getFJOExpression(XQENodeFactory nodeFactory, ColumnMapping mp) {
        if (mp.sqlOp instanceof SQLIn) {
            List<Pair> grps;
            Value vFirst;
            if (mp.leftValues.isEmpty()) {
                if (mp.hasNull) {
                    return this.generateIsNull(nodeFactory, mp.rightQueryItem);
                }
                return null;
            }
            if (mp.leftValues.size() >= 2 && (vFirst = mp.leftValues.first()) instanceof DateValue && (grps = this.getGroups(mp.leftValues)) != null && grps.size() < mp.leftValues.size()) {
                IXQEQueryNode rt = this.generateBetween(nodeFactory, mp.rightQueryItem, grps);
                if (mp.bNegative) {
                    rt = this.negate(nodeFactory, rt);
                }
                if (mp.hasNull) {
                    rt = this.addIsNull(nodeFactory, rt, mp.rightQueryItem);
                }
                return rt;
            }
            IXQEQueryNode left = nodeFactory.deepCopyNode(mp.rightQueryItem);
            mp.sqlOp.addChild(left);
            SQLValueList vl = (SQLValueList)nodeFactory.createNode(301030);
            mp.sqlOp.addChild(vl);
            for (Value v : mp.leftValues) {
                V5LiteralValue value = this.createV5LiteralValue(nodeFactory, v);
                vl.addChild(value);
            }
            Object rt = mp.sqlOp;
            if (mp.bNegative) {
                rt = this.negate(nodeFactory, (IXQEQueryNode)rt);
            }
            if (mp.hasNull) {
                rt = this.addIsNull(nodeFactory, (IXQEQueryNode)rt, mp.rightQueryItem);
            }
            return rt;
        }
        if (mp.sqlOp instanceof SQLComparison) {
            if (mp.leftSingleValue[0] == null) {
                return null;
            }
            IXQEQueryNode left = nodeFactory.deepCopyNode(mp.rightQueryItem);
            mp.sqlOp.addChild(left);
            Value v = mp.leftSingleValue[0];
            V5LiteralValue value = this.createV5LiteralValue(nodeFactory, v);
            mp.sqlOp.addChild(value);
            return mp.sqlOp;
        }
        return null;
    }

    protected IXQEQueryNode negate(XQENodeFactory nodeFactory, IXQEQueryNode rt) {
        SQLLogical ng = (SQLLogical)nodeFactory.createNode(301027);
        ng.setSubType(SQLLogical.SubType.NOT);
        ng.addChild(rt);
        return ng;
    }

    protected IXQEQueryNode addIsNull(XQENodeFactory nodeFactory, IXQEQueryNode rt, IXQEQueryNode qi) {
        SQLLogical orOp = (SQLLogical)nodeFactory.createNode(301027);
        orOp.setSubType(SQLLogical.SubType.OR);
        orOp.addChild(rt);
        orOp.addChild(this.generateIsNull(nodeFactory, qi));
        return orOp;
    }

    protected IXQEQueryNode generateIsNull(XQENodeFactory nodeFactory, IXQEQueryNode qi) {
        SQLIsNull op = (SQLIsNull)nodeFactory.createNode(301024);
        IXQEQueryNode left = nodeFactory.deepCopyNode(qi);
        op.addChild(left);
        return op;
    }

    protected IXQEQueryNode generateBetween(XQENodeFactory nodeFactory, IXQEQueryNode qi, List<Pair> grps) {
        SQLAbstractBooleanFunction rt = null;
        for (Pair p : grps) {
            SQLBetween btw = (SQLBetween)nodeFactory.createNode(301045);
            IXQEQueryNode left = nodeFactory.deepCopyNode(qi);
            btw.addChild(left);
            V5LiteralValue value1 = this.createV5LiteralValue(nodeFactory, (Value)p.getFirst());
            btw.addChild(value1);
            V5LiteralValue value2 = this.createV5LiteralValue(nodeFactory, (Value)p.getSecond());
            btw.addChild(value2);
            if (rt == null) {
                rt = btw;
                continue;
            }
            SQLLogical newLogicalORNode = (SQLLogical)nodeFactory.createNode(301027);
            newLogicalORNode.setSubType(SQLLogical.SubType.OR);
            newLogicalORNode.addChild(rt);
            newLogicalORNode.addChild(btw);
            rt = newLogicalORNode;
        }
        return rt;
    }

    protected V5LiteralValue createV5LiteralValue(XQENodeFactory nodeFactory, Value v) {
        V5LiteralValue value = (V5LiteralValue)nodeFactory.createNode(201026);
        value.setDataType(v.getDataType());
        value.setValue(v.toString());
        value.setNativeName(v.toString());
        value.setInclusive(true);
        return value;
    }

    protected List<Pair> getGroups(TreeSet<Value> values) {
        ArrayList<Pair> grps = new ArrayList<Pair>();
        DateValue st = null;
        DateTimeValue current = null;
        for (Value v : values) {
            if (!(v instanceof DateValue) || !v.isOK()) {
                return null;
            }
            DateValue dtV = (DateValue)v;
            if (st == null) {
                st = dtV;
                current = dtV;
                continue;
            }
            int dif = (int)(DateTimeValue.subtractNoDST(current.getCalendar(), dtV.getCalendar()) / 86400000L);
            if (dif <= 1) {
                current = dtV;
                continue;
            }
            Pair p = new Pair(st, current);
            grps.add(p);
            st = dtV;
            current = dtV;
        }
        grps.add(new Pair(st, current));
        return grps;
    }

    protected void setRightRQPQuery(IXQEQueryNode rightNode, String rightRefId, ColumnMapping mp) {
        if (rightNode == null) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_FJONotAppliedFlexible);
        }
        List<IXQEQueryNode> sqlAlias = rightNode.getDescendantsOfTypeOrdered(301028, 301043);
        for (IXQEQueryNode a : sqlAlias) {
            SQLAlias sqlA = (SQLAlias)a;
            if (!rightRefId.equals(sqlA.getName())) continue;
            IXQEQueryNode[] refs = sqlA.getDescendantsOfType(801009, false);
            if (refs.length != 1) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_FJONotAppliedFlexible);
            }
            RQPDataItem di = ((RQPDataItemRef)refs[0]).getReferencedItem();
            List<IXQEQueryNode> keys = di.getDescendantsOfCategoryOrdered(201120, false);
            if (keys.size() != 1) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_FJONotAppliedFlexible);
            }
            mp.rightRQPQuery = (RQPQuery)di.getAncestorOfType(801017);
            mp.rightQueryItem = keys.get(0);
            return;
        }
        throw new XQERuntimeException(XQEMessageKeys.PLN_FJONotAppliedFlexible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getValues(RSAPIDataset dataset, PlanningEnvironment environment, PlanningEnvironment subPlanEnv, List<ColumnMapping> values, int absoluteLimit) {
        ExecutionEnvironment subExecEnv = (ExecutionEnvironment)subPlanEnv.getExecutionEnvironment();
        RSAPIPartialDataset partialDataset = ApplyJoinFilterOptimization.getPartialDataset(dataset, environment, subPlanEnv);
        if (partialDataset == null) {
            return false;
        }
        RSAPIEdgeIterator it = partialDataset.edgeIterator(0);
        if (it == null) {
            return false;
        }
        boolean bExceed = false;
        try {
            List<IValue> columns;
            while ((columns = ApplyJoinFilterOptimization.getNextRow(it)) != null) {
                for (int i = 0; i < columns.size(); ++i) {
                    Value v = (Value)columns.get(i);
                    ColumnMapping mp = values.get(i);
                    if (v.isNull()) {
                        if (!mp.bAllowNull) continue;
                        mp.hasNull = true;
                        continue;
                    }
                    if (!v.isOK()) continue;
                    if (mp.leftValues != null) {
                        mp.leftValues.add(v);
                        if (absoluteLimit <= 0 || mp.leftValues.size() <= absoluteLimit) continue;
                        bExceed = true;
                        break;
                    }
                    if (mp.leftSingleValue[0] != null) continue;
                    mp.leftSingleValue[0] = v;
                }
                if (!bExceed) continue;
                break;
            }
        }
        finally {
            it.close();
            partialDataset.release();
            dataset.releaseResultset(subExecEnv);
        }
        if (bExceed) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_ForceFJOAbsoluteLimitReached, absoluteLimit);
        }
        for (ColumnMapping v : values) {
            if (!(v.leftValues != null ? v.leftValues.isEmpty() && !v.hasNull && !v.bNegative : v.leftSingleValue[0] == null)) continue;
            return false;
        }
        return true;
    }

    protected RSAPIDataset getDataset(IXQEQueryNode node, V5Query v5Query, PlanningEnvironment environment, V5QueryResultDefinition v5QueryResultDefiniton, V5QuerySet v5QuerySet, PlanningEnvironment subPlanEnv) {
        ApplyJoinFilterOptimization.addGovernors(node, v5Query);
        ApplyJoinFilterOptimization.addSQLFeedbackForValidate(environment, v5QueryResultDefiniton);
        TransformationEngine.getInstance().applyTransformations(v5QuerySet, subPlanEnv);
        ExecutionEnvironment subExecEnv = (ExecutionEnvironment)subPlanEnv.getExecutionEnvironment();
        RequestEnvironment subReqEnv = (RequestEnvironment)subExecEnv.getRequestEnvironment();
        ApplyJoinFilterOptimization.throwErrorForUnresolvedParameters(environment, subReqEnv, v5QuerySet);
        return ApplyJoinFilterOptimization.getDataset(v5QuerySet);
    }

    protected IMetadata getQueryItemForLink(IQuerySubject qs, String id) {
        List<IMetadata> qis = qs.getQueryItemsAndMeasures();
        for (IMetadata qi : qis) {
            if (!id.equals(qi.getName())) continue;
            return qi;
        }
        return null;
    }

    protected V5QuerySet createSubV5QuerySet(PlanningEnvironment environment, XQENodeFactory nf, List<IXQEQueryNode> applicableFilters, Pair v5QueryAndQRD, Pair v5SelectAndGroupBody) {
        V5QuerySet v5QuerySet = (V5QuerySet)nf.createNode(101002);
        v5QuerySet.addToIndex();
        IXQEQueryNode v5Query = nf.createNode(101006);
        v5QueryAndQRD.setFirst(v5Query);
        v5Query.setPropertyValue("name", "joinKeyQuery");
        v5QuerySet.addChild(v5Query);
        V5Source v5Source = (V5Source)nf.createNode(101007);
        ApplyJoinFilterOptimization.setModelPathAndModelType(environment, v5Source);
        v5Query.addChild(v5Source);
        IXQEQueryNode v5Selection = nf.createNode(101009);
        v5SelectAndGroupBody.setFirst(v5Selection);
        v5Query.addChild(v5Selection);
        ApplyJoinFilterOptimization.applyQueryFiltersToOneSide((V5Query)v5Query, applicableFilters, environment);
        V5QueryResultDefinition v5QueryResultDefiniton = (V5QueryResultDefinition)nf.createNode(101055);
        v5QueryAndQRD.setSecond(v5QueryResultDefiniton);
        v5QueryResultDefiniton.setPropertyValue("refQuery", "joinKeyQuery");
        v5QueryResultDefiniton.setPropertyValue("name", "qrd1");
        v5QuerySet.addChild(v5QueryResultDefiniton);
        IXQEQueryNode v5Edge = nf.createNode(101049);
        v5Edge.setPropertyValue("name", "e");
        v5QueryResultDefiniton.addChild(v5Edge);
        IXQEQueryNode v5EdgeGroup = nf.createNode(101050);
        v5Edge.addChild(v5EdgeGroup);
        IXQEQueryNode v5ValueSet = nf.createNode(101057);
        v5ValueSet.setPropertyValue("name", "vs");
        v5EdgeGroup.addChild(v5ValueSet);
        IXQEQueryNode v5GroupBody = nf.createNode(101051);
        v5SelectAndGroupBody.setSecond(v5GroupBody);
        v5GroupBody.setPropertyValue("name", "gb");
        v5ValueSet.addChild(v5GroupBody);
        return v5QuerySet;
    }

    protected void addDataItem(XQENodeFactory nf, int pos, IMetadata qi, int aggr, Pair v5SelectAndGroupBody) {
        V5BoundModelIdentifier boundNode = (V5BoundModelIdentifier)nf.createNode(201116);
        boundNode.setMetadata(qi);
        boundNode.setIdentifier(qi.getUniqueID());
        V5Selection v5Selection = (V5Selection)v5SelectAndGroupBody.getFirst();
        IXQEQueryNode v5DataItem = nf.createNode(101003);
        v5Selection.addChild(v5DataItem);
        v5DataItem.setPropertyValue("name", "joinKey" + pos);
        if (aggr == 0) {
            v5DataItem.setPropertyValue("aggregate", "none");
            v5DataItem.addChild(boundNode);
        } else {
            V5ValueSummaryFunction aggrFunc = (V5ValueSummaryFunction)nf.createNode(201031);
            if (aggr == 8) {
                aggrFunc.setSubType(6);
            } else {
                aggrFunc.setSubType(4);
            }
            aggrFunc.addChild(boundNode);
            V5AggregateBreakClause forClause = (V5AggregateBreakClause)nf.createNode(201037);
            aggrFunc.addChild(forClause);
            forClause.setSubType(0);
            v5DataItem.setPropertyValue("aggregate", "calculated");
            v5DataItem.addChild(aggrFunc);
        }
        IXQEQueryNode v5GroupBody = (IXQEQueryNode)v5SelectAndGroupBody.getSecond();
        IXQEQueryNode v5DataItemRef = nf.createNode(101015);
        v5DataItemRef.setPropertyValue("refDataItem", "joinKey" + pos);
        v5GroupBody.addChild(v5DataItemRef);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Boolean b = (Boolean)node.getPropertyValue(APPLIED);
        if (Boolean.TRUE.equals(b)) {
            return false;
        }
        IRelationship.JoinFilterType jft = (IRelationship.JoinFilterType)((Object)node.getPropertyValue("joinFilterType"));
        return jft == IRelationship.JoinFilterType.FILTER_TYPE_FLEXIBLE;
    }

    protected class ColumnMapping {
        protected TreeSet<Value> leftValues;
        protected Value[] leftSingleValue;
        protected boolean bAllowNull;
        protected boolean hasNull;
        protected IXQEQueryNode rightQueryItem;
        protected SQLAbstractFunction sqlOp;
        protected RQPQuery rightRQPQuery;
        protected boolean bNegative;

        protected ColumnMapping() {
        }
    }
}

