/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilter;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class ConvertSecurityFiltersForQSToDetail
extends RQPTransformation {
    public ConvertSecurityFiltersForQSToDetail(int[] passNumbers) {
        this.mName = "ConvertSecurityFiltersForDynamicQSToDetail";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{801036};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] securityFilters;
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode embeddedFilter = factory.createNode(801035);
        RMEmbeddedFilter.processSecurityFilters(node, environment, factory, embeddedFilter);
        for (IXQEQueryNode securityFilter : securityFilters = node.getDescendantsOfType(801035, false)) {
            if (!((RMEmbeddedFilter)securityFilter).getFilterType().equals("securityFilterDefinition")) continue;
            securityFilter.detach();
            securityFilter.removeFromIndex();
        }
        if (embeddedFilter.getChildren().length > 0) {
            embeddedFilter.insertParent(node);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] securityFilters;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        if (node.getAncestorOfType(801017) == null) {
            this.traceNodeCondition(false, "The filter is not for dynamic or asView query subject.", xqeTrace);
            return false;
        }
        boolean containSecurityFilter = false;
        for (IXQEQueryNode securityFilter : securityFilters = node.getDescendantsOfType(801035, false)) {
            String filterType = ((RMEmbeddedFilter)securityFilter).getFilterType();
            if (filterType == null || !filterType.equals("securityFilterDefinition")) continue;
            containSecurityFilter = true;
            break;
        }
        if (!containSecurityFilter) {
            this.traceNodeCondition(false, "There is no security filter in the embedded filter for dynamic or asView query subject.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "Embedded security filter is for dynamic or asView query subject.", xqeTrace);
        return true;
    }
}

