/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.GenerateOuterASTForDBQS;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class CopyEmbeddedFilter
extends RQPTransformation {
    public static final String ISNODEAPPLY = "embeddedFilterApply";

    public CopyEmbeddedFilter() {
        this.mName = "Copy embedded filters to SQLFilter node";
        this.mPassNumbers = new int[]{10};
        this.mTypes = new int[]{801035};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode rmQuery = null;
        IXQEQueryNode rmEmbeddedFilterList = null;
        rmEmbeddedFilterList = node.getParent();
        rmQuery = rmEmbeddedFilterList.getParent();
        List<IXQEQueryNode> rmEmbeddedSqlFilter = rmQuery.getDescendantsOfTypeOrdered(801037, false);
        if (rmEmbeddedSqlFilter.size() == 0) {
            GenerateOuterASTForDBQS transformation = new GenerateOuterASTForDBQS();
            ((Transformation)transformation).apply(rmQuery, environment);
            rmEmbeddedSqlFilter = rmQuery.getDescendantsOfTypeOrdered(801037, false);
        }
        IXQEQueryNode rmEmbeddedSqlFilterNode = rmEmbeddedSqlFilter.get(0);
        for (IXQEQueryNode comparison : node.getChildren()) {
            IXQEQueryNode newSqlFilter = null;
            int filterType = RQPUtilities.hasAggregateInExpression(comparison) ? 301053 : 301009;
            newSqlFilter = factory.createNode(filterType);
            newSqlFilter.addChild(factory.deepCopyNode(comparison));
            IXQEQueryNode sqlFilter = rmEmbeddedSqlFilterNode.getFirstChildByType(filterType);
            if (sqlFilter == null) {
                rmEmbeddedSqlFilterNode.getChild(0).move(newSqlFilter, 0);
            } else {
                sqlFilter.move(newSqlFilter, 0);
            }
            newSqlFilter.insertParent(rmEmbeddedSqlFilterNode);
        }
        node.setPropertyValue(ISNODEAPPLY, true);
    }

    private Boolean validateOptionalEmbeddedFilter(IXQEQueryNode node, PlanningEnvironment environment) {
        Boolean retBool = true;
        String parameterName = null;
        IXQEQueryNode[] boundParameters = node.getDescendantsOfTypes(new int[]{201127, 201024}, false);
        for (int i = 0; i < boundParameters.length; ++i) {
            V5BoundToMetadata boundParameter;
            if (boundParameters[i].getType() == 201024) {
                boundParameter = (V5Parameter)boundParameters[i];
                parameterName = ((V5Parameter)boundParameter).getParameterName();
                boundParameter.setPropertyValue("optionalEmbeddedFilter", "true");
            } else {
                boundParameter = (V5BoundParameter)boundParameters[i];
                parameterName = ((V5BoundParameter)boundParameter).getParameterName();
            }
            RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
            Parameters parameters = requestEnv.getRequestParameters();
            Parameter parameter = parameters.getParameter(parameterName);
            if (parameter != null && !parameter.isIgnored()) continue;
            retBool = false;
        }
        return retBool;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        IXQEQueryNode rmSql = node.getAncestorOfTypes(new int[]{801027, 801028});
        if (rmSql == null) {
            this.traceNodeCondition(false, "The RMEmbeddedFilter are not under RMSqlCalcFilter or RMSqlAsView.", xqeTrace);
            return false;
        }
        Boolean addNode = true;
        if (node.getType() == 801035) {
            String filterType = ((RMEmbeddedFilter)node).getFilterType();
            if (null != filterType && filterType.equals("filterDefinition")) {
                addNode = this.validateOptionalEmbeddedFilter(node, environment);
            }
            if (null != filterType && filterType.equals("previewFilter") && !node.getGovernors().getDesignMode().booleanValue()) {
                addNode = false;
            }
            if (!addNode.booleanValue()) {
                this.traceNodeCondition(false, "The optional or design embedded filter will not be applied.", xqeTrace);
                return false;
            }
            filterType = ((RMEmbeddedFilter)node).getFilterType();
            if (null != filterType && filterType.equals("securityFilterDefinition")) {
                this.traceNodeCondition(false, "Avoid apply this transformation on Security Filter node.", xqeTrace);
                return false;
            }
        }
        if (node.getPropertyValue(ISNODEAPPLY) != null) {
            this.traceNodeCondition(false, "This embedded filter have been applied", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "Applied the transformation for this embedded node filter", xqeTrace);
        return true;
    }
}

