/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RMQueryItemRef;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPDetailFilterList;
import com.cognos.xqe.ast.rqp.RQPGroupByList;
import com.cognos.xqe.ast.rqp.RQPJoinInfo;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSubqueryList;
import com.cognos.xqe.ast.rqp.RQPSummaryFilterList;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPNameGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.SummaryQuerySubjectUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.itemNormalization.ItemNormalization;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.FactFinder;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class CreateRQPQueryFromRMQuery
extends RQPTransformation {
    public CreateRQPQueryFromRMQuery() {
        this.mName = "Create RQPQuery from RMQuery";
        this.mPassNumbers = new int[]{19};
        this.mTypes = new int[]{801047, 201116};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        int[] types = new int[]{801017, 801025, 801024, 801012};
        RQPQuery parentRqpQuery = (RQPQuery)node.getAncestorOfTypes(types);
        RMQueryList rmQueryList = RQPUtilities.getRMQueryList(node);
        RMQuery rmQuery = rmQueryList.getRMQuery(node);
        String rqpQueryName = rmQuery.getCorrelationName();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode newNode = null;
        if (rqpQueryName.equals(parentRqpQuery.getName()) && parentRqpQuery != parentRqpQuery.getRootRQPQuery()) {
            String identifier = null;
            identifier = node.getType() == 201116 ? ((V5BoundModelIdentifier)node).getMetadata().getV5UniqueName() : ((RMQueryItemRef)node).getIdentifier();
            newNode = this.replaceV5BoundSelfRefByDirectReference(nodeFactory, identifier, rmQuery);
        } else {
            boolean forceCreationOfAllProjections = false;
            IQuerySubject qs = null;
            if (node.getType() == 201116 && ((V5BoundMultiPartIdentifier)node).getMetadata() != null) {
                IMetadata metadata = ((V5BoundMultiPartIdentifier)node).getMetadata();
                qs = ((IQueryItem)metadata).getQuerySubject();
            }
            if (qs != null && SummaryQuerySubjectUtilities.isSummaryQuerySubject(qs) && qs.getSelectListControl() != IQuerySubject.SelectListControl.USEDQUERYITEMS) {
                forceCreationOfAllProjections = true;
            }
            CreateRQPQueryFromRMQuery.createRQPQuery(environment, parentRqpQuery, rmQuery, rqpQueryName, forceCreationOfAllProjections);
            String columnName = null;
            if (node.getType() == 201116) {
                if (((V5BoundMultiPartIdentifier)node).getMetadata() != null) {
                    columnName = RQPNameGenerator.generateUniqueAliasQueryItem(((V5BoundMultiPartIdentifier)node).getMetadata());
                }
                if (columnName == null) {
                    String[] parts = ((V5BoundMultiPartIdentifier)node).getNameParts();
                    columnName = parts[parts.length - 1];
                }
            } else {
                columnName = ((RMQueryItemRef)node).getName();
            }
            newNode = this.replaceV5BoundToMetadataByV5BoundToRqpQuery(nodeFactory, columnName, rqpQueryName);
        }
        node.exchange(newNode);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        IXQEQueryNode rmEmbeddedFilterList = node.getAncestorOfType(801036);
        if (rmEmbeddedFilterList != null) {
            this.traceNodeCondition(false, "The V5BMPI node is located under a EmbeddedFilterList node.", xqeTrace);
            return false;
        }
        int[] types = new int[]{801017, 301018, 801032, 801035};
        IXQEQueryNode firstAncestor = node.getAncestorOfTypes(types);
        if (firstAncestor != null && firstAncestor.getType() == 801032) {
            this.traceNodeCondition(false, "The V5BMPI node is located under the RM layer.", xqeTrace);
            return false;
        }
        if (firstAncestor != null && firstAncestor.getType() == 801035) {
            this.traceNodeCondition(false, "The V5BMPI node is located under the RMEMBEDDEDFILTER .", xqeTrace);
            return false;
        }
        if (firstAncestor != null && firstAncestor.getType() == 301018) {
            this.traceNodeCondition(true, "The V5BMPI node is located under a setOperator", xqeTrace);
            return true;
        }
        RMQueryList rmQueryList = RQPUtilities.getRMQueryList(node);
        RMQuery rmQuery = rmQueryList.getRMQuery(node);
        if (rmQuery == null || rmQuery.getType() != 801029) {
            this.traceNodeCondition(false, "The RMQuery is not a modelQueryAsView", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "The RMQuery will be used to create a new RQPQuery.", xqeTrace);
        return true;
    }

    public static void setNocache(IXQEQueryNode foundQuery, RMQuery rmQuery) {
        String datacache;
        IQuerySubject theQS = rmQuery.getQuerySubject();
        if (theQS != null && "0".equals(datacache = theQS.getQuerySubjectDataCacheExpiry())) {
            foundQuery.setPropertyValue("noCache", Boolean.TRUE);
        }
    }

    public static RQPQuery createRQPQuery(PlanningEnvironment environment, RQPQuery parentRqpQuery, RMQuery rmQuery, String rqpQueryName, boolean forceCreationOfAllProjections) {
        IXQEQueryNode iXQEQueryNode;
        IXQEQueryNode[] rmEmbeddedFilterList;
        RQPSubqueryList subqueryList;
        IQuerySubject sqsOwner;
        IQuerySubject.SelectListControl aProp;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode subqList = parentRqpQuery.getFirstChildByType(801022);
        if (subqList != null) {
            IXQEQueryNode[] queries;
            for (IXQEQueryNode q : queries = subqList.getChildren()) {
                RQPQuery query = (RQPQuery)q;
                if (!rqpQueryName.equals(query.getName())) continue;
                return query;
            }
        }
        CreateRQPQueryFromRMQuery.detectCircularReference(parentRqpQuery, rqpQueryName);
        RQPQuery foundQuery = (RQPQuery)nodeFactory.createNode(801017);
        foundQuery.setPropertyValue("refQuery", rqpQueryName);
        foundQuery.setName(rqpQueryName);
        foundQuery.setPropertyValue("QSNAME", ItemNormalization.getRMQueryQSName(rmQuery));
        String sProp = (String)rmQuery.getPropertyValue("dbHint");
        if (sProp != null) {
            foundQuery.setPropertyValue("dbHint", sProp);
        }
        if ((aProp = (IQuerySubject.SelectListControl)((Object)rmQuery.getPropertyValue("selectControl"))) != null) {
            foundQuery.setPropertyValue("selectControl", (Object)aProp);
        }
        if (forceCreationOfAllProjections) {
            foundQuery.setAsViewSubqueryGeneration(true);
        }
        CreateRQPQueryFromRMQuery.setNocache(foundQuery, rmQuery);
        if (rmQuery.getType() == 801029) {
            foundQuery.setAsViewModelQuery(true);
        }
        if ((sqsOwner = (IQuerySubject)rmQuery.getPropertyValue("sqsOwner")) != null) {
            foundQuery.setPropertyValue("sqsOwner", sqsOwner);
        }
        IXQEQueryNode groupByList = null;
        if (rmQuery.getPropertyValue("hasDeterminant") != null) {
            groupByList = nodeFactory.createNode(801013);
            foundQuery.addChild(groupByList);
            foundQuery.setPropertyValue("isForAsViewModelQueryWithDeterminants", "true");
            IXQEQueryNode joinPaths2 = rmQuery.getFirstChildByType(801039);
            if (joinPaths2 != null) {
                RQPJoinPath jp = (RQPJoinPath)joinPaths2;
                List<IMetadata> allJoins = jp.getJoinPath();
                foundQuery.setAllJoinsForOuterMostQuery(allJoins);
            }
        }
        if ((subqueryList = (RQPSubqueryList)parentRqpQuery.getFirstChildByType(801022)) == null) {
            subqueryList = (RQPSubqueryList)nodeFactory.createNode(801022);
            parentRqpQuery.addChild(subqueryList);
        }
        subqueryList.addChild(foundQuery);
        subqueryList = (RQPSubqueryList)nodeFactory.createNode(801022);
        foundQuery.addChild(subqueryList);
        IXQEQueryNode projList = parentRqpQuery.getFirstChildByType(801016);
        List<IXQEQueryNode> v5IdForProjs = projList.getDescendantsOfTypeOrdered(201116, false);
        ArrayList<IXQEQueryNode> queryItems = new ArrayList<IXQEQueryNode>();
        queryItems.addAll(Arrays.asList(rmQuery.getRMQueryItemList(environment).getChildrenOfTypeOrdered(801033)));
        IQuerySubject wrapper = rmQuery.getWrapperQuerySubject();
        if (wrapper != null) {
            CreateRQPQueryFromRMQuery.copyRMQueryItemsForItemNormalization(environment, rmQuery, queryItems, foundQuery, v5IdForProjs);
        } else {
            block1: for (IXQEQueryNode iXQEQueryNode2 : v5IdForProjs) {
                if (iXQEQueryNode2.getParent().getType() != 801008) continue;
                for (IXQEQueryNode q : queryItems) {
                    RMQueryItem queryItem = (RMQueryItem)q;
                    if (!((V5BoundModelIdentifier)iXQEQueryNode2).getIdentifier().equals(queryItem.getV5UniqueName())) continue;
                    CreateRQPQueryFromRMQuery.copyRMQueryItem(environment, rmQuery, queryItem, foundQuery);
                    queryItems.remove(q);
                    continue block1;
                }
            }
            for (IXQEQueryNode iXQEQueryNode3 : queryItems) {
                RMQueryItem queryItem = (RMQueryItem)iXQEQueryNode3;
                if (queryItem.getCount() <= 0 && !forceCreationOfAllProjections) continue;
                CreateRQPQueryFromRMQuery.copyRMQueryItem(environment, rmQuery, queryItem, foundQuery);
                if (queryItem.getCount() != 0) continue;
                queryItem.incrementCount();
            }
        }
        for (IXQEQueryNode efl : rmEmbeddedFilterList = rmQuery.getChildrenOfTypeOrdered(801036)) {
            IXQEQueryNode[] rmEmbeddedFilters = efl.getChildrenOfTypeOrdered(801035);
            RQPDetailFilterList detailFilterList = null;
            RQPSummaryFilterList summaryFilterList = null;
            for (IXQEQueryNode embeddedFilter : rmEmbeddedFilters) {
                if (RQPUtilities.hasAggregateInExpression(embeddedFilter)) {
                    if (sqsOwner != null) {
                        foundQuery.setPropertyValue("complexSQS", true);
                        CreateRQPQueryFromRMQuery.createDetailFilterForSQS(environment, sqsOwner, foundQuery, embeddedFilter);
                        continue;
                    }
                    if (summaryFilterList != null) continue;
                    summaryFilterList = (RQPSummaryFilterList)foundQuery.getOrCreateList(environment, 801023);
                    summaryFilterList.addChild(nodeFactory.deepCopyNode(embeddedFilter.getChild(0)));
                    continue;
                }
                if (sqsOwner != null) {
                    CreateRQPQueryFromRMQuery.createDetailFilterForSQS(environment, sqsOwner, foundQuery, embeddedFilter);
                    continue;
                }
                if (detailFilterList == null) {
                    detailFilterList = foundQuery.getOrCreateDetailFilters(environment);
                }
                detailFilterList.addChild(nodeFactory.deepCopyNode(embeddedFilter.getChild(0)));
            }
        }
        if (rmQuery.getPropertyValue("hasDeterminant") == null && (iXQEQueryNode = rmQuery.getFirstChildByType(801039)) != null) {
            FactFinder ff = new FactFinder(environment);
            RQPJoinPath jp = (RQPJoinPath)iXQEQueryNode;
            ff.addJoinPath(jp.getJoinPathWithDummyJoins());
            if (ff.getNumberOfFacts() > 1) {
                if (rmQuery.getPropertyValue("sqsOwner") != null) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_SummaryQuerySubjectMultiFactNotSupported, rmQuery.getName());
                }
                throw new XQERuntimeException(XQEMessageKeys.PLN_QuerySubjectAsViewMultiFactNotSupported, rmQuery.getName());
            }
            foundQuery.addChild(nodeFactory.deepCopyNode(iXQEQueryNode));
        }
        if (CreateRQPQueryFromRMQuery.mustUnwind(rmQuery)) {
            ArrayList<IXQEQueryNode> arrayList = new ArrayList<IXQEQueryNode>();
            arrayList.addAll(rmQuery.getDescendantsOfTypeOrdered(201116, false, 801017));
            for (IXQEQueryNode q : arrayList) {
                RMQueryList rmQueryList;
                RMQuery subRmQuery;
                int[] types;
                IXQEQueryNode parent = q.getAncestorOfTypes(types = new int[]{801032, 801033});
                if (parent.getType() == 801032 || (subRmQuery = (rmQueryList = RQPUtilities.getRMQueryList(q)).getRMQuery(q)) == null || subRmQuery.getType() != 801029) continue;
                String subRqpQueryName = subRmQuery.getCorrelationName();
                forceCreationOfAllProjections = subRmQuery.getPropertyValue("selectControl") != IQuerySubject.SelectListControl.USEDQUERYITEMS;
                CreateRQPQueryFromRMQuery.createRQPQuery(environment, foundQuery, subRmQuery, subRqpQueryName, forceCreationOfAllProjections);
            }
        }
        return foundQuery;
    }

    private static void createDetailFilterForSQS(PlanningEnvironment environment, IQuerySubject qs, RQPQuery sqsQuery, IXQEQueryNode embeddedFilter) {
        RQPDetailFilterList detailFilterList = sqsQuery.getOrCreateDetailFilters(environment);
        V5DetailFilter v5DetailFilter = (V5DetailFilter)environment.getNodeFactory().createNode(101008);
        v5DetailFilter.addChild(environment.getNodeFactory().deepCopyNode(embeddedFilter.getChild(0)));
        if (embeddedFilter.getPropertyValue("SQSFilterPAA") != null) {
            v5DetailFilter.setPostAutoAggregation(true);
        }
        detailFilterList.addChild(v5DetailFilter);
    }

    private static RQPDataItem copyRMQueryItem(PlanningEnvironment environment, RMQuery rmQuery, RMQueryItem queryItem, RQPQuery newQuery) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RQPDataItem rqpDataItem = RQPDataItem.create(environment, RQPNameGenerator.generateUniqueAliasQueryItem(queryItem.getQueryItem()));
        String preferredAlias = (String)queryItem.getPropertyValue("preferredAlias");
        if (preferredAlias != null) {
            rqpDataItem.setPropertyValue("preferredAlias", preferredAlias);
        }
        if (newQuery.isSQSQuery()) {
            rqpDataItem.setPropertyValue("queryItem", queryItem.getQueryItem());
        }
        IXQEQueryNode rqpDataItemChild = null;
        if (queryItem.getChildren().length > 0) {
            rqpDataItemChild = nodeFactory.deepCopyNode(queryItem.getChild(0));
        }
        if (rmQuery.getPropertyValue("hasDeterminant") != null) {
            IXQEQueryNode groupByList = newQuery.getFirstChildByType(801013);
            if (queryItem.getPropertyValue("isUsedInDeterminantKey") == null) {
                if (!RQPUtilities.hasAggregateInExpression(rqpDataItemChild)) {
                    SQLAggregate summaryFunction = (SQLAggregate)nodeFactory.createNode(301034);
                    summaryFunction.setSubType(SQLAggregate.SubType.MIN);
                    summaryFunction.addChild(rqpDataItemChild);
                    rqpDataItemChild = summaryFunction;
                }
            } else {
                RQPDataItemSelfRef selfRef = RQPDataItemSelfRef.create(environment, rqpDataItem.getName());
                groupByList.addChild(selfRef);
            }
        } else if (rqpDataItemChild != null && RQPUtilities.hasAggregateInExpression(rqpDataItemChild)) {
            int[] descendantTypes = new int[]{201031, 201033, 201035};
            IXQEQueryNode[] aggregateFunctions = rqpDataItemChild.getDescendantsOfTypes(descendantTypes, true);
            if (newQuery.isSQSQuery()) {
                newQuery.setPropertyValue("complexSQS", true);
            } else {
                for (int i = 0; i < aggregateFunctions.length; ++i) {
                    if (aggregateFunctions[i].hasChildOfType(201037)) continue;
                    V5AggregateBreakClause emptyBreakClause = (V5AggregateBreakClause)nodeFactory.createNode(201037);
                    aggregateFunctions[i].addChild(nodeFactory.deepCopyNode(emptyBreakClause));
                }
            }
        }
        if (rqpDataItemChild != null) {
            rqpDataItem.addChild(rqpDataItemChild);
        }
        newQuery.addToProjectionList(environment, rqpDataItem);
        return rqpDataItem;
    }

    IXQEQueryNode replaceV5BoundToMetadataByV5BoundToRqpQuery(IXQENodeFactory nodeFactory, String columnName, String rqpQueryName) {
        RQPDataItemRef newNode = (RQPDataItemRef)nodeFactory.createNode(801009);
        newNode.setQueryName(rqpQueryName);
        newNode.setName(columnName);
        newNode.setCreatedFromQS();
        return newNode;
    }

    IXQEQueryNode replaceV5BoundSelfRefByDirectReference(IXQENodeFactory nodeFactory, String identifier, RMQuery rmQuery) {
        IXQEQueryNode[] queryItems;
        for (IXQEQueryNode q : queryItems = rmQuery.getDescendantsOfType(801033, false)) {
            RMQueryItem queryItem = (RMQueryItem)q;
            if (!identifier.equals(queryItem.getV5UniqueName())) continue;
            return nodeFactory.deepCopyNode(queryItem.getChild(0));
        }
        return null;
    }

    private static void detectCircularReference(IXQEQueryNode start, String queryName) {
        RQPQuery nextRqpQuery;
        LoopDetectionChain ldc = new LoopDetectionChain();
        ldc.push(queryName);
        RQPQuery rqpQuery = null;
        rqpQuery = start.getType() == 801017 ? (RQPQuery)start : (RQPQuery)start.getAncestorOfType(801017);
        while (rqpQuery != null && (nextRqpQuery = (RQPQuery)rqpQuery.getAncestorOfType(801017)) != null) {
            if (!ldc.push(rqpQuery.getName())) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInModel, ldc.serialize());
            }
            rqpQuery = nextRqpQuery;
        }
    }

    private static boolean mustUnwind(RMQuery rmQuery) {
        IQuerySubject querySubject = rmQuery.getQuerySubject();
        if (!querySubject.getGeneratedSQLOption().equals("minimized")) {
            return true;
        }
        RQPJoinInfo joinInfo = (RQPJoinInfo)RQPNode.getRQPQuery(rmQuery).getRootRQPQuery().getFirstChildByType(801046);
        return RQPUtilities.querySubjectIsPartOfRepositoryJoins(joinInfo.getJoinsForQuerySubject(querySubject));
    }

    private static void copyRMQueryItemsForItemNormalization(PlanningEnvironment environment, RMQuery rmQuery, List<IXQEQueryNode> queryItems, RQPQuery newQuery, List<IXQEQueryNode> v5IdForProjs) {
        Object queryItem;
        ArrayList<IXQEQueryNode> done = new ArrayList<IXQEQueryNode>();
        IQuerySubject wrapper = rmQuery.getWrapperQuerySubject();
        ArrayList<RQPDataItem> keyItems = new ArrayList<RQPDataItem>();
        HashMap<IMetadata, Integer> qiToPos = new HashMap<IMetadata, Integer>();
        for (IXQEQueryNode q : queryItems) {
            queryItem = (RMQueryItem)q;
            IMetadata qi = ((RMQueryItem)queryItem).getQueryItem();
            if (!ItemNormalization.isGroupKey(wrapper, qi)) continue;
            RQPDataItem rqpDataItem = CreateRQPQueryFromRMQuery.copyRMQueryItem(environment, rmQuery, (RMQueryItem)queryItem, newQuery);
            RQPGroupByList groupByList = newQuery.getOrCreateGroupbyList(environment);
            RQPDataItemSelfRef selfRef = RQPDataItemSelfRef.create(environment, rqpDataItem.getName());
            groupByList.addChild(selfRef);
            if (((RMQueryItem)queryItem).getCount() == 0) {
                ((RMQueryItem)queryItem).incrementCount();
            }
            done.add(q);
            qiToPos.put(qi, keyItems.size());
            keyItems.add(rqpDataItem);
        }
        queryItems.removeAll(done);
        done.clear();
        block1: for (IXQEQueryNode v5Id : v5IdForProjs) {
            if (v5Id.getParent().getType() != 801008) continue;
            for (IXQEQueryNode q : queryItems) {
                IMetadata qi;
                RMQueryItem queryItem2 = (RMQueryItem)q;
                if (!((V5BoundModelIdentifier)v5Id).getIdentifier().equals(queryItem2.getV5UniqueName()) || !ItemNormalization.isWrappedQueryItem(wrapper, qi = queryItem2.getQueryItem())) continue;
                RQPDataItem rqpDataItem = CreateRQPQueryFromRMQuery.copyRMQueryItem(environment, rmQuery, queryItem2, newQuery);
                if (!ItemNormalization.applySQLOperator(environment, rqpDataItem, keyItems, qiToPos, wrapper, queryItem2.getQueryItem())) {
                    RQPGroupByList groupByList = newQuery.getOrCreateGroupbyList(environment);
                    RQPDataItemSelfRef selfRef = RQPDataItemSelfRef.create(environment, rqpDataItem.getName());
                    groupByList.addChild(selfRef);
                }
                done.add(q);
                continue block1;
            }
        }
        queryItems.removeAll(done);
        done.clear();
        for (IXQEQueryNode q : queryItems) {
            RQPDataItem rqpDataItem;
            queryItem = (RMQueryItem)q;
            if (((RMQueryItem)queryItem).getCount() <= 0 || ItemNormalization.applySQLOperator(environment, rqpDataItem = CreateRQPQueryFromRMQuery.copyRMQueryItem(environment, rmQuery, (RMQueryItem)queryItem, newQuery), keyItems, qiToPos, wrapper, ((RMQueryItem)queryItem).getQueryItem())) continue;
            RQPGroupByList groupByList = newQuery.getOrCreateGroupbyList(environment);
            RQPDataItemSelfRef selfRef = RQPDataItemSelfRef.create(environment, rqpDataItem.getName());
            groupByList.addChild(selfRef);
        }
    }
}

