/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilter;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilterList;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RMSqlAsView;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.PushFilterToSubQuery;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.ArrayList;

public class PushEmbeddedFilterToSubRMQuery
extends RQPTransformation {
    public static final String PUSHED_EXPR_LIST = "pushedList";

    public PushEmbeddedFilterToSubRMQuery() {
        this.mName = "PushEmbeddedFilterToSubRMQuery";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{801035};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RMQuery rmQuery = this.getRMQuery(node);
        this.moveFilterToSubQuery(environment, node, rmQuery);
    }

    private void moveFilterToSubQuery(PlanningEnvironment environment, IXQEQueryNode filter, RMQuery rmQuery) {
        Boolean bFromV5Filter = (Boolean)filter.getPropertyValue("fromV5Filter");
        IXQEQueryNode currentRMFilterList = filter.getParent();
        filter.detach();
        RMEmbeddedFilterList rmFilterList = rmQuery.getRMEmbeddedFilterList(environment);
        RMEmbeddedFilter rmEmbeddedFilter = RMEmbeddedFilterList.createRMEmbeddedFilter(environment, filter, "filterDefinition", "always");
        rmFilterList.addChild(rmEmbeddedFilter);
        if (Boolean.TRUE.equals(bFromV5Filter)) {
            Object jExpr = filter.getPropertyValue("orgFltExpr");
            Object orgExp = filter.getPropertyValue("originalExpression");
            if (jExpr != null || orgExp != null) {
                ArrayList<Object> lst = (ArrayList<Object>)currentRMFilterList.getPropertyValue(PUSHED_EXPR_LIST);
                if (lst == null) {
                    lst = new ArrayList<Object>();
                    currentRMFilterList.setPropertyValue(PUSHED_EXPR_LIST, lst);
                }
                if (jExpr != null) {
                    lst.add(jExpr);
                } else {
                    lst.add(orgExp);
                }
            }
        }
        filter.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            this.traceNodeCondition(true, "The embedded filter is not under a relational query.", xqeTrace);
            return false;
        }
        if (this.getRMQuery(node) == null) {
            this.traceNodeCondition(false, "This embedded filter can't be pushed down.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "This embedded filter needs to be pushed in sub-RMQuery.", xqeTrace);
        return true;
    }

    private RMQuery getRMQuery(IXQEQueryNode node) {
        RMQueryList rmQueryList = RQPUtilities.getRMQueryList(node);
        if (rmQueryList == null) {
            return null;
        }
        RMEmbeddedFilter embedFlt = (RMEmbeddedFilter)node;
        RMQuery currentRMQuery = (RMQuery)embedFlt.getAncestorOfCategory(801026);
        if (currentRMQuery == null) {
            return null;
        }
        IQuerySubject theQS = currentRMQuery.getQuerySubject();
        if (theQS == null || theQS.getSelectListControl() != IQuerySubject.SelectListControl.USEDQUERYITEMS) {
            return null;
        }
        IMetadata qs = PushFilterToSubQuery.getSingleQuerySubject(node, false);
        if (qs == null) {
            return null;
        }
        if (!PushFilterToSubQuery.checkOuterJoin((RQPJoinPath)currentRMQuery.getFirstChildByType(801039), qs)) {
            return null;
        }
        RMQuery rmQuery = PushFilterToSubQuery.getRMQueryMoreCheck(node, rmQueryList, qs, false);
        if (rmQuery == null || currentRMQuery == rmQuery) {
            return null;
        }
        if (rmQuery instanceof RMSqlAsView) {
            return null;
        }
        return rmQuery;
    }
}

