/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilter;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilterList;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RMQueryItemList;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.v5.query.V5JoinOperation;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.dynamic.DMQueryItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.PushFilterToSubQuery;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.Iterator;
import java.util.List;

public class PushExpressionsToDBQuery
extends PushFilterToSubQuery {
    public PushExpressionsToDBQuery() {
        this.mName = "PushExpressionsToDBQuery";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{101008, 801008};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] rmEmbeddedFilters;
        RMQuery rmQuery = this.getRMQuery(node, environment);
        if (node.getType() == 801008) {
            this.moveProjectionToRMQuery(environment, node, rmQuery);
            return;
        }
        for (IXQEQueryNode filter : rmEmbeddedFilters = rmQuery.getRMEmbeddedFilterList(environment).getChildren()) {
            if (!filter.getChild(0).isSameExpression(node.getChild(0), false)) continue;
            IXQEQueryNode parent = node.getParent();
            node.detach();
            if (parent.getChildren().length == 0) {
                parent.detach();
            }
            return;
        }
        this.moveFilterToRMQuery(environment, node, rmQuery);
    }

    private RMQuery getRMQuery(IXQEQueryNode node, PlanningEnvironment environment) {
        RMQueryList rmQueryList;
        IXQEQueryNode v5QuerySet = environment.getRoot();
        if (node.getType() == 801008) {
            if (node.getChild(0).getType() == 201116) {
                return null;
            }
            if (RQPUtilities.hasAggregateInExpression(node)) {
                return null;
            }
        }
        if ((rmQueryList = RQPUtilities.getRMQueryList(node)) == null) {
            return null;
        }
        if (node.getParent().getParent().getType() != 801017 && node.getParent().getParent().getType() != 801024 && node.getParent().getParent().getType() != 801025) {
            return null;
        }
        RQPQuery rqpQuery = (RQPQuery)node.getParent().getParent();
        RQPJoinPath joinPath = rqpQuery.getJoinPath();
        if (joinPath != null) {
            List<IMetadata> joins = joinPath.getJoinPath();
            for (IMetadata join : joins) {
                IRelationship relationship = (IRelationship)join;
                if (relationship.getLeftCardinality() == IRelationship.Cardinality.ZERO_ONE || relationship.getLeftCardinality() == IRelationship.Cardinality.ZERO_MANY || relationship.getRightCardinality() == IRelationship.Cardinality.ZERO_ONE || relationship.getRightCardinality() == IRelationship.Cardinality.ZERO_MANY) {
                    return null;
                }
                Object joinFilterType = relationship.getJoinFilterType();
                if (joinFilterType != IRelationship.JoinFilterType.FILTER_TYPE_NONE) {
                    return null;
                }
                String string = relationship.getFJOAdvancedProperty();
                if (string == null) continue;
                return null;
            }
        } else {
            return null;
        }
        IXQEQueryNode rmLayer = node.getAncestorOfTypes(new int[]{801032});
        if (rmLayer != null) {
            return null;
        }
        if (!node.getDescendantsOfTypeOrdered(201060, false).isEmpty()) {
            return null;
        }
        List<IXQEQueryNode> v5Identifiers = node.getDescendantsOfTypeOrdered(201116, false);
        String oneQSName = null;
        RMQuery rmQuery = null;
        for (IXQEQueryNode iXQEQueryNode : v5Identifiers) {
            V5BoundModelIdentifier boundIdentifier = (V5BoundModelIdentifier)iXQEQueryNode;
            IQueryItem queryItem = (IQueryItem)boundIdentifier.getMetadata();
            String qsName = boundIdentifier.getResolvedQSName();
            IQuerySubject theQS = boundIdentifier.getQuerySubject();
            if (theQS == null || theQS.getQuerySubjectUsage() == IQuerySubject.QuerySubjectUsageEnum.SUMMARY_QUERY) {
                return null;
            }
            if (theQS.getSelectListControl() == IQuerySubject.SelectListControl.USEDQUERYITEMS) {
                return null;
            }
            if (qsName == null) continue;
            if (oneQSName == null) {
                if (node.getType() == 101008 && queryItem.isFact()) {
                    return null;
                }
                oneQSName = qsName;
                rmQuery = rmQueryList.getRMQuery(qsName);
                continue;
            }
            if (oneQSName.equals(qsName)) continue;
            return null;
        }
        if (rmQuery != null && (rmQuery.getType() == 801027 || rmQuery.getType() == 801028)) {
            IXQEQueryNode[] rmQIs;
            for (IXQEQueryNode item : rmQIs = rmQuery.getRMQueryItemList(environment).getChildren()) {
                RMQueryItem rmQueryItem = (RMQueryItem)item;
                if (rmQueryItem.getCount() <= 0 || !RQPUtilities.hasAggregateInExpression(item)) continue;
                return null;
            }
            Iterator<IXQEQueryNode> iterator = v5QuerySet.getChildrenIterator();
            while (iterator.hasNext()) {
                IXQEQueryNode child = iterator.next();
                if (child.getType() != 101006) continue;
                V5Query v5Query = (V5Query)child;
                V5Source source = v5Query.getV5Source();
                if (source.getFirstChildByType(101018) != null) {
                    return null;
                }
                List<IXQEQueryNode> joins = source.getDescendantsOfTypeOrdered(101019, false);
                for (IXQEQueryNode j : joins) {
                    V5JoinOperation joinOperation = (V5JoinOperation)j;
                    SQLJoin.SubType joinType = joinOperation.getJoinType();
                    if (joinType != SQLJoin.SubType.LEFT_OUTER && joinType != SQLJoin.SubType.RIGHT_OUTER && joinType != SQLJoin.SubType.FULL_OUTER) continue;
                    return null;
                }
            }
            return rmQuery;
        }
        return null;
    }

    private void moveFilterToRMQuery(PlanningEnvironment environment, IXQEQueryNode v5DetailFilter, RMQuery rmQuery) {
        IXQEQueryNode parentNode = v5DetailFilter.getParent();
        v5DetailFilter.detach();
        RMEmbeddedFilterList rmFilterList = rmQuery.getRMEmbeddedFilterList(environment);
        RMEmbeddedFilter rmEmbeddedFilter = RMEmbeddedFilterList.createRMEmbeddedFilter(environment, v5DetailFilter, "filterDefinition", "always");
        rmFilterList.addChild(rmEmbeddedFilter);
        v5DetailFilter.extract();
        if (parentNode.getNumberChildren() == 0) {
            parentNode.extract();
        }
        if (rmQuery.getType() == 801028) {
            RMQuery newRmQuery = (RMQuery)environment.getNodeFactory().createNode(801027);
            newRmQuery.setName(rmQuery.getName());
            newRmQuery.setQuerySubject(rmQuery.getQuerySubject(), environment);
            newRmQuery.setNameParts(rmQuery.getNameParts());
            rmQuery.exchange(newRmQuery, true);
        }
    }

    private void moveProjectionToRMQuery(PlanningEnvironment environment, IXQEQueryNode dataItem, RMQuery rmQuery) {
        RMQueryItemList rmQueryItemList = rmQuery.getRMQueryItemList(environment);
        String calculationName = ((RQPDataItem)dataItem).getName();
        IQuerySubject qs = rmQuery.getQuerySubject();
        String uniqueName = qs.getID() + ".[" + calculationName + "]";
        DMQueryItem dynamicQueryItem = new DMQueryItem(uniqueName, calculationName, qs);
        V5BoundModelIdentifier calculationBoundId = (V5BoundModelIdentifier)environment.getNodeFactory().createNode(201116);
        calculationBoundId.setMetadata(dynamicQueryItem);
        calculationBoundId.setIdentifier(uniqueName);
        IXQEQueryNode childExpression = dataItem.getChild(0);
        childExpression.detach();
        dataItem.addChild(calculationBoundId);
        RMQueryItem rmQueryItem = (RMQueryItem)environment.getNodeFactory().createNode(801033);
        rmQueryItemList.addChild(rmQueryItem);
        rmQueryItem.setQueryItem(dynamicQueryItem);
        rmQueryItem.addChild(childExpression);
        rmQueryItem.incrementCount();
        if (rmQuery.getType() == 801028) {
            RMQuery newRmQuery = (RMQuery)environment.getNodeFactory().createNode(801027);
            newRmQuery.setName(rmQuery.getName());
            newRmQuery.setQuerySubject(rmQuery.getQuerySubject(), environment);
            newRmQuery.setNameParts(rmQuery.getNameParts());
            newRmQuery.getRMEmbeddedFilterList(environment);
            rmQuery.exchange(newRmQuery, true);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean pushCalculationsToInnerQuery = config.getBooleanProperty("queryPlanning.qsPushCalculationsToInnerQuery[@enabled]", false);
        boolean pushFiltersToInnerQuery = config.getBooleanProperty("queryPlanning.qsPushFiltersToInnerQuery[@enabled]", false);
        if (node.getType() == 801008 && !pushCalculationsToInnerQuery) {
            this.traceNodeCondition(false, "pushCalculationsToInnerQuery is not enabled.", xqeTrace);
            return false;
        }
        if (node.getType() == 101008 && !pushFiltersToInnerQuery) {
            this.traceNodeCondition(false, "pushFiltersToInnerQuery is not enabled.", xqeTrace);
            return false;
        }
        if (!node.isWithinScope(801017, 1002)) {
            this.traceNodeCondition(false, "The node is a child of RQPQuery.", xqeTrace);
            return false;
        }
        if (this.getRMQuery(node, environment) == null) {
            this.traceNodeCondition(false, "This expression cannot be moved under a RMDBQuery.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "This expression can be pushed to a RMDBQuery", xqeTrace);
        return true;
    }
}

