/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5.ExpandDataItemReferences;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.ExpandEmbeddedCalcsFilters;
import com.cognos.xqemoser.MoserQuerySubject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SetExpandSelfRefCalcs
extends ExpandEmbeddedCalcsFilters {
    public static final String EXPAND_SELFREF_CALC_FILTERS = "expandSefRefCalcs";
    private static final int NUM_TIMES_REFERENCED_LIMIT = 3;
    private static final int MAX_NESTING_LIMIT = 2;

    public SetExpandSelfRefCalcs() {
        this.mName = "Set flag indicating whether self referencing calculation should be replaced with data item references";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{801029};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        return ExpandDataItemReferences.generateSubqueryForCalc(node, environment) && this.isFromModule(node);
    }

    private boolean isFromModule(IXQEQueryNode node) {
        RMQuery rmQuery = (RMQuery)node;
        IQuerySubject qs = rmQuery.getQuerySubject();
        return qs != null && qs instanceof MoserQuerySubject;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        List<V5BoundModelIdentifier> calcOrFilterIdentifiers = this.collectCalcOrFilterIdentifiers(node);
        this.incrementRefCount(calcOrFilterIdentifiers);
        if (this.numCalcReferencesReachesLimit(node, calcOrFilterIdentifiers)) {
            node.setPropertyValue(EXPAND_SELFREF_CALC_FILTERS, Boolean.FALSE);
            return;
        }
        if (this.numNestedCalcReferencesReachesLimit(node, calcOrFilterIdentifiers)) {
            node.setPropertyValue(EXPAND_SELFREF_CALC_FILTERS, Boolean.FALSE);
            return;
        }
        node.setPropertyValue(EXPAND_SELFREF_CALC_FILTERS, Boolean.TRUE);
    }

    private boolean numNestedCalcReferencesReachesLimit(IXQEQueryNode node, List<V5BoundModelIdentifier> calcOrFilterIdentifiers) {
        List<RMQueryItem> rmItems = this.getCalcRMItems(calcOrFilterIdentifiers);
        Map<String, List<String>> dependencies = this.getCalcDependency(rmItems);
        int maxNesting = 0;
        for (String key : dependencies.keySet()) {
            HashSet<String> visited;
            int maxNestingForCurrent = this.getMaxNesting(key, visited = new HashSet<String>(), dependencies, 0);
            if (maxNestingForCurrent <= maxNesting) continue;
            maxNesting = maxNestingForCurrent;
        }
        return maxNesting >= 2;
    }

    private int getMaxNesting(String rmItem, Set<String> visited, Map<String, List<String>> dependencies, int nestedRefCount) {
        if (visited.contains(rmItem)) {
            return nestedRefCount;
        }
        int maxNesting = nestedRefCount;
        visited.add(rmItem);
        for (String dependentItem : dependencies.get(rmItem)) {
            int maxNestingForCurrent = this.getMaxNesting(dependentItem, visited, dependencies, nestedRefCount + 1);
            if (maxNestingForCurrent <= maxNesting) continue;
            maxNesting = maxNestingForCurrent;
        }
        visited.remove(rmItem);
        return maxNesting;
    }

    private List<RMQueryItem> getCalcRMItems(List<V5BoundModelIdentifier> calcOrFilterIdentifiers) {
        ArrayList<RMQueryItem> rmItems = new ArrayList<RMQueryItem>();
        for (V5BoundModelIdentifier identifier : calcOrFilterIdentifiers) {
            RMQueryItem rmQueryItem = this.getRMQueryItem(identifier);
            if (rmQueryItem == null || this.isInList(rmItems, rmQueryItem)) continue;
            rmItems.add(rmQueryItem);
        }
        return rmItems;
    }

    private Map<String, List<String>> getCalcDependency(List<RMQueryItem> rmItems) {
        HashMap<String, List<String>> dependency = new HashMap<String, List<String>>();
        for (RMQueryItem item : rmItems) {
            IXQEQueryNode[] ids;
            ArrayList<String> depList = new ArrayList<String>();
            dependency.put(item.getID(), depList);
            for (IXQEQueryNode id : ids = item.getDescendantsOfType(201116, false)) {
                V5BoundModelIdentifier identifier = (V5BoundModelIdentifier)id;
                RMQueryItem qItem = this.getRMQueryItem(identifier);
                if (qItem == item || !this.isInList(rmItems, qItem) || depList.contains(qItem.getID())) continue;
                depList.add(qItem.getID());
            }
        }
        return dependency;
    }

    private boolean isInList(List<RMQueryItem> rmItems, RMQueryItem rmQueryItem) {
        boolean found = false;
        for (RMQueryItem item : rmItems) {
            if (item != rmQueryItem) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean numCalcReferencesReachesLimit(IXQEQueryNode node, List<V5BoundModelIdentifier> calcOrFilterIdentifiers) {
        for (V5BoundModelIdentifier identifier : calcOrFilterIdentifiers) {
            RMQueryItem rmQueryItem = this.getRMQueryItem(identifier);
            if (rmQueryItem == null || rmQueryItem.getCount() < 3 || !rmQueryItem.getChild(0).isOfCategory(201125)) continue;
            return true;
        }
        return false;
    }

    private void incrementRefCount(List<V5BoundModelIdentifier> calcOrFilterIdentifiers) {
        for (V5BoundModelIdentifier identifier : calcOrFilterIdentifiers) {
            RMQueryItem rmQueryItem = this.getRMQueryItem(identifier);
            if (rmQueryItem == null) continue;
            rmQueryItem.incrementCount();
        }
    }

    private List<V5BoundModelIdentifier> collectCalcOrFilterIdentifiers(IXQEQueryNode node) {
        IXQEQueryNode[] identifiers = node.getDescendantsOfType(201116, false, this.mTypes);
        ArrayList<V5BoundModelIdentifier> calcOrFilterIdentifiers = new ArrayList<V5BoundModelIdentifier>();
        for (IXQEQueryNode id : identifiers) {
            V5BoundModelIdentifier identifier = (V5BoundModelIdentifier)id;
            if (!this.isQueryItemHasExpression(identifier)) continue;
            RMQueryItem queryItem = this.getRMQueryItem(identifier);
            RMQueryItem parentQueryItem = (RMQueryItem)identifier.getAncestorOfType(801033);
            if (!this.referencesSameQuerySubject(identifier) || queryItem == null || queryItem.getCount() <= 0 || parentQueryItem != null && parentQueryItem.getCount() <= 0) continue;
            calcOrFilterIdentifiers.add(identifier);
        }
        return calcOrFilterIdentifiers;
    }
}

