/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSubqueryList;
import com.cognos.xqe.ast.sql.SQLFromClause;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.util.RQEUtil;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.SummaryQuerySubjectUtilities;
import com.cognos.xqe.util.Pair;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class TransferRQPSubqueryToFromClause
extends RQPTransformation {
    public TransferRQPSubqueryToFromClause() {
        this.mName = "TransferRQPSubqueryToFromClause.";
        this.mPassNumbers = new int[]{22};
        this.mTypes = new int[]{801017};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IQuerySubject.SelectListControl aProp;
        Pair aggrQSName;
        RQPQuery rqpQuery = (RQPQuery)node;
        RQPQuery parentQuery = (RQPQuery)node.getParent().getParent();
        String queryName = rqpQuery.getName();
        SQLRangeVar rangeVar = (SQLRangeVar)environment.getNodeFactory().createNode(301007);
        if (rqpQuery.isSubqueryForCalcsInQS()) {
            RQPQuery.setSubqueryForCalcsInQS(rangeVar, true);
        }
        RQEUtil.transferNoCache(rqpQuery, rangeVar);
        String qsName = (String)rqpQuery.getPropertyValue("QSNAME");
        if (qsName != null) {
            rangeVar.setPropertyValue("fullQSName", qsName);
        }
        if ((aggrQSName = (Pair)rqpQuery.getPropertyValue("aggregateQuerySubject")) != null) {
            rangeVar.setPropertyValue("aggregateQuerySubject", aggrQSName);
        }
        rangeVar.setName(queryName);
        if (rqpQuery.getPropertyValue("isForAsViewModelQueryWithDeterminants") != null) {
            rangeVar.setPropertyValue("hasDeterminant", true);
        }
        if (rqpQuery.isAsViewModelQuery()) {
            rangeVar.setSubQueryType(SQLRangeVar.PropertySubqueryTypeEnum.RMSQLCALCFILTER_OR_RMMODELQUERYASVIEW);
        }
        if (rqpQuery.isSQSQuery() && SummaryQuerySubjectUtilities.getUseLocalCache(rqpQuery.getSQSOwner())) {
            rangeVar.setCandidateForQueryReuse(true);
        }
        SQLFromClause fromClause = RQPUtilities.getFromClauseNode(parentQuery, environment.getNodeFactory());
        fromClause.addChild(rangeVar);
        String sProp = (String)rqpQuery.getPropertyValue("dbHint");
        if (sProp != null) {
            rangeVar.setPropertyValue("dbHint", sProp);
        }
        if ((aProp = (IQuerySubject.SelectListControl)((Object)rqpQuery.getPropertyValue("selectControl"))) != null) {
            rangeVar.setPropertyValue("selectControl", (Object)aProp);
        }
        rqpQuery.move(rangeVar);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] allQueryChildren;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        IXQEQueryNode rqpSubqueryList = node.getParent();
        if (!(rqpSubqueryList instanceof RQPSubqueryList)) {
            this.traceNodeCondition(false, "This RQPQuery node is not directly under a RQPSubqueryList node.", xqeTrace);
            return false;
        }
        RQPQuery outerQuery = (RQPQuery)rqpSubqueryList.getParent();
        if (outerQuery == null) {
            this.traceNodeCondition(false, "This RQPQuery is not under another RQPQuery node.", xqeTrace);
            return false;
        }
        RQPQuery rqpQuery = (RQPQuery)node;
        if (rqpQuery.getAsViewSubqueryGeneration()) {
            this.traceNodeCondition(true, "The current RQPQuery is a subquery for the asView context generation", xqeTrace);
            return true;
        }
        String queryName = rqpQuery.getName();
        for (IXQEQueryNode c : allQueryChildren = outerQuery.getChildren()) {
            IXQEQueryNode[] dataItemRefs;
            if (c.getType() == 801022) continue;
            for (IXQEQueryNode q : dataItemRefs = c.getDescendantsOfType(801009, false)) {
                String refQueryName;
                RQPDataItemRef dataItemRef = (RQPDataItemRef)q;
                if (!dataItemRef.createdFromQS() || !queryName.equals(refQueryName = dataItemRef.getQueryName())) continue;
                this.traceNodeCondition(true, "The current RQPQuery is a subquery since the outer RQPQuery refers to it.", xqeTrace);
                return true;
            }
        }
        this.traceNodeCondition(false, "The outer RQPQuery does not refer to the current RQPQuery node.", xqeTrace);
        return false;
    }
}

