/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.Governors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class BuildQueryDependencyList
extends Transformation {
    public static final String PROP_ORDERED_QUERY_LIST = "orderedQueryList";

    public BuildQueryDependencyList() {
        this.mName = "BuildQueryDependencyList";
        this.mPassNumbers = new int[]{38};
        this.mTypes = new int[]{101002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ArrayList<String> queryList = new ArrayList<String>();
        TreeMap<String, TreeSet<String>> queryDependencyMap = new TreeMap<String, TreeSet<String>>();
        V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(environment, node);
        IXQEQueryNode[] v5Queries = rootQuerySet.getChildrenOfType(101006);
        boolean crossProductAllowed = false;
        for (IXQEQueryNode v5Query : v5Queries) {
            Governors governors;
            V5Query referencingQuery = (V5Query)v5Query;
            Set<String> dependentQueries = referencingQuery.getSubQueryNames(environment);
            TreeSet<String> sortedDependentQueries = new TreeSet<String>(dependentQueries);
            queryDependencyMap.put(referencingQuery.getV5QueryName(), sortedDependentQueries);
            if (crossProductAllowed || (governors = referencingQuery.getGovernors()).getCrossProdAllowed() != Governors.GovernorPermission.ALLOW) continue;
            crossProductAllowed = true;
        }
        if (crossProductAllowed) {
            rootQuerySet.setPropertyValue(V5Query.QueryHint.CROSS_PRODUCT_ALLOWED.getPropertyName(), true);
        }
        int queryDependencyMapSize = queryDependencyMap.size();
        int queryListSize = 0;
        if (queryDependencyMapSize == 1) {
            queryList.addAll(queryDependencyMap.keySet());
        } else {
            TreeMap tempMap = (TreeMap)queryDependencyMap.clone();
            while (queryListSize != queryDependencyMapSize) {
                Set referencingQueries = tempMap.keySet();
                TreeSet copiedKeySet = new TreeSet(referencingQueries);
                for (String referencingQ : copiedKeySet) {
                    TreeSet dependentQueries = (TreeSet)tempMap.get(referencingQ);
                    if (!dependentQueries.isEmpty() && !this.existInNameList(queryList, dependentQueries)) continue;
                    queryList.add(referencingQ);
                    ++queryListSize;
                    tempMap.remove(referencingQ);
                }
            }
        }
        node.setPropertyValue(PROP_ORDERED_QUERY_LIST, queryList);
        node.setPropertyValue("queryDependencyMap", queryDependencyMap);
    }

    private boolean existInNameList(List<String> nameList, Set<String> dependentQueries) {
        for (String dependentQ : dependentQueries) {
            if (nameList.contains(dependentQ)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROP_ORDERED_QUERY_LIST) != null) {
            this.traceQueryCondition(false, "The query dependency list is already built.", trace);
            return false;
        }
        Collection rqpSqls = environment.getNodeIndex().getNodesByType(801041);
        if (rqpSqls.isEmpty()) {
            this.traceQueryCondition(false, "There are no relational queries in the request.", trace);
            return false;
        }
        Collection v5Queries = environment.getNodeIndex().getNodesByType(101006);
        if (v5Queries.isEmpty()) {
            this.traceQueryCondition(false, "There are no V5 queries in the request.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The query dependency list needs to be built.", trace);
        return true;
    }
}

