/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWith;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Governors;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class GenerateCTEInWithClauseForRQPSubQuery
extends Transformation {
    public static final String PROP_BOOL_NEED_NEW_NAME_FOR_CTE = "needNewNameForCTE";
    public static final String PROP_RELATION_REFERENCE = "sqlRelationReference";
    private static final String PROP_CTE_NOT_REUSABLE = "cteNotReusable";

    public GenerateCTEInWithClauseForRQPSubQuery() {
        this.mName = "Generate common table expressions of WITH clause for RQP sub-queries";
        this.mPassNumbers = new int[]{58};
        this.mTypes = new int[]{301007, 301004};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String cteName;
        String initialRangeVarName = this.getName(node);
        SQLWith sqlWith = (SQLWith)node.getAncestorOfType(301022);
        List<String> cteNameList = sqlWith.getNameList();
        IXQEQueryNode parentOfRangeVar = node.getParent();
        int rangeVarPosition = parentOfRangeVar.getPositionOfChild(node);
        if (node.getType() == 301007) {
            IXQEQueryNode existingCte = this.findExistingCteThatCanBeReused(sqlWith, node);
            if (existingCte != null && this.completeProjectionListOfExistingCTE(existingCte, node)) {
                node.detach();
                SQLRelation sqlRelation = (SQLRelation)environment.getNodeFactory().createNode(301016);
                String newName = this.getName(existingCte);
                String fullQSName = this.getFullQSName(existingCte);
                sqlRelation.setName(newName);
                if (fullQSName != null) {
                    sqlRelation.setPropertyValue("fullQSName", fullQSName);
                }
                parentOfRangeVar.addChild(sqlRelation, rangeVarPosition);
                if (!newName.equals(initialRangeVarName)) {
                    GenerateCTEInWithClauseForRQPSubQuery.updateSQLColumnsInParentQuery(initialRangeVarName, newName, parentOfRangeVar);
                }
                return;
            }
        } else if (node.getType() == 301004 && this.findExistingQueryBlockCteWithSameName(sqlWith, node) != null) {
            node.setPropertyValue(PROP_BOOL_NEED_NEW_NAME_FOR_CTE, true);
        }
        if (this.canUseSameNameForCte(node)) {
            cteName = initialRangeVarName;
            HashMap identifierIndex = (HashMap)sqlWith.getPropertyValue("identifierIndex");
            identifierIndex.put(initialRangeVarName, 1);
        } else {
            cteName = this.getNewIdentifierForCte(initialRangeVarName, sqlWith);
            node.setPropertyValue("originalName", this.getName(node));
            this.setName(node, cteName);
            GenerateCTEInWithClauseForRQPSubQuery.updateSQLColumnsInParentQuery(initialRangeVarName, cteName, parentOfRangeVar);
            if (node.getType() == 301004) {
                SQLQueryItemList list = ((SQLQueryBlock)node).getQueryItemList().copy();
                ((SQLQueryBlock)node).setQueryItemList(list);
                for (int i = 0; i < list.size(); ++i) {
                    SQLQueryItem item = (SQLQueryItem)list.get(i);
                    item.setTableName(cteName);
                }
            }
        }
        int ctePositionInWithClause = GenerateCTEInWithClauseForRQPSubQuery.getCtePositionInWithClause(node);
        node.move(sqlWith, ctePositionInWithClause);
        cteNameList.add(ctePositionInWithClause, cteName);
        SQLRelation sqlRelation = (SQLRelation)environment.getNodeFactory().createNode(301016);
        sqlRelation.setName(cteName);
        String fullQSName = this.getFullQSName(node);
        if (fullQSName != null) {
            sqlRelation.setPropertyValue("fullQSName", fullQSName);
        }
        parentOfRangeVar.addChild(sqlRelation, rangeVarPosition);
        if (sqlRelation.getAncestorOfType(301059) != null) {
            node.setPropertyValue(PROP_RELATION_REFERENCE, sqlRelation);
        }
    }

    private String getName(IXQEQueryNode node) {
        String initialRangeVarName = node.getType() == 301004 ? ((SQLQueryBlock)node).getName() : ((SQLRangeVar)node).getName();
        return initialRangeVarName;
    }

    private String getFullQSName(IXQEQueryNode node) {
        return (String)node.getPropertyValue("fullQSName");
    }

    private void setName(IXQEQueryNode node, String newName) {
        if (node.getType() == 301004) {
            ((SQLQueryBlock)node).setName(newName);
        } else {
            ((SQLRangeVar)node).setName(newName);
        }
    }

    public static int getCtePositionInWithClause(IXQEQueryNode currentRangeVar) {
        IXQEQueryNode parent = currentRangeVar.getParent();
        if (parent == null) {
            return -1;
        }
        if (parent.getType() == 301022) {
            return parent.getPositionOfChild(currentRangeVar);
        }
        return GenerateCTEInWithClauseForRQPSubQuery.getCtePositionInWithClause(parent);
    }

    private boolean canUseSameNameForCte(IXQEQueryNode inputRangeVar) {
        return inputRangeVar.getPropertyValue(PROP_BOOL_NEED_NEW_NAME_FOR_CTE) == null;
    }

    private IXQEQueryNode findExistingCteThatCanBeReused(SQLWith sqlWithNode, IXQEQueryNode inputNode) {
        SQLRangeVar inputRangeVar = (SQLRangeVar)inputNode;
        String inputRangeVarName = this.getQuerySubjectName(inputRangeVar);
        boolean foundCteNameMatch = false;
        for (IXQEQueryNode child : sqlWithNode.getChildrenOfType(301007)) {
            String cteName;
            RQPQuery rqpquery;
            SQLRangeVar cte = (SQLRangeVar)child;
            IXQEQueryNode childOfRangeVar = cte.getChild(0);
            if (childOfRangeVar.getType() == 801017 && (rqpquery = (RQPQuery)childOfRangeVar).getPropertyValue("v5ref") != null || !(cteName = this.getQuerySubjectName(cte)).equals(inputRangeVarName)) continue;
            foundCteNameMatch = true;
            if (!this.canReuseCTE(inputRangeVar, cte)) continue;
            return cte;
        }
        if (foundCteNameMatch) {
            inputRangeVar.setPropertyValue(PROP_BOOL_NEED_NEW_NAME_FOR_CTE, true);
            this.markUpperSubQueriesNotReusable(inputRangeVar);
        }
        return null;
    }

    private boolean canReuseCTE(SQLRangeVar inputRangeVar, SQLRangeVar cte) {
        if (inputRangeVar.getPropertyValue(PROP_CTE_NOT_REUSABLE) != null) {
            return false;
        }
        if (this.hasDeterminant(inputRangeVar, cte)) {
            return false;
        }
        return !this.hasDifferentFilter(inputRangeVar, cte);
    }

    private void markUpperSubQueriesNotReusable(SQLRangeVar inputRangeVar) {
        IXQEQueryNode[] sqlRangeVars;
        for (IXQEQueryNode rv : sqlRangeVars = inputRangeVar.getAncestorsOfType(301007)) {
            SQLRangeVar rangeVar = (SQLRangeVar)rv;
            if (rangeVar.getNumberChildren() == 0 || rangeVar.getChild(0).getType() == 301016 || rangeVar.getParent().getNodeType() == 301022) continue;
            rangeVar.setPropertyValue(PROP_CTE_NOT_REUSABLE, true);
        }
    }

    private String getQuerySubjectName(SQLRangeVar sqlRangeVar) {
        String inputRangeVarName = this.getFullQSName(sqlRangeVar);
        if (inputRangeVarName == null) {
            inputRangeVarName = sqlRangeVar.getOriginalName();
        }
        if (inputRangeVarName == null) {
            inputRangeVarName = sqlRangeVar.getName();
        }
        return inputRangeVarName;
    }

    private IXQEQueryNode findExistingQueryBlockCteWithSameName(SQLWith sqlWithNode, IXQEQueryNode inputNode) {
        IXQEQueryNode[] sqlWithChildren;
        String inputNodeName = ((SQLQueryBlock)inputNode).getName();
        for (IXQEQueryNode child : sqlWithChildren = sqlWithNode.getChildren()) {
            String blockName;
            if (child.getType() != 301004 || (blockName = ((SQLQueryBlock)child).getName()) == null || !blockName.equals(inputNodeName)) continue;
            return child;
        }
        return null;
    }

    private boolean hasDifferentFilter(SQLRangeVar inputRangeVar, SQLRangeVar cte) {
        boolean[] hasFilter = new boolean[]{false, false};
        SQLFilter filter1 = null;
        SQLFilter filter2 = null;
        IXQEQueryNode child = inputRangeVar.getChild(0);
        if (child.getType() == 801012 || child.getType() == 801024) {
            if (child.getPropertyValue("hasFilterConvertedFromSummaryFilter") != null) {
                hasFilter[0] = true;
            }
        } else if (child.getType() == 801017) {
            filter1 = this.getSQLFilterNode(child);
        }
        if ((child = cte.getChild(0)).getType() == 801012 || child.getType() == 801024) {
            if (child.getPropertyValue("hasFilterConvertedFromSummaryFilter") != null) {
                hasFilter[1] = true;
            }
        } else if (child.getType() == 801017) {
            filter2 = this.getSQLFilterNode(child);
        }
        if (filter1 != null && filter2 == null || filter1 == null && filter2 != null) {
            return true;
        }
        if (filter1 != null) {
            return !filter1.isSameExpression(filter2, false);
        }
        return hasFilter[0] != hasFilter[1];
    }

    private SQLFilter getSQLFilterNode(IXQEQueryNode node) {
        if (node.getType() == 301009) {
            return (SQLFilter)node;
        }
        if (node.getType() == 301007 || node.getType() == 301016) {
            return null;
        }
        if (node.getNumberChildren() > 0) {
            return this.getSQLFilterNode(node.getChild(0));
        }
        return null;
    }

    private boolean hasDeterminant(SQLRangeVar inputRangeVar, SQLRangeVar cte) {
        return inputRangeVar.getPropertyValue("hasDeterminant") != null || cte.getPropertyValue("hasDeterminant") != null;
    }

    private boolean completeProjectionListOfExistingCTE(IXQEQueryNode cteOfWithClause, IXQEQueryNode inputNode) {
        if (inputNode.getType() == 301004) {
            return true;
        }
        SQLRangeVar inputRangeVar = (SQLRangeVar)inputNode;
        if (inputRangeVar.getSubQueryType() != SQLRangeVar.PropertySubqueryTypeEnum.RMSQLCALCFILTER_OR_RMMODELQUERYASVIEW) {
            return true;
        }
        SQLValueList rangeVarValueList = inputRangeVar.getOutputList();
        if (rangeVarValueList == null) {
            return true;
        }
        SQLValueList cteValueList = ((SQLRangeVar)cteOfWithClause).getOutputList();
        if (cteValueList == null) {
            return true;
        }
        ArrayList<IXQEQueryNode> derivedColumns = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode column : cteValueList.getChildren()) {
            derivedColumns.add(column);
        }
        for (IXQEQueryNode projection : rangeVarValueList.getChildren()) {
            String aliasName = ((SQLAlias)projection).getName();
            String origColName = GenerateCTEInWithClauseForRQPSubQuery.getOriginalColumnName((SQLAlias)projection);
            for (IXQEQueryNode derivedCol : derivedColumns) {
                String derivedColOrigName;
                if (derivedCol.getType() != 301028 || !aliasName.equals(((SQLAlias)derivedCol).getName()) || origColName.equals(derivedColOrigName = GenerateCTEInWithClauseForRQPSubQuery.getOriginalColumnName((SQLAlias)derivedCol))) continue;
                inputRangeVar.setPropertyValue(PROP_BOOL_NEED_NEW_NAME_FOR_CTE, true);
                return false;
            }
        }
        HashMap<String, String> relationNameMap = null;
        for (IXQEQueryNode projection : rangeVarValueList.getChildren()) {
            String aliasName = ((SQLAlias)projection).getName();
            boolean found = false;
            for (IXQEQueryNode derivedCol : derivedColumns) {
                if (derivedCol.getType() != 301028 || !aliasName.equals(((SQLAlias)derivedCol).getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (relationNameMap == null) {
                relationNameMap = this.buildRelationNameMap(inputRangeVar, cteOfWithClause);
            }
            for (String oldRelationName : relationNameMap.keySet()) {
                GenerateCTEInWithClauseForRQPSubQuery.updateSQLColumns(oldRelationName, relationNameMap.get(oldRelationName), projection);
            }
            projection.move(cteValueList);
            derivedColumns.add(projection);
        }
        return true;
    }

    private HashMap<String, String> buildRelationNameMap(SQLRangeVar currentRangeVar, IXQEQueryNode cteOfWithClause) {
        List<IXQEQueryNode> relations1 = currentRangeVar.getDescendantsOfTypeOrdered(301016, false);
        List<IXQEQueryNode> relations2 = cteOfWithClause.getDescendantsOfTypeOrdered(301016, false);
        SQLWith sqlWith = (SQLWith)cteOfWithClause.getParent();
        HashMap<String, String> relationNameMap = new HashMap<String, String>();
        block0: for (IXQEQueryNode relation1 : relations1) {
            IXQEQueryNode relation2;
            String relation1Name = ((SQLRelation)relation1).getName();
            SQLRangeVar rVar1 = this.findSQLRangeVar(sqlWith, relation1Name);
            String originalName1 = null;
            if (rVar1 != null) {
                originalName1 = rVar1.getOriginalName();
            }
            String relation2Name = null;
            Iterator<IXQEQueryNode> iterator = relations2.iterator();
            while (iterator.hasNext() && !relation1Name.equals(relation2Name = ((SQLRelation)(relation2 = iterator.next())).getName())) {
                if (originalName1 != null && originalName1.equals(relation2Name)) {
                    relationNameMap.put(relation1Name, relation2Name);
                    continue block0;
                }
                SQLRangeVar rVar2 = this.findSQLRangeVar(sqlWith, relation2Name);
                String originalName2 = null;
                if (rVar2 != null) {
                    originalName2 = rVar2.getOriginalName();
                }
                if (originalName2 == null || !originalName2.equals(relation1Name)) continue;
                relationNameMap.put(relation1Name, relation2Name);
                continue block0;
            }
        }
        return relationNameMap;
    }

    private SQLRangeVar findSQLRangeVar(SQLWith sqlWith, String relationName) {
        for (IXQEQueryNode node : sqlWith.getChildren()) {
            if (node.getType() != 301007 || !relationName.equals(((SQLRangeVar)node).getName())) continue;
            return (SQLRangeVar)node;
        }
        return null;
    }

    public static void updateSQLColumnsInParentQuery(String oldTableName, String newTableName, IXQEQueryNode parentNode) {
        boolean beyondParentQueryScope = false;
        switch (parentNode.getType()) {
            case 301014: 
            case 301043: {
                break;
            }
            case 301009: 
            case 301011: {
                int lastChildPos = parentNode.getNumberChildren() - 1;
                if (lastChildPos <= 0) break;
                GenerateCTEInWithClauseForRQPSubQuery.updateSQLColumns(oldTableName, newTableName, parentNode.getChild(lastChildPos));
                break;
            }
            case 301010: {
                IXQEQueryNode valueList;
                IXQEQueryNode groupByList = parentNode.getFirstChildByType(301029);
                if (groupByList != null) {
                    GenerateCTEInWithClauseForRQPSubQuery.updateSQLColumns(oldTableName, newTableName, groupByList);
                }
                if ((valueList = parentNode.getFirstChildByType(301030)) == null) break;
                GenerateCTEInWithClauseForRQPSubQuery.updateSQLColumns(oldTableName, newTableName, valueList);
                break;
            }
            case 301015: {
                IXQEQueryNode valueList = parentNode.getFirstChildByType(301030);
                if (valueList == null) break;
                GenerateCTEInWithClauseForRQPSubQuery.updateSQLColumns(oldTableName, newTableName, valueList);
                break;
            }
            default: {
                beyondParentQueryScope = true;
            }
        }
        if (!beyondParentQueryScope && (parentNode = parentNode.getParent()) != null) {
            GenerateCTEInWithClauseForRQPSubQuery.updateSQLColumnsInParentQuery(oldTableName, newTableName, parentNode);
        }
    }

    private static void updateSQLColumns(String oldTableName, String newTableName, IXQEQueryNode node) {
        IXQEQueryNode[] columns;
        for (IXQEQueryNode column : columns = node.getDescendantsOfType(301005, false)) {
            SQLColumn sqlColumnNode = (SQLColumn)column;
            if (!sqlColumnNode.getTableName().equals(oldTableName)) continue;
            sqlColumnNode.setTableName(newTableName);
        }
    }

    private String getNewIdentifierForCte(String sqlRangeVarName, SQLWith sqlWith) {
        HashMap identifierIndex = (HashMap)sqlWith.getPropertyValue("identifierIndex");
        Integer index = (Integer)identifierIndex.get(sqlRangeVarName);
        if (index == null) {
            index = 1;
        } else {
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        identifierIndex.put(sqlRangeVarName, index);
        return sqlRangeVarName + index.toString();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        SQLTableFunction sqlTableFunction;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode parent = node.getParent();
        if (node.getType() == 301004) {
            if (node.getPropertyValue("typedInSQLRootNode") == null) {
                this.traceQueryCondition(false, "SQLQueryBlock is not the root node of the typed-in SQL.", trace);
                return false;
            }
            if (parent == null || parent.getType() == 101016) {
                this.traceQueryCondition(false, "SQLQueryBlock is not transfered yet to RQPQuery.", trace);
                return false;
            }
            if (parent.getType() == 301022) {
                this.traceQueryCondition(false, "SQLQueryBlock is already a common table expression of WITH clause.", trace);
                return false;
            }
            if (node.getAncestorOfType(101006) != null) {
                this.traceQueryCondition(false, "SQLQueryBlock is not transfered to RQPQuery.", trace);
                return false;
            }
            if (RQPUtilities.getLocalCachePolicyFromGovernors(environment, node) != Governors.LocalCachePolicy.LOWEST_SUMMARY_SUBQUERY && node.getAncestorOfType(301022) == null) {
                this.traceQueryCondition(false, "SQLQueryBlock is not under WITH clause.", trace);
                return false;
            }
            return true;
        }
        SQLRangeVar sqlRangeVar = (SQLRangeVar)node;
        if (sqlRangeVar.getSubQueryType() == SQLRangeVar.PropertySubqueryTypeEnum.SIMPLE_DBQUERY) {
            this.traceQueryCondition(false, "SQLRangeVar is a sub-query under an RMSqlCalcFilter/RMModelQueryAsView query subject, no need to convert to CTE.", trace);
            return false;
        }
        if (node.getNumberChildren() == 0 || node.getChild(0).getType() == 301016 || node.getChild(0).getType() == 301092) {
            this.traceQueryCondition(false, "SQLRangeVar represents a table name, not a sub-query.", trace);
            return false;
        }
        if (sqlRangeVar.getPropertyValue("derivedTableOfDBQS") != null) {
            this.traceQueryCondition(false, "SQLRangeVar is a sub-query under an RMSQLAsView, no need to convert to CTE.", trace);
            return false;
        }
        if (node.getChild(0).getType() == 301039) {
            this.traceQueryCondition(false, "SQLRangeVar represents a table function, not a sub-query.", trace);
            return false;
        }
        if (node.getChild(0).getType() == 301038 && (sqlTableFunction = (SQLTableFunction)node.getChild(0)).getSubType().equals((Object)SQLTableFunction.SubType.UNNEST)) {
            this.traceQueryCondition(false, "SQLRangeVar represents the UNNEST table function, not a sub-query.", trace);
            return false;
        }
        if (parent == null || parent.getType() == 301022) {
            this.traceQueryCondition(false, "SQLRangeVar is already a common table expression of WITH clause.", trace);
            return false;
        }
        if (sqlRangeVar.getPropertyValue("fullQSName") == null && sqlRangeVar.getChild(0).getType() == 301018) {
            return false;
        }
        IXQEQueryNode sqlWith = node.getAncestorOfType(301022);
        if (sqlWith == null || sqlWith.getPropertyValue("createdForCognosSQL") == null) {
            this.traceQueryCondition(false, "SQLRangeVar is not under WITH clause or it's under a WITH clause of a typed-in SQL.", trace);
            return false;
        }
        RQPQuery rqpQuery = (RQPQuery)sqlRangeVar.getFirstChildByType(801017);
        if (rqpQuery != null && rqpQuery.isSubqueryForCalcsInQS() || RQPQuery.isSubqueryForCalcsInQS(sqlRangeVar)) {
            this.traceQueryCondition(false, "CTE not generated for top subquery of self referencing calculations created for query subject", trace);
            return false;
        }
        return true;
    }

    public static String getOriginalColumnName(SQLAlias sqlAlias) {
        String origColName = sqlAlias.getOrigColumnName();
        if (origColName == null) {
            origColName = sqlAlias.getName();
        }
        return origColName;
    }
}

