/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPNameGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashSet;
import java.util.Map;

public class GenerateColumnAlias
extends RQPTransformation {
    private static final String TRANSFORMATION_HAS_BEEN_DONE = "GenerateColumnAlias";

    public GenerateColumnAlias(int[] passNumbers) {
        this.mName = "Generate Column Alias";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{801016};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        GenerateColumnAlias.generateAliases(node, environment);
    }

    public static void generateAliases(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPNode projList = (RQPNode)node;
        HashSet<String> aliases = new HashSet<String>(projList.getNumberChildren());
        int maxColumnNameLength = RQPUtilities.getMaxColumnNameLength(environment);
        RQPQuery parentQuery = RQPNode.getRQPQuery(node);
        RQPQuery rootQuery = RQPNode.getRQPQuery(parentQuery);
        for (IXQEQueryNode projNode : projList.getChildren()) {
            String aliasName;
            String origColumnName;
            RQPNode rqpNode = (RQPNode)projNode;
            SQLAlias sqlAlias = (SQLAlias)environment.getNodeFactory().createNode(301028);
            if (rqpNode.getType() == 801009) {
                origColumnName = ((RQPDataItemRef)rqpNode).getReferencedItem().getName();
                aliasName = GenerateColumnAlias.getAliasNameFromReferencedDataItem((RQPDataItemRef)rqpNode);
            } else {
                origColumnName = rqpNode.getName();
                aliasName = RQPNameGenerator.makeValidSqlIdentifier(origColumnName);
            }
            String preferredAlias = (String)rqpNode.getPropertyValue("preferredAlias");
            aliasName = RQPNameGenerator.generateUniqueAliasName(aliases, aliasName, maxColumnNameLength, preferredAlias);
            sqlAlias.setName(aliasName);
            aliases.add(aliasName.toUpperCase());
            if (!aliasName.equals(origColumnName)) {
                sqlAlias.setOrigColumnName(origColumnName);
            }
            rqpNode.exchange(sqlAlias);
            sqlAlias.addChild(rqpNode);
            if (parentQuery.getType() != 801017 || rootQuery != null) continue;
            RQPProjectionList rootQueryProjectionList = (RQPProjectionList)parentQuery.getOrCreateList(environment, 801016);
            GenerateColumnAlias.setRowsetNameAndColumnName(rootQueryProjectionList, sqlAlias);
        }
        node.setPropertyValue(TRANSFORMATION_HAS_BEEN_DONE, "");
    }

    private static void setRowsetNameAndColumnName(RQPProjectionList rootQueryProjectionList, SQLAlias sqlAlias) {
        Map<Integer, String> rowsetNames = rootQueryProjectionList.getRowsetNames();
        Map<Integer, String> columnNames = rootQueryProjectionList.getColumnNames();
        if (rowsetNames == null || columnNames == null) {
            return;
        }
        int positionOfAlias = rootQueryProjectionList.getPositionOfChild(sqlAlias);
        String rowsetName = rowsetNames.get(positionOfAlias);
        String columnName = columnNames.get(positionOfAlias);
        if (rowsetName != null && columnName != null) {
            sqlAlias.setRowsetName(rowsetName);
            sqlAlias.setColumnName(columnName);
        }
    }

    private static String getAliasNameFromReferencedDataItem(RQPDataItemRef node) {
        RQPDataItem targetItem = node.getReferencedItem();
        IXQEQueryNode parent = targetItem.getParent();
        if (parent.getType() == 301028) {
            return ((SQLAlias)parent).getName();
        }
        return targetItem.getName();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Object done = node.getPropertyValue(TRANSFORMATION_HAS_BEEN_DONE);
        if (done != null) {
            return false;
        }
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        IXQEQueryNode parent = node.getParent();
        if (parent != null && parent.getType() == 801017 && ((RQPQuery)parent).getSQSOwner() != null) {
            return false;
        }
        this.traceNodeCondition(true, "Generate SQLAlias for query items in RQPProjectionList", xqeTrace);
        return true;
    }
}

