/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPDetailFilterList;
import com.cognos.xqe.ast.rqp.RQPGroupByList;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPTabularQuery;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5.ExpandDataItemReferences;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.GenerateColumnAlias;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Pair;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class GenerateSubqueriesForSelfReferencingCalcs
extends RQPTransformation {
    private static final int MAX_SUBQUERIES = 99;
    int[] aggregateCategories = new int[]{201124, 301034};

    public GenerateSubqueriesForSelfReferencingCalcs() {
        this.mName = "GenerateSubqueriesForSelfReferencingCalcs.";
        this.mPassNumbers = new int[]{21};
        this.mTypes = new int[]{801017, 801025, 801024, 801012};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!ExpandDataItemReferences.generateSubqueryForCalc(node, environment)) {
            return false;
        }
        return this.allDataItemReferencesToThisQuery(node);
    }

    private boolean allDataItemReferencesToThisQuery(IXQEQueryNode node) {
        for (IXQEQueryNode ref : GenerateSubqueriesForSelfReferencingCalcs.getDataItemReferences(node)) {
            V5BoundDataItemReference dataItemReference = (V5BoundDataItemReference)ref;
            if (dataItemReference.isQueryRefItem()) continue;
            return true;
        }
        return false;
    }

    public static List<IXQEQueryNode> getDataItemReferences(IXQEQueryNode node) {
        IXQEQueryNode[] refs;
        ArrayList<IXQEQueryNode> refsList = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode r : refs = node.getDescendantsOfType(201060, false, new int[]{801022, 801032})) {
            V5BoundDataItemReference ref = (V5BoundDataItemReference)r;
            if (ref.isQueryRefItem()) continue;
            refsList.add(ref);
        }
        return refsList;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery currentSubquery = null;
        RQPQuery mainQuery = (RQPQuery)node;
        String baseName = mainQuery.getName() + "_subqueryBC";
        ArrayList<RQPQuery> newRQPQueries = new ArrayList<RQPQuery>();
        int iQueryCount = 0;
        boolean isRQPQueryForQS = mainQuery.getPropertyValue("QSNAME") != null;
        mainQuery.setSubqueryForCalcsInQS(isRQPQueryForQS);
        List<IXQEQueryNode> newProjectionsAdded = this.addUnprojectedDataItemReferences(environment, mainQuery);
        this.useDetailContextOfV5DataItemReferenceInRMQuery(environment, mainQuery, newProjectionsAdded);
        while (!GenerateSubqueriesForSelfReferencingCalcs.getDataItemReferences(mainQuery).isEmpty()) {
            IXQEQueryNode subqueryList;
            currentSubquery = (RQPQuery)environment.getNodeFactory().createNode(801017);
            currentSubquery.setIsSubqueryForCalcs(true);
            currentSubquery.setSubqueryForCalcsInQS(isRQPQueryForQS);
            newRQPQueries.add(currentSubquery);
            currentSubquery.setName(baseName + iQueryCount);
            ++iQueryCount;
            ArrayList<Pair> pushedDataItems = new ArrayList<Pair>();
            block1: for (IXQEQueryNode di : this.getProjectionsOrderedByGroupingColumns(mainQuery)) {
                RQPDataItem rqpDataItem = di.getType() == 301028 ? (RQPDataItem)di.getChild(0) : (RQPDataItem)di;
                if (iQueryCount > 99) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "GenerateSubqueriesForSelfReferencingCalcs: Max subqueries exceeded");
                }
                if (GenerateSubqueriesForSelfReferencingCalcs.getDataItemReferences(rqpDataItem).isEmpty()) {
                    if (!RQPUtilities.hasAggregateInExpression(rqpDataItem.getExpression()) || mainQuery.getGroupByList() == null) {
                        IXQEQueryNode expressionToPush = rqpDataItem.getExpression();
                        RQPDataItemRef refToNewDataItem = this.pushExpressionToSubquery(environment, currentSubquery, rqpDataItem, expressionToPush);
                        this.updatePushedDataItems(pushedDataItems, rqpDataItem, refToNewDataItem);
                        continue;
                    }
                    List<IXQEQueryNode> modelItemsOrRefs = this.getItemsToPushToSubquery(rqpDataItem);
                    if (modelItemsOrRefs.isEmpty()) continue;
                    IXQEQueryNode expressionToPush = null;
                    ArrayList<IXQEQueryNode> pushedExpressions = new ArrayList<IXQEQueryNode>();
                    for (IXQEQueryNode modelItemOrRef : modelItemsOrRefs) {
                        if (this.alreadyPushed(pushedExpressions, modelItemOrRef)) continue;
                        boolean wholeExpressionPushed = false;
                        if (modelItemOrRef.getAncestorOfCategories(this.aggregateCategories) == null) {
                            expressionToPush = rqpDataItem.getExpression();
                            wholeExpressionPushed = true;
                        } else if (this.allGroupingColumnsPushed(mainQuery) && this.allAggregatedColumnsPushed(mainQuery) && this.detailFiltersPushed(mainQuery)) {
                            RQPGroupByList groupByList = mainQuery.getGroupByList();
                            if (groupByList != null) {
                                groupByList.detach();
                                currentSubquery.addChild(groupByList);
                                this.fixSelfRefs(pushedDataItems, currentSubquery);
                            }
                            expressionToPush = rqpDataItem.getExpression();
                            wholeExpressionPushed = true;
                        } else {
                            expressionToPush = modelItemOrRef.getAncestorChildOfTypes(new int[]{301020, 201037, 301042, 201114});
                            if (expressionToPush == null) {
                                expressionToPush = modelItemOrRef.getAncestorChildOfTypes(new int[]{201036});
                            }
                            if (expressionToPush == null) {
                                expressionToPush = modelItemOrRef.getAncestorChildOfCategories(this.aggregateCategories);
                            }
                            if (expressionToPush == null) {
                                expressionToPush = modelItemOrRef;
                            }
                        }
                        pushedExpressions.add(expressionToPush);
                        RQPDataItemRef refToNewDataItem = this.pushExpressionToSubquery(environment, currentSubquery, rqpDataItem, expressionToPush);
                        if (!wholeExpressionPushed) continue;
                        this.updatePushedDataItems(pushedDataItems, rqpDataItem, refToNewDataItem);
                        continue block1;
                    }
                    continue;
                }
                List<IXQEQueryNode> childModelItems = this.getItemsToPushToSubquery(rqpDataItem);
                if (childModelItems.isEmpty()) continue;
                for (IXQEQueryNode modelItem : childModelItems) {
                    RQPDataItem newDataItem = currentSubquery.getRQPDataItem(environment, modelItem, rqpDataItem.getName());
                    RQPDataItemRef refToNewDataItem = RQPDataItemRef.create(environment, newDataItem);
                    modelItem.exchange(refToNewDataItem);
                }
            }
            this.pushDetailFilters(environment, currentSubquery, mainQuery);
            RQPJoinPath joinPath = (RQPJoinPath)mainQuery.getFirstChildByType(801039);
            if (joinPath != null) {
                joinPath.detach();
                currentSubquery.addChild(joinPath);
            }
            GenerateColumnAlias.generateAliases(currentSubquery.getProjectionList(), environment);
            this.replaceBoundDataItemReferenceWithRefToSubquery(environment, mainQuery, pushedDataItems);
            if (iQueryCount != 1 || mainQuery.getType() != 801017 && mainQuery.getType() != 801025 || (subqueryList = mainQuery.getSubqueryList()) == null) continue;
            subqueryList.detach();
            currentSubquery.addChild(subqueryList);
        }
        this.removeUnprojectedDataItemReferences(mainQuery, newProjectionsAdded);
        if (currentSubquery != null) {
            if (mainQuery.getType() != 801017) {
                RQPQuery parentRQPQuery = mainQuery.getParentRQPQuery();
                parentRQPQuery.addToSubqueryList(environment, currentSubquery, false, currentSubquery.getName());
            } else {
                mainQuery.addToSubqueryList(environment, currentSubquery, false, currentSubquery.getName());
            }
        }
        while (newRQPQueries.size() > 1) {
            int lastQueryIndex = newRQPQueries.size() - 1;
            ((RQPQuery)newRQPQueries.get(lastQueryIndex)).addToSubqueryList(environment, (IXQEQueryNode)newRQPQueries.get(lastQueryIndex - 1), false, ((RQPQuery)newRQPQueries.get(lastQueryIndex - 1)).getName());
            newRQPQueries.remove(lastQueryIndex);
        }
    }

    private void pushDetailFilters(PlanningEnvironment environment, RQPQuery subquery, RQPQuery mainQuery) {
        RQPDetailFilterList detailFilters = mainQuery.getDetailFilterList();
        if (detailFilters == null) {
            return;
        }
        for (IXQEQueryNode df : detailFilters.getChildren()) {
            if (GenerateSubqueriesForSelfReferencingCalcs.getDataItemReferences(df).isEmpty()) {
                df.detach();
                subquery.getOrCreateDetailFilters(environment).addChild(df);
                continue;
            }
            for (IXQEQueryNode modelItem : this.getItemsToPushToSubquery(df)) {
                RQPDataItem newDataItem = subquery.getRQPDataItem(environment, modelItem, (String)null);
                RQPDataItemRef refToNewDataItem = RQPDataItemRef.create(environment, newDataItem);
                modelItem.exchange(refToNewDataItem);
            }
        }
        if (detailFilters.getNumberChildren() == 0) {
            detailFilters.detach();
        }
    }

    private boolean detailFiltersPushed(RQPQuery mainQuery) {
        return mainQuery.getDetailFilterList() == null;
    }

    private void fixSelfRefs(List<Pair> pushedDataItems, RQPQuery subquery) {
        for (IXQEQueryNode gbItem : subquery.getGroupByList().getChildren()) {
            RQPDataItemSelfRef selfRef = (RQPDataItemSelfRef)gbItem;
            String origName = selfRef.getName();
            for (Pair pushedItem : pushedDataItems) {
                RQPDataItemRef itemInSubquery;
                String newName;
                String pushedItemOrigName = (String)pushedItem.getFirst();
                if (!origName.equals(pushedItemOrigName) || origName.equals(newName = (itemInSubquery = (RQPDataItemRef)pushedItem.getSecond()).getName())) continue;
                selfRef.setName(newName);
            }
        }
    }

    private boolean allAggregatedColumnsPushed(RQPQuery mainQuery) {
        for (IXQEQueryNode proj : mainQuery.getProjectionList().getChildren()) {
            if (!RQPUtilities.hasAggregateInExpression(proj) || GenerateSubqueriesForSelfReferencingCalcs.getDataItemReferences(proj).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void replaceBoundDataItemReferenceWithRefToSubquery(PlanningEnvironment environment, RQPQuery mainQuery, List<Pair> pushedDataItems) {
        for (Pair pushedDataItem : pushedDataItems) {
            String dataItemName = (String)pushedDataItem.getFirst();
            RQPDataItemRef ref = (RQPDataItemRef)pushedDataItem.getSecond();
            for (IXQEQueryNode boundRef : GenerateSubqueriesForSelfReferencingCalcs.getDataItemReferences(mainQuery)) {
                String name = this.getDataItemReferenceName(boundRef);
                if (!name.equals(dataItemName)) continue;
                boundRef.exchange(environment.getNodeFactory().deepCopyNode(ref));
            }
        }
    }

    private List<IXQEQueryNode> getItemsToPushToSubquery(IXQEQueryNode expr) {
        int[] searchTypes = new int[]{201116, 801009, 201060};
        ArrayList<IXQEQueryNode> toPush = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode r : expr.getDescendantsOfTypes(searchTypes, false)) {
            if (r.getType() == 201060 && !((V5BoundDataItemReference)r).isQueryRefItem()) continue;
            toPush.add(r);
        }
        return toPush;
    }

    private RQPDataItemRef pushExpressionToSubquery(PlanningEnvironment environment, RQPQuery subquery, RQPDataItem rqpDataItem, IXQEQueryNode expressionToPush) {
        RQPDataItem newDataItem = subquery.getRQPDataItem(environment, expressionToPush, rqpDataItem.getName());
        RQPDataItemRef refToNewDataItem = RQPDataItemRef.create(environment, newDataItem);
        expressionToPush.exchange(refToNewDataItem);
        return refToNewDataItem;
    }

    private void updatePushedDataItems(List<Pair> pushedDataItems, RQPDataItem rqpDataItem, RQPDataItemRef refToNewDataItem) {
        Pair p = new Pair();
        p.setFirst(rqpDataItem.getName());
        p.setSecond(refToNewDataItem);
        pushedDataItems.add(p);
    }

    private List<IXQEQueryNode> getProjectionsOrderedByGroupingColumns(RQPQuery mainQuery) {
        ArrayList<IXQEQueryNode> orderedProjections = new ArrayList<IXQEQueryNode>();
        if (mainQuery.getGroupByList() != null) {
            for (IXQEQueryNode gbItem : mainQuery.getGroupByList().getChildren()) {
                orderedProjections.add(((RQPDataItemSelfRef)gbItem).getRefProjection());
            }
        }
        for (IXQEQueryNode dataItemReference : GenerateSubqueriesForSelfReferencingCalcs.getDataItemReferences(mainQuery)) {
            String name = this.getDataItemReferenceName(dataItemReference);
            RQPDataItem rqpDataItem = mainQuery.getRQPDataItemByName(name);
            if (rqpDataItem == null || orderedProjections.contains(rqpDataItem)) continue;
            orderedProjections.add(rqpDataItem);
        }
        for (IXQEQueryNode projection : mainQuery.getProjectionList().getChildren()) {
            RQPDataItem rqpDataItem = projection.getType() == 301028 ? (RQPDataItem)projection.getChild(0) : (RQPDataItem)projection;
            if (orderedProjections.contains(rqpDataItem)) continue;
            orderedProjections.add(rqpDataItem);
        }
        return orderedProjections;
    }

    private boolean allGroupingColumnsPushed(RQPQuery mainQuery) {
        RQPGroupByList groupByList = mainQuery.getGroupByList();
        if (groupByList == null) {
            return true;
        }
        for (IXQEQueryNode child : groupByList.getChildren()) {
            RQPDataItemSelfRef gbRef = (RQPDataItemSelfRef)child;
            RQPDataItem gbDataItem = gbRef.getRefProjection();
            if (GenerateSubqueriesForSelfReferencingCalcs.getDataItemReferences(gbDataItem).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void removeUnprojectedDataItemReferences(RQPQuery mainQuery, List<IXQEQueryNode> toDelete) {
        if (toDelete.isEmpty()) {
            return;
        }
        for (IXQEQueryNode di : mainQuery.getProjectionList().getChildren()) {
            RQPDataItem rqpDataItem = di.getType() == 301028 ? (RQPDataItem)di.getChild(0) : (RQPDataItem)di;
            if (!toDelete.contains(rqpDataItem)) continue;
            rqpDataItem.detach();
        }
    }

    private String getDataItemReferenceName(IXQEQueryNode boundRef) {
        String[] nameParts = ((V5BoundDataItemReference)boundRef).getNameParts();
        String name = nameParts[nameParts.length - 1];
        return name;
    }

    private void useDetailContextOfV5DataItemReferenceInRMQuery(PlanningEnvironment environment, RQPQuery mainQuery, List<IXQEQueryNode> newProjections) {
        List<IXQEQueryNode> refs = GenerateSubqueriesForSelfReferencingCalcs.getDataItemReferences(mainQuery.getProjectionList());
        HashSet<String> processedRefs = new HashSet<String>();
        for (IXQEQueryNode diR : refs) {
            String newProj;
            V5BoundDataItemReference dataItemReference = (V5BoundDataItemReference)diR;
            String refName = this.getDataItemReferenceName(dataItemReference);
            RMQueryItem rmQueryItem = (RMQueryItem)dataItemReference.getPropertyValue("rmRefCalc");
            if (rmQueryItem == null || processedRefs.contains(refName)) continue;
            IXQEQueryNode refExpr = rmQueryItem.getChild(0);
            RQPDataItem proj = mainQuery.getRQPDataItemByName(refName);
            if (proj == null && (proj = mainQuery.getRQPDataItemWithSameExpression(refExpr)) != null) {
                this.updateDataItemReferenceName(dataItemReference, proj);
                refName = this.getDataItemReferenceName(dataItemReference);
            }
            if (RQPUtilities.hasAggregateInExpression(proj) && (newProj = this.addNewProjectionAndUpdateReferences(environment, mainQuery, newProjections, refs, dataItemReference, refExpr)) != null) {
                processedRefs.add(newProj);
            }
            processedRefs.add(refName);
        }
    }

    private List<IXQEQueryNode> addUnprojectedDataItemReferences(PlanningEnvironment environment, RQPQuery mainQuery) {
        ArrayList<IXQEQueryNode> newProjections = new ArrayList<IXQEQueryNode>();
        List<IXQEQueryNode> refs = GenerateSubqueriesForSelfReferencingCalcs.getDataItemReferences(mainQuery.getProjectionList());
        for (IXQEQueryNode diR : refs) {
            String refName;
            RQPDataItem proj;
            RQPTabularQuery tabQuery;
            RQPDataItem rqpDataItem;
            V5BoundDataItemReference dataItemReference = (V5BoundDataItemReference)diR;
            if (dataItemReference.isQueryRefItem()) continue;
            IXQEQueryNode refExpr = null;
            RMQueryItem rmQueryItem = (RMQueryItem)dataItemReference.getPropertyValue("rmRefCalc");
            if (rmQueryItem != null) {
                refExpr = rmQueryItem.getChild(0);
            } else if (mainQuery.getRQPDataItemByName(this.getDataItemReferenceName(dataItemReference)) == null && (rqpDataItem = (tabQuery = mainQuery.getParentRQPQuery().getDefaultTabularQuery()).getRQPDataItemByName(this.getDataItemReferenceName(dataItemReference))) != null) {
                refExpr = rqpDataItem.getExpression();
            }
            if ((proj = mainQuery.getRQPDataItemByName(refName = this.getDataItemReferenceName(dataItemReference))) != null || (proj = mainQuery.getRQPDataItemWithSameExpression(refExpr)) != null) continue;
            this.addNewProjectionAndUpdateReferences(environment, mainQuery, newProjections, refs, dataItemReference, refExpr);
        }
        return newProjections;
    }

    private String addNewProjectionAndUpdateReferences(PlanningEnvironment environment, RQPQuery mainQuery, List<IXQEQueryNode> newProjections, List<IXQEQueryNode> refs, V5BoundDataItemReference dataItemReference, IXQEQueryNode refExpr) {
        if (refExpr != null && mainQuery.getRQPDataItemWithSameExpression(refExpr) == null) {
            String refName = this.getDataItemReferenceName(dataItemReference);
            RQPDataItem newDataItem = mainQuery.getRQPDataItem(environment, refExpr, refName);
            for (IXQEQueryNode r : refs) {
                V5BoundDataItemReference diRef = (V5BoundDataItemReference)r;
                if (!refName.equals(this.getDataItemReferenceName(diRef))) continue;
                this.updateDataItemReferenceName(diRef, newDataItem);
            }
            newProjections.add(newDataItem);
            return newDataItem.getName();
        }
        return null;
    }

    private void updateDataItemReferenceName(V5BoundDataItemReference dataItemReference, RQPDataItem projection) {
        String[] nameParts = dataItemReference.getNameParts();
        nameParts[nameParts.length - 1] = projection.getName();
    }

    private boolean alreadyPushed(List<IXQEQueryNode> pushedExpressions, IXQEQueryNode expr) {
        for (IXQEQueryNode pushedExpr : pushedExpressions) {
            if (!expr.isAncestor(pushedExpr)) continue;
            return true;
        }
        return false;
    }
}

