/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProcessNullValueSorting
extends RQPTransformation {
    private static final String NULLVALUESORTING = "nullValueSorting";
    private static final String UNSPECIFIED = "unspecified";
    private static final String ASCENDINGNULLSFIRST = "ascendingNullsFirst";
    private static final String ASCENDINGNULLSLAST = "ascendingNullsLast";
    private static final String NULLSFIRST = "nullsFirst";
    private static final String NULLSLAST = "nullsLast";
    private static final String PROP_BOOLEAN_IS_PROCESSED = "isProcessed";

    public ProcessNullValueSorting() {
        this.mName = "Process null value sorting";
        this.mPassNumbers = new int[]{65};
        this.mTypes = new int[]{301019};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.setPropertyValue(PROP_BOOLEAN_IS_PROCESSED, true);
        IXQEQueryNode[] sortKeyNodes = node.getDescendantsOfType(301020, true);
        MetadataConnection mdConnection = environment.getMetadataConnection();
        List<IModelDataSource> modelDSs = mdConnection.getModelDataSources();
        IXQEQueryNode querySet = node.getAncestorOfType(101002);
        Set<IDataSource> dataSources = ((V5QuerySet)querySet).getDataSources();
        Iterator<IDataSource> dataSourcesIter = dataSources.iterator();
        Iterator<IModelDataSource> modelDataSourcesIter = modelDSs.iterator();
        if (dataSources.size() == 1) {
            IModelDataSource modelDS = null;
            while (dataSourcesIter.hasNext()) {
                IDataSource dataSource = dataSourcesIter.next();
                if (!dataSource.isRelational()) continue;
                String datasourceCMName = dataSource.getCMDataSourceName();
                while (modelDataSourcesIter.hasNext()) {
                    modelDS = modelDataSourcesIter.next();
                    String modelDataSourceCMName = modelDS.getCMDataSourceName();
                    if (MacroExpander.isMacro(modelDataSourceCMName)) {
                        MacroExpander me = new MacroExpander();
                        modelDataSourceCMName = me.expand(null, environment, modelDataSourceCMName);
                    }
                    if (!datasourceCMName.equals(modelDataSourceCMName)) continue;
                    Map<String, Object> properties = modelDS.getMetadataProperties();
                    for (IXQEQueryNode sortKeyNode : sortKeyNodes) {
                        SQLSortKey sortKey = (SQLSortKey)sortKeyNode;
                        if (sortKey.getNullOrder() != SQLSortKey.NullOrdering.UNSPECIFIED) continue;
                        if (properties.get(NULLVALUESORTING).toString().equals(ASCENDINGNULLSFIRST)) {
                            if (sortKey.isAscending()) {
                                sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_FIRST);
                            } else {
                                sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_LAST);
                            }
                        }
                        if (properties.get(NULLVALUESORTING).toString().equals(ASCENDINGNULLSLAST)) {
                            if (sortKey.isAscending()) {
                                sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_LAST);
                            } else {
                                sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_FIRST);
                            }
                        }
                        if (sortKey.getNullOrder() == SQLSortKey.NullOrdering.UNSPECIFIED && properties.get(NULLVALUESORTING).toString().equals(NULLSFIRST)) {
                            sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_FIRST);
                        }
                        if (sortKey.getNullOrder() != SQLSortKey.NullOrdering.UNSPECIFIED || !properties.get(NULLVALUESORTING).toString().equals(NULLSLAST)) continue;
                        sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_LAST);
                    }
                }
            }
        }
        if (dataSources.size() > 1) {
            for (IXQEQueryNode sortKeyNode : sortKeyNodes) {
                Map<String, Object> properties;
                IModelDataSource modelDS;
                SQLColumn sqlColumn;
                SQLSortKey sortKey = (SQLSortKey)sortKeyNode;
                if (sortKey.getNullOrder() != SQLSortKey.NullOrdering.UNSPECIFIED || (sqlColumn = (SQLColumn)sortKey.getFirstChildByType(301005)) == null || (modelDS = (IModelDataSource)sqlColumn.getPropertyValue("dataSource")) == null || (properties = modelDS.getMetadataProperties()).get(NULLVALUESORTING) == null || sortKey.getNullOrder() != SQLSortKey.NullOrdering.UNSPECIFIED) continue;
                if (properties.get(NULLVALUESORTING).toString().equals(ASCENDINGNULLSFIRST)) {
                    if (sortKey.isAscending()) {
                        sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_FIRST);
                    } else {
                        sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_LAST);
                    }
                }
                if (properties.get(NULLVALUESORTING).toString().equals(ASCENDINGNULLSLAST)) {
                    if (sortKey.isAscending()) {
                        sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_LAST);
                    } else {
                        sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_FIRST);
                    }
                }
                if (sortKey.getNullOrder() == SQLSortKey.NullOrdering.UNSPECIFIED && properties.get(NULLVALUESORTING).toString().equals(NULLSFIRST)) {
                    sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_FIRST);
                }
                if (sortKey.getNullOrder() != SQLSortKey.NullOrdering.UNSPECIFIED || !properties.get(NULLVALUESORTING).toString().equals(NULLSLAST)) continue;
                sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_LAST);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode querySet = node.getAncestorOfType(101002);
        if (querySet == null) {
            return false;
        }
        Set<IDataSource> dataSources = ((V5QuerySet)querySet).getDataSources();
        if (dataSources == null) {
            return false;
        }
        MetadataConnection mdConnection = environment.getMetadataConnection();
        List<IModelDataSource> modelDSs = mdConnection.getModelDataSources();
        Iterator<IDataSource> dataSourcesIter = dataSources.iterator();
        Iterator<IModelDataSource> modelDataSourcesIter = modelDSs.iterator();
        if (dataSources.size() == 1) {
            while (dataSourcesIter.hasNext()) {
                IDataSource dataSource = dataSourcesIter.next();
                if (!dataSource.isRelational()) {
                    return false;
                }
                String datasourceCMName = dataSource.getCMDataSourceName();
                while (modelDataSourcesIter.hasNext()) {
                    Map<String, Object> properties;
                    IModelDataSource modelDS = modelDataSourcesIter.next();
                    String modelDataSourceCMName = modelDS.getCMDataSourceName();
                    if (!datasourceCMName.equals(modelDataSourceCMName) || (properties = modelDS.getMetadataProperties()) != null && properties.get(NULLVALUESORTING) != null && !properties.get(NULLVALUESORTING).toString().equals(UNSPECIFIED)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

