/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class RemoveV5Objects
extends RQPTransformation {
    public static final String PROP_BOOL_REMOVE_V5OBJ = "removeV5Objects";

    public RemoveV5Objects() {
        this.mName = "Remove V5 objects from query tree.";
        this.mPassNumbers = new int[]{47};
        this.mTypes = new int[]{801017};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        this.collapseDescendentsOfType(node, 101003);
        this.collapseDescendentsOfType(node, 801008);
        this.collapseDescendentsOfType(node, 801009);
        this.collapseDescendentsOfType(node, 101008);
        this.collapseDescendentsOfType(node, 101013);
        this.collapseDescendentsOfType(node, 101011);
        this.collapseDescendentsOfType(node, 801046);
        this.removeReferencedV5Query((RQPQuery)node, v5QuerySet);
        V5Edge v5Edge = (V5Edge)node.getFirstChildByType(101049);
        if (v5Edge != null) {
            node.detachChild(v5Edge);
        }
        this.detachDescendantsOfType(node, 801032);
        this.detachDescendantsOfType(node, 801036);
        this.detachDescendantsOfType(node, 801042);
        this.detachDescendantsOfType(node, 101059);
        node.setPropertyValue(PROP_BOOL_REMOVE_V5OBJ, true);
    }

    private void detachDescendantsOfType(IXQEQueryNode node, int type) {
        IXQEQueryNode[] descendants;
        for (IXQEQueryNode d : descendants = node.getDescendantsOfType(type, true)) {
            d.detach();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (node.getPropertyValue(PROP_BOOL_REMOVE_V5OBJ) != null) {
            this.traceNodeCondition(false, "All V5 objects in this RQPQuery are removed", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "Remove all objects that are not sql nodes", xqeTrace);
        return true;
    }

    private void removeReferencedV5Query(RQPQuery rqpQuery, V5QuerySet v5QuerySet) {
        RQPQuery rootRQPQuery = rqpQuery.getRootRQPQuery();
        if (null == rootRQPQuery) {
            rootRQPQuery = rqpQuery;
        }
        if (RQPUtilities.isRelationalSubquery(rootRQPQuery)) {
            return;
        }
        V5Query v5ReferencedQuery = rootRQPQuery.getRefV5Query();
        if (null != v5ReferencedQuery) {
            if (v5ReferencedQuery.getQueryPlan() != null) {
                return;
            }
            if (!v5ReferencedQuery.isDMR()) {
                v5QuerySet.detachChild(v5ReferencedQuery);
            }
        }
    }

    private void collapseDescendentsOfType(IXQEQueryNode node, int type) {
        IXQEQueryNode[] v5DataItems = node.getDescendantsOfType(type, true);
        if (v5DataItems != null) {
            for (int i = 0; i < v5DataItems.length; ++i) {
                v5DataItems[i].extract();
            }
        }
    }
}

