/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPQueryRef;
import com.cognos.xqe.ast.sql.SQLWith;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.List;

public class ReorderCTEsInWithClause
extends Transformation {
    public ReorderCTEsInWithClause() {
        this.mName = "ReorderCTEsInWithClause";
        this.mPassNumbers = new int[]{40};
        this.mTypes = new int[]{301022};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        SQLWith sqlWith = (SQLWith)node;
        IXQEQueryNode parentSqlWithNode = sqlWith.getParent();
        List<String> nameList = sqlWith.getNameList();
        V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(environment, node);
        if (nameList.size() == 1) {
            V5Query v5Query = rootQuerySet.getV5Query(nameList.get(0));
            if (v5Query != null) {
                v5Query.incrementCount();
            }
            return;
        }
        List orderedQueryList = (List)rootQuerySet.getPropertyValue("orderedQueryList");
        ArrayList<String> newNameList = new ArrayList<String>();
        for (String query : orderedQueryList) {
            if (!nameList.contains(query)) continue;
            newNameList.add(query);
        }
        IXQEQueryNode oldSqlWith = sqlWith.detach();
        SQLWith newSqlWith = (SQLWith)environment.getNodeFactory().createNode(301022);
        newSqlWith.setPropertyValue("createdForCognosSQL", true);
        IXQEQueryNode[] rqpQueryRefs = oldSqlWith.getChildren();
        for (String queryName : newNameList) {
            IXQEQueryNode rqpQueryRef = this.getRQPQueryRef(rqpQueryRefs, queryName);
            rqpQueryRef.move(newSqlWith);
        }
        newSqlWith.addChild(oldSqlWith.getChild(0));
        newSqlWith.setPropertyValue("identifierIndex", oldSqlWith.getPropertyValue("identifierIndex"));
        parentSqlWithNode.addChild(newSqlWith);
    }

    private IXQEQueryNode getRQPQueryRef(IXQEQueryNode[] rqpQueryRefs, String queryName) {
        for (IXQEQueryNode rqpQueryRef : rqpQueryRefs) {
            V5Query v5Query = ((RQPQueryRef)rqpQueryRef).getReferenceOf();
            if (!v5Query.getV5QueryName().equals(queryName)) continue;
            v5Query.incrementCount();
            return rqpQueryRef;
        }
        return null;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("createdForCognosSQL") == null) {
            this.traceQueryCondition(false, "This WITH clause is generated from a V5SQLQuery, do not need to reorder its CTE.", trace);
            return false;
        }
        if (((SQLWith)node).getNameList().isEmpty()) {
            this.traceQueryCondition(false, "This WITH clause has no CTEs.", trace);
            return false;
        }
        return true;
    }
}

