/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.decomposition.NormalizeV5ValueExpression;
import com.cognos.xqe.transformation.v5.ExpandDataItemReferences;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ReplaceCalcsWithReferences
extends RQPTransformation {
    public static final int NUM_TIMES_REFERENCED_LIMIT = 3;
    private static final int NESTED_LIMIT = 2;
    private static final String PROP_IS_DETAIL = "isDetail";
    int[] mAggregateCategories = new int[]{201124, 301034};

    public ReplaceCalcsWithReferences() {
        this.mName = "ReplaceCalcsWithReferences";
        this.mPassNumbers = new int[]{63};
        this.mTypes = new int[]{801017, 801024, 801012, 801025};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!ExpandDataItemReferences.generateSubqueryForCalc(node, environment)) {
            return false;
        }
        RQPQuery rqpQuery = ((RQPQuery)node).getParentRQPQuery();
        V5Query v5Query = rqpQuery.getRefV5Query();
        if (v5Query == null) {
            return false;
        }
        if (v5Query.isRelationalSubquery()) {
            return false;
        }
        List<IXQEQueryNode> expandedRefs = this.getCandidateCalculations(v5Query);
        if (expandedRefs == null || expandedRefs.isEmpty()) {
            return false;
        }
        List<IXQEQueryNode> expressions = this.getCalcExpressions(node);
        if (expressions == null || expressions.isEmpty()) {
            return false;
        }
        if (this.numTimesReferencedLimitReached(expandedRefs)) {
            return true;
        }
        return this.numNestedReferencesLimitReached(expandedRefs);
    }

    private List<IXQEQueryNode> getCandidateCalculations(V5Query v5Query) {
        ArrayList<IXQEQueryNode> candidateCalcs = new ArrayList<IXQEQueryNode>();
        List<IXQEQueryNode> expandedCalcs = v5Query.getExpandedCalculations();
        if (expandedCalcs == null) {
            return candidateCalcs;
        }
        for (IXQEQueryNode node : expandedCalcs) {
            V5BoundDataItemReference ref = (V5BoundDataItemReference)node;
            V5DataItem refDataItem = ref.getRefDataItem();
            if (refDataItem != null && "none".equals(refDataItem.getAggregateProperty()) && RQPUtilities.hasAggregateInExpression(refDataItem)) continue;
            candidateCalcs.add(node);
        }
        return candidateCalcs;
    }

    private boolean numNestedReferencesLimitReached(List<IXQEQueryNode> expandedRefs) {
        for (IXQEQueryNode node : expandedRefs) {
            int refCount;
            V5BoundDataItemReference ref = (V5BoundDataItemReference)node;
            if (ref.isQueryRefItem() || (refCount = this.getNestedRefCount(expandedRefs, ref, 0)) < 2) continue;
            return true;
        }
        return false;
    }

    private int getNestedRefCount(List<IXQEQueryNode> expandedRefs, V5BoundDataItemReference node, int nestedRefCount) {
        IXQEQueryNode[] refs;
        IXQEQueryNode refExpr = node.getRefDataItemExpression();
        if (refExpr == null) {
            return nestedRefCount;
        }
        int maxRefCount = nestedRefCount;
        for (IXQEQueryNode ref : refs = refExpr.getDescendantsOfType(201060, false)) {
            int thisRefCount;
            V5BoundDataItemReference nestedRef = this.findInList(expandedRefs, (V5BoundDataItemReference)ref);
            if (nestedRef == null || nestedRef.isQueryRefItem() || (thisRefCount = this.getNestedRefCount(expandedRefs, nestedRef, nestedRefCount + 1)) <= maxRefCount) continue;
            maxRefCount = thisRefCount;
        }
        return maxRefCount;
    }

    private V5BoundDataItemReference findInList(List<IXQEQueryNode> listToSearch, V5BoundDataItemReference node) {
        for (IXQEQueryNode ref : listToSearch) {
            if (!node.isSameExpression(ref, false)) continue;
            return (V5BoundDataItemReference)ref;
        }
        return null;
    }

    private boolean numTimesReferencedLimitReached(List<IXQEQueryNode> expandedRefs) {
        for (IXQEQueryNode node : expandedRefs) {
            V5BoundDataItemReference ref = (V5BoundDataItemReference)node;
            if (ref.getNumTimesReferenced() < 3) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rqpQuery = ((RQPQuery)node).getParentRQPQuery();
        V5Query v5Query = rqpQuery.getRefV5Query();
        List<IXQEQueryNode> expandedRefs = this.getCandidateCalculations(v5Query);
        this.normalizeV5ValueExpressions(expandedRefs, environment);
        List<IXQEQueryNode> expressions = this.getCalcExpressions(node);
        boolean expanded = true;
        boolean isDetail = false;
        while (expanded) {
            expanded = false;
            Iterator<IXQEQueryNode> iterator = expandedRefs.iterator();
            while (iterator.hasNext()) {
                IXQEQueryNode ref;
                IXQEQueryNode refExpr;
                isDetail = !RQPUtilities.hasAggregateInExpression(refExpr = ((V5BoundDataItemReference)(ref = iterator.next())).getRefDataItemExpression());
                boolean refReplaced = this.replaceMatchingExprWithReference(environment, rqpQuery, expressions, ref, refExpr, isDetail);
                if (!refReplaced) continue;
                expanded = true;
            }
        }
        expanded = true;
        int[] forClause = new int[]{201037, 301042};
        while (expanded) {
            expanded = false;
            for (IXQEQueryNode ref : expandedRefs) {
                boolean refReplaced;
                IXQEQueryNode refExpr;
                Boolean b = ref.getBooleanPropertyValue(PROP_IS_DETAIL);
                if (b != null && b.booleanValue() || (refExpr = this.getReferencedRQPDataItemExpression((RQPQuery)node, ref)) == null || refExpr.getDescendantsOfTypes(forClause, false).length != 0 || !(refReplaced = this.replaceMatchingExprWithReference(environment, rqpQuery, expressions, ref, refExpr, false))) continue;
                expanded = true;
            }
        }
        v5Query.removeProperty("DUMPROPERTY");
    }

    private List<IXQEQueryNode> getCalcExpressions(IXQEQueryNode node) {
        List<IXQEQueryNode> allCalculations = node.getDescendantsOfCategory(201125, false, 801022);
        return allCalculations;
    }

    private IXQEQueryNode getReferencedRQPDataItemExpression(RQPQuery rqpQuery, IXQEQueryNode ref) {
        RQPDataItem di = this.getReferencedRQPDataItem(rqpQuery, ref);
        if (di != null) {
            return di.getExpression();
        }
        return null;
    }

    private RQPDataItem getReferencedRQPDataItem(RQPQuery rqpQuery, IXQEQueryNode ref) {
        String name = this.getDataItemReferenceName(ref);
        RQPDataItem di = rqpQuery.getRQPDataItemByName(name);
        return di;
    }

    private String getDataItemReferenceName(IXQEQueryNode boundRef) {
        String[] nameParts = ((V5BoundDataItemReference)boundRef).getNameParts();
        String name = nameParts[nameParts.length - 1];
        return name;
    }

    private boolean replaceMatchingExprWithReference(PlanningEnvironment environment, RQPQuery rqpQuery, List<IXQEQueryNode> expressions, IXQEQueryNode ref, IXQEQueryNode refExpr, boolean isDetail) {
        boolean refReplaced = false;
        for (int i = 0; i < expressions.size(); ++i) {
            IXQEQueryNode expr = expressions.get(i);
            if (!isDetail && expr.getAncestorOfCategories(this.mAggregateCategories) != null || expr.getParent().getNodeType() == 801008 || !refExpr.isSameExpression(expr, false) || refExpr.getType() == 801009) continue;
            refReplaced = true;
            IXQEQueryNode refCopy = environment.getNodeFactory().deepCopyNode(ref);
            expressions.set(i, refCopy);
            expr.exchange(refCopy);
            refCopy.setPropertyValue(PROP_IS_DETAIL, isDetail);
            ref.setPropertyValue(PROP_IS_DETAIL, isDetail);
            RQPDataItem refDI = this.getReferencedRQPDataItem(rqpQuery, ref);
            if (refDI == null) continue;
            refDI.setDoNotRemove();
        }
        return refReplaced;
    }

    private void normalizeV5ValueExpressions(List<IXQEQueryNode> expandedRefs, PlanningEnvironment environment) {
        NormalizeV5ValueExpression tr = new NormalizeV5ValueExpression(new int[0]);
        for (IXQEQueryNode ref : expandedRefs) {
            IXQEQueryNode refExpr = ((V5BoundDataItemReference)ref).getRefDataItemExpression();
            for (IXQEQueryNode valueExpr : refExpr.getDescendantsOfType(201014, true)) {
                if (!tr.passesNodeCondition(valueExpr, environment)) continue;
                tr.apply(valueExpr, environment);
            }
        }
    }
}

