/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;

public class ReplaceDataItemRefWithSQLColumn
extends RQPTransformation {
    public ReplaceDataItemRefWithSQLColumn() {
        this.mPassNumbers = new int[]{44};
        this.mTypes = new int[]{201060};
        this.mName = "Replace V5DataItemReference with SQLColumn";
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)node;
        String tableName = dataItemRef.getNameParts()[0];
        String columnName = this.findProjectionAlias(dataItemRef.getNameParts()[0], dataItemRef.getNameParts()[1], dataItemRef);
        if (columnName == null) {
            columnName = dataItemRef.getNameParts()[1];
        }
        node.exchange(RQPUtilities.createSQLColumn(environment.getNodeFactory(), tableName, columnName));
    }

    private String findProjectionAlias(String subQueryName, String nodeName, IXQEQueryNode node) {
        String aliasName;
        V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(node);
        V5Query v5Query = rootQuerySet.getV5Query(subQueryName);
        if (v5Query == null) {
            return null;
        }
        IXQEQueryNode queryPlan = v5Query.getQueryPlan();
        if (queryPlan == null) {
            return null;
        }
        if (queryPlan.getType() == 801017 && (aliasName = RQPUtilities.getAliasName((RQPQuery)queryPlan, nodeName)) != null) {
            return aliasName;
        }
        return null;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)node;
        return dataItemRef.isNestedQuerySetRefItem() || dataItemRef.isQueryRefItem();
    }
}

