/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;

public class ReplaceRQPNodesWithSQLNodes
extends RQPTransformation {
    public ReplaceRQPNodesWithSQLNodes() {
        this.mName = "Replace RQP Nodes with SQL Nodes";
        this.mPassNumbers = new int[]{45};
        this.mTypes = new int[]{801016, 801013, 801011, 801023, 801020};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode sqlNode = this.createSQLNode(environment.getNodeFactory(), node);
        node.exchange(sqlNode, true);
    }

    private IXQEQueryNode createSQLNode(IXQENodeFactory nodeFactory, IXQEQueryNode rqpNode) {
        switch (rqpNode.getType()) {
            case 801016: {
                return this.moveNodesToSQLList(nodeFactory, rqpNode, 301015, 301030);
            }
            case 801013: {
                return this.moveNodesToSQLList(nodeFactory, rqpNode, 301010, 301029);
            }
            case 801020: {
                return this.moveNodesToSQLList(nodeFactory, rqpNode, 301019, 301021);
            }
            case 801011: {
                return nodeFactory.createNode(301009);
            }
            case 801023: {
                return nodeFactory.createNode(301053);
            }
        }
        return null;
    }

    private IXQEQueryNode moveNodesToSQLList(IXQENodeFactory nodeFactory, IXQEQueryNode parentOfNodesToMove, int newNodeType, int listType) {
        IXQEQueryNode newNode = nodeFactory.createNode(newNodeType);
        IXQEQueryNode newParentOfNodes = nodeFactory.createNode(listType);
        while (parentOfNodesToMove.getNumberChildren() > 0) {
            parentOfNodesToMove.getChild(0).move(newParentOfNodes);
        }
        newNode.addChild(newParentOfNodes);
        return newNode;
    }
}

