/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.v5Exp.V5GenericFunction;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.IFunction;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;

public class ReplaceV5GenericFunction
extends RQPTransformation {
    public static final String NAME_SEPARATOR = ".";

    public ReplaceV5GenericFunction() {
        this.mName = "Replace V5GenericFunction";
        this.mPassNumbers = new int[]{44};
        this.mTypes = new int[]{201042};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5GenericFunction genericFunction = (V5GenericFunction)node;
        SQLFunction sqlFunction = (SQLFunction)nodeFactory.createNode(301033);
        sqlFunction.setSubType(SQLFunction.getSubTypeFromFunctionName(genericFunction.getName()), genericFunction.getName());
        if (sqlFunction.getSubType() == SQLFunction.SubType.UDF) {
            IFunction function;
            MetadataConnection mdConnection = environment.getMetadataConnection();
            String fName = sqlFunction.getFunctionName();
            if (fName.charAt(0) == '\"') {
                fName = fName.substring(1, fName.length() - 1);
            }
            if ((function = (IFunction)mdConnection.getFunction(fName)) != null) {
                String cName = function.getCanonicalName();
                IModelDataSource datasource = function.getDataSource();
                String fqName = this.buildFullyQualifyName(genericFunction, sqlFunction, environment, datasource, cName);
                sqlFunction.setFunctionName(fqName);
            }
            sqlFunction.setDataType(genericFunction.getDataType());
            if (genericFunction.getPropertyValue("isColumn") != null) {
                sqlFunction.setPropertyValue("isColumn", true);
            }
        }
        node.exchange(sqlFunction, true);
    }

    private String buildFullyQualifyName(IXQEQueryNode node, SQLIdentifier id, IPlanningEnvironment env, IModelDataSource datasource, String name) {
        MacroExpander expander = new MacroExpander();
        StringBuilder fullyQualifyName = new StringBuilder();
        String catalogName = null;
        ICatalog catalog = datasource.getCatalog();
        if (catalog != null && MacroExpander.isMacro(catalogName = catalog.getName())) {
            catalogName = expander.expand(node, env, catalogName);
        }
        String schemaName = datasource.getSchema();
        if (catalogName != null) {
            fullyQualifyName.append(catalogName);
            id.setCatalogName(catalogName);
            fullyQualifyName.append(NAME_SEPARATOR);
        }
        if (schemaName != null) {
            if (MacroExpander.isMacro(schemaName)) {
                schemaName = expander.expand(node, env, schemaName);
            }
            fullyQualifyName.append(schemaName);
            id.setSchemaName(schemaName);
            fullyQualifyName.append(NAME_SEPARATOR);
        } else if (catalogName != null) {
            fullyQualifyName.append(NAME_SEPARATOR);
        }
        fullyQualifyName.append(name);
        id.setName(name);
        return fullyQualifyName.toString();
    }
}

