/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLLike;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.ast.v5Exp.AbstractV5BooleanExpression;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.parameters.V5ParameterValueItem;
import com.cognos.xqe.query.parameters.V5ParameterValueItemPattern;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;

public final class ReplaceV5StringPredicate
extends RQPTransformation {
    private static final String PERCENT = "%";
    private static final String ESC_CHAR = "\\";
    private static final String UNDERSCORE = "_";

    public ReplaceV5StringPredicate() {
        this.mName = "Replace V5Expression(starts with, ends with, contains, like) node with SQLLike node.";
        this.mPassNumbers = new int[]{45};
        this.mTypes = new int[]{201006, 201007, 201005, 201004};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLLike sqlNode = (SQLLike)nodeFactory.createNode(301044);
        sqlNode.setSubType(SQLLike.SubType.LIKE);
        node.exchange(sqlNode, true);
        String valuePrefix = new String();
        String valueSuffix = new String();
        switch (node.getType()) {
            case 201006: {
                valueSuffix = PERCENT;
                break;
            }
            case 201007: {
                valuePrefix = PERCENT;
                break;
            }
            case 201005: {
                valuePrefix = PERCENT;
                valueSuffix = PERCENT;
                break;
            }
        }
        IXQEQueryNode childNode = sqlNode.getChild(1);
        if (childNode.getType() == 301031) {
            String value = ((SQLLiteral)childNode).getValue().toString();
            value = this.searchWildCardAndAddEscClause(nodeFactory, node, sqlNode, value);
            StringBuilder sb = new StringBuilder(valuePrefix);
            sb.append(value);
            sb.append(valueSuffix);
            ((SQLLiteral)childNode).setValue(sb.toString());
        } else if (childNode.getType() == 301051) {
            ((SQLParameter)childNode).setValuePrefix(valuePrefix);
            ((SQLParameter)childNode).setValueSuffix(valueSuffix);
            this.searchWildcardInParamValue(environment, nodeFactory, childNode, node, sqlNode);
        } else {
            if (childNode instanceof SQLFunction && (((SQLFunction)childNode).getSubType() == SQLFunction.SubType.UPPER || ((SQLFunction)childNode).getSubType() == SQLFunction.SubType.LOWER)) {
                if (((AbstractV5BooleanExpression)node).isLiteralMatch() && childNode.getChild(0).getType() != 301031 && childNode.getChild(0).getType() != 301051) {
                    StringBuilder buffer = new StringBuilder();
                    childNode.writeFormattedText(buffer);
                    if (buffer.length() <= 0) {
                        buffer.append(childNode.dumpToString(false));
                    }
                    if (buffer.length() <= 0) {
                        buffer.append(childNode.toString());
                    }
                    throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedLiteralPattern, buffer.toString());
                }
                if (childNode.getChild(0).getType() == 301031) {
                    SQLLiteral sqlLiteral = (SQLLiteral)childNode.getChild(0);
                    String value = sqlLiteral.getValue().toString();
                    value = this.searchWildCardAndAddEscClause(nodeFactory, node, sqlNode, value);
                    sqlLiteral.setValue(value);
                }
                if (childNode.getChild(0).getType() == 301051) {
                    SQLParameter sqlParameter = (SQLParameter)childNode.getChild(0);
                    this.searchWildcardInParamValue(environment, nodeFactory, sqlParameter, node, sqlNode);
                }
            }
            if (valuePrefix.length() > 0) {
                this.addConcat(nodeFactory, childNode, 0);
                childNode = sqlNode.getChild(1);
            }
            if (valueSuffix.length() > 0) {
                this.addConcat(nodeFactory, childNode, 1);
            }
        }
    }

    private void addConcat(IXQENodeFactory nodeFactory, IXQEQueryNode operand, int suffix) {
        SQLValueExpression concat = (SQLValueExpression)nodeFactory.createNode(301025);
        concat.setSubType(SQLValueExpression.SubType.CONCATENATE);
        operand.insertParent(concat);
        SQLLiteral percent = (SQLLiteral)nodeFactory.createNode(301031);
        percent.setDataType(DataTypeFactory.getCharType());
        percent.setValue(PERCENT);
        concat.addChild(percent, suffix);
    }

    private void searchWildcardInParamValue(PlanningEnvironment env, IXQENodeFactory nodeFactory, IXQEQueryNode sqlParam, IXQEQueryNode node, IXQEQueryNode sqlNode) {
        V5ParameterValueItem valItem;
        String value;
        String modifiedValue;
        if (!((AbstractV5BooleanExpression)node).isLiteralMatch()) {
            return;
        }
        SQLParameter sqlParm = (SQLParameter)sqlParam;
        Parameters parameters = ((RequestEnvironment)env.getRequestEnvironment()).getRequestParameters();
        Parameter parameter = parameters.getParameter(sqlParm.getName());
        ParameterValues values = parameter.getParameterValueItems();
        if (values.size() > 0 && values.get(0) instanceof V5ParameterValueItem && !(modifiedValue = this.searchWildCardAndAddEscClause(nodeFactory, node, sqlNode, value = (valItem = (V5ParameterValueItem)values.get(0)).getExternalValue())).equals(value)) {
            for (int i = 0; i < values.size(); ++i) {
                if (!(values.get(i) instanceof V5ParameterValueItemPattern)) continue;
                return;
            }
            V5ParameterValueItemPattern viPattern = new V5ParameterValueItemPattern(valItem);
            viPattern.setExternalValue(modifiedValue);
            values.add(viPattern);
        }
    }

    private String searchWildCardAndAddEscClause(IXQENodeFactory nodeFactory, IXQEQueryNode node, IXQEQueryNode sqlNode, String pattern) {
        if (node.getType() == 201006 || node.getType() == 201007 || node.getType() == 201005) {
            boolean isEscClauseNeeded = false;
            if (((AbstractV5BooleanExpression)node).isLiteralMatch() && (pattern.indexOf(PERCENT) != -1 || pattern.indexOf(UNDERSCORE) != -1)) {
                isEscClauseNeeded = true;
                pattern = this.searchWildCardAndEscape(pattern);
            }
            if (isEscClauseNeeded) {
                SQLLiteral escClause = (SQLLiteral)nodeFactory.createNode(301031);
                escClause.setDataType(DataTypeFactory.getCharType());
                escClause.setValue(ESC_CHAR);
                sqlNode.addChild(escClause);
            }
        }
        return pattern;
    }

    private String searchWildCardAndEscape(String pattern) {
        if ((pattern = this.searchWildCardAndEscape(pattern, ESC_CHAR)).indexOf(PERCENT) != -1) {
            pattern = this.searchWildCardAndEscape(pattern, PERCENT);
        }
        if (pattern.indexOf(UNDERSCORE) != -1) {
            pattern = this.searchWildCardAndEscape(pattern, UNDERSCORE);
        }
        return pattern;
    }

    private String searchWildCardAndEscape(String pattern, String charToEscape) {
        if (pattern.isEmpty()) {
            return pattern;
        }
        int foundIdx = pattern.indexOf(charToEscape);
        if (foundIdx != -1) {
            StringBuilder sb = new StringBuilder();
            if (foundIdx == 0) {
                sb.append(ESC_CHAR);
            } else {
                sb.append(pattern.substring(0, foundIdx));
                sb.append(ESC_CHAR);
            }
            sb.append(charToEscape);
            sb.append(this.searchWildCardAndEscape(pattern.substring(foundIdx + 1), charToEscape));
            return sb.toString();
        }
        return pattern;
    }
}

