/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.rqp.RQPSql;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLNativeSql;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.util.SQLCursorCollectionFormatter;
import com.cognos.xqe.ast.sql.util.SQLPrettyPrintQueryFormatter;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5SqlQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.relational.SQLCapabilities;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.ObjectValue;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.SecurityContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.util.RQEUtil;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.GenerateRQPSQL;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.IQueryReuseManager;
import com.cognos.xqe.util.QueryReuseEntry;
import com.cognos.xqe.util.QueryReuseManager;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class ReuseQuery
extends RQPTransformation {
    private static final String REPORT = "REPORT=";
    private static final String QUERY = " QUERY=";
    private static final String PROP_BOOL_REUSED = "reused";
    private static final String PROP_STR_RQPQUERYALREADYREMOVED = "RQPQueryAlreadyRemoved";

    public ReuseQuery() {
        this.mName = "Reuse Query";
        this.mPassNumbers = new int[]{57};
        this.mTypes = new int[]{301007, 801041};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getType() == 801041) {
            IXQEQueryNode sqlSort = null;
            IXQEQueryNode sqlSortKeyList = null;
            IXQEQueryNode firstChild = node.getChild(0);
            if (firstChild.getType() == 301019) {
                sqlSort = firstChild;
                sqlSortKeyList = sqlSort.getFirstChildByType(301021);
                sqlSortKeyList.detach();
                sqlSort.extract();
            }
            this.getOrCreateReusableEntry(environment, node);
            if (sqlSort != null) {
                IXQEQueryNode[] children = node.getChildren();
                node.detachChildren();
                node.addChild(sqlSort);
                sqlSort.addChildren(children, 0);
                sqlSort.addChild(sqlSortKeyList);
            }
            return;
        }
        SQLRangeVar sqlRangeVar = (SQLRangeVar)node;
        this.getOrCreateReusableEntry(environment, sqlRangeVar);
        sqlRangeVar.setPropertyValue(PROP_BOOL_REUSED, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (RQEUtil.hasNoCacheObjects(node, new int[]{301007, 801041})) {
            return false;
        }
        if (node.getType() == 301007) {
            if (node.getPropertyValue(PROP_BOOL_REUSED) != null) {
                return false;
            }
            SQLRangeVar rangeVar = (SQLRangeVar)node;
            return rangeVar.isQueryReusable();
        }
        RQPSql rqpSql = (RQPSql)node;
        Object isQueryReusable = rqpSql.isQueryReusable();
        if (isQueryReusable == null) {
            return false;
        }
        return (Boolean)isQueryReusable;
    }

    private SQLRangeVar createReusableSubQuery(IXQENodeFactory factory, Governors.LocalCachePolicy localCachePolicy, IXQEQueryNode inputQuery, String cursorName) {
        if (inputQuery.getType() == 301007 && inputQuery.getParent().getType() == 301018) {
            return this.makeReusableSetOperatorSubquery(factory, inputQuery, cursorName);
        }
        return this.makeReusableSubquery(factory, localCachePolicy, inputQuery, cursorName);
    }

    private SQLRangeVar makeReusableSubquery(IXQENodeFactory factory, Governors.LocalCachePolicy localCachePolicy, IXQEQueryNode inputQuery, String cursorName) {
        IXQEQueryNode topNode = inputQuery;
        SQLValueList valueList = RQPUtilities.getTopSQLValueList(inputQuery);
        if (valueList == null) {
            return null;
        }
        IXQEQueryNode[] columnRefs = this.createColumnReferences(factory, valueList, cursorName);
        SQLQueryNode cValueList = (SQLQueryNode)factory.createNode(301030);
        cValueList.addChildren(columnRefs, 0);
        SQLRangeVar reusableRangeVar = (SQLRangeVar)factory.createNode(301007);
        reusableRangeVar.setName(cursorName);
        IXQEQueryNode child = null;
        if (localCachePolicy == Governors.LocalCachePolicy.LOWEST_SUMMARY_SUBQUERY) {
            if (topNode.getType() == 801041) {
                if ((topNode = topNode.getChild(0)).getType() == 301022) {
                    child = topNode.detachChild(topNode.getNumberChildren() - 1);
                }
            } else {
                child = topNode.detachChild(0);
            }
        } else {
            child = topNode.detachChild(0);
            if (child.getType() == 301022 && child.getNumberChildren() == 1) {
                child = child.detachChild(0);
            }
        }
        SQLProject newSqlProject = (SQLProject)factory.createNode(301015);
        topNode.addChild(newSqlProject);
        newSqlProject.addChild(reusableRangeVar);
        newSqlProject.addChild(cValueList);
        reusableRangeVar.addChild(child);
        return reusableRangeVar;
    }

    private SQLRangeVar makeReusableSetOperatorSubquery(IXQENodeFactory factory, IXQEQueryNode inputQuery, String cursorName) {
        IXQEQueryNode parent = inputQuery.getParent();
        IXQEQueryNode projectionNode = RQPUtilities.getProjectionNode(inputQuery);
        IXQEQueryNode valueList = projectionNode.getFirstChildByType(301030);
        IXQEQueryNode[] columnRefs = this.createColumnReferences(factory, valueList, cursorName);
        IXQEQueryNode cValueList = factory.createNode(301030);
        cValueList.addChildren(columnRefs, 0);
        SQLRangeVar reusableRangeVar = (SQLRangeVar)inputQuery;
        reusableRangeVar.setName(cursorName);
        int rangeVarIndex = parent.getPositionOfChild(reusableRangeVar);
        parent.detachChild(rangeVarIndex);
        SQLProject newSqlProject = (SQLProject)factory.createNode(301015);
        parent.addChild(newSqlProject, rangeVarIndex);
        newSqlProject.addChild(reusableRangeVar);
        newSqlProject.addChild(cValueList);
        return reusableRangeVar;
    }

    private IXQEQueryNode[] createColumnReferencesAgainstReusableEntry(IXQENodeFactory factory, IXQEQueryNode inputQueryValueList, IXQEQueryNode reusableAstValueList, String cursorName) {
        int numOfProjItems = inputQueryValueList.getNumberChildren();
        IXQEQueryNode[] columnRefs = new IXQEQueryNode[numOfProjItems];
        for (int i = 0; i < numOfProjItems; ++i) {
            IXQEQueryNode inputProjItem = inputQueryValueList.getChild(i);
            SQLAlias reusableASTAlias = (SQLAlias)this.findProjectionItem(inputProjItem, reusableAstValueList);
            SQLColumn columnRefToASTAlias = RQPUtilities.createSQLColumn(factory, cursorName, reusableASTAlias.getName());
            SQLAlias columnRefAlias = (SQLAlias)factory.copyNode(inputProjItem);
            columnRefAlias.addChild(columnRefToASTAlias);
            columnRefs[i] = columnRefAlias;
        }
        return columnRefs;
    }

    private IXQEQueryNode findProjectionItem(IXQEQueryNode projectionItem, IXQEQueryNode sqlValueList) {
        IXQEQueryNode projectionExpression = projectionItem;
        if (projectionItem.getType() == 301028) {
            projectionExpression = projectionItem.getChild(0);
        }
        IXQEQueryNode[] iXQEQueryNodeArray = sqlValueList.getChildren();
        int n = iXQEQueryNodeArray.length;
        for (int i = 0; i < n; ++i) {
            IXQEQueryNode child;
            IXQEQueryNode childExpression = child = iXQEQueryNodeArray[i];
            if (child.getType() == 301028) {
                childExpression = child.getChild(0);
            }
            if (!childExpression.isSameExpression(projectionExpression, false)) continue;
            return child;
        }
        return null;
    }

    private IXQEQueryNode[] createColumnReferences(IXQENodeFactory factory, IXQEQueryNode valueList, String cursorName) {
        int numOfProjItems = valueList.getNumberChildren();
        IXQEQueryNode[] columnRefs = new IXQEQueryNode[numOfProjItems];
        for (int i = 0; i < numOfProjItems; ++i) {
            SQLAlias alias = (SQLAlias)valueList.getChild(i);
            SQLAlias cAlias = (SQLAlias)factory.copyNode(alias);
            SQLColumn columnRef = RQPUtilities.createSQLColumn(factory, cursorName, alias.getName());
            cAlias.addChild(columnRef);
            columnRefs[i] = cAlias;
        }
        return columnRefs;
    }

    private void getOrCreateReusableEntry(PlanningEnvironment environment, IXQEQueryNode inputQuery) {
        Object property;
        Map<String, Object> dsMetadataProperties;
        IDataSource ds;
        int i;
        RequestEnvironment reqEnvironment = (RequestEnvironment)environment.getRequestEnvironment();
        QueryReuseManager queryReuseManager = (QueryReuseManager)reqEnvironment.getQueryReuseManager();
        Governors.LocalCachePolicy localCachePolicy = RQPUtilities.getLocalCachePolicyFromGovernors(environment, inputQuery);
        Governors.DataCacheUsePolicy dataCacheUsePolicy = RQPUtilities.getDataCacheUsePolicyFromGovernors(environment, inputQuery);
        long dataCacheExpiry = RQPUtilities.getDataCacheExpiryFromGovernors(environment, inputQuery);
        XQENodeFactory factory = environment.getNodeFactory();
        LinkedList<IDataSource> dsList = new LinkedList<IDataSource>();
        RSAPIDataset dataSet = (RSAPIDataset)inputQuery.getAncestorOfType(401005);
        ArrayList<IXQEQueryNode> cteList = new ArrayList<IXQEQueryNode>();
        boolean captureTheCamPassport = false;
        String camPassport = reqEnvironment.getCAMPassport();
        if (localCachePolicy == Governors.LocalCachePolicy.EXPLICITLY_PER_QUERY) {
            this.getDataSourcesFromSQLRelations(environment, inputQuery, queryReuseManager, localCachePolicy, dsList, cteList);
        } else {
            IXQEQueryNode[] relations = inputQuery.getDescendantsOfType(301016, false);
            for (i = 0; i < relations.length; ++i) {
                SQLRelation relation = (SQLRelation)relations[i];
                ds = this.getDataSource(environment, relation);
                if (ds == null || dsList.contains(ds)) continue;
                dsMetadataProperties = ds.getMetadataProperties();
                property = dsMetadataProperties.get("connectionString");
                if (property != null && property instanceof String && MacroExpander.isMacro((String)property)) {
                    captureTheCamPassport = true;
                }
                dsList.add(ds);
            }
        }
        IXQEQueryNode[] nativeSqls = inputQuery.getDescendantsOfType(301012, false);
        for (i = 0; i < nativeSqls.length; ++i) {
            SQLNativeSql nativesql = (SQLNativeSql)nativeSqls[i];
            ds = nativesql.getDataSource();
            if (ds == null || dsList.contains(ds)) continue;
            dsMetadataProperties = ds.getMetadataProperties();
            property = dsMetadataProperties.get("connectionString");
            if (property != null && property instanceof String && MacroExpander.isMacro((String)property)) {
                captureTheCamPassport = true;
            }
            dsList.add(ds);
        }
        SecurityContext sc = new SecurityContext(reqEnvironment, environment.getMetadataConnection(), dsList, ((ExecutionEnvironment)environment.getExecutionEnvironment()).getGovernors());
        if (captureTheCamPassport) {
            sc.setCamPassport(camPassport);
        }
        QueryReuseEntry entry = null;
        if (localCachePolicy == Governors.LocalCachePolicy.LOWEST_SUMMARY_SUBQUERY) {
            RQPUtilities.removeRQPQueryNodes(inputQuery);
        } else {
            this.removeAllRQPQueryNodes(inputQuery);
        }
        Parameters reqParams = reqEnvironment.getRequestParameters();
        HashMap<String, ParameterValues> paramValuesMap = this.createParamValuesMapForInputQuery(inputQuery, reqParams);
        if (dataCacheUsePolicy != Governors.DataCacheUsePolicy.ONLY_FRESH_DATA) {
            entry = queryReuseManager.find(localCachePolicy, inputQuery, sc, paramValuesMap, reqParams, dataCacheExpiry, (IExecutionEnvironment)environment.getExecutionEnvironment());
        }
        if (entry != null) {
            this.reuseQueryEntry(factory, inputQuery, entry, queryReuseManager);
            this.logToSqlFile(reqEnvironment, entry, inputQuery);
            IUsageIndicator indicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.CACHED_QUERIES_REUSED, reqEnvironment.getReportName());
            if (indicator != null) {
                indicator.add(1L);
            }
            if (queryReuseManager.loggingEnabled()) {
                String logText = REPORT + reqEnvironment.getReportName() + QUERY + ReuseQuery.getQueryName(inputQuery) + " REUSED cursor=" + entry.getName() + " remainingTimeBeforeExpiry=" + entry.getCurrentExpiry(System.currentTimeMillis());
                queryReuseManager.logToXQELog(logText);
            }
            if (dataSet != null) {
                dataSet.setCurrentDataCacheExpiry(entry.getCurrentExpiry(System.currentTimeMillis()));
            }
        } else {
            IUsageIndicator indicator;
            QueryReuseEntry qre = null;
            String cursorName = queryReuseManager.createCursorName();
            SQLRangeVar reusableRangeVar = this.createReusableSubQuery(factory, localCachePolicy, inputQuery, cursorName);
            if (localCachePolicy != Governors.LocalCachePolicy.EXPLICITLY_PER_QUERY) {
                qre = queryReuseManager.addQueryReuseEntry(cursorName, factory.deepCopyNode(reusableRangeVar), sc, paramValuesMap, dataCacheExpiry);
                reusableRangeVar.setReusableQuery(qre);
            } else if (inputQuery.getType() == 801041) {
                qre = queryReuseManager.addQueryReuseEntry(cursorName, factory.deepCopyNode(reusableRangeVar), sc, paramValuesMap, dataCacheExpiry);
                reusableRangeVar.setReusableQuery(qre);
            } else {
                V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(environment, inputQuery);
                TreeSet<String> dq = rootQuerySet.getDependentQueriesOf(((SQLRangeVar)inputQuery).getName());
                if (dq != null && !dq.isEmpty()) {
                    IXQEQueryNode clonedReusableRangeVar = this.buildCursorSQLInWithClauseSyntax(environment, reusableRangeVar, cteList);
                    qre = queryReuseManager.addQueryReuseEntry(cursorName, clonedReusableRangeVar, sc, paramValuesMap, dataCacheExpiry);
                    reusableRangeVar.setReusableQuery(qre);
                } else {
                    qre = queryReuseManager.addQueryReuseEntry(cursorName, factory.deepCopyNode(reusableRangeVar), sc, paramValuesMap, dataCacheExpiry);
                    reusableRangeVar.setReusableQuery(qre);
                }
            }
            if (queryReuseManager.loggingEnabled()) {
                String logText = REPORT + reqEnvironment.getReportName() + QUERY + ReuseQuery.getQueryName(inputQuery) + " CREATED cursor=" + cursorName + " timeBeforeExpiry=" + qre.getCurrentExpiry(System.currentTimeMillis());
                queryReuseManager.logToXQELog(logText);
                queryReuseManager.logToXQELog(LogLevel.TRACE, "Cognos SQL of " + cursorName + "\n" + this.generateSQLForScrollCursor(inputQuery, reusableRangeVar));
            }
            if (dataSet != null) {
                dataSet.setCurrentDataCacheExpiry(qre.getCurrentExpiry(System.currentTimeMillis()));
            }
            if ((indicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.CACHED_QUERIES_CREATED, reqEnvironment.getReportName())) != null) {
                indicator.add(1L);
            }
        }
    }

    private String generateSQLForScrollCursor(IXQEQueryNode inputQuery, IXQEQueryNode cursorSQLAST) {
        Properties props = new Properties();
        props.setProperty("printDbName", "true");
        SQLPrettyPrintQueryFormatter formatter = new SQLPrettyPrintQueryFormatter(props);
        SQLQueryNode qNode = (SQLQueryNode)cursorSQLAST.getChild(0);
        RQPSql rqpSql = null;
        rqpSql = inputQuery.getType() == 801041 ? (RQPSql)inputQuery : (RQPSql)inputQuery.getAncestorOfType(801041);
        formatter.setWithClauseGovernor(rqpSql.getGovernors().getSqlWithClause());
        formatter.setForPlanning(true);
        formatter.setReportAsDatasource(rqpSql.getGovernors().getReportAsDatasource());
        SQLCapabilities capabilities = SQLCapabilities.getInstance();
        qNode.accept(formatter, capabilities);
        String formattedSql = formatter.toString();
        return formattedSql;
    }

    public static String getQueryName(IXQEQueryNode inputQuery) {
        if (inputQuery.getType() == 801041) {
            return ((RQPSql)inputQuery).getName();
        }
        if (inputQuery.getType() == 301007) {
            return ((SQLRangeVar)inputQuery).getName();
        }
        return null;
    }

    private void removeAllRQPQueryNodes(IXQEQueryNode inputQuery) {
        IXQEQueryNode topNode = null;
        if (inputQuery.getType() == 801041) {
            topNode = inputQuery;
        } else {
            topNode = inputQuery.getParent();
            if (topNode.getType() == 301022) {
                topNode = topNode.getParent();
            }
        }
        if (topNode.getPropertyValue(PROP_STR_RQPQUERYALREADYREMOVED) == null) {
            RQPUtilities.removeRQPQueryNodes(topNode);
            topNode.setPropertyValue(PROP_STR_RQPQUERYALREADYREMOVED, true);
        }
    }

    private IXQEQueryNode buildCursorSQLInWithClauseSyntax(PlanningEnvironment environment, IXQEQueryNode inputV5Query, ArrayList<IXQEQueryNode> cteList) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode sqlWith = factory.createNode(301022);
        for (int i = cteList.size() - 1; i >= 0; --i) {
            IXQEQueryNode clonedRangeVar = factory.deepCopyNode(cteList.get(i));
            IXQEQueryNode rqpQuery = clonedRangeVar.getChild(0);
            if (rqpQuery.getType() == 801017) {
                rqpQuery.extract();
            }
            sqlWith.addChild(clonedRangeVar);
        }
        IXQEQueryNode clonedRangeVar = factory.deepCopyNode(inputV5Query);
        IXQEQueryNode mainSelect = clonedRangeVar.detachChild(0);
        sqlWith.addChild(mainSelect);
        clonedRangeVar.addChild(sqlWith);
        return clonedRangeVar;
    }

    private void getDataSourcesFromSQLRelations(PlanningEnvironment environment, IXQEQueryNode inputQuery, QueryReuseManager queryReuseManager, Governors.LocalCachePolicy localCachePolicy, List<IDataSource> dsList, ArrayList<IXQEQueryNode> cteList) {
        List<IXQEQueryNode> relations = null;
        relations = inputQuery.getDescendantsOfTypeOrdered(301016, false);
        for (int i = 0; i < relations.size(); ++i) {
            SQLRelation relation = (SQLRelation)relations.get(i);
            IDataSource ds = this.getDataSource(environment, relation);
            if (ds != null && !dsList.contains(ds)) {
                dsList.add(ds);
                continue;
            }
            if (localCachePolicy != Governors.LocalCachePolicy.EXPLICITLY_PER_QUERY || ds != null) continue;
            this.getDataSourcesFromCTE(environment, relation, queryReuseManager, localCachePolicy, dsList, cteList);
        }
        this.getDataSourcesFromCursors(inputQuery, queryReuseManager, dsList);
    }

    private void getDataSourcesFromCursors(IXQEQueryNode inputQuery, QueryReuseManager queryReuseManager, List<IDataSource> dsList) {
        IXQEQueryNode[] sqlTableFunctions = inputQuery.getDescendantsOfType(301038, false);
        for (int i = 0; i < sqlTableFunctions.length; ++i) {
            IDataSource ds;
            ObjectValue tmp;
            IQueryReuseManager.CursorInfo cursorInfo;
            SQLLiteral cursorInfoLiteral;
            SQLTableFunction sqlTableFunction = (SQLTableFunction)sqlTableFunctions[i];
            if (sqlTableFunction.getSubType() != SQLTableFunction.SubType.CURSOR || (cursorInfoLiteral = (SQLLiteral)sqlTableFunction.getChild(0)) == null || (cursorInfo = (IQueryReuseManager.CursorInfo)(tmp = (ObjectValue)cursorInfoLiteral.getValue()).getObject()) == null || (ds = cursorInfo.getDataSource()) == null || dsList.contains(ds)) continue;
            dsList.add(ds);
        }
    }

    private void getDataSourcesFromCTE(PlanningEnvironment environment, IXQEQueryNode relation, QueryReuseManager queryReuseManager, Governors.LocalCachePolicy localCachePolicy, List<IDataSource> dsList, ArrayList<IXQEQueryNode> cteList) {
        IXQEQueryNode child;
        IXQEQueryNode withSpec = relation.getAncestorOfType(301022);
        if (withSpec == null) {
            return;
        }
        String relationName = ((SQLRelation)relation).getName();
        SQLRangeVar rangeVar = null;
        for (int i = 0; !(i >= withSpec.getNumberChildren() - 1 || (child = withSpec.getChild(i)).getType() == 301007 && (rangeVar = (SQLRangeVar)child).getName().equals(relationName)); ++i) {
        }
        if (rangeVar != null) {
            if (!cteList.contains(rangeVar)) {
                cteList.add(rangeVar);
            }
            this.getDataSourcesFromSQLRelations(environment, rangeVar, queryReuseManager, localCachePolicy, dsList, cteList);
        }
    }

    private IDataSource getDataSource(PlanningEnvironment planningEnv, SQLRelation relation) {
        V5SqlQuery sqlQuery;
        IDataSource dataSource = relation.getDataSource();
        if (dataSource != null) {
            return dataSource;
        }
        String modelDatasourceName = relation.getModelDatasourceName();
        String database = relation.getDatabaseName();
        if (database == null && (sqlQuery = (V5SqlQuery)relation.getAncestorOfType(101016)) != null) {
            database = (String)sqlQuery.getPropertyValue("dataSource");
        }
        if (database != null) {
            dataSource = SQLBinderUtil.findOrCreateDataSource(planningEnv, modelDatasourceName, database, relation.getCatalogName(), relation.getSchemaName(), null, false);
        }
        return dataSource;
    }

    private void reuseQueryEntry(IXQENodeFactory factory, IXQEQueryNode inputQuery, QueryReuseEntry reusableEntry, QueryReuseManager queryReuseManager) {
        IXQEQueryNode temp;
        SQLRangeVar reusableRangeVar;
        IXQEQueryNode topNode = inputQuery;
        String cursorName = reusableEntry.getName();
        IXQEQueryNode reusableAST = reusableEntry.getReusableSQLAST();
        IXQEQueryNode reusableASTProjNode = RQPUtilities.getProjectionNode(reusableAST);
        IXQEQueryNode inputQueryProjNode = RQPUtilities.getProjectionNode(inputQuery);
        IXQEQueryNode reusableAstValueList = reusableASTProjNode.getFirstChildByType(301030);
        IXQEQueryNode inputQueryValueList = inputQueryProjNode.getFirstChildByType(301030);
        IXQEQueryNode[] columnRefs = this.createColumnReferencesAgainstReusableEntry(factory, inputQueryValueList, reusableAstValueList, cursorName);
        SQLQueryNode cValueList = (SQLQueryNode)factory.createNode(301030);
        cValueList.addChildren(columnRefs, 0);
        if (reusableEntry.getCursorInfo() != null) {
            reusableRangeVar = (SQLRangeVar)factory.createNode(301007);
            reusableRangeVar.setName(cursorName);
            reusableRangeVar.setReusableQuery(null);
            SQLTableFunction tableFunction = (SQLTableFunction)factory.createNode(301038);
            tableFunction.setSubType(SQLTableFunction.SubType.CURSOR);
            tableFunction.setDataSource(reusableEntry.getCursorInfo().getDataSource());
            SQLLiteral sqlLiteral = (SQLLiteral)factory.createNode(301031);
            sqlLiteral.setDataType(DataTypeFactory.getObjectType());
            ObjectValue value = DataValueFactory.createObjectValue();
            value.set(reusableEntry.getCursorInfo());
            sqlLiteral.setValue(value);
            reusableRangeVar.addChild(tableFunction);
            tableFunction.addChild(sqlLiteral);
        } else {
            reusableRangeVar = (SQLRangeVar)factory.deepCopyNode(reusableAST);
            reusableRangeVar.setReusableQuery(reusableEntry);
        }
        IXQEQueryNode sqlFilter1 = QueryReuseManager.getSQLFilter(inputQuery);
        IXQEQueryNode sqlFilter2 = QueryReuseManager.getSQLFilter(reusableAST);
        ArrayList<IXQEQueryNode> filterExprs1 = new ArrayList<IXQEQueryNode>();
        QueryReuseManager.getFilterExpressions(sqlFilter1, filterExprs1);
        ArrayList<IXQEQueryNode> filterExprs2 = new ArrayList<IXQEQueryNode>();
        QueryReuseManager.getFilterExpressions(sqlFilter2, filterExprs2);
        ArrayList<IXQEQueryNode> matchingExprs = new ArrayList<IXQEQueryNode>();
        ArrayList<IXQEQueryNode> nonMatchingExprs = new ArrayList<IXQEQueryNode>();
        QueryReuseManager.bucketFilterExpressions(filterExprs1, filterExprs2, matchingExprs, nonMatchingExprs);
        IXQEQueryNode sqlFilter = this.addNewFilters(factory, nonMatchingExprs, cursorName, reusableASTProjNode);
        if (sqlFilter != null) {
            temp = sqlFilter;
            temp.addChild(reusableRangeVar, 0);
        } else {
            temp = reusableRangeVar;
        }
        SQLProject sqlProject = (SQLProject)factory.createNode(301015);
        sqlProject.addChild(temp);
        sqlProject.addChild(cValueList);
        topNode.detachFirstChild();
        topNode.addChild(sqlProject);
    }

    private void logToSqlFile(RequestEnvironment reqEnvironment, QueryReuseEntry entry, IXQEQueryNode inputQuery) {
        RQPSql rqpSql = null;
        rqpSql = inputQuery.getType() == 801041 ? (RQPSql)inputQuery : (RQPSql)inputQuery.getAncestorOfType(801041);
        if (rqpSql == null) {
            return;
        }
        RSAPIDataset dataSet = (RSAPIDataset)rqpSql.getAncestorOfType(401005);
        if (dataSet == null) {
            return;
        }
        if (GenerateRQPSQL.isSQLFilePathSet(reqEnvironment) || dataSet.queryFeedbackIsRequested("CognosCommandText") || dataSet.getSqlToMessageFolder()) {
            String cursorName = entry.getName();
            SQLCursorCollectionFormatter plannedSQLCursors = rqpSql.getPlannedSQLCursors();
            if (!plannedSQLCursors.getCursors().containsKey(cursorName)) {
                IXQEQueryNode plannedSqlAst = entry.getReusableSQLAST();
                SQLQueryNode qNode = (SQLQueryNode)plannedSqlAst.getChild(0);
                Properties props = new Properties();
                props.setProperty("printDbName", "true");
                SQLPrettyPrintQueryFormatter formatter = new SQLPrettyPrintQueryFormatter(props);
                formatter.setWithClauseGovernor(inputQuery.getGovernors().getSqlWithClause());
                formatter.setForPlanning(true);
                SQLCapabilities capabilities = SQLCapabilities.getInstance();
                qNode.accept(formatter, capabilities);
                String formattedSql = formatter.toString();
                plannedSQLCursors.addSQLCursorText(cursorName, formattedSql);
            }
        }
    }

    private IXQEQueryNode addNewFilters(IXQENodeFactory factory, List<IXQEQueryNode> additionalFilters, String cursorName, IXQEQueryNode reusableASTProjNode) {
        IXQEQueryNode sqlFilter = null;
        if (additionalFilters.size() > 0) {
            sqlFilter = factory.createNode(301009);
            if (additionalFilters.size() == 1) {
                IXQEQueryNode filter = additionalFilters.get(0);
                this.rewriteFilterExpression(filter, reusableASTProjNode, cursorName);
                sqlFilter.addChild(filter);
            } else {
                SQLLogical logicalAND = (SQLLogical)factory.createNode(301027);
                logicalAND.setSubType(SQLLogical.SubType.AND);
                for (int i = 0; i < additionalFilters.size(); ++i) {
                    IXQEQueryNode filter = additionalFilters.get(i);
                    this.rewriteFilterExpression(filter, reusableASTProjNode, cursorName);
                    if (logicalAND.getNumberChildren() != 2) {
                        logicalAND.addChild(filter);
                        continue;
                    }
                    SQLLogical temp = (SQLLogical)factory.createNode(301027);
                    temp.setSubType(SQLLogical.SubType.AND);
                    temp.addChild(logicalAND);
                    temp.addChild(filter);
                    logicalAND = temp;
                }
                sqlFilter.addChild(logicalAND);
            }
        }
        return sqlFilter;
    }

    private void rewriteFilterExpression(IXQEQueryNode sqlFilter, IXQEQueryNode reusableASTProjNode, String cursorName) {
        IXQEQueryNode sqlValueList = reusableASTProjNode.getFirstChildByType(301030);
        block0: for (IXQEQueryNode column : sqlFilter.getDescendantsOfType(301005, true, 301059)) {
            SQLColumn sqlColumn = (SQLColumn)column;
            for (IXQEQueryNode child : sqlValueList.getChildren()) {
                if (!child.getChild(0).isSameExpression(column, false)) continue;
                sqlColumn.setTableName(cursorName);
                sqlColumn.setName(((SQLAlias)child).getName());
                continue block0;
            }
        }
    }

    private void populateMapWithParamsFoundUnderNode(IXQEQueryNode queryNode, HashMap<String, ParameterValues> paramValuesMap, Parameters reqParams) {
        IXQEQueryNode[] sqlParams = queryNode.getDescendantsOfType(301051, false);
        for (int i = 0; i < sqlParams.length; ++i) {
            Parameter param;
            SQLParameter sqlParam = (SQLParameter)sqlParams[i];
            String paramName = sqlParam.getName();
            if (paramName == null || paramValuesMap.containsKey(paramName) || (param = (Parameter)reqParams.get(paramName)) == null) continue;
            param.setIsUsedByScrollCursor(true);
            paramValuesMap.put(paramName, param.getParameterValueItems());
        }
    }

    private HashMap<String, ParameterValues> createParamValuesMapForInputQuery(IXQEQueryNode inputQuery, Parameters reqParams) {
        V5QuerySet rootQuerySet;
        TreeSet<String> dependentQueries;
        HashMap<String, ParameterValues> paramValuesMap = new HashMap<String, ParameterValues>();
        this.populateMapWithParamsFoundUnderNode(inputQuery, paramValuesMap, reqParams);
        if (inputQuery.getType() == 301007 && inputQuery.getParent().getType() == 301022 && (dependentQueries = (rootQuerySet = V5QuerySet.getRootQuerySet(inputQuery)).getDependentQueriesOf(((SQLRangeVar)inputQuery).getName())) != null) {
            IXQEQueryNode sqlWithOfInputQuery = inputQuery.getParent();
            int nbCTEsInInputQuery = sqlWithOfInputQuery.getNumberChildren() - 1;
            for (int j = 0; j < nbCTEsInInputQuery; ++j) {
                SQLRangeVar sqlRangeVar = (SQLRangeVar)sqlWithOfInputQuery.getChild(j);
                if (!dependentQueries.contains(sqlRangeVar.getName())) continue;
                this.populateMapWithParamsFoundUnderNode(sqlRangeVar, paramValuesMap, reqParams);
            }
        }
        return paramValuesMap;
    }
}

