/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ApplyRollupAggregate;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class ApplyAggregateAttributeOnRQPDataItem
extends RQPTransformation {
    public ApplyAggregateAttributeOnRQPDataItem() {
        this.mName = "Apply aggregate attribute on RQPDataItem.";
        this.mPassNumbers = new int[]{16};
        this.mTypes = new int[]{801008};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPDataItem inputRqpDataItem = (RQPDataItem)node;
        IXQEQueryNode rqpdataItemExpr = inputRqpDataItem.getExpression();
        V5DataItem dataItem = RQPUtilities.getV5DataItem(rqpdataItemExpr);
        IXQEQueryNode itemExpression = null;
        boolean autoSumTrue = inputRqpDataItem.getParentRQPQuery().isAutoSummaryTRUE();
        if (dataItem.getAggregateProperty().equals("none") || !autoSumTrue) {
            IXQEQueryNode detailExpr = environment.getNodeFactory().deepCopyNode(dataItem.getDetailExpression());
            if (!inputRqpDataItem.belongsToLastValueSet() && autoSumTrue) {
                V5ValueSummaryFunction minFunction = ExpressionAnalyzer.createV5SummaryFunctionMin(environment);
                minFunction.addChild(detailExpr);
                itemExpression = minFunction;
                inputRqpDataItem.setBelongsToLastValueSet(true);
            } else {
                itemExpression = detailExpr;
            }
        } else {
            IXQEQueryNode aggrExpr = dataItem.getAggregateExpression(environment);
            if (aggrExpr == null) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_AggregateAutomaticNotResolved, dataItem.getNameProperty());
            }
            itemExpression = environment.getNodeFactory().deepCopyNode(aggrExpr);
            if (!RQPUtilities.hasAggregateInExpression(itemExpression)) {
                V5ValueSet vsSet = inputRqpDataItem.getValueSet();
                IXQEQueryNode[] vGrps = vsSet.getAncestorsOfType(101050);
                boolean toBeGrouped = false;
                for (IXQEQueryNode vGrp : vGrps) {
                    V5ValueSet v = (V5ValueSet)vGrp.getFirstChildByType(101057);
                    if (null == v.getRefDataItemProperty()) continue;
                    toBeGrouped = true;
                    break;
                }
                if (toBeGrouped) {
                    V5ValueSummaryFunction minFunction = ExpressionAnalyzer.createV5SummaryFunctionMin(environment);
                    itemExpression.insertParent(minFunction);
                    itemExpression = minFunction;
                }
            }
        }
        if (!inputRqpDataItem.belongsToLastValueSet()) {
            ApplyRollupAggregate.generateMinAroundStandardAggWithExplicitForClause(itemExpression, environment, false, null);
        }
        rqpdataItemExpr.exchange(itemExpression, false);
        if (dataItem.getPropIsRollupExpression()) {
            List<IXQEQueryNode> dataItemReferences = itemExpression.getDescendantsOfTypeOrdered(201060, false);
            for (IXQEQueryNode di : dataItemReferences) {
                V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)di;
                V5DataItem refDataItem = dataItemRef.getRefDataItem();
                if (refDataItem.getType() != 101003) continue;
                V5DataItem v5DataItem = refDataItem;
                String aggregateName = v5DataItem.getAggregateProperty();
                if (aggregateName.equals("none")) {
                    IXQEQueryNode nodeToExchange = environment.getNodeFactory().deepCopyNode(refDataItem.getChild(0));
                    dataItemRef.exchange(nodeToExchange);
                    continue;
                }
                IXQEQueryNode aggregateExpr = v5DataItem.getAggregateExpression(environment);
                if (aggregateExpr == null) continue;
                IXQEQueryNode expression = environment.getNodeFactory().deepCopyNode(aggregateExpr);
                dataItemRef.exchange(expression);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            this.traceNodeCondition(false, "The RQPDataItem node is not under a RQP query", xqeTrace);
            return false;
        }
        RQPDataItem rqpDataItem = (RQPDataItem)node;
        if (rqpDataItem.isFooterHeaderItem() || rqpDataItem.isGroupBodyItemOfNonLastValueSet()) {
            this.traceNodeCondition(false, "The RQPDataItem needs to apply rollup aggregate attribute.", xqeTrace);
            return false;
        }
        if (node.getAncestorOfType(801016) != null && node.getNumberChildren() == 1 && (node.getChild(0).getType() == 101015 || node.getChild(0).getType() == 101003)) {
            this.traceNodeCondition(true, "The RQPDataItem node is under a RQPProjectionList.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "The RQPDataItem node is not under a RQPProjectionList.", xqeTrace);
        return false;
    }
}

