/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.Bridge;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueAnalyticFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DistributeProjectionsInFactQueries;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.List;

public class DistributeProjectionsInBridgeFactQueries
extends DistributeProjectionsInFactQueries {
    public DistributeProjectionsInBridgeFactQueries() {
        this.mName = "DistributeProjectionsInBridgeFactQueries";
    }

    @Override
    protected void addProjectionInSupportingFactQueries(PlanningEnvironment environment, RQPFactManager factManager, RQPDataItem mainProjectionItem) {
        IXQEQueryNode[] aggrNodes;
        IXQEQueryNode projectionExpression = mainProjectionItem.getExpression();
        String projectionName = mainProjectionItem.getName();
        for (IXQEQueryNode aggrNode : aggrNodes = ExpressionAnalyzer.getAggregateNodes(mainProjectionItem)) {
            if (((V5AggregateFunction)aggrNode).getPrefilter()) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_NonSupportedBridgePreFilterAggregate, RQPNode.getRQPQuery(factManager).getName(), projectionName);
            }
            int type = aggrNode.getType();
            if (type == 201031 && ((V5ValueSummaryFunction)aggrNode).getSubType() == 1 && !((V5ValueSummaryFunction)aggrNode).getRollupAggregateNode()) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_NonSupportedBridgeAverageAggregate, RQPNode.getRQPQuery(factManager).getName(), projectionName);
            }
            if (type == 201033 && ((V5ValueAnalyticFunction)aggrNode).getSubType() != 14) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_NonSupportedBridgeAnalyticAggregate, RQPNode.getRQPQuery(factManager).getName(), projectionName);
            }
            if (type != 201035) continue;
            throw new XQERuntimeException(XQEMessageKeys.PLN_NonSupportedBridgeRunningAggregate, RQPNode.getRQPQuery(factManager).getName(), projectionName);
        }
        boolean rankFunction = false;
        if (projectionExpression.getType() == 201033) {
            rankFunction = true;
        }
        if (!this.isFooterHeaderOrRollup(mainProjectionItem) && !rankFunction) {
            List<String> supportingStreams = factManager.getSupportingStreams(mainProjectionItem, null);
            if (supportingStreams.size() == 0) {
                this.splitProjectionExpression(environment, factManager, projectionExpression, projectionName);
                return;
            }
        } else {
            if (ExpressionAnalyzer.isStandardAggregateWithAutoForClause(projectionExpression) && ExpressionAnalyzer.isStandardAggregate(projectionExpression.getChild(0)) && !ExpressionAnalyzer.isStandardAggregateWithAutoForClause(projectionExpression.getChild(0))) {
                projectionExpression = projectionExpression.getChild(0);
            }
            if (rankFunction) {
                this.processBreakClause(environment, factManager, projectionExpression);
                projectionExpression = projectionExpression.getChild(0).getChild(0);
            }
            if (projectionExpression.getType() != 201031) {
                for (IXQEQueryNode child : projectionExpression.getChildren()) {
                    this.processCustomFooterExpressionForBridgeQuery(environment, factManager, child, projectionName);
                }
            } else {
                IXQEQueryNode expression;
                List<String> supportingStreams;
                List<RQPQuery> rqpQueries;
                boolean automaticRollup = false;
                if (mainProjectionItem.getAutomaticRollup()) {
                    automaticRollup = true;
                }
                if ((rqpQueries = factManager.getRQPQueries(supportingStreams = factManager.getSupportingStreams(expression = projectionExpression.getChild(0), null))).size() != 0) {
                    if (expression.getType() != 201031) {
                        V5ValueSummaryFunction parentAggFunc = (V5ValueSummaryFunction)projectionExpression;
                        V5ValueSummaryFunction aggFunc = (V5ValueSummaryFunction)environment.getNodeFactory().createNode(201031);
                        aggFunc.setSubType(parentAggFunc.getSubType());
                        if (parentAggFunc.getSubType() == 2) {
                            parentAggFunc.setSubType(9);
                        }
                        expression.insertParent(aggFunc);
                        expression = aggFunc;
                    } else if (!automaticRollup) {
                        projectionExpression.setPropertyValue("isExplicitAggregate", Boolean.TRUE);
                    }
                    factManager.pushExpressionInQueriesAndCreateRefInOuterQuery(environment, rqpQueries, expression, projectionName, false);
                } else {
                    this.splitProjectionExpression(environment, factManager, expression, projectionName);
                }
                this.processBreakClause(environment, factManager, projectionExpression);
            }
            return;
        }
        super.addProjectionInSupportingFactQueries(environment, factManager, mainProjectionItem);
    }

    private void processCustomFooterExpressionForBridgeQuery(PlanningEnvironment environment, RQPFactManager factManager, IXQEQueryNode projectionExpression, String projectionName) {
        throw new XQERuntimeException(XQEMessageKeys.PLN_NonSupportedCustomFooterOverBridgeQuery);
    }

    private boolean isFooterHeaderOrRollup(RQPDataItem rqpDataItem) {
        IXQEQueryNode[] aggrNodes;
        if (rqpDataItem.isFooterHeaderItem()) {
            return true;
        }
        if (rqpDataItem.getPropIsRollupExpression()) {
            return true;
        }
        for (IXQEQueryNode aggrNode : aggrNodes = ExpressionAnalyzer.getAggregateNodes(rqpDataItem)) {
            if (!aggrNode.hasChildOfType(201037)) continue;
            return true;
        }
        return false;
    }

    private void processBreakClause(PlanningEnvironment environment, RQPFactManager factManager, IXQEQueryNode projectionExpression) {
        IXQEQueryNode forClause = projectionExpression.getFirstChildByType(201037);
        if (forClause != null) {
            for (IXQEQueryNode node : forClause.getChildren()) {
                List<String> supportingStreams = factManager.getSupportingStreams(node, null);
                List<RQPQuery> rqpQueries = factManager.getRQPQueries(supportingStreams);
                if (rqpQueries.size() == 0) continue;
                factManager.pushExpressionInQueriesAndCreateRefInOuterQuery(environment, rqpQueries, node, RQPUtilities.getExpressionName(node), true);
            }
        }
    }

    @Override
    protected boolean passesBridgeCondition(RQPQuery rootQuery) {
        return rootQuery.isUsingBridge();
    }
}

