/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.Bridge;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPBridgeTabularQuery;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryFilterList;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.rqp.RQPTabularQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;

public class WrapBridgeQuery
extends RQPTransformation {
    public WrapBridgeQuery() {
        this.mName = "Wrap Bridge Query";
        this.mPassNumbers = new int[]{38};
        this.mTypes = new int[]{801017};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery query = (RQPQuery)node;
        this.wrapQuery(environment, query, false);
        RQPSummaryFilterList summaryFilterList = query.getSummaryFilterList();
        if (summaryFilterList != null) {
            RQPBridgeTabularQuery bridgeTabularQuery = query.getDefaultBridgeTabularQuery();
            summaryFilterList.move(bridgeTabularQuery);
            this.wrapQuery(environment, bridgeTabularQuery, true);
        }
    }

    private void wrapQuery(PlanningEnvironment environment, RQPQuery query, boolean isFilter) {
        RQPSummaryQuery summaryQuery;
        RQPTabularQuery tabularQuery = query.getDefaultTabularQuery();
        if (tabularQuery != null) {
            tabularQuery.detach();
        }
        if ((summaryQuery = query.getDefaultSummaryQuery()) != null) {
            summaryQuery.detach();
        }
        IXQEQueryNode subqueryList = query.getSubqueryList();
        subqueryList.detach();
        RQPBridgeTabularQuery bridgeTabularQuery = null;
        RQPQuery filterQuery = null;
        if (isFilter) {
            filterQuery = (RQPQuery)query.createQueryAndAddToSubqueryList(environment, 801017, true);
            filterQuery.setIsBridgeSummaryFilterQuery();
            bridgeTabularQuery = filterQuery.getOrCreateDefaultBridgeTabularQuery(environment);
        } else {
            bridgeTabularQuery = query.getOrCreateDefaultBridgeTabularQuery(environment);
        }
        bridgeTabularQuery.addChild(subqueryList);
        RQPFactManager factManager = query.getFactManager();
        factManager.move(bridgeTabularQuery);
        RQPJoinPath joinPath = query.getJoinPath();
        joinPath.move(bridgeTabularQuery);
        bridgeTabularQuery.setComputedJoinPlan(true);
        query.setComputedJoinPlan(false);
        if (!isFilter) {
            query.createFactManager(environment);
            query.getOrCreateDefaultSummaryQuery(environment);
        }
        for (IXQEQueryNode projection : query.getProjectionList().getChildren()) {
            RQPDataItem item = (RQPDataItem)projection;
            for (IXQEQueryNode ref : item.getDescendantsOfTypeOrdered(801009, false)) {
                this.projectItemInSubqueries(environment, (RQPDataItemRef)ref, filterQuery, bridgeTabularQuery, isFilter);
            }
        }
        if (isFilter) {
            RQPSummaryFilterList summaryFilterList = query.getSummaryFilterList();
            for (IXQEQueryNode filter : summaryFilterList.getChildren()) {
                for (IXQEQueryNode ref : filter.getDescendantsOfTypeOrdered(801009, false)) {
                    this.projectItemInSubqueries(environment, (RQPDataItemRef)ref, filterQuery, bridgeTabularQuery, isFilter);
                }
            }
            this.projectBridgeKeys(environment, bridgeTabularQuery, filterQuery);
        }
        this.setBridgeStreamOnDataItems(environment, bridgeTabularQuery);
        if (isFilter) {
            this.setBridgeStreamOnDataItems(environment, filterQuery);
        }
    }

    private void projectItemInSubqueries(PlanningEnvironment environment, RQPDataItemRef dataItemRef, RQPQuery filterQuery, RQPBridgeTabularQuery bridgeTabularQuery, boolean isFilter) {
        RQPDataItem referencedItem = bridgeTabularQuery.getDataItemInSubQuery(dataItemRef);
        RQPDataItem dataItem = bridgeTabularQuery.getRQPDataItem(environment, (IXQEQueryNode)dataItemRef, referencedItem);
        if (isFilter) {
            RQPDataItemRef filterItemRef = RQPDataItemRef.create(environment, dataItem);
            RQPDataItem filterItem = filterQuery.getRQPDataItem(environment, (IXQEQueryNode)filterItemRef, dataItem);
            dataItemRef.setName(filterItem.getName());
            dataItemRef.setQueryName(filterQuery.getName());
        } else {
            dataItemRef.setName(dataItem.getName());
            dataItemRef.setQueryName(bridgeTabularQuery.getName());
        }
    }

    private void projectBridgeKeys(PlanningEnvironment environment, RQPBridgeTabularQuery bridgeTabularQuery, RQPQuery filterQuery) {
        ArrayList<RQPQuery> processedStreamQueries = new ArrayList<RQPQuery>();
        for (IXQEQueryNode item : bridgeTabularQuery.getProjectionList().getChildren()) {
            RQPDataItem dataItem = (RQPDataItem)item;
            for (IXQEQueryNode ref : dataItem.getDescendantsOfTypeOrdered(801009, false)) {
                RQPDataItem referencedItem = ((RQPDataItemRef)ref).getNextReferencedItem();
                RQPQuery streamQuery = RQPNode.getRQPQuery(referencedItem);
                if (processedStreamQueries.contains(streamQuery)) continue;
                processedStreamQueries.add(streamQuery);
                for (IXQEQueryNode item2 : streamQuery.getProjectionList().getChildren()) {
                    RQPDataItem streamItem = (RQPDataItem)item2;
                    if (!streamItem.isBridgeKey()) continue;
                    RQPDataItemRef streamItemRef = RQPDataItemRef.create(environment, streamItem);
                    RQPDataItem tabularItem = bridgeTabularQuery.getRQPDataItem(environment, (IXQEQueryNode)streamItemRef, streamItem);
                    RQPDataItemRef tabularItemRef = RQPDataItemRef.create(environment, tabularItem);
                    filterQuery.getRQPDataItem(environment, (IXQEQueryNode)tabularItemRef, tabularItem);
                }
            }
        }
    }

    private void setBridgeStreamOnDataItems(PlanningEnvironment environment, RQPQuery query) {
        for (IXQEQueryNode item : query.getProjectionList().getChildren()) {
            RQPDataItem dataItem = (RQPDataItem)item;
            IXQEQueryNode expression = dataItem.getExpression();
            if (expression.getType() != 801009) {
                throw new XQERuntimeException();
            }
            RQPDataItemRef dataItemRef = (RQPDataItemRef)expression;
            RQPDataItem referencedItem = dataItemRef.getNextReferencedItem();
            String streamName = referencedItem.getBridgeStream();
            if (streamName != null) {
                dataItem.setBridgeStream(streamName);
                continue;
            }
            dataItem.setBridgeStream(dataItemRef.getQueryName());
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        RQPQuery query = (RQPQuery)node;
        if (!query.isUsingBridge()) {
            this.traceNodeCondition(false, "This RQPQuery is not using a Bridge.", trace);
            return false;
        }
        if (query.isAutoSummaryFALSE()) {
            if (query.isFooterHeaderInProjectionList()) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_AutoGroupSumFalseWithBridgeQuery, query.getName());
            }
            this.traceNodeCondition(false, "Autosummarize is disabled.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This RQPQuery uses a bridge, need to wrap it as a RQPBridgeTabularQuery.", trace);
        return true;
    }
}

