/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.util.MDXOOMInfo;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.FFNode;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.FactFinder;
import com.cognos.xqe.util.Governors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class ComputeOOMforRelationalCrossTab
extends RQPTransformation {
    private static final String REL_XTAB_OOM_COMPUTED = "oomComputed";

    public ComputeOOMforRelationalCrossTab() {
        this.mName = "ComputeOOMforRelationalCrossTab";
        this.mPassNumbers = new int[]{34};
        this.mTypes = new int[]{801017};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.setPropertyValue(REL_XTAB_OOM_COMPUTED, Boolean.TRUE);
        CubeWrapper cube = this.getCubeWrapperForRelationalCrossTab(node);
        List<IDimension> dims = cube.getDimensions();
        for (IDimension d : dims) {
            String dimName;
            if (d.isMeasuresDimension() || (dimName = d.getName()).equals("dummy") || dimName.equals("secondDummy") || dimName.equals("tagDimension")) continue;
            List<IHierarchy> hiers = d.getHierarchies();
            for (IHierarchy h : hiers) {
                this.setOOMforLevelsInHierarchy(node, h);
            }
        }
    }

    protected void setOOMforLevelsInHierarchy(IXQEQueryNode node, IHierarchy hier) {
        Map<IMetadata, Double> involvedQS;
        List<ILevel> lvls = hier.getLevels();
        if ((lvls = lvls.subList(1, lvls.size())).size() < 1) {
            return;
        }
        ArrayList<Map<IMetadata, Double>> querySubjects = new ArrayList<Map<IMetadata, Double>>();
        RQPProjectionList mainProjectionList = ((RQPQuery)node).getProjectionList();
        for (ILevel l : lvls) {
            String column = (String)l.getProperty("expression");
            int colPos = Integer.parseInt(column);
            querySubjects.add(this.getQuerySubjects(mainProjectionList.getChild(colPos)));
        }
        RQPFactManager factManager = ((RQPQuery)node).getFactManager();
        FactFinder factFinder = factManager.getFactFinder();
        IXQEQueryNode summaryFilterList = node.getFirstChildByType(801023);
        IXQEQueryNode detailFilterList = node.getFirstChildByType(801011);
        if (summaryFilterList != null) {
            for (IXQEQueryNode sf : summaryFilterList.getChildren()) {
                involvedQS = this.getQuerySubjects(sf);
                if (involvedQS.isEmpty()) continue;
                for (IMetadata qs : involvedQS.keySet()) {
                    this.adjustOOMfactor(factFinder, querySubjects, qs);
                }
            }
        }
        if (detailFilterList != null) {
            for (IXQEQueryNode df : detailFilterList.getChildren()) {
                involvedQS = this.getQuerySubjects(df);
                if (involvedQS.isEmpty()) continue;
                for (IMetadata qs : involvedQS.keySet()) {
                    this.adjustOOMfactor(factFinder, querySubjects, qs);
                }
            }
        }
        this.setOOMonLevel(factFinder, lvls, querySubjects);
    }

    protected void setOOMonLevel(FactFinder factFinder, List<ILevel> lvls, ArrayList<Map<IMetadata, Double>> querySubjects) {
        for (int i = 0; i < lvls.size(); ++i) {
            V5DataItemToLevelWrapper level = (V5DataItemToLevelWrapper)lvls.get(i);
            Map<IMetadata, Double> mp = querySubjects.get(i);
            if (mp.isEmpty()) {
                if (i <= 0) continue;
                level.setOrderOfMagnitude(level.getPreviousLevel().getOrderOfMagnitude());
                continue;
            }
            double[] oom = new double[]{0.0};
            IMetadata biggestQS = this.getOOMfromBiggestQuerySubject(factFinder, querySubjects.get(i), oom);
            if (i > 0) {
                oom[0] = this.adjustOOMByRelationship(oom[0], factFinder, biggestQS, querySubjects, i);
                oom[0] = oom[0] + level.getPreviousLevel().getOrderOfMagnitude();
            }
            level.setOrderOfMagnitude(oom[0]);
            querySubjects.get(i).clear();
            querySubjects.get(i).put(biggestQS, oom[0]);
        }
    }

    protected double adjustOOMByRelationship(double oom, FactFinder factFinder, IMetadata qs, ArrayList<Map<IMetadata, Double>> pre, int currentPos) {
        Double relatedOOM = this.getHigherLevelOOMforManyToOneRelationship(factFinder, qs, pre, currentPos);
        if (relatedOOM != null) {
            if (Double.compare(oom -= relatedOOM.doubleValue(), 0.0) < 0) {
                oom = 0.0;
            }
            return oom;
        }
        if (this.isOneToOneOrOneToMany(factFinder, qs, pre, currentPos)) {
            return 0.0;
        }
        return oom;
    }

    protected Double getHigherLevelOOMforManyToOneRelationship(FactFinder factFinder, IMetadata qs, ArrayList<Map<IMetadata, Double>> pre, int currentPos) {
        FFNode thisNode = factFinder.getFFNodeByMetadata(qs);
        for (int i = currentPos - 1; i >= 0; --i) {
            IMetadata c;
            FFNode cNode;
            Map<IMetadata, Double> mp = pre.get(i);
            if (mp.isEmpty() || !this.isChild(cNode = factFinder.getFFNodeByMetadata(c = mp.keySet().iterator().next()), thisNode)) continue;
            return mp.values().iterator().next();
        }
        return null;
    }

    protected boolean isOneToOneOrOneToMany(FactFinder factFinder, IMetadata qs, ArrayList<Map<IMetadata, Double>> pre, int currentPos) {
        FFNode thisNode = factFinder.getFFNodeByMetadata(qs);
        for (int i = currentPos - 1; i >= 0; --i) {
            Map<IMetadata, Double> mp = pre.get(i);
            if (mp.isEmpty()) continue;
            IMetadata c = mp.keySet().iterator().next();
            FFNode cNode = factFinder.getFFNodeByMetadata(c);
            if (thisNode == cNode) {
                return true;
            }
            if (!this.isChild(thisNode, cNode)) continue;
            return true;
        }
        return false;
    }

    protected IMetadata getOOMfromBiggestQuerySubject(FactFinder factFinder, Map<IMetadata, Double> mp, double[] oom) {
        IQuerySubject rt = null;
        if (mp.size() == 1) {
            IQuerySubject qs = (IQuerySubject)mp.keySet().iterator().next();
            oom[0] = this.getOOM(qs, mp);
            return qs;
        }
        ArrayList<IMetadata> querySubjects = new ArrayList<IMetadata>(mp.keySet());
        for (int i = 0; i < querySubjects.size(); ++i) {
            IMetadata qs = querySubjects.get(i);
            if (qs == null || this.isBiggestQuerySubject(factFinder, qs, querySubjects, mp, i)) continue;
            querySubjects.set(i, null);
        }
        for (IMetadata aQS : querySubjects) {
            if (aQS == null) continue;
            IQuerySubject qs = (IQuerySubject)aQS;
            double o = this.getOOM(qs, mp);
            if (rt != null && Double.compare(oom[0], o) >= 0) continue;
            rt = qs;
            oom[0] = o;
        }
        return rt;
    }

    protected double getOOM(IMetadata aQS, Map<IMetadata, Double> mp) {
        IQuerySubject qs = (IQuerySubject)aQS;
        Double factor = mp.get(qs);
        double o = qs.getOrderOfMagnitude();
        if (Double.compare(factor, 1.0) > 0) {
            o = MDXOOMInfo.getNumberFromOOM(o);
            if (Double.compare(o /= factor.doubleValue(), 1.0) < 0) {
                o = 1.0;
            }
            o = MDXOOMInfo.getOOMFromNumber(o);
        }
        return o;
    }

    protected boolean isBiggestQuerySubject(FactFinder factFinder, IMetadata qs, ArrayList<IMetadata> querySubjects, Map<IMetadata, Double> mp, int currentPos) {
        for (int i = 0; i < querySubjects.size(); ++i) {
            double o2;
            double o1;
            FFNode otherNode;
            IMetadata qs1;
            if (i == currentPos || (qs1 = querySubjects.get(i)) == null) continue;
            FFNode thisNode = factFinder.getFFNodeByMetadata(qs);
            if (this.isChild(thisNode, otherNode = factFinder.getFFNodeByMetadata(qs1))) {
                return false;
            }
            if (thisNode != otherNode || Double.compare(o1 = this.getOOM(qs, mp), o2 = this.getOOM(qs1, mp)) > 0) continue;
            return false;
        }
        return true;
    }

    protected void adjustOOMfactor(FactFinder factFinder, ArrayList<Map<IMetadata, Double>> querySubjects, IMetadata qs) {
        FFNode thisNode = factFinder.getFFNodeByMetadata(qs);
        for (Map<IMetadata, Double> mp : querySubjects) {
            for (IMetadata qs1 : mp.keySet()) {
                FFNode otherNode = factFinder.getFFNodeByMetadata(qs1);
                if (thisNode != otherNode && !this.isChild(otherNode, thisNode) && !this.isChild(thisNode, otherNode)) continue;
                double adjustedFactor = mp.get(qs1) * 2.0;
                mp.put(qs1, adjustedFactor);
            }
        }
    }

    protected boolean isChild(FFNode nodeChild, FFNode nodeParent) {
        TreeSet<FFNode> parents = new TreeSet<FFNode>();
        nodeChild.getParents(parents);
        return parents.contains(nodeParent);
    }

    protected Map<IMetadata, Double> getQuerySubjects(IXQEQueryNode node) {
        IXQEQueryNode[] v5Identifiers;
        HashMap<IMetadata, Double> rt = new HashMap<IMetadata, Double>();
        for (IXQEQueryNode a : v5Identifiers = node.getDescendantsOfType(201116, true)) {
            V5BoundModelIdentifier v5Identifier = (V5BoundModelIdentifier)a;
            IQuerySubject qs = v5Identifier.getQuerySubject();
            if (qs == null || !(qs instanceof IQuerySubject)) continue;
            rt.put(qs, 1.0);
        }
        return rt;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        Object obj = node.getPropertyValue(REL_XTAB_OOM_COMPUTED);
        if (obj != null) {
            this.traceNodeCondition(false, "OOM is computed for temporary levels for relational crosstab.", trace);
            return false;
        }
        if (this.needComputeOOMforRelXtab(node)) {
            this.traceNodeCondition(true, "need to compute level OOM for relational crosstab.", trace);
            return true;
        }
        this.traceNodeCondition(false, "no need to compute level OOM for relational crosstab.", trace);
        return false;
    }

    protected boolean needComputeOOMforRelXtab(IXQEQueryNode node) {
        CubeWrapper cube = this.getCubeWrapperForRelationalCrossTab(node);
        if (cube == null) {
            return false;
        }
        Governors g = cube.getGovernors();
        if (g == null) {
            return false;
        }
        double oomRestriction = g.getMaxOrderOfMagnitudeMDXResult();
        if (Double.compare(oomRestriction, 0.0) <= 0) {
            return false;
        }
        List<IDimension> dims = cube.getDimensions();
        for (IDimension d : dims) {
            String dimName;
            if (d.isMeasuresDimension() || (dimName = d.getName()).equals("dummy") || dimName.equals("secondDummy") || dimName.equals("tagDimension")) continue;
            List<IHierarchy> hiers = d.getHierarchies();
            for (IHierarchy h : hiers) {
                List<ILevel> lvls = h.getLevels();
                for (int i = 1; i < lvls.size(); ++i) {
                    ILevel l = lvls.get(i);
                    if (!(l instanceof V5DataItemToLevelWrapper)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected CubeWrapper getCubeWrapperForRelationalCrossTab(IXQEQueryNode node) {
        IXQEQueryNode[] cubes;
        IXQEQueryNode parent = node.getParent();
        if (parent == null || parent.getType() != 801041 || !V5Query.RelationalSubquerySource.XTABREL.getName().equals(parent.getPropertyValue("relationalSubquerySource"))) {
            return null;
        }
        if ((parent = parent.getParent()) == null || parent.getType() != 401005) {
            return null;
        }
        if ((parent = parent.getParent()) == null || parent.getType() != 101006 || !V5Query.RelationalSubquerySource.XTABREL.getName().equals(parent.getPropertyValue("relationalSubquerySource"))) {
            return null;
        }
        String subqueryName = ((V5Query)parent).getV5QueryName();
        if (subqueryName == null || subqueryName.isEmpty()) {
            return null;
        }
        if ((parent = parent.getParent()) == null || parent.getType() != 101002) {
            return null;
        }
        for (IXQEQueryNode c : cubes = parent.getDescendantsOfType(1007, false)) {
            ICube cube = ((MDXFromCube)c).getCube();
            if (cube == null || !(cube instanceof CubeWrapper) || !subqueryName.equals(((CubeWrapper)cube).getTabularResultSetName())) continue;
            return (CubeWrapper)cube;
        }
        return null;
    }
}

