/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.AggregateExpressionBuilder;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.List;
import java.util.ListIterator;

public class ConvertFunctionAggregateToStandardAggregate
extends RQPTransformation {
    public static final int PROP_INT_DEFAULT_TO_DATATYPE = -1;
    public static final int PROP_INT_DEFAULT_TO_COUNTDISTINCT = -2;

    public ConvertFunctionAggregateToStandardAggregate(int[] passNumbers) {
        this.mName = "Convert Function Aggregate to Standard Aggregate";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{101015, 801008, 801033, 101011};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode dataItem = node;
        IXQEQueryNode dataItemAggr = null;
        if (node.getType() == 101015) {
            dataItem = RQPUtilities.getV5DataItem(node);
            dataItemAggr = ((V5DataItem)dataItem).getAggregateExpression(environment);
        } else if (node.getType() == 801008) {
            dataItemAggr = ((RQPDataItem)dataItem).getExpression();
        } else if (node.getType() == 801033) {
            dataItemAggr = (IXQEQueryNode)dataItem.getPropertyValue("expression");
        }
        List<IXQEQueryNode> summaryFunctions = null;
        summaryFunctions = dataItem.getDescendantsOfTypeOrdered(201031, false);
        if (node.getType() == 801008 && this.aggregateFunctionAppliedOnCalculatedItem(summaryFunctions)) {
            this.resolveAggregateFunctionForCalculatedExpression(environment, dataItem, (V5AggregateFunction)summaryFunctions.get(0));
            return;
        }
        this.replaceAggregateFunctionSubType(summaryFunctions);
        if (null != dataItemAggr) {
            summaryFunctions = dataItemAggr.getDescendantsOfTypeOrdered(201031, true);
            this.replaceAggregateFunctionSubType(summaryFunctions);
        }
    }

    private boolean aggregateFunctionAppliedOnCalculatedItem(List<IXQEQueryNode> summaryFunctions) {
        return summaryFunctions.size() == 1 && ((V5AggregateFunction)summaryFunctions.get(0)).getSubType() == 0 && summaryFunctions.get(0).getPropertyValue("calculated") != null;
    }

    private void resolveAggregateFunctionForCalculatedExpression(PlanningEnvironment environment, IXQEQueryNode dataItem, V5AggregateFunction aggregateFunction) {
        V5AggregateBreakClause forClause = aggregateFunction.getForClause();
        IXQEQueryNode savedForClause = null;
        IXQEQueryNode operand = aggregateFunction.getChild(0);
        if (forClause != null) {
            RQPQuery rqpQuery = RQPNode.getRQPQuery(aggregateFunction);
            List<RQPDataItem> groupingItems = rqpQuery.getProjectionsMarkedAsGroupingColumns();
            IXQEQueryNode[] forClauseItems = forClause.getChildren();
            int matchedItems = 0;
            IXQEQueryNode[] iXQEQueryNodeArray = forClauseItems;
            int n = iXQEQueryNodeArray.length;
            block0: for (int i = 0; i < n; ++i) {
                IXQEQueryNode forClauseItem = iXQEQueryNodeArray[i];
                for (IXQEQueryNode iXQEQueryNode : groupingItems) {
                    IXQEQueryNode rqpDiExpr = ((RQPDataItem)iXQEQueryNode).getExpression();
                    if (rqpDiExpr.getType() == 101003) {
                        rqpDiExpr = rqpDiExpr.getChild(0);
                    }
                    if (!forClauseItem.isSameExpression(rqpDiExpr, false)) continue;
                    ++matchedItems;
                    continue block0;
                }
            }
            if (matchedItems > 0 && matchedItems == forClauseItems.length && forClauseItems.length == groupingItems.size()) {
                forClause.detach();
            } else {
                savedForClause = forClause.detach();
            }
        }
        aggregateFunction.extract();
        AggregateExpressionBuilder builder = new AggregateExpressionBuilder(environment);
        IXQEQueryNode aggrExpr = builder.generateAggregateExpression("calculated", operand);
        operand.exchange(aggrExpr);
        if (savedForClause != null) {
            IXQEQueryNode[] standardAggs;
            for (IXQEQueryNode agg : standardAggs = ExpressionAnalyzer.getSummaryFunctions(aggrExpr)) {
                agg.addChild(environment.getNodeFactory().deepCopyNode(forClause));
            }
        }
    }

    private void replaceAggregateFunctionSubType(List<IXQEQueryNode> summaryFunctions) {
        ListIterator<IXQEQueryNode> it = summaryFunctions.listIterator();
        while (it.hasNext()) {
            V5ValueSummaryFunction summaryFunction = (V5ValueSummaryFunction)it.next();
            if (summaryFunction.getSubType() != 0) continue;
            int subType = this.determineAggregateSubType(summaryFunction);
            if (subType == -2) {
                subType = 2;
                summaryFunction.setDistinct(true);
            }
            summaryFunction.setSubType(subType);
        }
    }

    private int determineAggregateSubType(V5ValueSummaryFunction summaryFunction) {
        if (summaryFunction.getNumberChildren() == 0) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_MissingArgumentForAggFunc);
        }
        IXQEQueryNode childNode0 = summaryFunction.getChild(0);
        int subType = this.determineModelDrivenAggregateSubType(childNode0);
        if (subType == -1) {
            subType = this.determineDatatypeDrivenAggregateSubType(childNode0);
        }
        return subType;
    }

    private int determineModelDrivenAggregateSubType(IXQEQueryNode node) {
        V5BoundModelIdentifier id;
        int type = node.getType();
        if (type == 201031) {
            return this.determineModelDrivenAggregateSubType(node.getChild(0));
        }
        if (type == 201116 && (id = (V5BoundModelIdentifier)node).isFactQueryItemWithStandardRegularAggregate()) {
            String aggregateName = id.convertRegularAggregateSumToTotal();
            if (aggregateName.equals("countDistinct")) {
                return -2;
            }
            return RQPUtilities.convertAggregateNameToV5AggregateFunctionSubtype(aggregateName);
        }
        return -1;
    }

    private int determineDatatypeDrivenAggregateSubType(IXQEQueryNode node) {
        IDataType dataType = ((V5SimpleNode)node).getDataType();
        return RQPUtilities.getDefaultAggregateBasedOnDataType(dataType);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        RequestEnvironment requestEnvironment = (RequestEnvironment)environment.getRequestEnvironment();
        Parameters parameters = requestEnvironment.getRequestParameters();
        if (parameters.hasUnresolvedParameters()) {
            this.traceNodeCondition(false, "Need to resolve parameters", xqeTrace);
            return false;
        }
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        IXQEQueryNode dataItem = node;
        if (node.getType() == 101015) {
            dataItem = RQPUtilities.getV5DataItem(node);
        }
        List<IXQEQueryNode> summaryFunctions = dataItem.getDescendantsOfTypeOrdered(201031, false);
        for (IXQEQueryNode summaryFunction : summaryFunctions) {
            if (((V5ValueSummaryFunction)summaryFunction).getSubType() != 0) continue;
            return true;
        }
        this.traceNodeCondition(false, "There is no function Aggregate in data item or summary filter: " + node.getNodeTypeName(), xqeTrace);
        return false;
    }
}

