/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPBridgeQuery;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.V5AggregateEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.util.Governors;
import java.util.HashSet;
import java.util.List;

public class DetectAggregateThatCanNotBeAppliedInMultiFactQuery
extends RQPTransformation {
    public static final String AGGREGATE_CANNOT_BE_APPLIED = "AggregateCannotBeApplied";

    public DetectAggregateThatCanNotBeAppliedInMultiFactQuery() {
        this.mName = "DetectAggregateThatCanNotBeAppliedInMultiFactQuery.";
        this.mPassNumbers = new int[]{31};
        this.mTypes = new int[]{801017};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rqpQuery = (RQPQuery)node;
        RQPProjectionList projectionList = rqpQuery.getProjectionList();
        V5Selection v5Selection = rqpQuery.getRefV5Query().getV5Selection();
        for (IXQEQueryNode proj : projectionList.getChildren()) {
            RQPDataItem projection = (RQPDataItem)proj;
            if (projection.getBooleanPropertyValue(AGGREGATE_CANNOT_BE_APPLIED) == null) continue;
            String itemName = projection.getName();
            V5DataItem v5DataItem = v5Selection.getDataItemByRefName(itemName);
            if (null == v5DataItem.getPropertyValue("originalAggregate")) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_AggregateCannotBeApplied, v5DataItem.getAggregateProperty(), itemName);
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_AggregateCannotBeApplied2, v5DataItem.getPropertyValue("originalAggregate"), (Object)itemName, (Object)v5DataItem.getAggregateProperty());
        }
    }

    private boolean projectionExprFromMoreThanOneFactStream(RQPQuery rqpQuery, RQPDataItem projection, RQPFactManager factManager) {
        IXQEQueryNode[] v5Identifiers = projection.getDescendantsOfType(201116, false);
        HashSet<String> factStreamNames = new HashSet<String>();
        for (IXQEQueryNode node : v5Identifiers) {
            RQPQuery subQuery;
            List<String> supportingFactStreams = factManager.getSupportingStreams(node, null);
            if (supportingFactStreams.size() > 1 || supportingFactStreams.size() == 0 || (subQuery = rqpQuery.getSubquery(supportingFactStreams.get(0))).isBridgeQuery() || subQuery instanceof RQPBridgeQuery) continue;
            factStreamNames.add(supportingFactStreams.get(0));
        }
        return factStreamNames.size() > 1;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        Governors governors = node.getGovernors();
        if (governors.getNestedAggregateHandling().equals((Object)Governors.NestedAggregateHandling.REMOVE)) {
            return false;
        }
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        if (node.getAncestorOfType(101072) != null) {
            this.traceNodeCondition(false, "The transformation is not applicable for a DMR prePlan query.", trace);
            return false;
        }
        RQPQuery rqpQuery = (RQPQuery)node;
        RQPQuery rootQuery = rqpQuery.getRootRQPQuery();
        if (!rootQuery.isMultiFactQuery()) {
            this.traceNodeCondition(false, "The query is not a multi-fact query", trace);
            return false;
        }
        if (!rootQuery.isAutoSummaryTRUE()) {
            this.traceNodeCondition(false, "The request has autoSummary set to false", trace);
            return false;
        }
        RQPProjectionList projectionList = rqpQuery.getProjectionList();
        V5Selection v5Selection = rootQuery.getRefV5Query().getV5Selection();
        RQPFactManager factManager = rootQuery.getFactManager();
        for (IXQEQueryNode proj : projectionList.getChildren()) {
            String itemName;
            V5DataItem v5DataItem;
            RQPDataItem projection = (RQPDataItem)proj;
            if (projection.isGroupingItem() && !ExpressionAnalyzer.exprOrRefExprHasAggregate(projection.getExpression()) || (v5DataItem = v5Selection.getDataItemByRefName(itemName = projection.getName())) == null || !V5AggregateEnum.isDefinedAggregateFunction(v5DataItem.getAggregateProperty()) || v5DataItem.getAggregateProperty().equals("none") || !this.projectionExprFromMoreThanOneFactStream(rqpQuery, projection, factManager)) continue;
            projection.setPropertyValue(AGGREGATE_CANNOT_BE_APPLIED, true);
            this.traceNodeCondition(true, "The request has aggregate that can not be applied in the multifact query", trace);
            return true;
        }
        this.traceNodeCondition(false, "There is no aggregates that can not be applied in the multifact query ", trace);
        return false;
    }
}

