/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPFactQuery;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSortItem;
import com.cognos.xqe.ast.rqp.RQPSortList;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DistributeFiltersInFactQueries;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.MoveGroupingItemsToSubQuery;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ProcessDataItemRefInValueSet;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.SummaryFilters.CreateRQPSubqueryForSummaryFilters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class DistributeProjectionsInFactQueries
extends RQPTransformation {
    public DistributeProjectionsInFactQueries() {
        this.mName = "DistributeProjectionsInFactQueries";
        this.mPassNumbers = new int[]{35};
        this.mTypes = new int[]{801044};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rootQuery = ((RQPNode)node).getParentRQPQuery();
        RQPFactManager factManager = rootQuery.getFactManager();
        factManager.initializeFactQueries(environment);
        factManager.initializeBridgeQueries(environment);
        RQPProjectionList mainProjectionList = rootQuery.getProjectionList();
        for (IXQEQueryNode projection : mainProjectionList.getChildren()) {
            this.addProjectionInSupportingFactQueries(environment, factManager, (RQPDataItem)projection);
        }
        this.generateOlapAggregateFormForFooterExpr(environment, factManager, rootQuery);
    }

    protected void addProjectionInSupportingFactQueries(PlanningEnvironment environment, RQPFactManager factManager, RQPDataItem mainProjectionItem) {
        IXQEQueryNode projectionExpression = mainProjectionItem.getExpression();
        boolean expressionAggregatesItemFromSharedDimension = factManager.exprContainsAggrOnSharedDimItemToBeAppliedAfterStitch(projectionExpression);
        String projectionName = mainProjectionItem.getName();
        if (factManager.needToStayInOuterQuery(projectionExpression, RQPFactManager.Context.PROJECTION)) {
            this.splitProjectionExpression(environment, factManager, projectionExpression, projectionName);
            DistributeProjectionsInFactQueries.throwErrorIfCanNotSplitExpression(mainProjectionItem, false);
            if (expressionAggregatesItemFromSharedDimension) {
                this.adjustScopeAggregateOnSharedDimension(environment, factManager, mainProjectionItem, projectionExpression);
            }
            return;
        }
        if (!projectionExpression.hasDescendantOfType(201116, true)) {
            if (ExpressionAnalyzer.containsNonSQL99Function(projectionExpression)) {
                List<RQPQuery> supportingFactQueries = factManager.getFactQueries();
                factManager.pushExpressionInQueriesAndCreateRefInOuterQuery(environment, supportingFactQueries, projectionExpression, projectionName, false);
            } else {
                mainProjectionItem.setPropertyValue("stayInOuterQuery", true);
            }
            return;
        }
        List<String> supportingStreams = factManager.getSupportingStreams(mainProjectionItem, null);
        if (supportingStreams.size() == 0) {
            DistributeFiltersInFactQueries.checkForAnyForAllClause(factManager, mainProjectionItem, true);
            this.splitProjectionExpression(environment, factManager, mainProjectionItem.getExpression(), projectionName);
            DistributeProjectionsInFactQueries.throwErrorIfCanNotSplitExpression(mainProjectionItem, false);
        } else {
            List<RQPQuery> rqpQueries = factManager.getRQPQueries(supportingStreams);
            factManager.pushExpressionInQueriesAndCreateRefInOuterQuery(environment, rqpQueries, projectionExpression, projectionName, false);
        }
    }

    private void adjustScopeAggregateOnSharedDimension(PlanningEnvironment environment, RQPFactManager factManager, RQPDataItem mainProjectionItem, IXQEQueryNode projectionExpression) {
        V5ValueSet v5ValueSet = mainProjectionItem.getRollupScope();
        mainProjectionItem.setPropertyValue("aggrOnSharedDim", true);
        IXQEQueryNode[] aggregateNodes = ExpressionAnalyzer.getAggregateNodes(projectionExpression);
        RQPQuery rootQuery = mainProjectionItem.getRootRQPQuery();
        List<RQPDataItem> groupingItemsOfDefaultSummaryQuery = rootQuery.getProjectionsMarkedAsGroupingColumns();
        ArrayList<V5DataItem> groupingItemsOfFooter = new ArrayList();
        if (v5ValueSet != null) {
            groupingItemsOfFooter = ProcessDataItemRefInValueSet.getGroupingItems(v5ValueSet, rootQuery, true);
        }
        for (IXQEQueryNode aggregate : aggregateNodes) {
            V5AggregateFunction aggFunc = (V5AggregateFunction)aggregate;
            if (v5ValueSet == null) {
                DistributeProjectionsInFactQueries.addForClauseSelfRef(environment, aggFunc, groupingItemsOfDefaultSummaryQuery);
                continue;
            }
            if (aggFunc.getRollupAggregateNode()) {
                DistributeProjectionsInFactQueries.addForClause(environment, rootQuery, aggFunc, groupingItemsOfFooter);
                continue;
            }
            DistributeProjectionsInFactQueries.addForClauseSelfRef(environment, aggFunc, groupingItemsOfDefaultSummaryQuery);
            RQPDataItem rqpDataItem = (RQPDataItem)aggregate.getAncestorOfType(801008);
            if (rqpDataItem.getBooleanPropertyValue("aggregateOnlyOnFirstRow") == null) continue;
            this.replaceAggOnSharedDimensionWithCaseStmtOnRowID(environment.getNodeFactory(), aggFunc.getParent(), aggFunc);
        }
    }

    private void replaceAggOnSharedDimensionWithCaseStmtOnRowID(IXQENodeFactory nodeFactory, IXQEQueryNode parentNode, V5AggregateFunction aggregate) {
        ArrayList<IXQEQueryNode> partitionByClause = new ArrayList<IXQEQueryNode>();
        V5AggregateBreakClause forClause = aggregate.getForClause();
        if (forClause != null) {
            for (int i = 0; i < forClause.getNumberChildren(); ++i) {
                partitionByClause.add(forClause.getChild(i));
            }
        }
        ArrayList<IXQEQueryNode> sortItems = new ArrayList<IXQEQueryNode>();
        sortItems.add(aggregate);
        IXQEQueryNode rowNumberExpr = ExpressionAnalyzer.createRowNumberExpr(nodeFactory, partitionByClause, sortItems);
        IXQEQueryNode caseExpr = ExpressionAnalyzer.createCaseExpression(nodeFactory, rowNumberExpr, aggregate);
        parentNode.addChild(caseExpr, 0);
    }

    public static void throwErrorIfCanNotSplitExpression(RQPDataItem mainProjectionItem, boolean forAll) {
        if (forAll || mainProjectionItem.getDescendantsOfType(201116, false).length > 0) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_CanNotPushProjectionExpressionToMultiFactQuery, mainProjectionItem.getName());
        }
    }

    public static void addForClauseSelfRef(PlanningEnvironment environment, V5AggregateFunction aggregate, List<RQPDataItem> groupingItems) {
        V5AggregateBreakClause forClause = aggregate.getForClause();
        if (forClause == null) {
            forClause = (V5AggregateBreakClause)environment.getNodeFactory().createNode(201037);
            aggregate.addChild(forClause);
            for (RQPDataItem groupingItem : groupingItems) {
                forClause.addChild(RQPDataItemSelfRef.create(environment, groupingItem.getName()));
            }
        } else {
            int aggSubType = aggregate.getSubType();
            List<IXQEQueryNode> forClauseChildren = Arrays.asList(forClause.getChildren());
            if (aggSubType != 6 && aggSubType != 4 && ExpressionAnalyzer.isHigherScope(forClauseChildren, groupingItems)) {
                RQPDataItem rqpDataItem = (RQPDataItem)aggregate.getAncestorOfType(801008);
                rqpDataItem.setPropertyValue("aggregateOnlyOnFirstRow", true);
            }
        }
    }

    protected void splitProjectionExpression(PlanningEnvironment environment, RQPFactManager factManager, IXQEQueryNode node, String preferredName) {
        List<String> supportingStreams;
        List<RQPQuery> supportingQueries;
        boolean pushedDownToFactStream = false;
        if (DistributeProjectionsInFactQueries.canPushDownToFactQuery(node, factManager, false) && (supportingQueries = factManager.getRQPQueries(supportingStreams = factManager.getSupportingStreams(node, null))).size() > 0) {
            factManager.pushExpressionInQueriesAndCreateRefInOuterQuery(environment, supportingQueries, node, preferredName, false);
            pushedDownToFactStream = true;
        }
        if (!pushedDownToFactStream) {
            for (IXQEQueryNode child : node.getChildren()) {
                this.splitProjectionExpression(environment, factManager, child, preferredName);
            }
        }
    }

    public static boolean canPushDownToFactQuery(IXQEQueryNode node, RQPFactManager factManager, boolean contextFilter) {
        if (((V5SimpleNode)node).getDataType() instanceof BooleanType) {
            return false;
        }
        int nodeType = node.getType();
        if (nodeType == 201019 || nodeType == 201037 || nodeType == 201036 || nodeType == 201035) {
            return false;
        }
        if (factManager.exprContainsAggrOnSharedDimItemToBeAppliedAfterStitch(node)) {
            return false;
        }
        return !contextFilter || !factManager.containsFactNullCheck(node);
    }

    protected void generateOlapAggregateFormForFooterExpr(PlanningEnvironment environment, RQPFactManager factManager, RQPQuery rqpQuery) {
        List<RQPDataItem> footerItems = this.getFooterItems(rqpQuery);
        for (RQPDataItem footerItem : footerItems) {
            if (ExpressionAnalyzer.isAggregateFunction(footerItem.getExpression())) {
                this.convertStandardAggToOlapAgg(environment, factManager, rqpQuery, footerItem, footerItem.getExpression());
                continue;
            }
            if (!factManager.hasGroupingItemsInFactQueries()) continue;
            this.generateOlapMinAroundFooterExpr(environment, rqpQuery, footerItem);
        }
    }

    private void convertStandardAggToOlapAgg(PlanningEnvironment environment, RQPFactManager factManager, RQPQuery rqpQuery, RQPDataItem footerItem, IXQEQueryNode outermostAggregate) {
        if (outermostAggregate.getType() == 201033 || outermostAggregate.getType() == 201035) {
            if (outermostAggregate.getType() == 201033 && ((V5AggregateFunction)outermostAggregate).getSubType() == 14 && this.comeFromFooterInvolvingMultiFact(outermostAggregate, rqpQuery)) {
                ((V5AggregateFunction)outermostAggregate).setDistinct(true);
            }
            return;
        }
        V5ValueSet v5ValueSet = footerItem.getRollupScope();
        if (v5ValueSet != null) {
            List<V5DataItem> groupingItems = ProcessDataItemRefInValueSet.getGroupingItems(v5ValueSet, rqpQuery, true);
            DistributeProjectionsInFactQueries.addForClause(environment, rqpQuery, (V5AggregateFunction)outermostAggregate, groupingItems);
            return;
        }
        if (!footerItem.getPropIsRollupExpression()) {
            return;
        }
        List<IXQEQueryNode> explicitForClauses = footerItem.getDescendantsOfTypeOrdered(201037, false);
        if (explicitForClauses.size() > 1) {
            throw new XQERuntimeException();
        }
        V5AggregateBreakClause forClause = (V5AggregateBreakClause)explicitForClauses.get(0);
        for (IXQEQueryNode groupingItem : forClause.getChildren()) {
            List<String> supportingStreams = factManager.getSupportingStreams(groupingItem, null);
            List<RQPQuery> rqpQueries = factManager.getRQPQueries(supportingStreams);
            if (rqpQueries.size() != 1) continue;
            MoveGroupingItemsToSubQuery.createRQPDataItemInSubQueryAndRefInParentQuery(environment, rqpQueries.get(0), groupingItem, "c", true);
        }
    }

    private boolean comeFromFooterInvolvingMultiFact(IXQEQueryNode aggregate, RQPQuery rqpQuery) {
        IXQEQueryNode proj = aggregate.getAncestorOfType(801008);
        if (proj == null) {
            return false;
        }
        RQPDataItem footerProj = (RQPDataItem)proj;
        if (!footerProj.isFooterHeaderItem()) {
            return false;
        }
        return CreateRQPSubqueryForSummaryFilters.exprInvolvesMultiFacts(aggregate.getChild(0));
    }

    private void generateOlapMinAroundFooterExpr(PlanningEnvironment environment, RQPQuery rqpQuery, RQPDataItem footerItem) {
        IXQEQueryNode[] refs;
        V5ValueSummaryFunction minFunc = (V5ValueSummaryFunction)environment.getNodeFactory().createNode(201031);
        minFunc.setSubType(6);
        List<V5DataItem> groupingItems = (List<V5DataItem>)footerItem.getPropertyValue("rollupGroupingItems");
        if (groupingItems == null) {
            V5ValueSet v5ValueSet = footerItem.getRollupScope();
            groupingItems = ProcessDataItemRefInValueSet.getGroupingItems(v5ValueSet, rqpQuery, true);
        }
        if ((refs = footerItem.getDescendantsOfType(801009, false)) != null && refs.length > 0) {
            for (IXQEQueryNode ref : refs) {
                if (ExpressionAnalyzer.hasAggregateAncestor(ref)) continue;
                ref.insertParent(environment.getNodeFactory().deepCopyNode(minFunc));
                List<RQPDataItem> rqpGroupingItems = DistributeProjectionsInFactQueries.addForClause(environment, rqpQuery, (V5AggregateFunction)ref.getParent(), groupingItems);
                this.addGroupingItemsInOverallSort(environment, rqpQuery, rqpGroupingItems);
            }
        }
    }

    public static List<RQPDataItem> addForClause(PlanningEnvironment environment, RQPQuery rqpQuery, V5AggregateFunction aggregate, List<V5DataItem> groupingItems) {
        List<RQPDataItem> rqpGroupingItems = DistributeProjectionsInFactQueries.convertListV5DataItemToListRQPDataItem(rqpQuery, groupingItems);
        DistributeProjectionsInFactQueries.addForClause(environment, aggregate, rqpGroupingItems);
        return rqpGroupingItems;
    }

    public static List<RQPDataItem> convertListV5DataItemToListRQPDataItem(RQPQuery rqpQuery, List<V5DataItem> groupingItems) {
        ArrayList<RQPDataItem> rqpGroupingItems = new ArrayList<RQPDataItem>();
        Iterator<V5DataItem> iterator = groupingItems.iterator();
        while (iterator.hasNext()) {
            V5DataItem groupingItem;
            V5DataItem v5DataItem = groupingItem = iterator.next();
            rqpGroupingItems.add(rqpQuery.getRQPDataItemByName(v5DataItem.getNameProperty()));
        }
        return rqpGroupingItems;
    }

    public static void addForClause(PlanningEnvironment environment, V5AggregateFunction aggregate, List<RQPDataItem> groupingItems) {
        V5AggregateBreakClause forClause = aggregate.getForClause();
        if (forClause == null) {
            forClause = (V5AggregateBreakClause)environment.getNodeFactory().createNode(201037);
            aggregate.addChild(forClause);
        } else {
            RQPDataItem rqpItem = (RQPDataItem)forClause.getAncestorOfType(801008);
            if (rqpItem != null && rqpItem.getPropertyValue("aggrOnSharedDim") != null) {
                return;
            }
        }
        Iterator<RQPDataItem> iterator = groupingItems.iterator();
        while (iterator.hasNext()) {
            RQPDataItem groupingItem;
            RQPDataItem forClauseItem = groupingItem = iterator.next();
            IXQEQueryNode groupingItemExpr = environment.getNodeFactory().deepCopyNode(forClauseItem.getExpression());
            forClause.addChild(groupingItemExpr);
        }
    }

    private void addGroupingItemsInOverallSort(PlanningEnvironment environment, RQPQuery rootQuery, List<RQPDataItem> groupingItems) {
        for (RQPDataItem item : groupingItems) {
            String itemName = item.getName();
            if (this.existInSortList(rootQuery, itemName)) continue;
            RQPSortItem sortItem = RQPSortItem.create(environment, itemName, "ascending");
            rootQuery.addToSortList(environment, sortItem);
        }
    }

    private boolean existInSortList(RQPQuery rootQuery, String itemName) {
        RQPSortList sortList = (RQPSortList)rootQuery.getFirstChildByType(801020);
        if (sortList != null && sortList.getNumberChildren() > 0) {
            for (IXQEQueryNode child : sortList.getChildren()) {
                RQPSortItem sortItem = (RQPSortItem)child;
                RQPDataItemSelfRef diRef = (RQPDataItemSelfRef)sortItem.getChild(0);
                if (!diRef.getName().equals(itemName)) continue;
                return true;
            }
        }
        return false;
    }

    private List<RQPDataItem> getFooterItems(RQPQuery rqpQuery) {
        ArrayList<RQPDataItem> footerItems = new ArrayList<RQPDataItem>();
        RQPProjectionList projectionList = rqpQuery.getProjectionList();
        for (IXQEQueryNode projection : projectionList.getChildren()) {
            RQPDataItem rqpDataItem = (RQPDataItem)projection;
            if (!rqpDataItem.isFooterHeaderItem() && !rqpDataItem.getPropIsRollupExpression() && rqpDataItem.getPropertyValue("rollupGroupingItems") == null) continue;
            footerItems.add(rqpDataItem);
        }
        return footerItems;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        RQPFactQuery factQuery = (RQPFactQuery)node;
        RQPProjectionList projectionList = factQuery.getProjectionList();
        if (projectionList != null) {
            this.traceNodeCondition(false, "The projection list of this fact query needs to be populated", trace);
            return false;
        }
        if (!this.passesBridgeCondition(factQuery.getParentRQPQuery())) {
            this.traceNodeCondition(false, "Failed to pass the bridge condition", trace);
            return false;
        }
        this.traceNodeCondition(true, "The projection list of this fact query is not populated", trace);
        return true;
    }

    protected boolean passesBridgeCondition(RQPQuery rootQuery) {
        return !rootQuery.isUsingBridge();
    }
}

