/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DynamicSQS;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5JoinOperand;
import com.cognos.xqe.ast.v5.query.V5JoinOperation;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5CoalesceFunction;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DynamicSQS.CreateV5QueryForDynamicSQS;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.InitializeFactManager;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.SummaryQuerySubjectUtilities;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class DistributeDynamicGroupingColumnAndFilterInDSQS
extends Transformation {
    private static final String PROP_USED_QS = "usedQuerySubjects";
    private static final String PROP_APPLICABLE_DYNAMIC_QS = "applicableDynamicQS";
    public static final String PROP_STR_HIGHER_SCOPE_QUERY_NAME = "higherScopeQueryName";
    public static final String PROP_GROUPING_COLUMNS_IN_HIGHER_SCOPE_QUERY = "gcInHigherScopeQuery";
    public static final String PROP_LOWEST_GROUPING_LEVEL_COLUMNS = "lowestGroupingLevelColumns";
    public static final String PROP_BOOL_STATIC_COLUMN_PROJECTED = "staticColumnProjectedInReport";
    public static final String PROP_BOOL_POTENTIAL_DUPLICATE_COLUMN = "potentialDuplicateColumn";
    public static final String PROP_BOOL_STATIC_COLUMN_SAME_EXPR_AS_DYNAMIC = "staticColumnSameExprAsDynamic";
    private static final String STR_COMMA = ",";
    private static final String PROP_LEAF_DSQS_QUERIES = "leafDSQSQueries";
    private static final String PROP_ALL_SUB_QUERIES = "allSubQueries";

    public DistributeDynamicGroupingColumnAndFilterInDSQS() {
        this.mName = "DistributeDynamicGroupingColumnAndFilterInDSQS";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{101006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query rootQuery = (V5Query)node;
        Set<V5Query> leafSQSQueries = this.getLeafSQSQueries(environment, rootQuery);
        List<V5Query> allSubQueries = this.getAllSubQueries(environment, rootQuery);
        rootQuery.setPropertyValue(PROP_LEAF_DSQS_QUERIES, leafSQSQueries);
        rootQuery.setPropertyValue(PROP_ALL_SUB_QUERIES, allSubQueries);
        this.computeFactStreams(environment, rootQuery);
        this.computeApplicableQuerySubjectsForDSQS(environment, rootQuery);
        this.distributeDynamicFiltersToLeafDSQS(environment, rootQuery);
        V5QuerySet querySet = (V5QuerySet)environment.getRoot();
        this.distributeDynamicGroupingColumnsInDSQS(environment, querySet, rootQuery);
        RQPQuery tempRQPQuery = (RQPQuery)rootQuery.getFirstChildByType(801017);
        tempRQPQuery.detach();
        tempRQPQuery.removeFromIndex();
        this.detectDoubleCountingInJoinQueries(environment, rootQuery);
    }

    private void detectDoubleCountingInJoinQueries(PlanningEnvironment environment, V5Query rootQuery) {
        List subQueries = (List)rootQuery.getPropertyValue(PROP_ALL_SUB_QUERIES);
        subQueries.add(rootQuery);
        for (V5Query query : subQueries) {
            IXQEQueryNode joinOperation;
            List<V5Query> operandQueries;
            if (CreateV5QueryForDynamicSQS.isStitchQuery(query) || (operandQueries = DistributeDynamicGroupingColumnAndFilterInDSQS.getSubQueries(environment, query)).size() != 2 || query.getV5Source().getNumberChildren() != 1 || (joinOperation = query.getV5Source().getChild(0)).getType() != 101019) continue;
            String leftQueryName = ((V5JoinOperand)joinOperation.getChild(0)).getQueryRef();
            if (operandQueries.get(0).getV5QueryName().equals(leftQueryName)) {
                this.detectDoubleCountingInJoinQuery(environment, query, operandQueries.get(0), operandQueries.get(1));
                continue;
            }
            this.detectDoubleCountingInJoinQuery(environment, query, operandQueries.get(1), operandQueries.get(0));
        }
    }

    private void distributeDynamicGroupingColumnsInDSQS(PlanningEnvironment environment, V5QuerySet querySet, V5Query currentQuery) {
        List<V5Query> subQueries = DistributeDynamicGroupingColumnAndFilterInDSQS.getSubQueries(environment, currentQuery);
        if (subQueries.size() == 0) {
            return;
        }
        if (subQueries.size() == 1) {
            this.pushReportProjectionsInSQS(environment, currentQuery, subQueries.get(0));
        } else {
            this.distributeProjectionsInJoinOperandQueries(environment, currentQuery, this.getLeftQuery(currentQuery, querySet), this.getRightQuery(currentQuery, querySet));
        }
        for (V5Query subQuery : subQueries) {
            this.distributeDynamicGroupingColumnsInDSQS(environment, querySet, subQuery);
        }
    }

    private void distributeDynamicFiltersToLeafDSQS(PlanningEnvironment environment, V5Query rootQuery) {
        Set leafSQSQueries = (Set)rootQuery.getPropertyValue(PROP_LEAF_DSQS_QUERIES);
        XQENodeFactory factory = environment.getNodeFactory();
        List<IXQEQueryNode> filters = rootQuery.getDescendantsOfTypeOrdered(101008, false);
        block0: for (IXQEQueryNode filter : filters) {
            if (((V5DetailFilter)filter).getPostAutoAggregation()) continue;
            this.validateApplyToInformation(environment, rootQuery, filter);
            this.expandDataItemReferences(environment.getNodeFactory(), filter, rootQuery.getV5Selection());
            Set<String> qsInFilter = this.collectQuerySubjects(filter);
            IXQEQueryNode[] boundIds = filter.getDescendantsOfType(201116, false);
            HashSet<IQuerySubject> referencedQs = new HashSet<IQuerySubject>();
            for (IXQEQueryNode id : boundIds) {
                IQuerySubject qs = ((V5BoundModelIdentifier)id).getQuerySubject();
                if (qs == null || !SummaryQuerySubjectUtilities.isDynamicSQS(qs)) continue;
                referencedQs.add(qs);
            }
            if (referencedQs.size() == 1) {
                List subQueries = (List)rootQuery.getPropertyValue(PROP_ALL_SUB_QUERIES);
                String qsname = ((IQuerySubject)referencedQs.iterator().next()).getID();
                for (V5Query subQ : subQueries) {
                    IQuerySubject subQueryDSQS = subQ.getDynamicSQS();
                    if (subQueryDSQS == null || !subQueryDSQS.getID().equals(qsname)) continue;
                    SummaryQuerySubjectUtilities.unwindSelfReferencesInExpr(filter, subQueryDSQS, subQ.getV5Selection(), factory);
                    subQ.addChild(filter.detach());
                    continue block0;
                }
                continue;
            }
            if (referencedQs.size() > 1) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_ExpressionCanNotSplitAcrossDSQS, ((V5DetailFilter)filter).getOriginalExpression());
            }
            for (V5Query query : leafSQSQueries) {
                if (!this.isApplicableToDSQS(environment, query, filter, qsInFilter)) continue;
                IXQEQueryNode clonedFilter = factory.deepCopyNode(filter);
                query.addChild(clonedFilter);
                SummaryQuerySubjectUtilities.unwindSelfReferencesInExpr(clonedFilter, query.getDynamicSQS(), query.getV5Selection(), factory);
            }
            filter.detach();
        }
    }

    private void computeApplicableQuerySubjectsForDSQS(PlanningEnvironment environment, V5Query rootQuery) {
        RQPQuery tempRQPQuery = (RQPQuery)rootQuery.getFirstChildByType(801017);
        RQPFactManager rqpFactManager = tempRQPQuery.getFactManager();
        TreeMap<String, TreeSet<String>> factStreamToQS = rqpFactManager.getFactStreamToQS();
        Set leafSQSQueries = (Set)rootQuery.getPropertyValue(PROP_LEAF_DSQS_QUERIES);
        for (V5Query query : leafSQSQueries) {
            Set qsInQuery = (Set)query.getPropertyValue(PROP_USED_QS);
            for (Map.Entry<String, TreeSet<String>> stream : factStreamToQS.entrySet()) {
                TreeSet<String> qsInFactStream = stream.getValue();
                HashSet<String> intersection = new HashSet<String>(qsInFactStream);
                intersection.retainAll(qsInQuery);
                if (intersection.size() != qsInQuery.size()) continue;
                query.setPropertyValue(PROP_APPLICABLE_DYNAMIC_QS, qsInFactStream);
                break;
            }
            if (query.getPropertyValue(PROP_APPLICABLE_DYNAMIC_QS) != null) continue;
            TreeSet<String> qsNames = new TreeSet<String>();
            qsNames.addAll(qsInQuery);
            this.handleCrossJoin(environment, rootQuery, qsNames);
            query.setPropertyValue(PROP_APPLICABLE_DYNAMIC_QS, qsNames);
        }
        List queries = (List)rootQuery.getPropertyValue(PROP_ALL_SUB_QUERIES);
        for (V5Query subQuery : queries) {
            if (subQuery.getPropertyValue(PROP_APPLICABLE_DYNAMIC_QS) != null) continue;
            Set<V5Query> subLeafQueries = this.getLeafSQSQueries(environment, subQuery);
            HashSet myApplicableQs = new HashSet();
            for (V5Query subQ : subLeafQueries) {
                TreeSet applicableQS = (TreeSet)subQ.getPropertyValue(PROP_APPLICABLE_DYNAMIC_QS);
                myApplicableQs.addAll(applicableQS);
            }
            subQuery.setPropertyValue(PROP_APPLICABLE_DYNAMIC_QS, myApplicableQs);
        }
    }

    private void handleCrossJoin(PlanningEnvironment environment, V5Query rootQuery, TreeSet<String> qsNames) {
        V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(rootQuery);
        if (rootQuerySet.getPropertyValue(V5Query.QueryHint.CROSS_PRODUCT_ALLOWED.getPropertyName()) == Governors.GovernorPermission.ALLOW) {
            return;
        }
        Governors governors = rootQuery.getGovernors();
        if (governors == null || governors.getCrossProdAllowed() == Governors.GovernorPermission.DENY) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_CrossJoinsNotPermitted, RQPUtilities.getNameListFromSetOfString(qsNames));
        }
        if (governors.getCrossProdAllowed() == Governors.GovernorPermission.WARN) {
            ExecutionEnvironment ee = (ExecutionEnvironment)environment.getExecutionEnvironment();
            String nagMsg = XQEMessages.getMessage(XQEMessageKeys.PLN_CrossJoinsDetected, XQEMessages.getCurrProductLocale());
            ee.addNag(nagMsg);
        }
    }

    private void computeFactStreams(PlanningEnvironment environment, V5Query rootQuery) {
        XQENodeFactory factory = environment.getNodeFactory();
        RQPQuery tempRQPQuery = (RQPQuery)factory.createNode(801017);
        RQPFactManager rqpFactManager = (RQPFactManager)factory.createNode(801042);
        rqpFactManager.create(environment);
        tempRQPQuery.addChild(rqpFactManager);
        rootQuery.addChild(tempRQPQuery);
        HashMap<Integer, IXQEQueryNode> detailFiltersToBeAnalyzed = new HashMap<Integer, IXQEQueryNode>();
        HashMap<Integer, Set<Integer>> inputNodeToDetailFilters = new HashMap<Integer, Set<Integer>>();
        HashMap<String, IMetadata> idToJoin = null;
        InitializeFactManager transformationIFM = new InitializeFactManager();
        this.populateInputNode(rqpFactManager, rootQuery, environment);
        Set leafSQSQueries = (Set)rootQuery.getPropertyValue(PROP_LEAF_DSQS_QUERIES);
        for (V5Query query : leafSQSQueries) {
            this.populateInputNode(rqpFactManager, query, environment);
        }
        List<IMetadata> qsSetToJoin = transformationIFM.collectQuerySubjects(rqpFactManager, false);
        if (qsSetToJoin.size() <= 1) {
            TreeMap map = new TreeMap();
            TreeSet<String> qsSet = new TreeSet<String>();
            IQuerySubject qs = (IQuerySubject)qsSetToJoin.get(0);
            qsSet.add(qs.getID());
            map.put("FS1", qsSet);
            rqpFactManager.setPropertyValue("FactStreamsToQSNames", map);
            return;
        }
        boolean rowStitch = false;
        if (!transformationIFM.createFactFinder(rqpFactManager, environment, null, idToJoin, qsSetToJoin, rowStitch, null)) {
            return;
        }
        boolean qualifyStreamName = false;
        transformationIFM.computeStreams(rqpFactManager, qualifyStreamName, rootQuery.getV5QueryName(), environment);
        transformationIFM.computeInput(rqpFactManager, environment, true);
        transformationIFM.removeFactStreamsNotAccessedFromInput(rqpFactManager);
        transformationIFM.removeFactStreamGeneratedForFilter(rqpFactManager, detailFiltersToBeAnalyzed, inputNodeToDetailFilters);
        rqpFactManager.computeFinalFactStreamToQS();
    }

    public void populateInputNode(RQPFactManager factManager, V5Query query, PlanningEnvironment environment) {
        List<IXQEQueryNode> v5Identifiers = query.getDescendantsOfTypeOrdered(201116, true);
        HashSet<String> usedQs = new HashSet<String>();
        for (IXQEQueryNode v5Identifier : v5Identifiers) {
            IQuerySubject qs = ((V5BoundModelIdentifier)v5Identifier).getQuerySubject();
            if (qs == null || SummaryQuerySubjectUtilities.isDynamicSQS(qs)) continue;
            factManager.addInputChild((V5BoundModelIdentifier)v5Identifier, environment);
            usedQs.add(qs.getID());
        }
        query.setPropertyValue(PROP_USED_QS, usedQs);
    }

    public Set<String> collectQuerySubjects(IXQEQueryNode expression) {
        List<IXQEQueryNode> v5Identifiers = expression.getDescendantsOfTypeOrdered(201116, true);
        HashSet<String> usedQs = new HashSet<String>();
        for (IXQEQueryNode v5Identifier : v5Identifiers) {
            IQuerySubject qs = ((V5BoundModelIdentifier)v5Identifier).getQuerySubject();
            if (qs == null) continue;
            usedQs.add(qs.getID());
        }
        return usedQs;
    }

    private void expandDataItemReferences(IXQENodeFactory factory, IXQEQueryNode filter, V5Selection selection) {
        IXQEQueryNode[] refs;
        for (IXQEQueryNode ref : refs = filter.getDescendantsOfType(201060, true)) {
            if (((V5BoundDataItemReference)ref).isQueryRefItem()) continue;
            V5DataItem di = CreateV5QueryForDynamicSQS.getDataItemByRefName(selection, ((V5BoundDataItemReference)ref).getColumnName());
            ref.exchange(factory.deepCopyNode(di));
        }
    }

    private V5DataItem addGroupingColumn(IXQENodeFactory factory, IXQEQueryNode expr, V5Selection dynamicSQSQuerySelection, V5DataItem dataItem) {
        V5DataItem newDi = (V5DataItem)factory.copyNode(dataItem);
        newDi.addChild(factory.deepCopyNode(expr));
        newDi.setNameProperty(dataItem.getNameProperty());
        newDi.setAggregateProperty("none");
        newDi.setIsOriginal();
        dynamicSQSQuerySelection.addChild(newDi, 0);
        return newDi;
    }

    private void pushReportProjectionsInSQS(PlanningEnvironment environment, V5Query currentQuery, V5Query dynamicSQSQuery) {
        IXQEQueryNode[] boundIds;
        IXQEQueryNode[] dataItems;
        V5Selection dynamicSQSQuerySelection = dynamicSQSQuery.getV5Selection();
        String dynamicSQSQueryName = dynamicSQSQuery.getV5QueryName();
        XQENodeFactory factory = environment.getNodeFactory();
        for (IXQEQueryNode di : dataItems = currentQuery.getV5Selection().getChildren()) {
            Set<String> qsInExpression;
            V5DataItem dataItem = (V5DataItem)di;
            if (!CreateV5QueryForDynamicSQS.isGroupingItem(dataItem) || CreateV5QueryForDynamicSQS.isStaticGroupingColumn(dataItem)) continue;
            if (CreateV5QueryForDynamicSQS.isRootDSQSQuery(currentQuery)) {
                if (!dataItem.getIsProjected()) continue;
                this.validateApplyToInformation(environment, currentQuery, di);
            }
            if (!this.isApplicableToDSQS(environment, dynamicSQSQuery, dataItem, qsInExpression = this.collectQuerySubjects(dataItem))) continue;
            this.pushGroupingItem(dynamicSQSQuerySelection, dynamicSQSQueryName, factory, dataItem);
            if (dataItem.getAggregateProperty() != null && !dataItem.getAggregateProperty().equals("automatic")) continue;
            dataItem.setAggregateProperty("none");
        }
        for (IXQEQueryNode b : boundIds = currentQuery.getDescendantsOfType(201116, true)) {
            V5DataItem di1;
            V5BoundModelIdentifier v5BoundId = (V5BoundModelIdentifier)b;
            V5DataItem diRef = (V5DataItem)v5BoundId.getAncestorOfType(101003);
            if (diRef == null || diRef.getParent().getType() == 101009 || (di1 = currentQuery.getV5Selection().getDataItemByRefName(diRef.getNameProperty())) == null) continue;
            v5BoundId.exchange(factory.deepCopyNode(di1.getExpression(true)));
        }
    }

    private void validateApplyToInformation(PlanningEnvironment environment, V5Query rootQuery, IXQEQueryNode expr) {
        String applyToValue = (String)expr.getPropertyValue("applyToDSQS");
        List allQueries = (List)rootQuery.getPropertyValue(PROP_ALL_SUB_QUERIES);
        if (applyToValue == null) {
            return;
        }
        for (V5Query query : allQueries) {
            IQuerySubject qs = query.getDynamicSQS();
            if (qs == null || !applyToValue.contains(qs.getID())) continue;
            return;
        }
        if (rootQuery.isRelationalSubquery()) {
            return;
        }
        int aSeverity = 1;
        if (expr.getType() == 101008) {
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_NoDSQSMatchingApplyTo2, this.buildErrorContext(expr, rootQuery), applyToValue));
        } else {
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_NoDSQSMatchingApplyTo, this.buildErrorContext(expr, rootQuery), applyToValue));
        }
    }

    private void removeUnreferencedFacts(V5Query dynamicSQSQuery) {
        IXQEQueryNode[] children;
        V5Selection selection = dynamicSQSQuery.getV5Selection();
        for (IXQEQueryNode di : children = selection.getChildren()) {
            V5DataItem v5Di = (V5DataItem)di;
            if (v5Di.getAggregateProperty().equals("none") || v5Di.isReferenced()) continue;
            di.detach();
        }
    }

    private boolean isApplicableToDSQS(PlanningEnvironment environment, V5Query currentQuery, IXQEQueryNode expr, Set<String> qsInExpression) {
        String applyToValue;
        String qsName = null;
        if (currentQuery.getDynamicSQS() != null) {
            qsName = currentQuery.getDynamicSQS().getID();
            if (qsInExpression.size() == 1 && qsInExpression.iterator().next().equals(qsName)) {
                return true;
            }
        }
        Set supportedQS = (Set)currentQuery.getPropertyValue(PROP_APPLICABLE_DYNAMIC_QS);
        HashSet intersection = new HashSet(supportedQS);
        intersection.retainAll(qsInExpression);
        boolean isSupportedByFactStream = true;
        if (intersection.size() != qsInExpression.size()) {
            isSupportedByFactStream = false;
        }
        if ((applyToValue = (String)expr.getPropertyValue("applyToDSQS")) == null) {
            return isSupportedByFactStream;
        }
        if (isSupportedByFactStream) {
            if (this.isPartOfApplyTo(environment, currentQuery, applyToValue)) {
                return true;
            }
        } else if (this.isPartOfApplyTo(environment, currentQuery, applyToValue)) {
            this.throwErrorDynamicExpressionCanNotApply(expr, currentQuery);
        }
        return false;
    }

    private boolean isPartOfApplyTo(PlanningEnvironment environment, V5Query currentQuery, String applyToValue) {
        IQuerySubject qs = currentQuery.getDynamicSQS();
        if (qs != null && applyToValue.contains(qs.getID())) {
            return true;
        }
        return this.hasLeafDSQSApplicable(environment, currentQuery, applyToValue);
    }

    private boolean hasLeafDSQSApplicable(PlanningEnvironment environment, V5Query currentQuery, String applyToValue) {
        Set<V5Query> leafQueries = this.getLeafSQSQueries(environment, currentQuery);
        for (V5Query leafQ : leafQueries) {
            IQuerySubject qs = leafQ.getDynamicSQS();
            if (qs == null || !applyToValue.contains(qs.getID())) continue;
            return true;
        }
        return false;
    }

    private void throwErrorDynamicExpressionCanNotApply(IXQEQueryNode expr, V5Query dsqsQuery) {
        Set supportedQS = (Set)dsqsQuery.getPropertyValue(PROP_APPLICABLE_DYNAMIC_QS);
        Iterator it = supportedQS.iterator();
        StringBuilder arg = new StringBuilder();
        int i = 0;
        while (it.hasNext()) {
            arg.append((String)it.next());
            if (i < supportedQS.size() - 1) {
                arg.append(STR_COMMA);
            }
            ++i;
        }
        if (expr.getType() == 101008) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_DynamicExpressionCanNotApplyToDSQS2, (Object)this.buildErrorContext(expr, dsqsQuery), (Object)dsqsQuery.getDynamicSQS().getID(), (Object)arg.toString());
        }
        throw new XQERuntimeException(XQEMessageKeys.PLN_DynamicExpressionCanNotApplyToDSQS, (Object)this.buildErrorContext(expr, dsqsQuery), (Object)dsqsQuery.getDynamicSQS().getID(), (Object)arg.toString());
    }

    private String buildErrorContext(IXQEQueryNode expr, V5Query query) {
        if (expr.getType() == 101008) {
            return ((V5DetailFilter)expr).getOriginalExpression();
        }
        String rootQueryName = null;
        StringBuilder arg1 = new StringBuilder();
        rootQueryName = CreateV5QueryForDynamicSQS.isRootDSQSQuery(query) ? query.getV5QueryName() : query.getRootQueryName();
        arg1.append("[");
        arg1.append(rootQueryName);
        arg1.append("].[");
        arg1.append(((V5DataItem)expr).getNameProperty());
        arg1.append("]");
        return arg1.toString();
    }

    private V5DataItem pushGroupingItem(V5Selection dynamicSQSQuerySelection, String dynamicSQSQueryName, IXQENodeFactory factory, V5DataItem dataItem) {
        IXQEQueryNode expr = dataItem.getExpression(true);
        if (expr.getType() == 201026) {
            return null;
        }
        V5DataItem di = this.findProjectionWithSameExpr(dataItem, dynamicSQSQuerySelection);
        if (di == null) {
            di = this.addGroupingColumn(factory, expr, dynamicSQSQuerySelection, dataItem);
            di.setPropertyValue(PROP_BOOL_POTENTIAL_DUPLICATE_COLUMN, true);
            dynamicSQSQuerySelection.getParent().setPropertyValue(PROP_BOOL_POTENTIAL_DUPLICATE_COLUMN, true);
        }
        if (dynamicSQSQueryName != null) {
            CreateV5QueryForDynamicSQS.replaceSimpleNodeWithDataItemRef(factory, expr, di, dynamicSQSQueryName);
        }
        return di;
    }

    private void distributeProjectionsInJoinOperandQueries(PlanningEnvironment environment, V5Query joinQuery, V5Query leftSQSQuery, V5Query rightSQSQuery) {
        IXQEQueryNode[] dataItems;
        XQENodeFactory factory = environment.getNodeFactory();
        for (IXQEQueryNode di : dataItems = joinQuery.getV5Selection().getChildren()) {
            V5DataItem v5Di = (V5DataItem)di;
            if (CreateV5QueryForDynamicSQS.isGroupingItem(v5Di)) {
                if (CreateV5QueryForDynamicSQS.isRootDSQSQuery(joinQuery)) {
                    if (!v5Di.getIsProjected()) continue;
                    this.validateApplyToInformation(environment, joinQuery, di);
                }
                this.distributeDynamicGroupingColumn(environment, v5Di, joinQuery, leftSQSQuery, rightSQSQuery);
                continue;
            }
            this.updateV5BoundModelIdInExpr(factory, v5Di, leftSQSQuery, rightSQSQuery);
        }
        IXQEQueryNode joinExpr = joinQuery.getV5Source().getChild(0).getChild(2);
        this.updateV5BoundModelIdInExpr(factory, joinExpr, leftSQSQuery, rightSQSQuery);
        if (joinQuery.getDynamicSQS() != null) {
            this.removeUnreferencedFacts(joinQuery);
        }
        this.removeUnreferencedFacts(leftSQSQuery);
        this.removeUnreferencedFacts(rightSQSQuery);
    }

    private void distributeDynamicGroupingColumn(PlanningEnvironment environmnent, V5DataItem v5Di, V5Query joinQuery, V5Query leftSQSQuery, V5Query rightSQSQuery) {
        XQENodeFactory factory = environmnent.getNodeFactory();
        List<V5Query> applicableSQSs = this.getApplicableSQSQueries(environmnent, v5Di, leftSQSQuery, rightSQSQuery);
        if (applicableSQSs.size() == 2) {
            V5DataItem leftDi = null;
            V5DataItem rightDi = null;
            Set<V5Query> queryRefs = this.determineQueryReference(joinQuery, leftSQSQuery, rightSQSQuery);
            V5DataItem cloneDynamicColumn = (V5DataItem)factory.deepCopyNode(v5Di);
            if (queryRefs.size() == 1) {
                if (queryRefs.iterator().next() == leftSQSQuery) {
                    leftDi = this.pushGroupingItem(leftSQSQuery.getV5Selection(), leftSQSQuery.getV5QueryName(), factory, v5Di);
                    rightDi = this.pushGroupingItem(rightSQSQuery.getV5Selection(), null, factory, cloneDynamicColumn);
                } else {
                    rightDi = this.pushGroupingItem(rightSQSQuery.getV5Selection(), rightSQSQuery.getV5QueryName(), factory, cloneDynamicColumn);
                    leftDi = this.pushGroupingItem(leftSQSQuery.getV5Selection(), null, factory, v5Di);
                }
            } else {
                leftDi = this.pushGroupingItem(leftSQSQuery.getV5Selection(), leftSQSQuery.getV5QueryName(), factory, v5Di);
                IXQEQueryNode diExpr = v5Di.getExpression(true);
                rightDi = this.pushGroupingItem(rightSQSQuery.getV5Selection(), null, factory, cloneDynamicColumn);
                V5CoalesceFunction coalesceF = (V5CoalesceFunction)factory.createNode(201055);
                coalesceF.setNativeName("coalesce");
                diExpr.insertParent(coalesceF);
                V5BoundDataItemReference dataItemRef = this.createV5QueryRefItem(factory, rightDi, rightSQSQuery.getV5QueryName());
                coalesceF.addChild(dataItemRef);
            }
            if (leftDi != null && rightDi != null) {
                V5BoundDataItemReference leftJoinExpr = this.createV5QueryRefItem(factory, leftDi, leftSQSQuery.getV5QueryName());
                V5BoundDataItemReference rightJoinExpr = this.createV5QueryRefItem(factory, rightDi, rightSQSQuery.getV5QueryName());
                this.addInJoinExpr(factory, joinQuery, leftJoinExpr, rightJoinExpr);
            }
            return;
        }
        if (applicableSQSs.size() == 1) {
            if (leftSQSQuery == applicableSQSs.get(0)) {
                this.pushGroupingItem(leftSQSQuery.getV5Selection(), leftSQSQuery.getV5QueryName(), factory, v5Di);
            } else {
                this.pushGroupingItem(rightSQSQuery.getV5Selection(), rightSQSQuery.getV5QueryName(), factory, v5Di);
            }
        }
    }

    private void addInJoinExpr(IXQENodeFactory factory, V5Query joinQuery, IXQEQueryNode leftJoinExpr, IXQEQueryNode rightJoinExpr) {
        V5JoinOperation joinOperation = (V5JoinOperation)joinQuery.getV5Source().getChild(0);
        IXQEQueryNode existingJoinExpr = null;
        if (joinOperation.getNumberChildren() > 2) {
            existingJoinExpr = joinOperation.getChild(2);
            IXQEQueryNode[] equalNodes = existingJoinExpr.getDescendantsOfType(201013, true);
            if (leftJoinExpr.getType() == 201060 && rightJoinExpr.getType() == 201060) {
                String leftJoinColName = ((V5BoundDataItemReference)leftJoinExpr).getNameParts()[1];
                String rightJoinColName = ((V5BoundDataItemReference)rightJoinExpr).getNameParts()[1];
                IXQEQueryNode dummyJoin = null;
                for (IXQEQueryNode eq : equalNodes) {
                    if (((V5ComparisonExpression)eq).getSubType() != 2) continue;
                    if (this.isDummyJoin(eq)) {
                        dummyJoin = eq;
                        continue;
                    }
                    if (!this.equivalentJoin(eq, leftJoinColName, rightJoinColName)) continue;
                    if (dummyJoin != null) {
                        dummyJoin.detach();
                    }
                    return;
                }
                if (dummyJoin != null) {
                    dummyJoin.detach();
                }
            }
        }
        V5ComparisonExpression equalNode = (V5ComparisonExpression)factory.createNode(201013);
        equalNode.setSubType(2);
        equalNode.addChild(leftJoinExpr);
        equalNode.addChild(rightJoinExpr);
        if (joinOperation.getNumberChildren() > 2) {
            V5LogicalExpression andNode = (V5LogicalExpression)factory.createNode(201003);
            andNode.setSubType(0);
            existingJoinExpr.insertParent(andNode);
            andNode.addChild(equalNode);
        } else {
            joinOperation.addChild(equalNode);
        }
    }

    private boolean isDummyJoin(IXQEQueryNode eq) {
        return eq.getChild(0).getType() == 201026 && eq.getChild(1).getType() == 201026;
    }

    private boolean equivalentJoin(IXQEQueryNode existingEqualNode, String dynLeftJoinCol, String dynRightJoinCol) {
        IXQEQueryNode existingLeftExpr = existingEqualNode.getChild(0);
        IXQEQueryNode existingRightExpr = existingEqualNode.getChild(1);
        String existingLeftColumnName = null;
        String existingRightColumnName = null;
        if (existingLeftExpr.getType() == 201116) {
            existingLeftColumnName = ((V5BoundMultiPartIdentifier)existingLeftExpr).getNameParts()[2];
        }
        if (existingRightExpr.getType() == 201116) {
            existingRightColumnName = ((V5BoundMultiPartIdentifier)existingRightExpr).getNameParts()[2];
        }
        return dynLeftJoinCol.equals(existingLeftColumnName) && dynRightJoinCol.equals(existingRightColumnName) || dynRightJoinCol.equals(existingLeftColumnName) && dynLeftJoinCol.equals(existingRightColumnName);
    }

    private List<V5Query> getApplicableSQSQueries(PlanningEnvironment environment, IXQEQueryNode expr, V5Query leftSQSQuery, V5Query rightSQSQuery) {
        ArrayList<V5Query> applicableSQSs = new ArrayList<V5Query>();
        Set<String> qsInExpression = this.collectQuerySubjects(expr);
        if (this.isApplicable(environment, leftSQSQuery, expr, qsInExpression)) {
            applicableSQSs.add(leftSQSQuery);
        }
        if (applicableSQSs.size() == 1 && qsInExpression.size() == 1 && leftSQSQuery.getDynamicSQS() != null && qsInExpression.iterator().next().equals(leftSQSQuery.getDynamicSQS().getID())) {
            return applicableSQSs;
        }
        if (this.isApplicable(environment, rightSQSQuery, expr, qsInExpression)) {
            applicableSQSs.add(rightSQSQuery);
        }
        return applicableSQSs;
    }

    private boolean isApplicable(PlanningEnvironment environment, V5Query query, IXQEQueryNode expr, Set<String> qsInExpression) {
        IQuerySubject dSQS = query.getDynamicSQS();
        if (dSQS != null || query.getPropertyValue("queryForNonDSQSItems") != null) {
            return this.isApplicableToDSQS(environment, query, expr, qsInExpression);
        }
        return CreateV5QueryForDynamicSQS.isStitchQuery(query) && this.containsApplicableDescendant(environment, query, expr, qsInExpression);
    }

    private boolean containsApplicableDescendant(PlanningEnvironment environment, V5Query stitchQuery, IXQEQueryNode expr, Set<String> qsInExpression) {
        List<V5Query> subQueries = DistributeDynamicGroupingColumnAndFilterInDSQS.getSubQueries(environment, stitchQuery);
        for (V5Query subQuery : subQueries) {
            if (!this.isApplicable(environment, subQuery, expr, qsInExpression)) continue;
            return true;
        }
        return false;
    }

    private Set<V5Query> determineQueryReference(V5Query currentQuery, V5Query leftQuery, V5Query rightQuery) {
        V5JoinOperation joinOperation = (V5JoinOperation)currentQuery.getV5Source().getChild(0);
        SQLJoin.SubType joinType = joinOperation.getJoinType();
        if (joinType == null) {
            return null;
        }
        HashSet<V5Query> applicableQSs = new HashSet<V5Query>();
        if (joinType == SQLJoin.SubType.INNER || joinType == SQLJoin.SubType.LEFT_OUTER) {
            applicableQSs.add(leftQuery);
        } else if (joinType == SQLJoin.SubType.RIGHT_OUTER) {
            applicableQSs.add(rightQuery);
        } else {
            applicableQSs.add(leftQuery);
            applicableQSs.add(rightQuery);
        }
        return applicableQSs;
    }

    private void updateV5BoundModelIdInExpr(IXQENodeFactory factory, IXQEQueryNode expr, V5Query leftSQSQuery, V5Query rightSQSQuery) {
        IXQEQueryNode[] boundIds;
        for (IXQEQueryNode b : boundIds = expr.getDescendantsOfType(201116, true)) {
            V5BoundModelIdentifier v5BoundId = (V5BoundModelIdentifier)b;
            String queryName = null;
            V5DataItem di = CreateV5QueryForDynamicSQS.findProjection(factory, v5BoundId, leftSQSQuery);
            if (di != null) {
                queryName = leftSQSQuery.getV5QueryName();
            } else {
                di = CreateV5QueryForDynamicSQS.findProjection(factory, v5BoundId, rightSQSQuery);
                if (di != null) {
                    queryName = rightSQSQuery.getV5QueryName();
                }
            }
            if (di == null) continue;
            CreateV5QueryForDynamicSQS.replaceSimpleNodeWithDataItemRef(factory, v5BoundId, di, queryName);
            di.setIsReferenced();
        }
    }

    private Set<V5Query> getLeafSQSQueries(PlanningEnvironment environment, V5Query subQuery) {
        V5QuerySet querySet = V5QuerySet.getRootQuerySet(subQuery);
        HashSet<String> subQueryNames = new HashSet<String>();
        HashSet<V5Query> leafSQSQueries = new HashSet<V5Query>();
        subQuery.getAllSubQueryNames(subQueryNames, querySet, environment);
        for (String subQueryName : subQueryNames) {
            V5Query query = querySet.getV5Query(subQueryName);
            if (query == null || query.getReferencedDynamicSQS() != null || CreateV5QueryForDynamicSQS.isStitchQuery(query)) continue;
            leafSQSQueries.add(query);
        }
        return leafSQSQueries;
    }

    private V5DataItem findProjectionWithSameExpr(V5DataItem dataItem, V5Selection dynamicSQSQuerySelection) {
        V5BoundModelIdentifier v5BoundId;
        IXQEQueryNode expr = dataItem.getExpression(true);
        V5DataItem gpItemInDynamicSQS = null;
        if (expr.getType() == 201116 && this.referenceNestedSQS(v5BoundId = (V5BoundModelIdentifier)expr, (V5Query)dynamicSQSQuerySelection.getParent())) {
            gpItemInDynamicSQS = CreateV5QueryForDynamicSQS.getDataItemByRefName(dynamicSQSQuerySelection, v5BoundId.getColumnName());
            V5Query query = (V5Query)dataItem.getAncestorOfType(101006);
            if (CreateV5QueryForDynamicSQS.isRootDSQSQuery(query)) {
                dataItem.setPropertyValue(PROP_BOOL_STATIC_COLUMN_PROJECTED, true);
                gpItemInDynamicSQS.setPropertyValue(PROP_BOOL_STATIC_COLUMN_PROJECTED, true);
            } else if (dataItem.getPropertyValue(PROP_BOOL_STATIC_COLUMN_PROJECTED) != null) {
                gpItemInDynamicSQS.setPropertyValue(PROP_BOOL_STATIC_COLUMN_PROJECTED, true);
            }
            return gpItemInDynamicSQS;
        }
        gpItemInDynamicSQS = dynamicSQSQuerySelection.getDataItemByExpression(expr);
        if (gpItemInDynamicSQS != null) {
            if (!this.sameApplyTo(dataItem, gpItemInDynamicSQS)) {
                return null;
            }
            gpItemInDynamicSQS.setPropertyValue(PROP_BOOL_STATIC_COLUMN_SAME_EXPR_AS_DYNAMIC, true);
        }
        return gpItemInDynamicSQS;
    }

    private boolean sameApplyTo(V5DataItem dynamicDataItem, V5DataItem dataItemInNestedQuery) {
        String applyTo1 = (String)dynamicDataItem.getPropertyValue("applyToDSQS");
        String applyTo2 = (String)dataItemInNestedQuery.getPropertyValue("applyToDSQS");
        return applyTo1 == null ? applyTo2 == null : applyTo2 != null && applyTo1.equals(applyTo2);
    }

    private boolean referenceNestedSQS(V5BoundModelIdentifier v5BoundId, V5Query query) {
        IQuerySubject dynamicSQS;
        IQuerySubject querySubject = v5BoundId.getQuerySubject();
        return querySubject != null && (dynamicSQS = (IQuerySubject)query.getPropertyValue("dynamicSQSQuery")) != null && querySubject == dynamicSQS;
    }

    private V5BoundDataItemReference createV5QueryRefItem(IXQENodeFactory factory, V5DataItem refDataItem, String refQueryName) {
        V5BoundDataItemReference queryItemRef = (V5BoundDataItemReference)factory.createNode(201060);
        queryItemRef.setRefDataItem(refDataItem);
        queryItemRef.setIsQueryRefItem();
        queryItemRef.setIdentifier(UniqueNameGenerator.createUniqueName(refQueryName, refDataItem.getNameProperty()));
        return queryItemRef;
    }

    private void detectDoubleCountingInJoinQuery(PlanningEnvironment environment, V5Query joinQuery, V5Query leftSQSQuery, V5Query rightSQSQuery) {
        if (CreateV5QueryForDynamicSQS.isStitchQuery(leftSQSQuery)) {
            Set<V5Query> leafSQSQueries = this.getLeafSQSQueries(environment, leftSQSQuery);
            leafSQSQueries.add(rightSQSQuery);
            HashSet<V5Query> lowestGroupingLevelQuery = new HashSet<V5Query>();
            ArrayList<V5BoundDataItemReference> lowestGroupingLevel = new ArrayList<V5BoundDataItemReference>();
            this.getLowestGroupingLevelQuery(environment.getNodeFactory(), leafSQSQueries, lowestGroupingLevelQuery, lowestGroupingLevel);
            if (lowestGroupingLevelQuery.size() > 0) {
                for (V5Query query : leafSQSQueries) {
                    if (lowestGroupingLevelQuery.contains(query)) continue;
                    this.markPotentialDoubleCountingFactItems(environment, joinQuery, query, this.getGroupingColumns(query), null);
                }
            } else {
                for (V5Query query : leafSQSQueries) {
                    this.markPotentialDoubleCountingFactItems(environment, joinQuery, query, this.getGroupingColumns(query), lowestGroupingLevel);
                }
            }
            return;
        }
        List<V5DataItem> gcLeftQuery = this.getGroupingColumns(leftSQSQuery);
        List<V5DataItem> gcRightQuery = this.getGroupingColumns(rightSQSQuery);
        int compareGranularity = this.compareGranularity(gcLeftQuery, gcRightQuery, joinQuery);
        switch (compareGranularity) {
            case 0: {
                return;
            }
            case 1: {
                this.markPotentialDoubleCountingFactItems(environment, joinQuery, leftSQSQuery, gcLeftQuery, null);
                return;
            }
            case 2: {
                this.markPotentialDoubleCountingFactItems(environment, joinQuery, rightSQSQuery, gcRightQuery, null);
                return;
            }
        }
        this.markPotentialDoubleCountingFactItems(environment, joinQuery, leftSQSQuery, gcLeftQuery, null);
        this.markPotentialDoubleCountingFactItems(environment, joinQuery, rightSQSQuery, gcRightQuery, null);
    }

    private void markPotentialDoubleCountingFactItems(PlanningEnvironment environment, V5Query joinQuery, V5Query queryWithHigherScope, List<V5DataItem> groupingColumnsInHigherScopeQuery, List<V5BoundDataItemReference> lowestGroupingLevel) {
        String queryWithHigherScopeName = queryWithHigherScope.getV5QueryName();
        boolean useLowestGroupingLevel = false;
        if (groupingColumnsInHigherScopeQuery.size() == 0) {
            if (lowestGroupingLevel != null && lowestGroupingLevel.size() > 0) {
                useLowestGroupingLevel = true;
            } else {
                return;
            }
        }
        IXQEQueryNode[] dis = joinQuery.getV5Selection().getChildren();
        V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(joinQuery);
        for (IXQEQueryNode child : dis) {
            IXQEQueryNode[] diRefs;
            V5DataItem di = (V5DataItem)child;
            if (CreateV5QueryForDynamicSQS.isGroupingItem(di)) continue;
            for (IXQEQueryNode ref : diRefs = di.getDescendantsOfType(201060, false)) {
                V5BoundDataItemReference boundRef = (V5BoundDataItemReference)ref;
                if (!boundRef.isQueryRefItem()) continue;
                if (boundRef.getNameParts()[0].equals(queryWithHigherScopeName)) {
                    if (useLowestGroupingLevel) {
                        boundRef.setPropertyValue(PROP_LOWEST_GROUPING_LEVEL_COLUMNS, lowestGroupingLevel);
                    } else {
                        boundRef.setPropertyValue(PROP_GROUPING_COLUMNS_IN_HIGHER_SCOPE_QUERY, groupingColumnsInHigherScopeQuery);
                    }
                    boundRef.setPropertyValue(PROP_STR_HIGHER_SCOPE_QUERY_NAME, queryWithHigherScopeName);
                    continue;
                }
                String queryName = boundRef.getNameParts()[0];
                V5Query query = rootQuerySet.getV5Query(queryName);
                V5BoundDataItemReference tempRef = boundRef;
                while (query != null && CreateV5QueryForDynamicSQS.isStitchQuery(query) && tempRef != null) {
                    V5DataItem di1 = tempRef.getRefDataItem();
                    V5Query parentQuery = (V5Query)di1.getAncestorOfType(101006);
                    if (parentQuery.getDynamicSQS() != null) {
                        if (parentQuery.getV5QueryName().equals(queryWithHigherScopeName)) {
                            if (useLowestGroupingLevel) {
                                boundRef.setPropertyValue(PROP_LOWEST_GROUPING_LEVEL_COLUMNS, lowestGroupingLevel);
                            } else {
                                boundRef.setPropertyValue(PROP_GROUPING_COLUMNS_IN_HIGHER_SCOPE_QUERY, groupingColumnsInHigherScopeQuery);
                            }
                            boundRef.setPropertyValue(PROP_STR_HIGHER_SCOPE_QUERY_NAME, queryWithHigherScopeName);
                        }
                        query = null;
                        continue;
                    }
                    query = parentQuery;
                    if (di1.getExpression(true).getType() != 201060) continue;
                    tempRef = (V5BoundDataItemReference)di1.getExpression(true);
                }
            }
        }
    }

    private void getLowestGroupingLevelQuery(IXQENodeFactory factory, Set<V5Query> leafSQSQueries, Set<V5Query> lowestScopeQuery, List<V5BoundDataItemReference> lowestGroupingLevel) {
        int longestGroupingColumn = -1;
        ArrayList<V5Query> lowestGroupingLevelQuery = new ArrayList<V5Query>();
        for (V5Query query : leafSQSQueries) {
            List<V5DataItem> groupingColumns = this.getGroupingColumns(query);
            if (groupingColumns.size() > longestGroupingColumn) {
                lowestGroupingLevelQuery.clear();
                lowestGroupingLevelQuery.add(query);
                longestGroupingColumn = groupingColumns.size();
                continue;
            }
            if (groupingColumns.size() != longestGroupingColumn) continue;
            lowestGroupingLevelQuery.add(query);
        }
        V5Query startQuery = (V5Query)lowestGroupingLevelQuery.get(0);
        lowestScopeQuery.add(startQuery);
        List<V5DataItem> longestGroupingColumns = this.getGroupingColumns(startQuery);
        String lowestGroupingLevelQueryName = startQuery.getV5QueryName();
        for (V5DataItem di : longestGroupingColumns) {
            V5BoundDataItemReference ref = this.createV5QueryRefItem(factory, di, lowestGroupingLevelQueryName);
            lowestGroupingLevel.add(ref);
        }
        boolean needToCombineGroupingColumns = false;
        for (V5Query query : leafSQSQueries) {
            if (query == startQuery) continue;
            List<V5DataItem> groupingColumns = this.getGroupingColumns(query);
            for (V5DataItem gc : groupingColumns) {
                boolean found = false;
                for (V5DataItem gc1 : longestGroupingColumns) {
                    if (!gc.getExpression(true).isSameExpression(gc1.getExpression(true), false)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                needToCombineGroupingColumns = true;
                longestGroupingColumns.add(gc);
                V5BoundDataItemReference ref = this.createV5QueryRefItem(factory, gc, query.getV5QueryName());
                lowestGroupingLevel.add(ref);
            }
            if (needToCombineGroupingColumns || lowestGroupingLevelQuery.size() <= 1) continue;
            for (int i = 1; i < lowestGroupingLevelQuery.size(); ++i) {
                if (lowestGroupingLevelQuery.get(i) != query) continue;
                lowestScopeQuery.add(query);
            }
        }
        if (needToCombineGroupingColumns) {
            lowestScopeQuery.clear();
        }
    }

    private int compareGranularity(List<V5DataItem> leftGrColumns, List<V5DataItem> rightGrColumns, V5Query joinQuery) {
        if (leftGrColumns.size() == 0 && rightGrColumns.size() == 0) {
            return 0;
        }
        if (leftGrColumns.size() > 0 && rightGrColumns.size() == 0) {
            return 2;
        }
        if (leftGrColumns.size() == 0 && rightGrColumns.size() > 0) {
            return 1;
        }
        ArrayList<V5DataItem> shorterGrColumns = new ArrayList<V5DataItem>();
        ArrayList<V5DataItem> longerGrColumns = new ArrayList<V5DataItem>();
        int higherGranularity = 0;
        if (leftGrColumns.size() <= rightGrColumns.size()) {
            shorterGrColumns.addAll(leftGrColumns);
            longerGrColumns.addAll(rightGrColumns);
            higherGranularity = 1;
        } else {
            shorterGrColumns.addAll(rightGrColumns);
            longerGrColumns.addAll(leftGrColumns);
            higherGranularity = 2;
        }
        int foundItem = 0;
        ArrayList<V5DataItem> notMatchedColumns = new ArrayList<V5DataItem>();
        for (V5DataItem groupingColumn1 : shorterGrColumns) {
            boolean found = false;
            for (V5DataItem groupingColumn2 : longerGrColumns) {
                if (!groupingColumn1.getExpression(true).isSameExpression(groupingColumn2.getExpression(true), false)) continue;
                found = true;
                ++foundItem;
                break;
            }
            if (found) continue;
            notMatchedColumns.add(groupingColumn1);
        }
        if (foundItem == shorterGrColumns.size()) {
            if (foundItem == longerGrColumns.size()) {
                return 0;
            }
            return higherGranularity;
        }
        V5Query query = (V5Query)((V5DataItem)notMatchedColumns.get(0)).getAncestorOfType(101006);
        String thisQueryName = query.getV5QueryName();
        String otherQueryName = null;
        V5JoinOperation joinOperation = (V5JoinOperation)joinQuery.getV5Source().getChild(0);
        String leftQueryName = ((V5JoinOperand)joinOperation.getChild(0)).getQueryRef();
        otherQueryName = leftQueryName.equals(thisQueryName) ? ((V5JoinOperand)joinOperation.getChild(1)).getQueryRef() : leftQueryName;
        IXQEQueryNode joinExpr = joinOperation.getChild(2);
        IXQEQueryNode[] diRefs = joinExpr.getDescendantsOfType(201060, true);
        for (V5DataItem col : notMatchedColumns) {
            if (!this.belongsToJoinExpression(col, diRefs, thisQueryName, otherQueryName)) continue;
            ++foundItem;
        }
        if (foundItem == shorterGrColumns.size()) {
            if (foundItem == longerGrColumns.size()) {
                return 0;
            }
            return higherGranularity;
        }
        return -1;
    }

    private boolean belongsToJoinExpression(V5DataItem groupingColumn, IXQEQueryNode[] diRefs, String thisQueryName, String otherQueryName) {
        String groupingColumnName = groupingColumn.getNameProperty();
        for (IXQEQueryNode ref : diRefs) {
            IXQEQueryNode parent;
            V5BoundDataItemReference diRef = (V5BoundDataItemReference)ref;
            if (!diRef.getNameParts()[0].equals(thisQueryName) || !diRef.getNameParts()[1].equals(groupingColumnName) || (parent = diRef.getParent()).getType() != 201013 || ((V5ComparisonExpression)parent).getSubType() != 2) continue;
            IXQEQueryNode otherNode = null;
            otherNode = diRef == parent.getChild(0) ? parent.getChild(1) : parent.getChild(0);
            if (otherNode.getType() != 201060 || !((V5BoundDataItemReference)otherNode).getNameParts()[0].equals(otherQueryName)) continue;
            return true;
        }
        return false;
    }

    private List<V5DataItem> getGroupingColumns(V5Query query) {
        IXQEQueryNode[] dis = query.getV5Selection().getChildren();
        ArrayList<V5DataItem> gcs = new ArrayList<V5DataItem>();
        for (IXQEQueryNode di : dis) {
            if (!CreateV5QueryForDynamicSQS.isGroupingItem((V5DataItem)di)) continue;
            gcs.add((V5DataItem)di);
        }
        return gcs;
    }

    private V5Query getLeftQuery(V5Query joinQuery, V5QuerySet querySet) {
        V5JoinOperation joinOperation = (V5JoinOperation)joinQuery.getV5Source().getChild(0);
        V5JoinOperand leftOperand = (V5JoinOperand)joinOperation.getChild(0);
        return querySet.getV5Query(leftOperand.getQueryRef());
    }

    private V5Query getRightQuery(V5Query joinQuery, V5QuerySet querySet) {
        V5JoinOperation joinOperation = (V5JoinOperation)joinQuery.getV5Source().getChild(0);
        V5JoinOperand rightOperand = (V5JoinOperand)joinOperation.getChild(1);
        return querySet.getV5Query(rightOperand.getQueryRef());
    }

    public static List<V5Query> getSubQueries(PlanningEnvironment environment, V5Query query) {
        V5QuerySet querySet = V5QuerySet.getRootQuerySet(query);
        ArrayList<V5Query> subQueries = new ArrayList<V5Query>();
        Set<String> subQueryNames = query.getSubQueryNames(environment);
        if (subQueryNames.size() > 0) {
            for (String subQueryName : subQueryNames) {
                subQueries.add(querySet.getV5Query(subQueryName));
            }
        }
        return subQueries;
    }

    public List<V5Query> getAllSubQueries(PlanningEnvironment environment, V5Query query) {
        V5QuerySet querySet = V5QuerySet.getRootQuerySet(query);
        ArrayList<V5Query> subQueries = new ArrayList<V5Query>();
        HashSet<String> subQueryNames = new HashSet<String>();
        query.getAllSubQueryNames(subQueryNames, querySet, environment);
        if (subQueryNames.size() > 0) {
            for (String subQueryName : subQueryNames) {
                subQueries.add(querySet.getV5Query(subQueryName));
            }
        }
        return subQueries;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (node.getPropertyValue("generateDynamicSQSQuery") == null) {
            this.traceNodeCondition(false, "Query doesn't involve DSQS.", xqeTrace);
            return false;
        }
        V5Query query = (V5Query)node;
        if (!CreateV5QueryForDynamicSQS.isRootDSQSQuery(query)) {
            this.traceNodeCondition(false, "This query is not the report query that references DSQS.", xqeTrace);
            return false;
        }
        return true;
    }
}

