/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.GenerateCTEInWithClauseForRQPSubQuery;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPNameGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MakeDerivedColumnListValid
extends RQPTransformation {
    public static final String CONTAINS_NON_RELATIONAL_REFERENCE = "containsNonRelationalReference";

    public MakeDerivedColumnListValid() {
        this.mPassNumbers = new int[]{60};
        this.mTypes = new int[]{301007};
        this.mName = "Make valid sql identifier for dervied column list";
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        int maxColumnNameLength = RQPUtilities.getMaxColumnNameLength(environment);
        SQLRangeVar rangeVar = (SQLRangeVar)node;
        List<String> dcList = rangeVar.getDerivedColumnList();
        HashSet<String> aliases = new HashSet<String>();
        ArrayList<String> temp = new ArrayList<String>(dcList.size());
        for (int i = 0; i < dcList.size(); ++i) {
            String derivedColumn = dcList.get(i);
            String aliasName = RQPNameGenerator.makeValidSqlIdentifier(derivedColumn);
            if (!(aliasName = RQPNameGenerator.generateUniqueAliasName(aliases, aliasName, maxColumnNameLength)).equals(derivedColumn)) {
                this.updateSQLColumns(rangeVar, derivedColumn, aliasName);
            }
            temp.add(i, aliasName);
            aliases.add(aliasName.toUpperCase());
        }
        rangeVar.setDerivedColumnList(temp);
        if (null != rangeVar.getPropertyValue("refSQLRangeVarHavingMovedDetailFilter")) {
            SQLRangeVar refRangeVar = (SQLRangeVar)rangeVar.getPropertyValue("refSQLRangeVarHavingMovedDetailFilter");
            refRangeVar.setDerivedColumnList(new ArrayList<String>(rangeVar.getDerivedColumnList()));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        SQLRangeVar rangeVar = (SQLRangeVar)node;
        List<String> dcList = rangeVar.getDerivedColumnList();
        if (dcList == null || dcList.size() == 0) {
            return false;
        }
        if (rangeVar.getPropertyValue(CONTAINS_NON_RELATIONAL_REFERENCE) != null) {
            return false;
        }
        int maxColumnNameLength = RQPUtilities.getMaxColumnNameLength(environment);
        if (this.allValidIdentifiers(dcList, maxColumnNameLength)) {
            return false;
        }
        IXQEQueryNode setOperator = rangeVar.getFirstChildByType(301018);
        if (setOperator == null) {
            return false;
        }
        return setOperator.hasChildOfType(301015) || setOperator.hasChildOfType(801017);
    }

    private boolean allValidIdentifiers(List<String> derivedColumns, int maxColumnNameLength) {
        HashSet<String> aliases = new HashSet<String>();
        for (String columnName : derivedColumns) {
            String aliasName = RQPNameGenerator.makeValidSqlIdentifier(columnName);
            if (!aliasName.equals(columnName)) {
                return false;
            }
            if (!(aliasName = RQPNameGenerator.generateUniqueAliasName(aliases, aliasName, maxColumnNameLength)).equals(columnName)) {
                return false;
            }
            aliases.add(aliasName.toUpperCase());
        }
        return true;
    }

    private void updateSQLColumns(SQLRangeVar rangeVar, String oldName, String newName) {
        String rangeVarName = rangeVar.getName();
        IXQEQueryNode parent = rangeVar.getParent();
        if (parent.getType() != 301022) {
            this.updateSQLColumnsWithinParentQuery(rangeVar, oldName, newName);
            return;
        }
        int nbCTEs = parent.getNumberChildren();
        int ctePositionInWithClause = GenerateCTEInWithClauseForRQPSubQuery.getCtePositionInWithClause(rangeVar);
        for (int i = ctePositionInWithClause + 1; i < nbCTEs; ++i) {
            IXQEQueryNode cte = parent.getChild(i);
            boolean found = false;
            List<IXQEQueryNode> relations = cte.getDescendantsOfTypeOrdered(301016, false);
            for (IXQEQueryNode r : relations) {
                SQLRelation relation = (SQLRelation)r;
                if (!relation.getName().equals(rangeVarName)) continue;
                found = true;
            }
            if (!found) continue;
            List<IXQEQueryNode> columns = cte.getDescendantsOfTypeOrdered(301005, false);
            this.updateSqlColumnName(rangeVar.getName(), oldName, newName, columns);
            if (rangeVar.getChild(0).getType() != 301018 || rangeVar.getChild(0).getPropertyValue("sqsOwner") == null) continue;
            this.updateSQLColumns((SQLRangeVar)cte, oldName, newName);
        }
    }

    private void updateSQLColumnsWithinParentQuery(SQLRangeVar rangeVar, String oldColumnName, String newColumnName) {
        IXQEQueryNode parent;
        int[] types = new int[]{301007, 301010, 301015, 301076, 301019, 801017};
        for (parent = rangeVar.getParent(); parent != null && !parent.isOfTypes(types); parent = parent.getParent()) {
        }
        List<IXQEQueryNode> columns = parent.getDescendantsOfTypeOrdered(301005, 301007);
        this.updateSqlColumnName(rangeVar.getName(), oldColumnName, newColumnName, columns);
    }

    private void updateSqlColumnName(String rangeVarName, String oldColumnName, String newColumnName, List<IXQEQueryNode> columns) {
        for (IXQEQueryNode c : columns) {
            SQLColumn column = (SQLColumn)c;
            String tableName = column.getTableName();
            if (tableName == null || !tableName.equals(rangeVarName) || !column.getName().equals(oldColumnName)) continue;
            column.setName(newColumnName);
        }
    }
}

