/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPFooterQuery;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DetectNoOpAggregates;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DistributeProjectionsInFactQueries;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.MoveGroupingItemsToSubQuery;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ProcessDataItemRefInValueSet;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MoveFooterItemsToFooterQuery
extends RQPTransformation {
    public MoveFooterItemsToFooterQuery() {
        this.mName = "Move footer items to footer query.";
        this.mPassNumbers = new int[]{45};
        this.mTypes = new int[]{801016};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        HashMap<V5ValueSet, List<V5DataItem>> footerScopes = this.getGroupingItemsOfEachValueSetLevel(rqpQuery);
        for (IXQEQueryNode child : node.getChildren()) {
            List<V5DataItem> footerScope;
            RQPDataItem projection = (RQPDataItem)child;
            if (!projection.isFooterHeaderItem() && !projection.isGroupBodyItemOfNonLastValueSet() || !this.needToBeMovedToFooterQuery(environment, rqpQuery, projection, footerScope = footerScopes.get(projection.getRollupScope()))) continue;
            this.moveFooterItemToFooterQuery(environment, rqpQuery, projection, footerScope);
        }
    }

    private HashMap<V5ValueSet, List<V5DataItem>> getGroupingItemsOfEachValueSetLevel(RQPQuery rqpQuery) {
        RQPQuery rootQuery = rqpQuery.getRootRQPQuery();
        List<IXQEQueryNode> valueSets = rootQuery.getDescendantsOfTypeOrdered(101057, false);
        HashMap<V5ValueSet, List<V5DataItem>> footerScopes = new HashMap<V5ValueSet, List<V5DataItem>>();
        for (IXQEQueryNode vs : valueSets) {
            V5ValueSet valueSet = (V5ValueSet)vs;
            List<V5DataItem> groupingItems = ProcessDataItemRefInValueSet.getGroupingItems(valueSet, rootQuery, true);
            if (groupingItems.size() > 0 && rqpQuery.isFactQuery()) {
                groupingItems = this.filterOutGroupingItemsNotInScope(rqpQuery, groupingItems);
                footerScopes.put(valueSet, groupingItems);
                continue;
            }
            footerScopes.put(valueSet, groupingItems);
        }
        return footerScopes;
    }

    private List<V5DataItem> filterOutGroupingItemsNotInScope(RQPQuery factStreamQuery, List<V5DataItem> groupingItems) {
        List<V5DataItem> retGroupingItems = groupingItems;
        for (V5DataItem di : groupingItems) {
            RQPProjectionList projList = factStreamQuery.getProjectionList();
            boolean found = false;
            for (int i = 0; i < projList.getNumberChildren(); ++i) {
                RQPDataItem projection = (RQPDataItem)projList.getChild(i);
                if (!this.isSameGroupingItem(di, projection)) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (retGroupingItems == groupingItems) {
                retGroupingItems = new ArrayList<V5DataItem>();
                retGroupingItems.addAll(groupingItems);
            }
            retGroupingItems.remove(di);
        }
        return retGroupingItems;
    }

    private boolean isSameGroupingItem(V5DataItem di, RQPDataItem projection) {
        if (!projection.isGroupingItem()) {
            return false;
        }
        return di.getNameProperty().equals(projection.getOriginalName());
    }

    private void moveFooterItemToFooterQuery(PlanningEnvironment environment, RQPQuery rqpQuery, RQPDataItem item, List<V5DataItem> groupingItems) {
        IXQEQueryNode[] aggregates = ExpressionAnalyzer.getAggregateNodes(item);
        for (int i = 0; i < aggregates.length; ++i) {
            V5AggregateFunction analyticFunctionOperand;
            V5AggregateFunction aggregate = (V5AggregateFunction)aggregates[i];
            IXQEQueryNode dataItem = aggregate.getAncestorOfType(801008);
            if (dataItem == null || !aggregate.getRollupAggregateNode() && !ExpressionAnalyzer.isAnalyticFunction(aggregate) && !ExpressionAnalyzer.isRunningMovingFunction(aggregate) || this.analyticOrRMFunctionWithDefaultScopeAndSummaryFilter(environment, rqpQuery, item, aggregate, groupingItems) || aggregate.getAncestorOfType(801012) != null || aggregate.getAncestorOfType(801024) != null) continue;
            if (ExpressionAnalyzer.isStandardAggregateWithAutoForClause(aggregate)) {
                if (ExpressionAnalyzer.hasAnalyticMovingRunningFunctions(aggregate)) {
                    this.moveFooterExpressionToFooterQueryMatchingQRDLevel(environment, rqpQuery, item, aggregate, groupingItems, false);
                } else {
                    this.moveFooterExpressionToFooterQueryMatchingQRDLevel(environment, rqpQuery, item, aggregate, groupingItems, true);
                }
            }
            if (!ExpressionAnalyzer.isAnalyticOrRunningMovingFunction(aggregate) || (analyticFunctionOperand = ExpressionAnalyzer.getStdAggregateOperandOfAnalyticFunction(aggregate)) == null) continue;
            if (analyticFunctionOperand.getRollupAggregateNode() && ExpressionAnalyzer.isStandardAggregateWithAutoForClause(analyticFunctionOperand)) {
                this.moveFooterExpressionToFooterQueryMatchingQRDLevel(environment, rqpQuery, item, aggregate, groupingItems, true);
                continue;
            }
            this.moveFooterExpressionToSummaryQueryMatchingOperandForClause(environment, rqpQuery, item, aggregate, analyticFunctionOperand);
        }
    }

    private boolean analyticOrRMFunctionWithDefaultScopeAndSummaryFilter(PlanningEnvironment environment, RQPQuery rqpQuery, RQPDataItem item, V5AggregateFunction aggregate, List<V5DataItem> groupingItems) {
        return (ExpressionAnalyzer.isAnalyticFunction(aggregate) || ExpressionAnalyzer.isRunningMovingFunction(aggregate)) && rqpQuery.getRQPSummaryFilterList() != null && this.footerQueryOfLevelIsDefaultSummaryQuery(environment, rqpQuery, item, aggregate, groupingItems);
    }

    private boolean footerQueryOfLevelIsDefaultSummaryQuery(PlanningEnvironment environment, RQPQuery rqpQuery, RQPDataItem item, V5AggregateFunction aggregate, List<V5DataItem> groupingItems) {
        V5ValueSet v5ValueSetOfItem = item.getRollupScope();
        RQPSummaryQuery footerQuery = this.getFooterQueryOfLevel(environment, rqpQuery, v5ValueSetOfItem, groupingItems, true);
        return footerQuery == rqpQuery.getDefaultSummaryQuery();
    }

    private void moveFooterExpressionToFooterQueryMatchingQRDLevel(PlanningEnvironment environment, RQPQuery rqpQuery, RQPDataItem item, V5AggregateFunction aggregate, List<V5DataItem> groupingItems, boolean searchSummaryQueries) {
        V5ValueSet v5ValueSetOfItem = item.getRollupScope();
        RQPSummaryQuery footerQuery = this.getFooterQueryOfLevel(environment, rqpQuery, v5ValueSetOfItem, groupingItems, searchSummaryQueries);
        MoveGroupingItemsToSubQuery.createRQPDataItemInSubQueryAndRefInParentQuery(environment, footerQuery, aggregate, item.getName(), false);
    }

    private void moveFooterExpressionToSummaryQueryMatchingOperandForClause(PlanningEnvironment environment, RQPQuery rqpQuery, RQPDataItem item, V5AggregateFunction aggregate, V5AggregateFunction analyticFunctionOperand) {
        V5AggregateBreakClause forClause;
        RQPQuery summaryQuery = RQPSummaryQuery.getSummaryQueryMatchingAggregateForClause(environment, analyticFunctionOperand, new int[]{801024});
        MoveGroupingItemsToSubQuery.createRQPDataItemInSubQueryAndRefInParentQuery(environment, summaryQuery, aggregate, item.getName(), true);
        if (ExpressionAnalyzer.isStandardAggregate(analyticFunctionOperand) && analyticFunctionOperand.getRollupAggregateNode() && (forClause = analyticFunctionOperand.getForClause()) != null) {
            forClause.detach();
        }
    }

    private boolean needToBeMovedToFooterQuery(PlanningEnvironment environment, RQPQuery rqpQuery, RQPDataItem item, List<V5DataItem> groupingItems) {
        List<IXQEQueryNode> outermostAggs = ExpressionAnalyzer.getOutermostAggregates(item);
        if (outermostAggs.size() == 0) {
            return false;
        }
        boolean needToGenerateExplicitForClauseOnRollupAggs = false;
        for (IXQEQueryNode outermostAgg : outermostAggs) {
            V5AggregateFunction operand;
            IXQEQueryNode[] aggregates = ExpressionAnalyzer.getAggregateNodes(outermostAgg);
            for (int i = 0; i < aggregates.length; ++i) {
                V5AggregateFunction aggregate = (V5AggregateFunction)aggregates[i];
                if (this.analyticOrRMFunctionWithDefaultScopeAndSummaryFilter(environment, rqpQuery, item, aggregate, groupingItems)) {
                    item.setPropertyValue("containsAnalyticOrRunningMovingWithDefaultScopeAndSummaryFilter", true);
                    return false;
                }
                if (aggregate == outermostAgg || !ExpressionAnalyzer.isStandardAggregate(aggregate) || !ExpressionAnalyzer.isStandardAggregate(outermostAgg) || !this.nestedAggregateAtHigherScope((V5AggregateFunction)outermostAgg, aggregate, environment)) continue;
                needToGenerateExplicitForClauseOnRollupAggs = true;
                break;
            }
            if (needToGenerateExplicitForClauseOnRollupAggs) break;
            if (ExpressionAnalyzer.isAnalyticOrRunningMovingFunction(outermostAgg) && (operand = ExpressionAnalyzer.getStdAggregateOperandOfAnalyticFunction(outermostAgg)) != null && (operand.getRollupAggregateNode() || operand.getForClause() != null)) {
                return true;
            }
            if (ExpressionAnalyzer.isRollupAggregateNode(outermostAgg)) continue;
            return false;
        }
        if (needToGenerateExplicitForClauseOnRollupAggs) {
            for (IXQEQueryNode outermostAgg : outermostAggs) {
                List<RQPDataItem> rqpGroupingItems = DistributeProjectionsInFactQueries.convertListV5DataItemToListRQPDataItem(rqpQuery, groupingItems);
                List<IXQEQueryNode> rollupAggregates = ExpressionAnalyzer.getRollupAggregates(outermostAgg);
                for (IXQEQueryNode rollupAggregate : rollupAggregates) {
                    rollupAggregate.removeProperty("rollupAggregateNode");
                    DistributeProjectionsInFactQueries.addForClause(environment, (V5AggregateFunction)rollupAggregate, rqpGroupingItems);
                }
            }
        }
        return true;
    }

    private boolean nestedAggregateAtHigherScope(V5AggregateFunction outerAggregate, V5AggregateFunction nestedAggregate, PlanningEnvironment environment) {
        IXQEQueryNode[] outerGroupingItems = DetectNoOpAggregates.getScope(outerAggregate, environment);
        IXQEQueryNode[] innerGroupingItems = DetectNoOpAggregates.getScope(nestedAggregate, environment);
        if (!(innerGroupingItems != null && innerGroupingItems.length != 0 || outerGroupingItems != null && outerGroupingItems.length != 0)) {
            return false;
        }
        if (innerGroupingItems == null || innerGroupingItems.length == 0) {
            return true;
        }
        if (outerGroupingItems == null || outerGroupingItems.length == 0) {
            return false;
        }
        if (outerGroupingItems.length == innerGroupingItems.length) {
            for (IXQEQueryNode oScope : outerGroupingItems) {
                boolean same = false;
                for (IXQEQueryNode iScope : innerGroupingItems) {
                    if (!oScope.isSameExpression(iScope, true)) continue;
                    same = true;
                }
                if (!same) continue;
            }
            return false;
        }
        return RQPSummaryQuery.groupingItemsAreSubsetOf(innerGroupingItems, outerGroupingItems);
    }

    private RQPSummaryQuery getFooterQueryOfLevel(PlanningEnvironment environment, RQPQuery rqpQuery, V5ValueSet valueSet, List<V5DataItem> groupingItems, boolean searchSummaryQueries) {
        IXQEQueryNode subQueryList = rqpQuery.getSubqueryList();
        for (IXQEQueryNode subQuery : subQueryList.getChildren()) {
            RQPFooterQuery footerQuery;
            if (subQuery.getType() != 801012 || (footerQuery = (RQPFooterQuery)subQuery).getV5ValueSet() != valueSet) continue;
            return footerQuery;
        }
        RQPQuery summaryQuery = null;
        if (searchSummaryQueries) {
            IXQEQueryNode[] gpItems = new IXQEQueryNode[groupingItems.size()];
            for (int i = 0; i < groupingItems.size(); ++i) {
                V5DataItem valueSetRefDataItem = groupingItems.get(i);
                gpItems[i] = valueSetRefDataItem.isAggregate() && rqpQuery.isAutoSummaryTRUE() && (RQPUtilities.containsAnalyticOrMovingRunningOnDetailExpr(valueSetRefDataItem) || valueSetRefDataItem.isAggregate("calculated")) ? valueSetRefDataItem.getAggregateExpression() : valueSetRefDataItem.getDetailExpression();
            }
            summaryQuery = RQPSummaryQuery.getSummaryQueryMatchingGroupingItems(rqpQuery, gpItems, new int[]{801024}, environment);
        }
        if (summaryQuery == null) {
            return RQPFooterQuery.create(environment, rqpQuery, groupingItems, valueSet);
        }
        return (RQPSummaryQuery)summaryQuery;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] projections;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode parentQuery = node.getParent();
        if (parentQuery.getType() != 801017) {
            this.traceNodeCondition(false, "The parent query is not the main query", trace);
            return false;
        }
        if (((RQPQuery)parentQuery).isMultiFactQuery() || ((RQPQuery)parentQuery).isBridgeWrapperQuery()) {
            this.traceNodeCondition(false, "The RQPDataItem node is under a multi-fact RQP query", trace);
            return false;
        }
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        HashMap<V5ValueSet, List<V5DataItem>> footerScopes = this.getGroupingItemsOfEachValueSetLevel(rqpQuery);
        for (IXQEQueryNode child : projections = node.getChildren()) {
            List<V5DataItem> footerScope;
            RQPDataItem item = (RQPDataItem)child;
            if (!item.isFooterHeaderItem() && !item.isGroupBodyItemOfNonLastValueSet() || item.hasDescendantOfType(801009, false) || !this.needToBeMovedToFooterQuery(environment, rqpQuery, item, footerScope = footerScopes.get(item.getRollupScope()))) continue;
            this.traceNodeCondition(true, "There are footer items that need to be moved to the footer query", trace);
            return true;
        }
        this.traceNodeCondition(false, "There are no footer items that need to be moved to the footer query", trace);
        return false;
    }
}

