/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPFooterQuery;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class MoveRollupExprsHavingOnlyRefItems
extends RQPTransformation {
    public MoveRollupExprsHavingOnlyRefItems() {
        this.mName = "Move rollup expressions having only references to tabular or summary query.";
        this.mPassNumbers = new int[]{68};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
        this.mTypes = new int[]{801012};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPFooterQuery footerQuery = (RQPFooterQuery)node;
        List<IXQEQueryNode> footerItems = footerQuery.getRollupsHavingOnlyRefItemsProperty();
        for (IXQEQueryNode f : footerItems) {
            RQPDataItem footerItem = (RQPDataItem)f;
            footerItem.updateReferencesWithExpression(environment, footerItem.getExpression());
            footerItem.detach();
        }
        RQPProjectionList projectionList = (RQPProjectionList)footerQuery.getFirstChildByType(801016);
        if (projectionList.getNumberChildren() == 0) {
            footerQuery.detach();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        RQPFooterQuery footerQuery = (RQPFooterQuery)node;
        List<IXQEQueryNode> refItems = footerQuery.getRollupsHavingOnlyRefItems();
        if (refItems.size() == 0) {
            this.traceNodeCondition(false, "The footer query does not have any rollup expressions to be moved to the outermost query.", xqeTrace);
            return false;
        }
        footerQuery.setRollupsHavingOnlyRefItemsProperty(refItems);
        this.traceNodeCondition(true, "The footer query has rollup expressions to be moved to the outermost query.", xqeTrace);
        return true;
    }
}

