/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSortItem;
import com.cognos.xqe.ast.rqp.RQPSortList;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5GroupFooter;
import com.cognos.xqe.ast.v5.result.V5GroupHeader;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IFacet;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.AggregateExpressionBuilder;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.symboltable.SymbolTableForQS;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserSortItem;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class ProcessDataItemRefInValueSet
extends RQPTransformation {
    protected boolean bJoinGraph = false;

    public ProcessDataItemRefInValueSet() {
        this.mName = "ProcessDataItemRefInValueSet";
        this.mPassNumbers = new int[]{11};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode gf;
        IXQEQueryNode gh;
        IXQEQueryNode gb;
        if (this.bJoinGraph) {
            IXQEQueryNode gb2 = node.getFirstChildByType(101051);
            if (gb2 != null) {
                this.processGroupBody(gb2, environment, true);
            }
            return;
        }
        V5ValueSet valueSet = (V5ValueSet)node;
        RQPQuery rootQuery = (RQPQuery)valueSet.getAncestorOfType(801017);
        V5Edge v5Edge = (V5Edge)valueSet.getAncestorOfType(101049);
        List<IXQEQueryNode> ancestorValueSets = v5Edge.getDescendantsOfTypeOrdered(101057, false);
        V5ValueSet lastValueSet = (V5ValueSet)ancestorValueSets.get(ancestorValueSets.size() - 1);
        boolean isLastValueSet = valueSet == lastValueSet;
        String refDataItem = valueSet.getRefDataItemProperty();
        V5Query query = rootQuery.getRefV5Query();
        if (query != null && query.getPropertyValue("sourceModule") != null) {
            rootQuery.setPropertyValue("sourceModule", true);
        }
        if (refDataItem != null) {
            this.processValueSetRefDataItem(environment, valueSet, isLastValueSet, rootQuery, refDataItem);
        }
        if ((gb = node.getFirstChildByType(101051)) != null) {
            this.processGroupBody(gb, environment, isLastValueSet);
        }
        if ((gh = node.getFirstChildByType(101053)) != null) {
            this.processGroupHeaderFooter(gh, environment);
        }
        if ((gf = node.getFirstChildByType(101052)) != null) {
            this.processGroupHeaderFooter(gf, environment);
        }
    }

    private void processValueSetRefDataItem(PlanningEnvironment environment, V5ValueSet valueSet, boolean isLastValueSet, RQPQuery rootQuery, String refDataItem) {
        V5DataItem v5DataItem = rootQuery.getRefV5Query().getV5Selection().getDataItemByRefName(refDataItem);
        RQPDataItem rqpDI = this.createGroupingItemInRootQuery(environment, rootQuery, refDataItem, v5DataItem);
        rqpDI.setValueSetRefDataItem(true);
        rqpDI.setValueSet(valueSet);
        if (isLastValueSet) {
            rqpDI.setBelongsToLastValueSet(true);
        }
        this.addFormat(valueSet, v5DataItem, rqpDI);
        rootQuery.registerRowsetNameAndColumnName(environment, (String)valueSet.getPropertyValue("name"), refDataItem);
        this.processSort(rootQuery, v5DataItem, valueSet, rqpDI, environment);
    }

    private RQPDataItem createGroupingItemInRootQuery(PlanningEnvironment environment, RQPQuery rootQuery, String preferredName, V5DataItem v5DataItem) {
        IXQEQueryNode itemExpr = null;
        itemExpr = v5DataItem.isAggregate() && rootQuery.isAutoSummaryTRUE() ? environment.getNodeFactory().deepCopyNode(v5DataItem.getAggregateExpression(environment)) : environment.getNodeFactory().deepCopyNode(v5DataItem.getDetailContext(environment));
        RQPDataItem rqpDataItemInRQ = rootQuery.createRQPDataItem(environment, preferredName);
        rqpDataItemInRQ.addChild(itemExpr);
        rqpDataItemInRQ.setGroupingItem(true);
        String sortAttribute = (String)v5DataItem.getPropertyValue("sort");
        if (sortAttribute != null) {
            rqpDataItemInRQ.setExplicitSort();
            if (sortAttribute.equals("descending")) {
                rqpDataItemInRQ.setDescending();
            }
        }
        return rqpDataItemInRQ;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processSort(RQPQuery rootQuery, V5DataItem v5DataItem, V5ValueSet valueSet, RQPDataItem rqpDataItem, PlanningEnvironment environment) {
        String refDataItem;
        String rqpDataItemName = rqpDataItem.getName();
        if (rootQuery.getParent() != null && rootQuery.getParent().getType() == 101006) {
            String sortValue = (String)v5DataItem.getPropertyValue("sort");
            if (sortValue == null || !sortValue.equals("descending")) return;
            rqpDataItem.setDescending();
            return;
        }
        String sort = (String)v5DataItem.getPropertyValue("sort");
        if (sort != null && !sort.equalsIgnoreCase("none")) {
            if (RQPUtilities.hasMovingRunningInExpression(v5DataItem)) {
                String nagMsg = XQEMessages.getMessage(XQEMessageKeys.WRN_NoSortForRunningMovingAggregates, XQEMessages.getCurrProductLocale());
                ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(nagMsg);
            } else {
                RQPSortItem sortItem = RQPSortItem.create(environment, rqpDataItemName, sort);
                sortItem.setPropertyValue("explicitSort", "true");
                sortItem.setValueSetNameProperty(valueSet.getNameProperty());
                rootQuery.addToSortList(environment, sortItem);
                return;
            }
        }
        if ((refDataItem = valueSet.getRefDataItemProperty()) != null) {
            if (RQPUtilities.hasMovingRunningInExpression(v5DataItem)) {
                ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(XQEMessageKeys.WRN_NoSortForRunningMovingAggregates.toString());
                return;
            }
            if (!refDataItem.equals(v5DataItem.getNameProperty())) return;
            Governors.AutoSort autoSort = rootQuery.getGovernors().getAutoSort();
            if (autoSort.equals((Object)Governors.AutoSort.NONE)) {
                if (!rootQuery.v5ProjectionHasMovingOrRunning()) return;
                autoSort = Governors.AutoSort.MINIMAL;
            }
            List<IXQEQueryNode> valueSets = rootQuery.getDescendantsOfTypeOrdered(101057, false);
            int lastValueSet = valueSets.size();
            if (autoSort.equals((Object)Governors.AutoSort.MINIMAL)) {
                if (this.createSortItemBasedOnFacetInfo(rootQuery, v5DataItem, valueSet, rqpDataItemName, environment, refDataItem)) {
                    return;
                }
                if (lastValueSet == valueSet.getDepth()) {
                    return;
                }
            }
        } else {
            if (!rootQuery.isAutoSummaryTRUE()) {
                return;
            }
            if (this.createSortItemBasedOnFacetInfo(rootQuery, v5DataItem, valueSet, rqpDataItemName, environment, refDataItem)) {
                return;
            }
            if (!RQPUtilities.isAutoSortItem(v5DataItem)) {
                return;
            }
            Governors.AutoSort autoSort = rootQuery.getGovernors().getAutoSort();
            if (!autoSort.equals((Object)Governors.AutoSort.ALL) && !rootQuery.v5ProjectionHasMovingOrRunning()) {
                return;
            }
        }
        this.createSortItem(rootQuery, valueSet, rqpDataItemName, environment, refDataItem, "ascending");
    }

    private boolean createSortItemBasedOnFacetInfo(RQPQuery rootQuery, V5DataItem v5DataItem, V5ValueSet valueSet, String rqpDataItemName, PlanningEnvironment environment, String refDataItem) {
        IXQEQueryNode expression = v5DataItem.getChild(0);
        if (expression == null || expression.getType() != 201116) {
            return false;
        }
        IMetadata exprMd = ((V5BoundModelIdentifier)expression).getMetadata();
        if (!(exprMd instanceof MoserQueryItem)) {
            return false;
        }
        MoserQueryItem qi = (MoserQueryItem)exprMd;
        IFacet facet = qi.getFacet();
        if (facet == null) {
            return false;
        }
        if (!facet.isExplicitlySetByModeler()) {
            return false;
        }
        boolean nullable = qi.isNullable();
        ISortItem[] sortItems = facet.getSortItems();
        IXQEQueryNode v5SortItem = this.getMatchingSortItem(valueSet, rqpDataItemName);
        for (ISortItem si : sortItems) {
            RQPDataItem refDi;
            MoserSortItem sortItem = (MoserSortItem)si;
            String ref = sortItem.getRefObject();
            String sortDirection = "ascending";
            if (v5SortItem == null) {
                if (sortItem.getSort() != null) {
                    sortDirection = sortItem.getSort().toString();
                }
            } else {
                sortDirection = v5SortItem.getPropertyValue("sortOrder").toString();
            }
            ISortItem.NullPlacementType nullPlace = sortItem.getNullPlacement();
            if (v5SortItem != null) {
                if (nullPlace == null || nullPlace == ISortItem.NullPlacementType.NULL_LAST) {
                    v5SortItem.setPropertyValue("nullPlace", "last");
                } else if (nullPlace == ISortItem.NullPlacementType.NULL_FIRST) {
                    v5SortItem.setPropertyValue("nullPlace", "first");
                }
            }
            if (ref == null) continue;
            String[] parts = ref.split("\\.");
            String refName = ref;
            if (parts.length > 1) {
                refName = parts[parts.length - 1];
            }
            if (refName.equals(exprMd.getName())) {
                RQPSortItem rqpSortItem = this.createSortItem(rootQuery, valueSet, rqpDataItemName, environment, refDataItem, sortDirection);
                if (rqpSortItem != null) {
                    rqpSortItem.setSortOrder(sortDirection);
                }
                if (!nullable) {
                    nullPlace = null;
                }
                this.setNullsPlacement(rqpSortItem, nullPlace);
                continue;
            }
            V5BoundModelIdentifier mi = this.bindSortReference(environment, ref, qi.getQuerySubject(), sortItem.isResolvedReference());
            if (mi == null) continue;
            if (mi.getMetadata() instanceof MoserQueryItem && !(nullable = ((MoserQueryItem)mi.getMetadata()).isNullable())) {
                nullPlace = null;
            }
            if ((refDi = rootQuery.getRQPDataItemWithSameExpression(mi)) != null) {
                RQPSortItem rqpSortItem = this.createSortItem(rootQuery, valueSet, refDi.getName(), environment, refDataItem, sortDirection);
                this.setNullsPlacement(rqpSortItem, nullPlace);
                continue;
            }
            if (v5SortItem == null) {
                this.createGroupSortItem(rootQuery, valueSet, environment, mi, refName, sortDirection, nullPlace);
                continue;
            }
            this.adjustGroupSortItem(rootQuery, environment, mi, refName, sortDirection, nullPlace, v5SortItem);
        }
        return true;
    }

    private IXQEQueryNode getMatchingSortItem(V5ValueSet valueSet, String rqpDataItemName) {
        List<IXQEQueryNode> v5SortItems = valueSet.getDescendantsOfTypeOrdered(101056, false);
        if (v5SortItems.isEmpty()) {
            return null;
        }
        for (IXQEQueryNode sortItem : v5SortItems) {
            String refDataItem = (String)sortItem.getPropertyValue("refDataItem");
            if (refDataItem == null || !refDataItem.equals(rqpDataItemName)) continue;
            return sortItem;
        }
        return null;
    }

    private void setNullsPlacement(RQPSortItem rqpSortItem, ISortItem.NullPlacementType nullPlace) {
        if (rqpSortItem == null || nullPlace == null) {
            return;
        }
        if (nullPlace == ISortItem.NullPlacementType.NULL_LAST) {
            rqpSortItem.setPropertyValue("nullOrdering", (Object)SQLSortKey.NullOrdering.NULLS_LAST);
        } else if (nullPlace == ISortItem.NullPlacementType.NULL_FIRST) {
            rqpSortItem.setPropertyValue("nullOrdering", (Object)SQLSortKey.NullOrdering.NULLS_FIRST);
        }
    }

    private void createGroupSortItem(RQPQuery rootQuery, V5ValueSet valueSet, PlanningEnvironment environment, V5BoundModelIdentifier mi, String refName, String sortDirection, ISortItem.NullPlacementType nullPlace) {
        V5Query query = rootQuery.getRefV5Query();
        V5Selection selection = query.getV5Selection();
        V5DataItem newDataItem = selection.getDataItemByExpression(mi);
        if (newDataItem == null) {
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            newDataItem = (V5DataItem)environment.getNodeFactory().createNode(101003);
            selection.addChild(newDataItem);
            newDataItem.setPropertyValue("name", refName);
            newDataItem.addChild(mi);
            if (config.getBooleanProperty("queryPlanning.generateMinOnFacetSortItem[@enabled]", true)) {
                newDataItem.setAggregateProperty("minimum");
            } else {
                newDataItem.setAggregateProperty("none");
            }
            newDataItem.setRollupAggregateProperty("none");
            newDataItem.setDetailContext(mi);
            AggregateExpressionBuilder b = new AggregateExpressionBuilder(environment);
            newDataItem.setAggregateExpression(b.generateAggregateExpression("none", mi));
        }
        V5SortItem sortItem = (V5SortItem)environment.getNodeFactory().createNode(101056);
        valueSet.addChild(sortItem);
        String dataItemName = (String)newDataItem.getPropertyValue("name");
        sortItem.setPropertyValue("refDataItem", dataItemName);
        sortItem.setStringPropertyValue("sortOrder", sortDirection);
        if (nullPlace == ISortItem.NullPlacementType.NULL_LAST) {
            sortItem.setPropertyValue("nullPlace", "last");
        } else if (nullPlace == ISortItem.NullPlacementType.NULL_FIRST) {
            sortItem.setPropertyValue("nullPlace", "first");
        }
    }

    private void adjustGroupSortItem(RQPQuery rootQuery, PlanningEnvironment environment, V5BoundModelIdentifier mi, String refName, String sortDirection, ISortItem.NullPlacementType nullPlace, IXQEQueryNode v5SortItem) {
        V5Query query = rootQuery.getRefV5Query();
        V5Selection selection = query.getV5Selection();
        V5DataItem newDataItem = selection.getDataItemByExpression(mi);
        if (newDataItem == null) {
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            newDataItem = (V5DataItem)environment.getNodeFactory().createNode(101003);
            selection.addChild(newDataItem);
            newDataItem.setPropertyValue("name", refName);
            newDataItem.addChild(mi);
            if (config.getBooleanProperty("queryPlanning.generateMinOnFacetSortItem[@enabled]", true)) {
                newDataItem.setAggregateProperty("minimum");
            } else {
                newDataItem.setAggregateProperty("none");
            }
            newDataItem.setRollupAggregateProperty("none");
            newDataItem.setDetailContext(mi);
            AggregateExpressionBuilder b = new AggregateExpressionBuilder(environment);
            newDataItem.setAggregateExpression(b.generateAggregateExpression("none", mi));
        }
        String dataItemName = (String)newDataItem.getPropertyValue("name");
        v5SortItem.setPropertyValue("refDataItem", dataItemName);
        v5SortItem.setPropertyValue("sortOrder", sortDirection);
        if (nullPlace == ISortItem.NullPlacementType.NULL_LAST) {
            v5SortItem.setPropertyValue("nullPlace", "last");
        } else if (nullPlace == ISortItem.NullPlacementType.NULL_FIRST) {
            v5SortItem.setPropertyValue("nullPlace", "first");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V5BoundModelIdentifier bindSortReference(PlanningEnvironment environment, String ref, IQuerySubject qs, boolean isResolved) {
        IMetadata sortMetadata = null;
        if (!isResolved) {
            try {
                environment.pushSymbolTable(new SymbolTableForQS(qs, null, true));
                sortMetadata = environment.bindMetadataReference(ref);
            }
            finally {
                environment.popSymbolTable();
            }
        } else {
            sortMetadata = environment.getMetadataConnection().bindMetadataReference(ref);
        }
        if (sortMetadata == null) {
            return null;
        }
        V5BoundModelIdentifier mi = (V5BoundModelIdentifier)environment.getNodeFactory().createNode(201116);
        mi.setMetadata(sortMetadata);
        mi.setIsUnwound();
        mi.setIdentifier(sortMetadata.getUniqueID());
        return mi;
    }

    private RQPSortItem createSortItem(RQPQuery rootQuery, V5ValueSet valueSet, String rqpDataItemName, PlanningEnvironment environment, String refDataItem, String sortDirection) {
        if (!this.existSortItem(valueSet, rqpDataItemName, rootQuery)) {
            RQPSortItem rqpSortItem = RQPSortItem.create(environment, rqpDataItemName, sortDirection);
            rqpSortItem.setValueSetNameProperty(valueSet.getNameProperty());
            if (refDataItem != null) {
                rqpSortItem.setPropertyValue("levelKey", true);
            }
            rootQuery.addToSortList(environment, rqpSortItem);
            return rqpSortItem;
        }
        return null;
    }

    private boolean existSortItem(V5ValueSet valueSet, String rqpDataItemName, RQPQuery rootQuery) {
        IXQEQueryNode[] sortItems;
        for (IXQEQueryNode sort : sortItems = valueSet.getChildrenOfType(101056)) {
            if (!((V5SortItem)sort).getRefDataItem().equals(rqpDataItemName)) continue;
            return true;
        }
        RQPSortList rqpSortList = (RQPSortList)rootQuery.getFirstChildByType(801020);
        if (rqpSortList == null) {
            return false;
        }
        for (IXQEQueryNode sort : rqpSortList.getChildren()) {
            RQPDataItemSelfRef rqpDataItemSelfRef = (RQPDataItemSelfRef)sort.getChild(0);
            if (!rqpDataItemSelfRef.getRefProjection().getName().equals(rqpDataItemName)) continue;
            return true;
        }
        return false;
    }

    private void processGroupBody(IXQEQueryNode gb, PlanningEnvironment environment, boolean isLastValueSet) {
        V5ValueSet v5ValueSet = (V5ValueSet)gb.getParent();
        RQPQuery rootQuery = RQPQuery.getRQPQuery(v5ValueSet).getRootRQPQuery();
        V5Selection v5Selection = null;
        V5ValueSet nestedValueSet = null;
        IXQEQueryNode projs = null;
        if (!this.bJoinGraph) {
            v5Selection = rootQuery.getRefV5Query().getV5Selection();
            nestedValueSet = RQPUtilities.getNestedValueSet(rootQuery, v5ValueSet);
        } else {
            projs = environment.getNodeFactory().createNode(801016);
            rootQuery.addChild(projs);
        }
        for (int i = 0; i < gb.getNumberChildren(); ++i) {
            String rollupAggregate;
            V5DataItemRef v5DataItemRef = (V5DataItemRef)gb.getChild(i);
            V5DataItem v5DataItem = null;
            v5DataItem = !this.bJoinGraph ? v5Selection.getDataItemByRefName(v5DataItemRef.getDataItemRefProperty()) : (V5DataItem)v5DataItemRef.getPropertyValue("refDI");
            RQPDataItem rqpDataItemInRQ = null;
            if (this.bJoinGraph) {
                rqpDataItemInRQ = (RQPDataItem)environment.getNodeFactory().createNode(801008);
                rqpDataItemInRQ.setName(v5DataItem.getNameProperty());
                IXQEQueryNode detailExpr = (IXQEQueryNode)v5DataItem.getPropertyValue("detailContext");
                rqpDataItemInRQ.addChild(detailExpr);
                projs.addChild(rqpDataItemInRQ);
                continue;
            }
            if (rootQuery.isAutoSummaryTRUE()) {
                if (isLastValueSet) {
                    if (v5DataItem.isGroupingItem()) {
                        rqpDataItemInRQ = this.createGroupingItemInRootQuery(environment, rootQuery, v5DataItem.getNameProperty(), v5DataItem);
                    } else {
                        rqpDataItemInRQ = rootQuery.createRQPDataItem(environment, v5DataItem.getNameProperty());
                        rqpDataItemInRQ.addChild(environment.getNodeFactory().deepCopyNode(v5DataItemRef));
                        Boolean b = (Boolean)v5DataItem.getPropertyValue("lookup");
                        if (b != null) {
                            rqpDataItemInRQ.setPropertyValue("lookup", b);
                        }
                    }
                    rqpDataItemInRQ.setBelongsToLastValueSet(true);
                } else {
                    rqpDataItemInRQ = rootQuery.createRQPDataItem(environment, v5DataItem.getNameProperty());
                    rqpDataItemInRQ.addChild(environment.getNodeFactory().deepCopyNode(v5DataItemRef));
                    rqpDataItemInRQ.setNestedValueSet(nestedValueSet);
                }
            } else {
                rqpDataItemInRQ = rootQuery.createRQPDataItem(environment, v5DataItem.getNameProperty());
                Object loc = v5DataItem.getPropertyValue("moduleLocation");
                if (loc != null) {
                    rqpDataItemInRQ.setPropertyValue("moduleLocation", loc);
                }
                IXQEQueryNode detailExpr = v5DataItem.getDetailContext(environment);
                if (isLastValueSet) {
                    rqpDataItemInRQ.addChild(detailExpr);
                    rqpDataItemInRQ.setBelongsToLastValueSet(true);
                } else {
                    rqpDataItemInRQ.addChild(environment.getNodeFactory().deepCopyNode(v5DataItemRef));
                    rqpDataItemInRQ.setNestedValueSet(nestedValueSet);
                }
            }
            rqpDataItemInRQ.setValueSet(v5ValueSet);
            List groupingItems = (List)v5DataItem.getPropertyValue("rollupGroupingItems");
            if (groupingItems != null) {
                rqpDataItemInRQ.setPropertyValue("rollupGroupingItems", groupingItems);
            }
            if (v5DataItem.getPropIsRollupExpression() && ((rollupAggregate = v5DataItem.getRollupAggregateProperty()) == null || rollupAggregate.equals("automatic") || rollupAggregate.equals("none"))) {
                rqpDataItemInRQ.setAutomaticRollup(true);
            }
            rqpDataItemInRQ.setPropIsRollupExpression(v5DataItem.getPropIsRollupExpression());
            if (v5DataItem.getCastDataType() != null) {
                IDataType dataType = v5DataItem.getCastDataType();
                rqpDataItemInRQ.setCastDataType(dataType);
            }
            this.addFormat(v5DataItemRef, v5DataItem, rqpDataItemInRQ);
            String aggr = v5DataItem.getAggregateProperty();
            if (!"count".equals(aggr) && !"countDistinct".equals(aggr)) {
                this.addCurrency(v5DataItemRef, v5DataItem, environment);
            }
            this.processSort(rootQuery, v5DataItem, v5ValueSet, rqpDataItemInRQ, environment);
            rootQuery.registerRowsetNameAndColumnName(environment, v5ValueSet.getNameProperty(), v5DataItem.getNameProperty());
        }
    }

    private void addCurrency(IXQEQueryNode v5DataItemRef, V5DataItem v5DataItem, PlanningEnvironment environment) {
        RSAPIDataItem rsapiDataItem;
        String currency = this.getCurrency(v5DataItem.getDetailExpression(), environment);
        if (currency != null && (rsapiDataItem = (RSAPIDataItem)v5DataItemRef.getPropertyValue("RSAPIRefDataItem")) != null) {
            rsapiDataItem.setCurrencyCode(currency);
        }
    }

    private String getCurrency(IXQEQueryNode expression, PlanningEnvironment environment) {
        String currency = null;
        block0 : switch (expression.getType()) {
            case 201030: {
                V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)environment.getNodeFactory().createNode(201116);
                MetadataConnection mc = environment.getMetadataConnection();
                String identifier = ((V5MultiPartIdentifier)expression).getIdentifier();
                newNode.setMetadata(mc.bindMetadataReference(identifier));
                newNode.setIdentifier(identifier);
                currency = this.getCurrencyProperty(newNode);
                newNode.detach();
                break;
            }
            case 201116: {
                currency = this.getCurrencyProperty((V5BoundModelIdentifier)expression);
                break;
            }
            case 201060: {
                V5BoundDataItemReference diRef = (V5BoundDataItemReference)expression;
                currency = (String)diRef.getRefDataItem().getPropertyValue("currency");
                if (currency != null) break;
                currency = this.getCurrency(diRef.getRefDataItem().getDetailExpression(), environment);
                break;
            }
            case 201031: 
            case 201035: {
                switch (((V5AggregateFunction)expression).getSubType()) {
                    case 1: 
                    case 4: 
                    case 6: 
                    case 9: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        currency = this.getCurrency(expression.getChild(0), environment);
                        break block0;
                    }
                }
            }
        }
        return currency;
    }

    private String getCurrencyProperty(V5BoundModelIdentifier v5Id) {
        String currency = null;
        if (v5Id.isQueryItem()) {
            currency = ((IQueryItem)v5Id.getMetadata()).getCurrency();
        } else if (v5Id.isCalculation()) {
            currency = ((ICalculation)v5Id.getMetadata()).getCurrency();
        }
        return currency;
    }

    private void addFormat(IXQEQueryNode v5DataItemRef, V5DataItem v5DataItem, RQPDataItem rqpDataItemInRQ) {
        String format = (String)v5DataItem.getPropertyValue("customFormat");
        if (format == null) {
            rqpDataItemInRQ.setPropertyValue("RSAPIRefDataItem", v5DataItemRef.getPropertyValue("RSAPIRefDataItem"));
        } else {
            RSAPIDataItem rsapiDataItem = (RSAPIDataItem)v5DataItemRef.getPropertyValue("RSAPIRefDataItem");
            if (rsapiDataItem != null) {
                RQPUtilities.setFormatOfRSAPIDataItem(format, rsapiDataItem, rqpDataItemInRQ);
            }
        }
    }

    private void processGroupHeaderFooter(IXQEQueryNode gf, PlanningEnvironment environment) {
        RQPQuery rootQuery = RQPQuery.getRQPQuery(gf).getParentRQPQuery();
        IXQEQueryNode v5ValueSet = gf.getParent();
        this.processGroupHeaderFooterChildren(environment, rootQuery, gf, (V5ValueSet)v5ValueSet);
    }

    public static List<V5DataItem> getGroupingItems(IXQEQueryNode v5ValueSet, RQPQuery rootQuery, boolean isForFooter) {
        V5Edge v5Edge = (V5Edge)v5ValueSet.getAncestorOfType(101049);
        List<IXQEQueryNode> ancestorValueSets = v5Edge.getDescendantsOfTypeOrdered(101057, false);
        LinkedHashSet<V5DataItem> groupingColumns = new LinkedHashSet<V5DataItem>();
        V5Selection v5Selection = rootQuery.getRootRQPQuery().getRefV5Query().getV5Selection();
        for (IXQEQueryNode vs : ancestorValueSets) {
            if (isForFooter && vs == v5ValueSet) break;
            V5ValueSet v5VSet = (V5ValueSet)vs;
            String refDataItem = v5VSet.getRefDataItemProperty();
            if (refDataItem == null || refDataItem.equals("")) continue;
            groupingColumns.add(v5Selection.getDataItemByRefName(refDataItem));
            if (vs != v5ValueSet) continue;
            break;
        }
        if (groupingColumns.size() > 0) {
            return new ArrayList<V5DataItem>(groupingColumns);
        }
        return new ArrayList<V5DataItem>();
    }

    private void processGroupHeaderFooterChildren(PlanningEnvironment environment, RQPQuery rootQuery, IXQEQueryNode v5GroupHeaderFooter, V5ValueSet v5ValueSet) {
        String groupHeaderFooterName = null;
        boolean isHeaderItem = false;
        V5Selection v5Selection = rootQuery.getRefV5Query().getV5Selection();
        if (v5GroupHeaderFooter instanceof V5GroupHeader) {
            groupHeaderFooterName = (String)v5GroupHeaderFooter.getPropertyValue("name");
            isHeaderItem = true;
        } else if (v5GroupHeaderFooter instanceof V5GroupFooter) {
            groupHeaderFooterName = (String)v5GroupHeaderFooter.getPropertyValue("name");
            isHeaderItem = false;
        }
        for (int i = 0; i < v5GroupHeaderFooter.getNumberChildren(); ++i) {
            V5DataItemRef v5DataItemRef = (V5DataItemRef)v5GroupHeaderFooter.getChild(i);
            V5DataItem v5DataItem = v5Selection.getDataItemByRefName(v5DataItemRef.getDataItemRefProperty());
            RQPDataItem rqpDataItemInRQ = rootQuery.createRQPDataItem(environment, v5DataItem.getNameProperty());
            IXQEQueryNode itemExpr = environment.getNodeFactory().deepCopyNode(v5GroupHeaderFooter.getChild(i));
            rqpDataItemInRQ.addChild(itemExpr);
            rqpDataItemInRQ.setFooterLevel(v5ValueSet);
            if (isHeaderItem) {
                rqpDataItemInRQ.setIsHeaderItem(true);
            } else {
                rqpDataItemInRQ.setIsFooterItem(true);
            }
            this.addFormat(v5DataItemRef, v5DataItem, rqpDataItemInRQ);
            rootQuery.registerRowsetNameAndColumnName(environment, groupHeaderFooterName, v5DataItem.getNameProperty());
        }
    }

    public void setUsedByJoinGraph() {
        this.bJoinGraph = true;
    }
}

