/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PullOutFooterProjectionsToApplyRollupAggAfterSummaryFilter
extends RQPTransformation {
    public PullOutFooterProjectionsToApplyRollupAggAfterSummaryFilter() {
        this.mName = "PullOutFooterProjectionsToApplyRollupAggAfterSummaryFilter.";
        this.mPassNumbers = new int[]{122};
        this.mTypes = new int[]{801017};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rootQuery = (RQPQuery)node;
        RQPFactManager factManager = rootQuery.getFactManager();
        List<RQPQuery> factQueries = factManager.getRQPQueriesOriginatedFromRQPFactQueries();
        for (RQPQuery factQuery : factQueries) {
            this.pullOutFooterProjections(environment, rootQuery, factQuery);
        }
        this.removeUnreferencedFooterProjections(rootQuery);
        RQPQuery subQueryForSF = rootQuery.getSubqueryForSummaryFilters();
        this.pullOutFooterProjections(environment, rootQuery, subQueryForSF);
        this.removeUnreferencedFooterProjections(rootQuery);
        rootQuery.setPropertyValue("pullOutFooter", true);
    }

    private void removeUnreferencedFooterProjections(RQPQuery rootQuery) {
        List<IXQEQueryNode> rqpQueries = rootQuery.getDescendantsOfTypeOrdered(801017, false);
        for (IXQEQueryNode node : rqpQueries) {
            RQPQuery rqpQuery = (RQPQuery)node;
            List<RQPDataItem> footerProjections = this.getFooterProjections(rqpQuery);
            ArrayList<RQPDataItem> footersToBeDeleted = new ArrayList<RQPDataItem>();
            for (RQPDataItem footerProjection : footerProjections) {
                if (!this.isNotReferencedInParentQuery(rqpQuery, footerProjection)) continue;
                footersToBeDeleted.add(footerProjection);
            }
            for (RQPDataItem footerProjection : footersToBeDeleted) {
                footerProjection.detach();
            }
        }
    }

    private boolean isNotReferencedInParentQuery(RQPQuery rqpQuery, RQPDataItem footerProjection) {
        int[] listsToCheck;
        RQPQuery parentRQPQuery = RQPNode.getRQPQuery(rqpQuery);
        String footerProjectionName = footerProjection.getName();
        for (int listType : listsToCheck = new int[]{801016, 801011}) {
            IXQEQueryNode list = parentRQPQuery.getFirstChildByType(listType);
            if (list == null) continue;
            for (int i = 0; i < list.getNumberChildren(); ++i) {
                IXQEQueryNode[] refsToSubqueries;
                IXQEQueryNode childNode = list.getChild(i);
                for (IXQEQueryNode r : refsToSubqueries = childNode.getDescendantsOfType(801009, false)) {
                    RQPDataItemRef ref = (RQPDataItemRef)r;
                    if (!ref.getQueryName().equals(rqpQuery.getName()) || !ref.getName().equals(footerProjectionName)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private List<RQPDataItem> getFooterProjections(RQPQuery rootQuery) {
        RQPProjectionList projectionList = rootQuery.getProjectionList();
        IXQEQueryNode[] projections = projectionList.getChildren();
        ArrayList<RQPDataItem> footerProjections = new ArrayList<RQPDataItem>();
        for (IXQEQueryNode child : projections) {
            RQPDataItem projection = (RQPDataItem)child;
            if (!projection.isFooterHeaderItem()) continue;
            footerProjections.add(projection);
        }
        return footerProjections;
    }

    private boolean hasFooterProjections(RQPQuery rootQuery) {
        IXQEQueryNode[] projections;
        RQPProjectionList projectionList = rootQuery.getProjectionList();
        for (IXQEQueryNode child : projections = projectionList.getChildren()) {
            RQPDataItem projection = (RQPDataItem)child;
            if (!projection.isFooterHeaderItem()) continue;
            return true;
        }
        return false;
    }

    private void pullOutFooterProjections(PlanningEnvironment environment, RQPQuery rootQuery, RQPQuery subQuery) {
        List<RQPDataItem> footerProjections = this.getFooterProjections(subQuery);
        List<RQPDataItem> groupingItemsOfMainQuery = rootQuery.getProjectionsMarkedAsGroupingColumns();
        for (RQPDataItem footerProjection : footerProjections) {
            if (!this.dataItemHasAggregateWithHigherScopeThanLowestLevelSummary(footerProjection, groupingItemsOfMainQuery)) continue;
            this.pullOutFooterProjection(environment, rootQuery, footerProjection);
        }
    }

    private void pullOutFooterProjection(PlanningEnvironment environment, RQPQuery rootQuery, RQPDataItem footerProjectionInSubQuery) {
        String footerProjectionName = footerProjectionInSubQuery.getName();
        RQPDataItem footerProjectionInOuterMostQuery = rootQuery.findProjection(footerProjectionName);
        IXQEQueryNode newFooterExpr = this.updateFooterExpression(environment, rootQuery, footerProjectionInSubQuery);
        if (footerProjectionInOuterMostQuery == null || footerProjectionInOuterMostQuery.getPropertyValue("involvesMultiFact") != null) {
            this.updateFooterInvolvingMultiFacts(environment, rootQuery, footerProjectionInSubQuery, newFooterExpr);
        } else {
            footerProjectionInOuterMostQuery.getExpression().detach();
            footerProjectionInOuterMostQuery.addChild(newFooterExpr);
        }
    }

    private void updateFooterInvolvingMultiFacts(PlanningEnvironment environment, RQPQuery rootQuery, RQPDataItem footerInFactQuery, IXQEQueryNode newExpr) {
        RQPDataItemRef diRef = RQPDataItemRef.create(environment, footerInFactQuery);
        RQPQuery subqueryForSummaryFilter = rootQuery.getSubqueryForSummaryFilters();
        RQPDataItem p = rootQuery.getSubqueryForSummaryFilters().getRQPDataItemWithSameExpression(diRef);
        if (p == null) {
            return;
        }
        String queryName = subqueryForSummaryFilter.getName();
        String projName = p.getName();
        List<RQPDataItem> allFooters = this.getFooterProjections(rootQuery);
        for (RQPDataItem f : allFooters) {
            IXQEQueryNode[] refsInFooter;
            for (IXQEQueryNode r : refsInFooter = f.getDescendantsOfType(801009, false)) {
                RQPDataItemRef ref = (RQPDataItemRef)r;
                if (!ref.getQueryName().equals(queryName) || !ref.getName().equals(projName)) continue;
                IXQEQueryNode parent = ref.getParent();
                if (this.nestedSummaryFunctionWithSameScope(newExpr, parent)) {
                    IXQEQueryNode gParent = parent.getParent();
                    int pos = gParent.getPositionOfChild(parent);
                    parent.detach();
                    gParent.addChild(environment.getNodeFactory().deepCopyNode(newExpr), pos);
                    continue;
                }
                ref.exchange(environment.getNodeFactory().deepCopyNode(newExpr));
            }
        }
        p.setPropertyValue("isFooterItem", true);
    }

    private boolean nestedSummaryFunctionWithSameScope(IXQEQueryNode newExpr, IXQEQueryNode parent) {
        if (!ExpressionAnalyzer.isStandardAggregate(newExpr)) {
            return false;
        }
        if (!ExpressionAnalyzer.isStandardAggregate(parent)) {
            return false;
        }
        return this.hasSameScope(newExpr, parent);
    }

    private boolean hasSameScope(IXQEQueryNode func1, IXQEQueryNode func2) {
        V5AggregateBreakClause innerForClause = ((V5AggregateFunction)func1).getForClause();
        V5AggregateBreakClause outerForClause = ((V5AggregateFunction)func2).getForClause();
        if (innerForClause == null && outerForClause == null) {
            return true;
        }
        int nbChildren1 = innerForClause.getNumberChildren();
        int nbChildren2 = innerForClause.getNumberChildren();
        if (nbChildren1 == 0 && nbChildren2 == 0) {
            return true;
        }
        if (nbChildren1 != nbChildren2) {
            return false;
        }
        for (int i = 0; i < nbChildren1; ++i) {
            if (innerForClause.getChild(i).isSameExpression(outerForClause.getChild(i), false)) continue;
            return false;
        }
        return true;
    }

    private IXQEQueryNode updateFooterExpression(PlanningEnvironment environment, RQPQuery rootQuery, RQPDataItem footerProjectionInSubQuery) {
        IXQEQueryNode[] refItems;
        IXQEQueryNode newFooterExpr = environment.getNodeFactory().deepCopyNode(footerProjectionInSubQuery.getExpression());
        RQPQuery subQueryForSF = rootQuery.getSubqueryForSummaryFilters();
        String subQueryForSFName = subQueryForSF.getName();
        for (IXQEQueryNode refItem : refItems = newFooterExpr.getDescendantsOfType(801009, true)) {
            RQPDataItemRef rqpRefItem = (RQPDataItemRef)refItem;
            RQPQuery parentQuery = footerProjectionInSubQuery.getParentRQPQuery();
            RQPDataItem refDataItem = rqpRefItem.getReferencedItem(parentQuery);
            RQPDataItem dataItemInRQ0 = subQueryForSF.getRQPDataItemWithSameExpression(refDataItem);
            if (dataItemInRQ0 == null) {
                dataItemInRQ0 = this.cloneFactItems(environment, subQueryForSF, rqpRefItem, refDataItem, parentQuery);
            }
            if (dataItemInRQ0 != null) {
                rqpRefItem.setName(dataItemInRQ0.getName());
            }
            rqpRefItem.setQueryName(subQueryForSFName);
        }
        this.updateOperandExpressionToAvoidDoubleCounting(environment, footerProjectionInSubQuery.getExpression(), rootQuery, newFooterExpr);
        return newFooterExpr;
    }

    private RQPDataItem cloneFactItems(PlanningEnvironment environment, RQPQuery subQueryForSF, RQPDataItemRef rqpRefItem, RQPDataItem refDataItem, RQPQuery parentQuery) {
        IXQEQueryNode parent = rqpRefItem.getParent();
        if (parent.getType() != 201031 || parent.getPositionOfChild(rqpRefItem) != 0) {
            return null;
        }
        RQPDataItem clonedItemInFS = parentQuery.createRQPDataItem(environment, refDataItem.getName());
        clonedItemInFS.addChild(environment.getNodeFactory().deepCopyNode(rqpRefItem));
        RQPDataItem clonedItemInRSF = subQueryForSF.createRQPDataItem(environment, clonedItemInFS.getName());
        RQPDataItemRef ref = RQPDataItemRef.create(environment, parentQuery.getName(), clonedItemInFS.getName());
        clonedItemInRSF.addChild(ref);
        return clonedItemInRSF;
    }

    private void updateOperandExpressionToAvoidDoubleCounting(PlanningEnvironment environment, IXQEQueryNode originalFooterExpr, RQPQuery rootQuery, IXQEQueryNode footerExprToBeUpdated) {
        if (!this.rollupAggIsMinOrMax(originalFooterExpr)) {
            return;
        }
        IXQEQueryNode operand = originalFooterExpr.getChild(0);
        IXQEQueryNode[] operandGroupingItems = this.getOperandScope(operand);
        List<RQPDataItem> groupingItemsOfMainQuery = rootQuery.getProjectionsMarkedAsGroupingColumns();
        if (operandGroupingItems == null || operandGroupingItems.length >= groupingItemsOfMainQuery.size()) {
            return;
        }
        ArrayList<IXQEQueryNode> operandScope = new ArrayList<IXQEQueryNode>();
        block0: for (IXQEQueryNode gi : operandGroupingItems) {
            RQPDataItemSelfRef operandGroupingItem = (RQPDataItemSelfRef)gi;
            for (RQPDataItem item : groupingItemsOfMainQuery) {
                if (!operandGroupingItem.getName().equals(item.getName())) continue;
                operandScope.add(item.getExpression());
                continue block0;
            }
        }
        if (operandScope.size() < operandGroupingItems.length) {
            return;
        }
        IXQEQueryNode operandInFooterExprToBeUpdated = footerExprToBeUpdated.getChild(0);
        IXQEQueryNode caseExpr = this.createCaseStmOnRowIDForFooterExpr(environment, rootQuery, operandScope, operandInFooterExprToBeUpdated);
        footerExprToBeUpdated.addChild(caseExpr, 0);
    }

    private IXQEQueryNode[] getOperandScope(IXQEQueryNode operand) {
        if (!(operand instanceof RQPDataItemRef)) {
            return null;
        }
        RQPDataItemRef operandRef = (RQPDataItemRef)operand;
        RQPQuery subQuery = RQPNode.getRQPQuery(operand).getSubquery(operandRef.getQueryName());
        if (subQuery == null) {
            return null;
        }
        if (subQuery.isSubqueryForSummaryFilters() || subQuery.getType() != 801024) {
            RQPDataItem operandItem = operandRef.getReferencedItem();
            if (operandItem == null) {
                return null;
            }
            subQuery = RQPNode.getRQPQuery(operandItem);
            if (subQuery == null || subQuery.getType() != 801024) {
                return null;
            }
        }
        return subQuery.getGroupingItems();
    }

    private boolean rollupAggIsMinOrMax(IXQEQueryNode originalFooterExpr) {
        int subType;
        if (!ExpressionAnalyzer.isRollupAggregateNode(originalFooterExpr)) {
            return false;
        }
        return ExpressionAnalyzer.isStandardAggregate(originalFooterExpr) && (subType = ((V5ValueSummaryFunction)originalFooterExpr).getSubType()) != 6 && subType != 4;
    }

    private boolean dataItemHasAggregateWithHigherScopeThanLowestLevelSummary(RQPDataItem dataItem, List<RQPDataItem> groupingItemsOfMainQuery) {
        IXQEQueryNode[] aggrNodes;
        boolean hasAggregateWithHigherScope = false;
        IXQEQueryNode expr = dataItem.getExpression();
        for (IXQEQueryNode aggrNode : aggrNodes = ExpressionAnalyzer.getAggregateNodes(expr)) {
            IXQEQueryNode[] aggrScope = ExpressionAnalyzer.getAggregateScope((V5AggregateFunction)aggrNode);
            List<IXQEQueryNode> aggrScopeList = Arrays.asList(aggrScope);
            if (!ExpressionAnalyzer.isHigherScope(aggrScopeList, groupingItemsOfMainQuery, true)) continue;
            hasAggregateWithHigherScope = true;
            break;
        }
        if (!hasAggregateWithHigherScope) {
            IXQEQueryNode[] diRefs;
            for (IXQEQueryNode diRef : diRefs = dataItem.getDescendantsOfType(801009, false)) {
                RQPDataItem refItem = ((RQPDataItemRef)diRef).getReferencedItem();
                if (!this.dataItemHasAggregateWithHigherScopeThanLowestLevelSummary(refItem, groupingItemsOfMainQuery)) continue;
                hasAggregateWithHigherScope = true;
                break;
            }
        }
        return hasAggregateWithHigherScope;
    }

    private IXQEQueryNode createCaseStmOnRowIDForFooterExpr(PlanningEnvironment environment, RQPQuery rootQuery, List<IXQEQueryNode> rowNumberPartition, IXQEQueryNode operandExpr) {
        ArrayList<IXQEQueryNode> sortItems = new ArrayList<IXQEQueryNode>();
        sortItems.add(operandExpr);
        IXQEQueryNode rowNumberExpr = ExpressionAnalyzer.createRowNumberExpr(environment.getNodeFactory(), rowNumberPartition, sortItems);
        IXQEQueryNode caseExpr = ExpressionAnalyzer.createCaseExpression(environment.getNodeFactory(), rowNumberExpr, operandExpr);
        return caseExpr;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        if (node.getBooleanPropertyValue("hasSummaryFilterAfterStitch") == null) {
            this.traceNodeCondition(false, "The multi-fact query doesn't have summary filter after the stitch.", trace);
            return false;
        }
        RQPQuery rootQuery = (RQPQuery)node;
        if (!this.hasFooterProjections(rootQuery)) {
            this.traceNodeCondition(false, "The multi-fact query doesn't have footer projections.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The footer projections will be pulled from fact streams to outermost query.", trace);
        return true;
    }
}

