/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5AggregateEnum;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5CaseExpression;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessageFolder;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResolveDataItemReferenceAutomaticAggregate
extends Transformation {
    public ResolveDataItemReferenceAutomaticAggregate() {
        this.mName = "ResolveDataItemReferenceAutomaticAggregate.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{101003};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String aggregateName = this.resolveAutomaticAggregate(node, environment);
        ((V5DataItem)node).setAggregateProperty(aggregateName);
    }

    public static boolean allQueryItemReferencesAreNotAggregateAutomatic(V5DataItem node, LoopDetectionChain ldc, Map<String, Boolean> nodeToResult) {
        String nodeId = node.getFullName();
        if (nodeToResult.containsKey(nodeId)) {
            return nodeToResult.get(nodeId);
        }
        if (!ldc.push(nodeId)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInExpression, "Model Expression", ldc.serialize());
        }
        IXQEQueryNode[] refs = node.getDescendantsOfType(201060, false);
        boolean result = true;
        for (IXQEQueryNode refNode : refs) {
            V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)refNode;
            if (!dataItemRef.isQueryRefItem() || ResolveDataItemReferenceAutomaticAggregate.isTargetDataItemResolved(dataItemRef, ldc, nodeToResult)) continue;
            result = false;
            break;
        }
        nodeToResult.put(nodeId, result);
        return result;
    }

    public static boolean isTargetDataItemResolved(V5BoundDataItemReference dataItemRef, LoopDetectionChain ldc, Map<String, Boolean> nodeToResult) {
        V5DataItem targetDataItem = dataItemRef.getRefDataItem();
        if (targetDataItem != null) {
            String targetAggrProp = targetDataItem.getAggregateProperty();
            if (targetAggrProp == null || targetAggrProp.equals("") || targetAggrProp.equals("automatic")) {
                return false;
            }
            IXQEQueryNode[] descendants = targetDataItem.getDescendantsOfType(101003, false);
            if (descendants.length > 0) {
                V5Query v5Query = (V5Query)targetDataItem.getAncestorOfType(101006);
                if (v5Query == null) {
                    return false;
                }
                if (v5Query.isTabular() && v5Query.isRelStyle()) {
                    return false;
                }
            }
            return ResolveDataItemReferenceAutomaticAggregate.allQueryItemReferencesAreNotAggregateAutomatic(targetDataItem, ldc, nodeToResult);
        }
        return false;
    }

    public IXQEQueryNode getTargetDataItemFromQueryRefItem(IXQEQueryNode node, String queryName, String dataItemName) {
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        V5Query refQuery = null;
        List<IXQEQueryNode> sources = query.getDescendantsOfTypeOrdered(101007, false);
        if (sources.size() > 0) {
            IXQEQueryNode[] subQueries;
            V5Source v5Source = (V5Source)sources.get(0);
            for (IXQEQueryNode subQuery : subQueries = v5Source.getDescendantsOfType(101006, false)) {
                String name = (String)subQuery.getPropertyValue("name");
                if (name == null || !queryName.equals(name)) continue;
                refQuery = (V5Query)subQuery;
                break;
            }
            if (refQuery != null) {
                V5Selection selection = refQuery.getV5Selection();
                V5DataItem dataItem = null;
                for (int i = 0; i < selection.getNumberChildren(); ++i) {
                    dataItem = (V5DataItem)selection.getChild(i);
                    if (!dataItem.getNameProperty().equals(dataItemName)) continue;
                    return dataItem;
                }
            }
        }
        return null;
    }

    private String resolveAutomaticAggregate(IXQEQueryNode node, PlanningEnvironment environment) {
        String aggregate = this.getAggregateFromDescendantV5DataItem(node, false);
        if (aggregate != null) {
            return aggregate;
        }
        List<IXQEQueryNode> v5DataItems = this.temporarilyRemoveV5DataItems(environment, node);
        if (this.hasAggregateInExpression(node)) {
            this.putBackV5DataItems(node, v5DataItems);
            return "calculated";
        }
        if (this.hasFactInIfClauseOfIfThenElse(node)) {
            this.putBackV5DataItems(node, v5DataItems);
            return "calculated";
        }
        if (this.hasQueryItemOrCalculationWithDefinedRegularAggregate(node)) {
            this.putBackV5DataItems(node, v5DataItems);
            return "summarize";
        }
        if (this.hasFactWithStandardRegularOrAutomaticAggregate(node)) {
            this.putBackV5DataItems(node, v5DataItems);
            return "summarize";
        }
        this.putBackV5DataItems(node, v5DataItems);
        ResolveDataItemReferenceAutomaticAggregate.addNagIfFactItemIsUnsupported(environment, node);
        return "none";
    }

    public static void addNagIfFactItemIsUnsupported(PlanningEnvironment environment, IXQEQueryNode node) {
        RequestEnvironment parentReqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        if ("validate".equals(parentReqEnv.getOperationName()) && parentReqEnv.getMaxSeverityLevel() == 3) {
            IXQEQueryNode[] modelReferences = node.getDescendantsOfType(201116, true);
            for (int i = 0; i < modelReferences.length; ++i) {
                IQueryItem queryItem;
                V5BoundModelIdentifier modelReference = (V5BoundModelIdentifier)modelReferences[i];
                if (!modelReference.isFactQueryItem() || !modelReference.isQueryItem() || !"unsupported".equals((queryItem = (IQueryItem)modelReference.getMetadata()).getRegularAggregate())) continue;
                String pathOrDataItem = null;
                IXQEQueryNode dataItem = null;
                dataItem = node.getType() == 101003 ? node : node.getAncestorOfType(101003);
                pathOrDataItem = dataItem != null ? ((V5DataItem)dataItem).getFullName() : ResponseMessageFolder.calculatePath(node);
                String message = XQEMessages.getMessage(XQEMessageKeys.WRN_FactQueryItemWithUnsupportedAggregate, XQEMessages.getCurrProductLocale(), queryItem.getV5UniqueName(), pathOrDataItem);
                ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(message);
                break;
            }
        }
    }

    private void putBackV5DataItems(IXQEQueryNode node, List<IXQEQueryNode> v5DataItems) {
        List<IXQEQueryNode> tempNodes = node.getDescendantsOfTypeOrdered(801043, false);
        int i = 0;
        for (IXQEQueryNode tempNode : tempNodes) {
            tempNode.exchange(v5DataItems.get(i));
            ++i;
        }
    }

    private List<IXQEQueryNode> temporarilyRemoveV5DataItems(PlanningEnvironment environment, IXQEQueryNode node) {
        List<IXQEQueryNode> v5DataItems = node.getDescendantsOfTypeOrdered(101003, false);
        for (IXQEQueryNode v5DataItem : v5DataItems) {
            IXQEQueryNode tempNode = environment.getNodeFactory().createNode(801043);
            v5DataItem.exchange(tempNode);
        }
        return v5DataItems;
    }

    private String getAggregateFromDescendantV5DataItem(IXQEQueryNode newNode, boolean includeSelf) {
        IXQEQueryNode[] refDataItems = newNode.getDescendantsOfType(101003, includeSelf);
        for (int i = 0; i < refDataItems.length; ++i) {
            if (((V5DataItem)refDataItems[i]).getAggregateProperty().equals("none")) continue;
            return "calculated";
        }
        IXQEQueryNode[] ids = newNode.getDescendantsOfType(201060, false);
        String aggregate = null;
        for (IXQEQueryNode id : ids) {
            V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)id;
            if (!dataItemRef.isQueryRefItem()) continue;
            V5DataItem targetDataItem = dataItemRef.getRefDataItem();
            V5Selection selection = (V5Selection)targetDataItem.getAncestorOfType(101009);
            if (!selection.getAutoSummary()) {
                return null;
            }
            aggregate = this.getAggregateFromDescendantV5DataItem(targetDataItem, true);
            if (aggregate == null) continue;
            return aggregate;
        }
        return null;
    }

    private boolean hasAggregateInExpression(IXQEQueryNode node) {
        int[] descendantTypes = new int[]{201031, 201033, 201035};
        return node.getDescendantsOfTypes(descendantTypes, false).length > 0;
    }

    private boolean hasFactInIfClauseOfIfThenElse(IXQEQueryNode node) {
        int[] conditionalNodeTypes = new int[]{201017, 201018, 201020};
        IXQEQueryNode[] expr = node.getDescendantsOfTypes(conditionalNodeTypes, false);
        boolean hasFact = false;
        for (int i = 0; i < expr.length; ++i) {
            if (!this.hasFactInConditionClauses(expr[i])) continue;
            hasFact = true;
            break;
        }
        return hasFact;
    }

    private IXQEQueryNode[] getConditionClauses(IXQEQueryNode node) {
        ArrayList<IXQEQueryNode> conditionClauses = new ArrayList<IXQEQueryNode>();
        if (node.getType() == 201017) {
            conditionClauses.add(node.getChild(0));
        } else if (node.getType() == 201018) {
            if (((V5CaseExpression)node).getSubType() == 0) {
                conditionClauses.add(node.getChild(0));
            } else {
                IXQEQueryNode[] caseWhenClauses = node.getChildrenOfType(201019);
                for (int i = 0; i < caseWhenClauses.length; ++i) {
                    conditionClauses.add(caseWhenClauses[i].getChild(0));
                }
            }
        } else if (node.getType() == 201020) {
            conditionClauses.add(node.getChild(0));
        }
        IXQEQueryNode[] nodes = new IXQEQueryNode[conditionClauses.size()];
        return conditionClauses.toArray(nodes);
    }

    private boolean hasFactInConditionClauses(IXQEQueryNode node) {
        IXQEQueryNode[] conditionClauses = this.getConditionClauses(node);
        for (int i = 0; i < conditionClauses.length; ++i) {
            IXQEQueryNode[] modelReferences = conditionClauses[i].getDescendantsOfType(201116, true);
            for (int j = 0; j < modelReferences.length; ++j) {
                if (!((V5BoundModelIdentifier)modelReferences[j]).isFactQueryItem() && !((V5BoundModelIdentifier)modelReferences[j]).isCalculationWithDefinedRegularAggregate()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasQueryItemOrCalculationWithDefinedRegularAggregate(IXQEQueryNode node) {
        IXQEQueryNode[] modelReferences = node.getDescendantsOfType(201116, false);
        for (int i = 0; i < modelReferences.length; ++i) {
            V5BoundModelIdentifier modelReference = (V5BoundModelIdentifier)modelReferences[i];
            if (!modelReference.isCalculationWithDefinedRegularAggregate() && (!modelReference.isFactQueryItem() || !modelReference.isQueryItemWithDefinedRegularAggregate())) continue;
            return true;
        }
        return false;
    }

    private boolean hasFactWithStandardRegularOrAutomaticAggregate(IXQEQueryNode node) {
        IXQEQueryNode[] itemReferences = node.getDescendantsOfType(201116, false);
        for (int i = 0; i < itemReferences.length; ++i) {
            V5BoundModelIdentifier itemReference = (V5BoundModelIdentifier)itemReferences[i];
            if (!itemReference.isFactQueryItem() || !V5AggregateEnum.isAutomaticAggregate(itemReference.getRegularAggregate()) && !V5AggregateEnum.isStandardAggregate(itemReference.convertRegularAggregateSumToTotal())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (null != ((V5DataItem)node).getAggregateExpression()) {
            return false;
        }
        String aggr = ((V5DataItem)node).getAggregateProperty();
        if (aggr != null && !aggr.equals("automatic")) {
            return false;
        }
        if (!node.isWithinScope(101006, 1002)) {
            this.traceNodeCondition(false, "The node is not a relational query.", xqeTrace);
            return false;
        }
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        if (querySet == null) {
            return false;
        }
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (!query.isTabular()) {
            this.traceNodeCondition(false, "The query is not a relational query.", xqeTrace);
            return false;
        }
        if (!querySet.hasDescendantOfType(801017, false)) {
            this.traceNodeCondition(false, "The transformation is only applied to query.", xqeTrace);
            return false;
        }
        IXQEQueryNode[] descendants = node.getDescendantsOfType(101003, false);
        for (int i = 0; i < descendants.length; ++i) {
            V5DataItem v5DiDescendant = (V5DataItem)descendants[i];
            if (v5DiDescendant.getDescendantsOfType(101003, false).length > 0) {
                return false;
            }
            if (null != v5DiDescendant.getAggregateExpression()) continue;
            if (v5DiDescendant.getPropertyValue("refModelObjectName") != null) {
                return false;
            }
            V5DataItem targetDataItem = (V5DataItem)RQPUtilities.findTargetDataItem(node, v5DiDescendant.getNameProperty());
            if (null != targetDataItem) continue;
            return false;
        }
        LoopDetectionChain ldc = new LoopDetectionChain();
        HashMap<String, Boolean> nodeToResult = new HashMap<String, Boolean>();
        return ResolveDataItemReferenceAutomaticAggregate.allQueryItemReferencesAreNotAggregateAutomatic((V5DataItem)node, ldc, nodeToResult);
    }
}

