/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPGroupByList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryFilterList;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.ArrayList;

public class RewriteDistinctAggregateOfGroupingColumnInTermsOfLLSQ
extends RQPTransformation {
    public static final String CONVERT_TO_ROW_NUMBER_SYNTAX = "convertToRowNumberSyntax";
    private static final String VISITED_FOR_ROW_NUMBER_CANDIDATES = "visitedForRowNumberCandidates";
    private static int[] functionArgs = new int[]{201031, 201060, 801009};

    public RewriteDistinctAggregateOfGroupingColumnInTermsOfLLSQ() {
        this.mName = "RewriteDistinctAggregateOfGroupingColumnInTermsOfLLSQ";
        this.mPassNumbers = new int[]{71};
        this.mTypes = new int[]{201031};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        V5ValueSummaryFunction aggr = (V5ValueSummaryFunction)node;
        if (!aggr.getDistinct()) {
            this.traceNodeCondition(false, "Not a distinct aggregate.", xqeTrace);
            return false;
        }
        RQPQuery queryOfAggregate = RQPQuery.getRQPQuery(node);
        IXQEQueryNode v5QuerySet = node.getAncestorOfType(101002);
        if (v5QuerySet.getPropertyValue(VISITED_FOR_ROW_NUMBER_CANDIDATES) == null) {
            v5QuerySet.setPropertyValue(VISITED_FOR_ROW_NUMBER_CANDIDATES, "visited");
            int[] mTypes = new int[]{201042};
            IXQEQueryNode[] genericFunctions = v5QuerySet.getDescendantsOfTypes(mTypes, false);
            if (genericFunctions.length > 0) {
                ArrayList<IXQEQueryNode> aggregateFunctions = new ArrayList<IXQEQueryNode>();
                for (IXQEQueryNode function : genericFunctions) {
                    IXQEQueryNode[] descendants;
                    for (IXQEQueryNode descendant : descendants = function.getDescendantsOfTypes(functionArgs, false)) {
                        RQPDataItem rqpDataItem;
                        if (descendant.getType() == 201031) {
                            aggregateFunctions.add(descendant);
                            continue;
                        }
                        if (descendant.getType() == 201060) {
                            rqpDataItem = ((V5BoundDataItemReference)descendant).getRQPDataITem();
                            this.collectAggregates(rqpDataItem, aggregateFunctions);
                            continue;
                        }
                        rqpDataItem = ((RQPDataItemRef)descendant).getReferencedItem();
                        this.collectAggregates(rqpDataItem, aggregateFunctions);
                    }
                }
                for (IXQEQueryNode aggregateFunction : aggregateFunctions) {
                    RQPQuery parentQuery;
                    RQPSummaryFilterList summaryFilterList;
                    V5ValueSummaryFunction af = (V5ValueSummaryFunction)aggregateFunction;
                    IXQEQueryNode projectionList = af.getAncestorOfType(801016);
                    if (!af.getDistinct() || !RewriteDistinctAggregateOfGroupingColumnInTermsOfLLSQ.isAggregateSupportedForDistinct(af) || projectionList == null || (summaryFilterList = (parentQuery = (RQPQuery)projectionList.getParent()).getSummaryFilterList()) != null && summaryFilterList.getChildren().length != 0) continue;
                    aggregateFunction.setPropertyValue(CONVERT_TO_ROW_NUMBER_SYNTAX, CONVERT_TO_ROW_NUMBER_SYNTAX);
                }
            }
        }
        if (queryOfAggregate.getType() == 801025) {
            this.traceNodeCondition(false, "Aggregate is already pushed to tabular query.", xqeTrace);
            return false;
        }
        RQPQuery parentRQPQuery = RQPQuery.getRQPQuery(node).getParentRQPQuery();
        RQPQuery llSQ = parentRQPQuery.getLowestLevelSummaryQuery();
        if (llSQ == null || queryOfAggregate == llSQ) {
            this.traceNodeCondition(false, "Aggregate is already in the LLSQ.", xqeTrace);
            return false;
        }
        if (!RewriteDistinctAggregateOfGroupingColumnInTermsOfLLSQ.isAggregateSupportedForDistinct(aggr)) {
            this.traceNodeCondition(false, "The transformation is applicable only to MAX,MIN,SUM,AVG,COUNT.", xqeTrace);
            return false;
        }
        if (!RewriteDistinctAggregateOfGroupingColumnInTermsOfLLSQ.aggregateOperandIsGroupingColumn(llSQ, aggr)) {
            this.traceNodeCondition(false, "First operand of the aggregate is not a grouping column.", xqeTrace);
            return false;
        }
        if (node.getPropertyValue(CONVERT_TO_ROW_NUMBER_SYNTAX) != null) {
            this.traceNodeCondition(false, "Node tagged for ROW_NUMBER transformation.", xqeTrace);
            return false;
        }
        return !llSQ.hasReferencesToQuery(queryOfAggregate);
    }

    private void collectAggregates(RQPDataItem dataItem, ArrayList<IXQEQueryNode> aggregateFunctions) {
        IXQEQueryNode[] descendants;
        if (dataItem == null) {
            return;
        }
        for (IXQEQueryNode descendant : descendants = dataItem.getDescendantsOfTypes(functionArgs, false)) {
            RQPDataItem rqpDataItem;
            if (descendant.getType() == 201031) {
                aggregateFunctions.add(descendant);
                continue;
            }
            if (descendant.getType() == 201060) {
                rqpDataItem = ((V5BoundDataItemReference)descendant).getRQPDataITem();
                this.collectAggregates(rqpDataItem, aggregateFunctions);
                continue;
            }
            rqpDataItem = ((RQPDataItemRef)descendant).getReferencedItem();
            this.collectAggregates(rqpDataItem, aggregateFunctions);
        }
    }

    public static boolean aggregateOperandIsGroupingColumn(RQPQuery llSQ, V5AggregateFunction aggr) {
        IXQEQueryNode firstOperand = aggr.getChild(0);
        RQPDataItem groupingColumn = RewriteDistinctAggregateOfGroupingColumnInTermsOfLLSQ.findMatchingroupingColumn(llSQ, firstOperand);
        return groupingColumn != null;
    }

    public static boolean isAggregateSupportedForDistinct(V5AggregateFunction aggr) {
        return aggr.getSubType() == 2 || aggr.getSubType() == 1 || aggr.getSubType() == 9 || aggr.getSubType() == 6 || aggr.getSubType() == 4;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode firstOperand = node.getChild(0);
        RQPQuery parentRQPQuery = RQPQuery.getRQPQuery(node).getParentRQPQuery();
        RQPQuery llSQ = parentRQPQuery.getLowestLevelSummaryQuery();
        RQPDataItem groupingColumn = RewriteDistinctAggregateOfGroupingColumnInTermsOfLLSQ.findMatchingroupingColumn(llSQ, firstOperand);
        RQPDataItemRef refToGroupingColumn = RQPDataItemRef.create(environment, groupingColumn);
        firstOperand.exchange(refToGroupingColumn);
    }

    private static RQPDataItem findMatchingroupingColumn(RQPQuery llSQ, IXQEQueryNode firstOperand) {
        RQPGroupByList groupBy = llSQ.getGroupByList();
        if (groupBy == null || groupBy.getNumberChildren() == 0) {
            return null;
        }
        for (IXQEQueryNode gbChild : groupBy.getChildren()) {
            if (!RQPSummaryQuery.isSameGroupingColumnExpression(gbChild, firstOperand)) continue;
            RQPDataItemSelfRef selfRef = (RQPDataItemSelfRef)gbChild;
            return selfRef.getRefProjection();
        }
        return null;
    }
}

