/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5Exp.V5CastFunction;
import com.cognos.xqe.ast.v5Exp.V5CastTarget;
import com.cognos.xqe.ast.v5Exp.V5IfExpression;
import com.cognos.xqe.ast.v5Exp.V5IsNullExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class SimplifyNestedStandardAggregate
extends RQPTransformation {
    public SimplifyNestedStandardAggregate() {
        this.mName = "Simplify nested standard aggregates in RQPSummaryQuery.";
        this.mPassNumbers = new int[]{57};
        this.mTypes = new int[]{201031};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        int outerAggrSubType = ((V5ValueSummaryFunction)node).getSubType();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        switch (outerAggrSubType) {
            case 2: {
                V5IfExpression v5IfExpr = SimplifyNestedStandardAggregate.buildIfExpressionForCount(node, nodeFactory);
                node.exchange(v5IfExpr);
                return;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                V5CastTarget castTarget = (V5CastTarget)nodeFactory.createNode(201052);
                castTarget.setDataType(DataTypeFactory.getDoubleType());
                V5CastFunction castFunction = (V5CastFunction)nodeFactory.createNode(201051);
                castFunction.addChild(nodeFactory.createNode(201023));
                castFunction.addChild(castTarget);
                node.exchange(castFunction);
                return;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                node.extract();
                return;
            }
        }
    }

    public static V5IfExpression buildIfExpressionForCount(IXQEQueryNode outerCount, XQENodeFactory nodeFactory) {
        IXQEQueryNode[] children = outerCount.getChildren();
        outerCount.detachChildren();
        V5IsNullExpression nullExpr = (V5IsNullExpression)nodeFactory.createNode(201010);
        nullExpr.addChildren(children, 0);
        String zeroString = "0";
        V5LiteralValue literalZero = (V5LiteralValue)nodeFactory.createNode(201026);
        literalZero.setDataType(IntegerType.INTEGERTYPE);
        literalZero.setValue(zeroString);
        String oneString = "1";
        V5LiteralValue literalOne = (V5LiteralValue)nodeFactory.createNode(201026);
        literalOne.setDataType(IntegerType.INTEGERTYPE);
        literalOne.setValue(oneString);
        V5IfExpression ifExpr = (V5IfExpression)nodeFactory.createNode(201017);
        ifExpr.addChild(nullExpr);
        ifExpr.addChild(literalZero);
        ifExpr.addChild(literalOne);
        return ifExpr;
    }

    public static boolean hasDescendantsThatDoNotAllowSimplification(IXQEQueryNode aggregate) {
        List<IXQEQueryNode> descendants = aggregate.getDescendantsOfTypesOrdered(new int[]{201033, 201035, 201116, 201097, 201103}, false);
        for (IXQEQueryNode descendant : descendants) {
            if (descendant.getAncestorOfType(201031) != aggregate) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] multiResultExprs;
        XQETrace xqeTrace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            this.traceNodeCondition(false, "The V5SummaryFunction node is not under a RQP query", xqeTrace);
            return false;
        }
        if (node.getFirstChildByType(201037) != null) {
            this.traceNodeCondition(false, "The V5SummaryFunction has explicit FOR clause", xqeTrace);
            return false;
        }
        List<IXQEQueryNode> nestedSummaryFunctions = node.getDescendantsOfTypesOrdered(new int[]{201031}, false);
        if (nestedSummaryFunctions.size() == 0) {
            this.traceNodeCondition(false, "The V5SummaryFunction doesn't have nested aggregates", xqeTrace);
            return false;
        }
        for (IXQEQueryNode nestedSummaryFunction : nestedSummaryFunctions) {
            if (nestedSummaryFunction.getFirstChildByType(201037) != null) {
                this.traceNodeCondition(false, "The nested V5SummaryFunction has explicit FOR clause", xqeTrace);
                return false;
            }
            IXQEQueryNode[] diRefs = nestedSummaryFunction.getParent().getChildrenOfType(801009);
            if (diRefs.length == 0) continue;
            return false;
        }
        for (IXQEQueryNode multiResultExpr : multiResultExprs = node.getChildrenOfTypes(new int[]{201018, 201017})) {
            if (!RQPUtilities.isDetailExpression(multiResultExpr)) continue;
            return false;
        }
        if (SimplifyNestedStandardAggregate.hasDescendantsThatDoNotAllowSimplification(node)) {
            this.traceNodeCondition(false, "The V5SummaryFunction has standard function nested with analytical/running/movingor other complex expression.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "The V5SummaryFunction has nested aggregate without FOR clause", xqeTrace);
        return true;
    }
}

