/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.SummaryFilters;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDetailFilterList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AddSummaryDetailFiltersToSubqueries
extends RQPTransformation {
    public static final String PROP_HAS_FILTER_CONVERTED_FROM_SUMMARYFILTER = "hasFilterConvertedFromSummaryFilter";

    public AddSummaryDetailFiltersToSubqueries() {
        this.mName = "AddSummaryDetailFiltersToSubqueries";
        this.mPassNumbers = new int[]{120};
        this.mTypes = new int[]{801017};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rqpQuery = (RQPQuery)node;
        RQPQuery parentRQPQuery = (RQPQuery)rqpQuery.getAncestorOfType(801017);
        List<RQPQuery> subquerySources = parentRQPQuery.getSubquerySources();
        ArrayList<RQPQuery> onlySummaryQueries = new ArrayList<RQPQuery>();
        for (RQPQuery rQPQuery : subquerySources) {
            if (!rQPQuery.isSummarizedQuery()) continue;
            onlySummaryQueries.add(rQPQuery);
        }
        ArrayList<RQPQuery> summaryQuerySources = new ArrayList<RQPQuery>();
        for (RQPQuery rQPQuery : onlySummaryQueries) {
            this.getSummaryQuerySources(rQPQuery, summaryQuerySources);
        }
        for (RQPQuery rQPQuery : summaryQuerySources) {
            if (!rQPQuery.isSummarizedQuery() || onlySummaryQueries.contains(rQPQuery)) continue;
            onlySummaryQueries.add(rQPQuery);
        }
        RQPDetailFilterList rQPDetailFilterList = (RQPDetailFilterList)parentRQPQuery.getFirstChildByType(801011);
        for (RQPQuery rQPQuery : onlySummaryQueries) {
            for (int i = 0; i < rQPDetailFilterList.getNumberChildren(); ++i) {
                IXQEQueryNode filterExpression = rQPDetailFilterList.getChild(i);
                rQPQuery.setPropertyValue(PROP_HAS_FILTER_CONVERTED_FROM_SUMMARYFILTER, true);
                rQPQuery.addToDetailFilterList(environment, environment.getNodeFactory().deepCopyNode(filterExpression));
            }
        }
    }

    private void getSummaryQuerySources(RQPQuery summaryQuery, List<RQPQuery> sources) {
        for (RQPQuery subquery : summaryQuery.getSubquerySources()) {
            if (!subquery.isSummarizedQuery() || sources.contains(subquery)) continue;
            sources.add(subquery);
            this.getSummaryQuerySources(subquery, sources);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery subquery;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        RQPQuery rqpQuery = (RQPQuery)node;
        if (!rqpQuery.isSubqueryForSummaryFilters()) {
            this.traceNodeCondition(false, "RQPQuery is not subquery created for summary filters.", xqeTrace);
            return false;
        }
        RQPQuery parentRQPQuery = (RQPQuery)rqpQuery.getAncestorOfType(801017);
        List<RQPQuery> subquerySources = parentRQPQuery.getSubquerySources();
        if (subquerySources.size() <= 1) {
            this.traceNodeCondition(false, "The parent query has one subquery so detail filters created for summary filters can be left alone.", xqeTrace);
            return false;
        }
        Boolean bSummarizedQuery = false;
        Iterator<RQPQuery> it = subquerySources.iterator();
        while (it.hasNext() && !(bSummarizedQuery = Boolean.valueOf((subquery = it.next()).isSummarizedQuery())).booleanValue()) {
        }
        if (!bSummarizedQuery.booleanValue()) {
            this.traceNodeCondition(false, "The parent query doesn not contains a summarized Query.", xqeTrace);
            return false;
        }
        RQPDetailFilterList detailFilters = (RQPDetailFilterList)parentRQPQuery.getFirstChildByType(801011);
        if (detailFilters == null || detailFilters.getNumberChildren() <= 0) {
            this.traceNodeCondition(false, "There are no detail filters.", xqeTrace);
            return false;
        }
        return true;
    }
}

