/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.List;

public class CreateSummaryQueryToAvoidDoubleCounting
extends RQPTransformation {
    public CreateSummaryQueryToAvoidDoubleCounting() {
        this.mName = "CreateSummaryQueryToAvoidDoubleCounting";
        this.mPassNumbers = new int[]{80};
        this.mTypes = new int[]{801017};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode summaryFilters;
        RQPQuery rqpQuery = (RQPQuery)node;
        RQPQuery newRQPQuery = (RQPQuery)environment.getNodeFactory().createNode(801017);
        newRQPQuery.setName(rqpQuery.generateQueryName(newRQPQuery.getType()));
        newRQPQuery.addChild(environment.getNodeFactory().deepCopyNode(rqpQuery.getSubqueryList()));
        rqpQuery.addToSubqueryList(environment, newRQPQuery, false);
        this.moveSummaryQueryProjectionsToSubquery(environment, rqpQuery, newRQPQuery);
        RQPQuery lowestLevelSQ = rqpQuery.getLowestLevelSummaryQueryProperty();
        if (lowestLevelSQ != null) {
            RQPQuery lowestLevelOfRQ0 = newRQPQuery.getSubquery(lowestLevelSQ.getName());
            newRQPQuery.setLowestLevelSummaryQueryProperty(lowestLevelOfRQ0);
        }
        rqpQuery.setLowestLevelSummaryQueryProperty(newRQPQuery);
        IXQEQueryNode detailFilters = rqpQuery.getFirstChildByType(801011);
        if (detailFilters != null) {
            newRQPQuery.addChild(environment.getNodeFactory().deepCopyNode(detailFilters));
        }
        if ((summaryFilters = rqpQuery.getFirstChildByType(801023)) != null) {
            summaryFilters.detach();
            newRQPQuery.addChild(summaryFilters);
        }
        newRQPQuery.addNonProjectedDataItemsFromLowestLevelSQ(environment);
        newRQPQuery.setIsSubqueryToAvoidDoubleCounting();
        this.removeSummarySubqueries(rqpQuery);
    }

    private void removeSummarySubqueries(RQPQuery rqpQuery) {
        IXQEQueryNode[] summaryQueries;
        IXQEQueryNode subqueryList = rqpQuery.getSubqueryList();
        if (subqueryList == null) {
            return;
        }
        int[] sqTypes = new int[]{801024, 801012};
        for (IXQEQueryNode query : summaryQueries = subqueryList.getChildrenOfTypes(sqTypes)) {
            query.detach();
        }
    }

    private void moveSummaryQueryProjectionsToSubquery(PlanningEnvironment environment, RQPQuery inRQPQuery, RQPQuery targetRQPQuery) {
        RQPProjectionList inProjList = inRQPQuery.getProjectionList();
        if (inProjList == null) {
            return;
        }
        List<IXQEQueryNode> diRefs = inProjList.getDescendantsOfTypeOrdered(801009, false);
        for (IXQEQueryNode ref : diRefs) {
            RQPDataItemRef dataItemRef = (RQPDataItemRef)ref;
            RQPQuery refQuery = dataItemRef.getQuery();
            if (!refQuery.isSummarizedQuery()) continue;
            RQPDataItem rqpDataItemInSQ = targetRQPQuery.createRQPDataItem(environment, dataItemRef.getName());
            rqpDataItemInSQ.copyPropertiesFrom(dataItemRef.getAncestorOfType(801008));
            RQPDataItemRef replacementRef = RQPDataItemRef.create(environment, rqpDataItemInSQ);
            dataItemRef.exchange(replacementRef);
            rqpDataItemInSQ.addChild(dataItemRef);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        RQPQuery rqpQuery = (RQPQuery)node;
        if (!rqpQuery.getRootRQPQuery().isAutoSummaryTRUE() && this.willDoubleCountJoiningDetailAndSummary((RQPQuery)node)) {
            this.traceNodeCondition(true, "RQPQuery contains detail and footer data so a summary query to avoid double counting will be created.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "No summary query to avoid double counting needs to be created.", xqeTrace);
        return false;
    }

    private boolean willDoubleCountJoiningDetailAndSummary(RQPQuery rqpQuery) {
        IXQEQueryNode[] diRefs;
        boolean hasDetailData = false;
        boolean willComputeFootersOverLowestLevelSQ = false;
        boolean allSummaryQueriesAreForReport = true;
        RQPQuery lowestLevelSQ = rqpQuery.getLowestLevelSummaryQuery();
        RQPProjectionList projList = rqpQuery.getProjectionList();
        if (projList == null) {
            return false;
        }
        for (IXQEQueryNode ref : diRefs = projList.getDescendantsOfType(801009, false)) {
            RQPDataItemRef dataItemRef = (RQPDataItemRef)ref;
            RQPQuery refQuery = dataItemRef.getQuery();
            if (refQuery != lowestLevelSQ && refQuery.isSummarizedQuery() && CreateSummaryQueryToAvoidDoubleCounting.hasNestedAggregates(dataItemRef.getNextReferencedItem().getExpression())) {
                willComputeFootersOverLowestLevelSQ = true;
            } else if (refQuery.getType() == 801025) {
                hasDetailData = true;
            }
            if (!refQuery.isSummarizedQuery() || RQPSummaryQuery.isForReportSubquery(refQuery)) continue;
            allSummaryQueriesAreForReport = false;
        }
        return willComputeFootersOverLowestLevelSQ && hasDetailData && !allSummaryQueriesAreForReport;
    }

    public static boolean hasNestedAggregates(IXQEQueryNode expr) {
        IXQEQueryNode[] aggregates = ExpressionAnalyzer.getAggregateNodes(expr);
        if (aggregates == null || aggregates.length == 0) {
            return false;
        }
        for (IXQEQueryNode aggr : aggregates) {
            if (CreateSummaryQueryToAvoidDoubleCounting.aggregateOperandIsFromDetail(aggr)) continue;
            return true;
        }
        return false;
    }

    public static boolean aggregateOperandIsFromDetail(IXQEQueryNode aggr) {
        IXQEQueryNode[] operands;
        for (IXQEQueryNode aggrOperand : operands = aggr.getDescendantsOfType(801009, false)) {
            RQPDataItemRef refOperand = (RQPDataItemRef)aggrOperand;
            if (refOperand.getQuery().isTabularQuery()) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAncestorRQPQueryToAvoidDoubleCounting(RQPQuery queryOfAggregate) {
        for (RQPQuery parentRQPQuery = queryOfAggregate.getParentRQPQuery(); parentRQPQuery != null; parentRQPQuery = (RQPQuery)parentRQPQuery.getAncestorOfType(801017)) {
            if (!parentRQPQuery.isSubqueryToAvoidDoubleCounting()) continue;
            return true;
        }
        return false;
    }
}

