/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class ReplaceRefsToTQWithRefToLowestLevelSQ
extends RQPTransformation {
    public ReplaceRefsToTQWithRefToLowestLevelSQ() {
        this.mName = "Replace references to Tabular Query";
        this.mPassNumbers = new int[]{89};
        this.mTypes = new int[]{801009};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPDataItemRef ref = (RQPDataItemRef)node;
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node).getParentRQPQuery();
        RQPQuery lowestLevelSQ = rqpQuery.getLowestLevelSummaryQueryProperty();
        RQPDataItem rqpDataItem = lowestLevelSQ.getRQPDataItemWithSameExpression(ref);
        RQPDataItemRef newRef = RQPDataItemRef.create(environment, rqpDataItem);
        ref.exchange(newRef);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        RQPDataItemRef ref = (RQPDataItemRef)node;
        RQPQuery parentRQPQuery = RQPNode.getRQPQuery(node).getParentRQPQuery();
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        RQPQuery lowestLevelSQ = parentRQPQuery.getLowestLevelSummaryQueryProperty();
        if (ref.getQuery().getType() == 801025 && !rqpQuery.isSummarizedQuery() && rqpQuery.getRootRQPQuery().isAutoSummaryTRUE() && this.lowestLevelSQContainsGroupingItem(lowestLevelSQ, ref)) {
            this.traceNodeCondition(true, "Reference to tabular query will be replaced by reference to LLSQ.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "autoSummary=false or lowest level SQ does not contain projection.", xqeTrace);
        return false;
    }

    private boolean lowestLevelSQContainsGroupingItem(RQPQuery lowestLevelSQ, RQPDataItemRef ref) {
        if (lowestLevelSQ == null || !lowestLevelSQ.isSummarizedQuery()) {
            return false;
        }
        IXQEQueryNode groupByList = lowestLevelSQ.getFirstChildByType(801013);
        if (groupByList != null) {
            for (int i = 0; i < groupByList.getNumberChildren(); ++i) {
                if (!RQPSummaryQuery.isSameGroupingColumnExpression(groupByList.getChild(i), ref)) continue;
                return true;
            }
        }
        return false;
    }
}

