/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPTabularQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.AvoidDoubleCountingOfDetAttribute;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RewriteDistinctAggregateOfGroupingColumnInTermsOfLLSQ;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public class RewriteDistinctAggregateInTermsOfLowestScope
extends RQPTransformation {
    public RewriteDistinctAggregateInTermsOfLowestScope() {
        this.mName = "RewriteDistinctAggregateInTermsOfLowestScope";
        this.mPassNumbers = new int[]{72};
        this.mTypes = new int[]{201031};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5AggregateFunction aggregate = (V5AggregateFunction)node;
        if (aggregate.getSubType() == 4 || aggregate.getSubType() == 6) {
            aggregate.setDistinct(false);
            return;
        }
        IXQEQueryNode[] aggregateScope = ExpressionAnalyzer.getAggregateScope(aggregate);
        ArrayList<IXQEQueryNode> partitionByOperands = new ArrayList<IXQEQueryNode>();
        if (aggregateScope != null) {
            for (IXQEQueryNode groupingColumn : aggregateScope) {
                IXQEQueryNode groupingColumnExpr = AvoidDoubleCountingOfDetAttribute.getUnwoundGroupingColumExpression(environment, groupingColumn);
                if (groupingColumnExpr.getType() == 201026) continue;
                partitionByOperands.add(environment.getNodeFactory().deepCopyNode(groupingColumnExpr));
            }
        }
        this.replaceWithCaseExprInTQ(aggregate, partitionByOperands, environment);
        aggregate.setRewriteDistinctTransformationIsApplied(true);
    }

    private void replaceWithCaseExprInTQ(V5AggregateFunction aggregate, List<IXQEQueryNode> partitionByOperands, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        this.replaceRefsInAggregateOperandWithExpressions(aggregate, nodeFactory);
        IXQEQueryNode aggregateOperand = aggregate.getChild(0);
        ArrayList<IXQEQueryNode> partitionByOrder = new ArrayList<IXQEQueryNode>();
        partitionByOrder.addAll(partitionByOperands);
        partitionByOrder.add(aggregateOperand);
        IXQEQueryNode rowNumberExpr = ExpressionAnalyzer.createRowNumberExpr(nodeFactory, partitionByOrder, partitionByOrder);
        IXQEQueryNode caseExpr = ExpressionAnalyzer.createCaseExpression(nodeFactory, rowNumberExpr, nodeFactory.deepCopyNode(aggregateOperand));
        RQPTabularQuery tabQuery = RQPNode.getRQPQuery(aggregate).getParentRQPQuery().getDefaultTabularQuery();
        tabQuery.setPropertyValue("canNotBeCollapsed", true);
        aggregate.setDistinct(false);
        RQPQuery parentQuery = RQPQuery.getRQPQuery(aggregate);
        if (parentQuery == tabQuery) {
            aggregateOperand.exchange(caseExpr);
            return;
        }
        RQPDataItem parent = (RQPDataItem)aggregate.getAncestorOfType(801008);
        String preferredName = parent.getName() + "_d";
        RQPDataItem rqpDataItemCaseExpr = tabQuery.getRQPDataItem(environment, caseExpr, preferredName);
        rqpDataItemCaseExpr.setIsRowNumberExpr();
        rqpDataItemCaseExpr.setIsRowNumberForDistinct();
        caseExpr.detach();
        RQPDataItemRef refToCaseExpr = RQPDataItemRef.create(environment, tabQuery.getName(), rqpDataItemCaseExpr.getName());
        aggregateOperand.exchange(refToCaseExpr);
    }

    private void replaceRefsInAggregateOperandWithExpressions(V5AggregateFunction aggregate, IXQENodeFactory nodeFactory) {
        IXQEQueryNode[] listRefs;
        IXQEQueryNode aggregateOperand = aggregate.getChild(0);
        for (IXQEQueryNode ref : listRefs = aggregateOperand.getDescendantsOfType(801009, true)) {
            RQPDataItemRef diRef = (RQPDataItemRef)ref;
            RQPDataItem di = diRef.getReferencedItem();
            IXQEQueryNode expression = nodeFactory.deepCopyNode(di.getExpression());
            diRef.exchange(expression);
        }
    }

    private boolean isFromGroupingItem(IXQEQueryNode aggregate) {
        RQPDataItem rqpDataItem = (RQPDataItem)aggregate.getAncestorOfType(801008);
        return rqpDataItem != null && !rqpDataItem.isGroupingItem();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] diRefs;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        V5AggregateFunction aggregate = (V5AggregateFunction)node;
        if (node.getPropertyValue("convertToRowNumberSyntax") != null) {
            this.traceNodeCondition(true, "The transformation must be applied to ensure valid sql to be pushed to the database.", xqeTrace);
            return true;
        }
        if (aggregate.getAvoidRewritingDistinctAggregate()) {
            this.traceNodeCondition(false, "The transformation must not be applied to this aggregate node.", xqeTrace);
            return false;
        }
        if (!RewriteDistinctAggregateOfGroupingColumnInTermsOfLLSQ.isAggregateSupportedForDistinct(aggregate)) {
            this.traceNodeCondition(false, "The transformation is applicable only to MAX,MIN,SUM,AVG,COUNT.", xqeTrace);
            return false;
        }
        if (!aggregate.getDistinct()) {
            this.traceNodeCondition(false, "The transformation is applicable only to distinct aggregate.", xqeTrace);
            return false;
        }
        RQPQuery queryOfAggregate = RQPNode.getRQPQuery(aggregate);
        RQPQuery lowestLevelSummaryQuery = queryOfAggregate.getLowestLevelSummaryQuery();
        if (lowestLevelSummaryQuery == null) {
            this.traceNodeCondition(false, "The transformation is not applicable if no lowest summary query can be found.", xqeTrace);
            return false;
        }
        RQPQuery parentRQPQuery = queryOfAggregate.getParentRQPQuery();
        if (parentRQPQuery != null && parentRQPQuery.getSummaryFilterList() != null && parentRQPQuery.getSummaryFilterList().getNumberChildren() > 0) {
            this.traceNodeCondition(false, "The transformation is not applied because there are summary filters.", xqeTrace);
            return false;
        }
        if (queryOfAggregate == lowestLevelSummaryQuery && this.isFromGroupingItem(aggregate)) {
            this.traceNodeCondition(false, "The transformation is not applicable as the distinct aggregate is in the lowest summary query.", xqeTrace);
            return false;
        }
        for (IXQEQueryNode xqeNode : diRefs = node.getChild(0).getDescendantsOfType(801009, true)) {
            RQPDataItemRef diRef = (RQPDataItemRef)xqeNode;
            if (diRef.getQuery().getType() == 801025) continue;
            this.traceNodeCondition(false, "The transformation is not applicable as the distinct aggregate is not in terms of TQ0.", xqeTrace);
            return false;
        }
        if (RQPUtilities.hasStandardAggregateInExpression(node.getChild(0))) {
            this.traceNodeCondition(false, "The transformation is not applicable if aggregates are present in the expression.", xqeTrace);
            return false;
        }
        if (RewriteDistinctAggregateOfGroupingColumnInTermsOfLLSQ.aggregateOperandIsGroupingColumn(lowestLevelSummaryQuery, aggregate)) {
            this.traceNodeCondition(false, "The transformation is not applied to grouping columns.", xqeTrace);
            return false;
        }
        IXQEQueryNode[] aggregateScope = ExpressionAnalyzer.getAggregateScope(aggregate);
        if (aggregateScope != null) {
            IXQEQueryNode[] iXQEQueryNodeArray = aggregateScope;
            int n = iXQEQueryNodeArray.length;
            for (int i = 0; i < n; ++i) {
                IXQEQueryNode groupingColumn;
                IXQEQueryNode currentGroupingColumnExpression = groupingColumn = iXQEQueryNodeArray[i];
                if (groupingColumn.getType() == 801010) {
                    currentGroupingColumnExpression = ((RQPDataItemSelfRef)groupingColumn).getExpression();
                }
                for (RQPDataItemRef rqpDataItemRef : ExpressionAnalyzer.getAllReferences(currentGroupingColumnExpression)) {
                    RQPQuery summaryQuery = rqpDataItemRef.getQuery();
                    for (RQPDataItemRef rqpDataItemRefInSummaryQuery : ExpressionAnalyzer.getAllReferences(summaryQuery)) {
                        if (rqpDataItemRefInSummaryQuery.getQuery().getType() != 801025) continue;
                        String failReason = "One of the aggregate scope references another summary query AND the summary query reference tabular query which may cause a circular reference.";
                        this.traceNodeCondition(false, failReason, xqeTrace);
                        return false;
                    }
                }
            }
        }
        this.traceNodeCondition(true, "The transformation is applicable.", xqeTrace);
        return true;
    }
}

