/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;

public class RewriteGroupingColumnsInTermsOfLowestLevelSQ
extends RQPTransformation {
    public RewriteGroupingColumnsInTermsOfLowestLevelSQ() {
        this.mName = "RewriteGroupingColumnsInTermsOfLowestLevelSQ";
        this.mPassNumbers = new int[]{89};
        this.mTypes = new int[]{801010};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        if (node.getParent().getType() != 801013) {
            this.traceNodeCondition(false, "The self reference is not in the context of a group-by list.", xqeTrace);
            return false;
        }
        RQPQuery queryOfGroupingColumn = RQPNode.getRQPQuery(node);
        if (((RQPSummaryQuery)queryOfGroupingColumn).getBooleanPropertyValue("beingSplit") != null) {
            this.traceNodeCondition(false, "The grouping column belongs to the default summary query that has been split.", xqeTrace);
            return false;
        }
        if (queryOfGroupingColumn == queryOfGroupingColumn.getLowestLevelSummaryQuery()) {
            this.traceNodeCondition(false, "The grouping column is already in the lowest level summary query.", xqeTrace);
            return false;
        }
        RQPQuery lowestLevelSQ = queryOfGroupingColumn.getLowestLevelSummaryQuery();
        if (lowestLevelSQ == null) {
            this.traceNodeCondition(false, "No lowest summary query for rewrite.", xqeTrace);
            return false;
        }
        if (lowestLevelSQ.hasReferencesToQuery(queryOfGroupingColumn)) {
            this.traceNodeCondition(false, "The lowest level summarey query has references to the grouping query.", xqeTrace);
            return false;
        }
        if (lowestLevelSQ.getProjectionWithSameExprAsTheGroupingExpression(((RQPDataItemSelfRef)node).getExpression()) == null) {
            this.traceNodeCondition(false, "The lowest level summary query doesn't have any expressionequal to the grouping item expression.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "The grouping column will be rewritten in terms of the lowest-level summary query.", xqeTrace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPDataItemSelfRef selfRef;
        IXQEQueryNode groupingItemExpr;
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        RQPQuery lowestLevelSQ = rqpQuery.getLowestLevelSummaryQuery();
        RQPDataItem projItem = lowestLevelSQ.getProjectionWithSameExprAsTheGroupingExpression(groupingItemExpr = (selfRef = (RQPDataItemSelfRef)node).getExpression());
        if (projItem != null) {
            RQPDataItemRef dataItemRef = RQPDataItemRef.create(environment, lowestLevelSQ.getName(), projItem.getName());
            groupingItemExpr.exchange(dataItemRef);
        }
    }
}

