/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;

public class RewriteNestedAggrContainingForClauseToAvoidDoubleCounting
extends RQPTransformation {
    public static final String PROJECTION_ROW_NUMBER = "rowNumber";

    public RewriteNestedAggrContainingForClauseToAvoidDoubleCounting() {
        this.mName = "RewriteNestedAggregateContainingForClauseToAvoidDoubleCounting";
        this.mPassNumbers = new int[]{96};
        this.mTypes = new int[]{201031};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5AggregateBreakClause aggregateBreakClause = ((V5AggregateFunction)node).getForClause();
        ArrayList<IXQEQueryNode> partitionByScope = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode breakItem : aggregateBreakClause.getChildren()) {
            if (RQPUtilities.isConstantGroupingItem(breakItem)) continue;
            partitionByScope.add(breakItem);
        }
        IXQEQueryNode ancestorAggr = node.getAncestorOfType(201031);
        if (ancestorAggr != null && ancestorAggr.getNumberChildren() > 1) {
            aggregateBreakClause = (V5AggregateBreakClause)ancestorAggr.getChild(1);
            for (IXQEQueryNode breakItem : aggregateBreakClause.getChildren()) {
                boolean isAlreadyInScopeList = false;
                for (IXQEQueryNode scopeItem : partitionByScope) {
                    if (!scopeItem.isSameExpression(breakItem, false)) continue;
                    isAlreadyInScopeList = true;
                    break;
                }
                if (isAlreadyInScopeList) continue;
                partitionByScope.add(breakItem);
            }
        }
        IXQEQueryNode rowNumberExpr = ExpressionAnalyzer.createRowNumberExpr(nodeFactory, partitionByScope, partitionByScope);
        IXQEQueryNode caseExpr = ExpressionAnalyzer.createCaseExpression(nodeFactory, rowNumberExpr, nodeFactory.deepCopyNode(node));
        node.exchange(caseExpr);
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        V5AggregateFunction aggregate = (V5AggregateFunction)node;
        RQPDataItem rqpDataItem = (RQPDataItem)node.getAncestorOfType(801008);
        if (rqpDataItem == null) {
            this.traceNodeCondition(false, "The aggregate in not under a data item", xqeTrace);
            return false;
        }
        if (!rqpDataItem.isGroupingItem()) {
            this.traceNodeCondition(false, "The aggregate in not under a grouping item", xqeTrace);
            return false;
        }
        if (aggregate.getAncestorOfType(201037) != null) {
            this.traceNodeCondition(false, "The aggregate is part of a FOR clause.", xqeTrace);
            return false;
        }
        if (aggregate.getForClause() == null) {
            this.traceNodeCondition(false, "The aggregate does not have a FOR clause.", xqeTrace);
            return false;
        }
        V5ValueSummaryFunction ancestorAggr = (V5ValueSummaryFunction)aggregate.getAncestorOfType(201031);
        if (ancestorAggr == null) {
            this.traceNodeCondition(false, "The aggregate is not nested in another aggregate", xqeTrace);
            return false;
        }
        if (ancestorAggr.getDistinct()) {
            this.traceNodeCondition(false, "The transformation is not applicable for a distinct-aggregate.", xqeTrace);
            return false;
        }
        if (ancestorAggr.getSubType() == 4 || ancestorAggr.getSubType() == 6) {
            this.traceNodeCondition(false, "MAX and MIN don't get double-counted.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "The aggregate will be rewritten to avoid double-counting.", xqeTrace);
        return true;
    }
}

