/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.rqp.RQPTabularQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DetectNoOpAggregates;
import com.cognos.xqe.transformation.v5tocogsql.optimization.RewriteMaxMinSumInTermsOfLowestScope;
import java.util.ArrayList;

public class RewriteNestedMaxMinSum
extends RewriteMaxMinSumInTermsOfLowestScope {
    public RewriteNestedMaxMinSum() {
        this.mName = "Rewrite nested Max/Min/Sum expressions that are at a higher scope that lowest level scope";
        this.mPassNumbers = new int[]{91};
        this.mTypes = new int[]{201031};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.superPassesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        V5AggregateFunction aggregate = (V5AggregateFunction)node;
        if (node.getNumberChildren() == 0 || 201014 == node.getChild(0).getType()) {
            this.traceNodeCondition(false, "The MAX/MIN/SUM aggregate is not directly over a nested aggregate.", xqeTrace);
            return false;
        }
        if (!this.isApplicableForAggregate(aggregate)) {
            this.traceNodeCondition(false, "The aggregate expression is not one of: MAX/MIN/SUM.", xqeTrace);
            return false;
        }
        if (this.aggregateExpressionIsFromLowestLevelSummaryQuery(aggregate)) {
            this.traceNodeCondition(false, "The MAX/MIN/SUM aggregate is already at the lowest scope.", xqeTrace);
            return false;
        }
        if (!this.containsNestedAggregateCandidateForRewrite(aggregate)) {
            this.traceNodeCondition(false, "The MAX/MIN/SUM aggregate does not contain a nested aggregate.", xqeTrace);
            return false;
        }
        if (!this.nestedAggregateIsSameSubType(aggregate)) {
            this.traceNodeCondition(false, "The MAX/MIN/SUM aggregate is not the same aggregate.", xqeTrace);
            return false;
        }
        if (!this.innerAggregateBasedOnDetailData(aggregate)) {
            this.traceNodeCondition(false, "The nested MAX/MIN/SUM aggregate is based on summarized query.", xqeTrace);
            return false;
        }
        if (!RewriteNestedMaxMinSum.innerAggregateGroupingCanBeSkipped(aggregate)) {
            this.traceNodeCondition(false, "The nested aggregate grouping does not support the current aggregate grouping.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "Nested MAX/MIN/SUM or reference to it will be replaced with lowest level aggregate.", xqeTrace);
        return true;
    }

    private boolean innerAggregateBasedOnDetailData(V5AggregateFunction aggregate) {
        RQPTabularQuery tabularQuery = RQPNode.getRQPQuery(aggregate).getParentRQPQuery().getDefaultTabularQuery();
        IXQEQueryNode[] dataItemRefs = aggregate.getDescendantsOfType(801009, true);
        if (dataItemRefs.length == 0) {
            return false;
        }
        for (int i = 0; i < dataItemRefs.length; ++i) {
            IXQEQueryNode[] diRefs;
            RQPDataItemRef dataItemRef = (RQPDataItemRef)dataItemRefs[i];
            RQPDataItem referencedItem = dataItemRef.getNextReferencedItem();
            for (IXQEQueryNode diRef : diRefs = referencedItem.getDescendantsOfType(801009, false)) {
                RQPQuery rqpQuery = ((RQPDataItemRef)diRef).getQuery();
                if (rqpQuery == tabularQuery) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean innerAggregateGroupingCanBeSkipped(V5AggregateFunction outerAggregate) {
        RQPQuery parentOfouterAggregate = RQPNode.getRQPQuery(outerAggregate);
        IXQEQueryNode[] currentQueryGroupingItems = parentOfouterAggregate.getGroupingItems();
        if (currentQueryGroupingItems == null || currentQueryGroupingItems.length == 0) {
            return true;
        }
        IXQEQueryNode[] dataItemRefs = outerAggregate.getDescendantsOfType(801009, true);
        for (int i = 0; i < dataItemRefs.length; ++i) {
            RQPDataItemRef dataItemRef = (RQPDataItemRef)dataItemRefs[i];
            RQPDataItem referencedItem = dataItemRef.getNextReferencedItem();
            RQPQuery referencedQuery = (RQPQuery)referencedItem.getParent().getParent();
            IXQEQueryNode[] referencedQueryGrouping = referencedQuery.getGroupingItems();
            if (referencedQueryGrouping == null || referencedQueryGrouping.length == 0) {
                return false;
            }
            if (referencedQueryGrouping.length < currentQueryGroupingItems.length) {
                return false;
            }
            if (RewriteNestedMaxMinSum.currentQueryGroupingSupportedByReferencedQuery(currentQueryGroupingItems, referencedQueryGrouping)) continue;
            return false;
        }
        return true;
    }

    public static boolean currentQueryGroupingSupportedByReferencedQuery(IXQEQueryNode[] currentQueryGrouping, IXQEQueryNode[] referencedQueryGrouping) {
        for (int i = 0; i < currentQueryGrouping.length; ++i) {
            boolean supported = false;
            for (int j = 0; j < referencedQueryGrouping.length && !supported; ++j) {
                if (!RQPSummaryQuery.isSameGroupingColumnExpression(currentQueryGrouping[i], referencedQueryGrouping[j])) continue;
                supported = true;
            }
            if (supported) continue;
            return false;
        }
        return true;
    }

    private boolean nestedAggregateIsSameSubType(V5AggregateFunction aggregate) {
        IXQEQueryNode[] dataItemRefs = aggregate.getDescendantsOfType(801009, true);
        for (int i = 0; i < dataItemRefs.length; ++i) {
            RQPDataItemRef dataItemRef = (RQPDataItemRef)dataItemRefs[i];
            IXQEQueryNode refExpression = dataItemRef.getNextReferencedItem();
            if (refExpression.getType() != 801008) {
                return false;
            }
            if ((refExpression = ((RQPDataItem)refExpression).getExpression()).getType() != 201031) {
                return false;
            }
            V5AggregateFunction nestedAggregate = (V5AggregateFunction)refExpression;
            if (nestedAggregate.getSubType() == aggregate.getSubType()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] dataItemRefs = node.getDescendantsOfType(801009, true);
        ArrayList<IXQEQueryNode> aggregates = new ArrayList<IXQEQueryNode>();
        DetectNoOpAggregates.getTopAggregatesOfType(node.getChildren(), 201031, aggregates);
        RQPQuery lowestLevelSQ = RQPNode.getRQPQuery(node).getLowestLevelSummaryQuery();
        for (IXQEQueryNode iter : dataItemRefs) {
            RQPDataItemRef dataItemRef = (RQPDataItemRef)iter;
            V5AggregateFunction aggregate = (V5AggregateFunction)dataItemRef.getNextReferencedItem().getExpression();
            if (!aggregates.contains(aggregate)) continue;
            RQPDataItemRef refToLLSQ = this.getOrCreateAggregateInLowestLevelSQ(environment, node, lowestLevelSQ, aggregate, dataItemRef.getName());
            dataItemRef.exchange(refToLLSQ);
        }
    }
}

