/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.PushDetailExpressionToTabularQuery;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;

public class RewriteTabularReferencesInTermsOfSummaryQuery
extends RQPTransformation {
    public RewriteTabularReferencesInTermsOfSummaryQuery() {
        this.mName = "RewriteTabularReferencesInTermsAggregateSummaryQuery";
        this.mPassNumbers = new int[]{90};
        this.mTypes = new int[]{801024};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        RQPSummaryQuery summaryQuery = (RQPSummaryQuery)node;
        if (summaryQuery.isLowestLevelSummaryQuery()) {
            return false;
        }
        IXQEQueryNode[] dataItemRefs = node.getDescendantsOfType(801009, false);
        String subqueryName = null;
        boolean tabularQuery = false;
        for (IXQEQueryNode dir : dataItemRefs) {
            IXQEQueryNode[] aggregateDataItemRefs;
            RQPDataItem di;
            RQPDataItemRef dataItemRef = (RQPDataItemRef)dir;
            String name = dataItemRef.getQueryName();
            RQPQuery refQuery = dataItemRef.getQuery();
            if (refQuery.isSummarizedQuery() || refQuery.isSubqueryForSummaryFilters()) {
                if (subqueryName != null && !subqueryName.equals(name)) {
                    return false;
                }
                subqueryName = name;
                continue;
            }
            tabularQuery = true;
            IXQEQueryNode dataItem = dataItemRef.getAncestorOfType(801008);
            if (dataItem != null && (di = (RQPDataItem)dataItem).isGroupingItem()) {
                return false;
            }
            if (RQPUtilities.dataItemReferencesAMeasure(dataItemRef)) {
                return false;
            }
            int[] ancestorTypes = new int[]{201031, 201033, 201035, 301034, 801008};
            IXQEQueryNode aggregate = dataItemRef.getAncestorOfTypes(ancestorTypes);
            if (aggregate instanceof RQPDataItem) continue;
            boolean refersToSummaryQuery = false;
            for (IXQEQueryNode adir : aggregateDataItemRefs = aggregate.getDescendantsOfType(801009, false)) {
                RQPDataItemRef aggregateDataItemRef = (RQPDataItemRef)adir;
                RQPQuery aggregateRefQuery = aggregateDataItemRef.getQuery();
                if (!aggregateRefQuery.isSummarizedQuery() && !aggregateRefQuery.isSubqueryForSummaryFilters()) continue;
                refersToSummaryQuery = true;
            }
            if (refersToSummaryQuery) continue;
            return false;
        }
        return subqueryName != null && tabularQuery;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery refQuery;
        RQPDataItemRef dataItemRef;
        RQPProjectionList projectionList = ((RQPQuery)node).getProjectionList();
        IXQEQueryNode[] dataItemRefs = projectionList.getDescendantsOfType(801009, true);
        RQPQuery summaryQuery = null;
        for (IXQEQueryNode dir : dataItemRefs) {
            dataItemRef = (RQPDataItemRef)dir;
            refQuery = dataItemRef.getQuery();
            if (refQuery.isTabularQuery()) continue;
            summaryQuery = refQuery;
            if (refQuery.getType() == 801024 && ((RQPSummaryQuery)refQuery).isLowestLevelSummaryQuery()) break;
        }
        for (IXQEQueryNode dir : dataItemRefs) {
            dataItemRef = (RQPDataItemRef)dir;
            refQuery = dataItemRef.getQuery();
            if (!refQuery.isTabularQuery()) continue;
            RQPDataItem dataItem = dataItemRef.getReferencedItem();
            IXQEQueryNode expression = dataItem.getExpression();
            String preferredName = RQPSummaryQuery.getDataItemName(summaryQuery, expression);
            RQPDataItem newRQPDataItem = summaryQuery.getRQPDataItem(environment, expression, preferredName);
            RQPDataItemRef newDIRef = RQPDataItemRef.create(environment, newRQPDataItem);
            dataItemRef.exchange(newDIRef);
            IXQEQueryNode newExpression = newRQPDataItem.getChild(0);
            PushDetailExpressionToTabularQuery transformation = new PushDetailExpressionToTabularQuery();
            if (newExpression instanceof V5BoundModelIdentifier && transformation.passesNodeCondition(newExpression, environment)) {
                transformation.apply(newExpression, environment);
            }
            if (summaryQuery.getGroupByList() == null || !(summaryQuery instanceof RQPSummaryQuery) || ((RQPSummaryQuery)summaryQuery).getGroupingItem(newRQPDataItem.getName()) != null) continue;
            if (((RQPSummaryQuery)summaryQuery).isLowestLevelSummaryQuery()) {
                RQPDataItemSelfRef selfRef = RQPDataItemSelfRef.create(environment, newRQPDataItem.getName());
                summaryQuery.addToGroupByList(environment, selfRef);
                continue;
            }
            RewriteTabularReferencesInTermsOfSummaryQuery.applyMINToExpression(environment, newRQPDataItem.getChild(0));
        }
        if (summaryQuery.getType() == 801017 && summaryQuery.isSubqueryForSummaryFilters()) {
            this.apply((IXQEQueryNode)summaryQuery, environment);
        }
    }

    private static void applyMINToExpression(PlanningEnvironment environment, IXQEQueryNode expr) {
        V5ValueSummaryFunction summaryFunction = (V5ValueSummaryFunction)environment.getNodeFactory().createNode(201031);
        int v5AggregateFunctionSubtypeCode = RQPUtilities.convertAggregateNameToV5AggregateFunctionSubtype("minimum");
        summaryFunction.setSubType(v5AggregateFunctionSubtypeCode);
        expr.insertParent(summaryFunction);
    }
}

