/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.prePlan;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPPrePlan;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.PrePlanResult;

public class MoveToCubeWrapper
extends RQPTransformation {
    public MoveToCubeWrapper(int[] passNumbers) {
        this.mName = "PrePlan-MoveToCubeWrapper.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{101072};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] projections;
        MDXQuery mdxQuery = (MDXQuery)node.getParent();
        MDXFromCube fromCube = mdxQuery.getMDXFrom();
        CubeWrapper cube = (CubeWrapper)fromCube.getCube();
        RQPPrePlan prePlan = (RQPPrePlan)environment.getNodeFactory().createNode(801048);
        cube.setRQPPrePlanQuery(prePlan);
        IXQEQueryNode prePlanContent = node.getChild(0);
        RQPQuery rqpQuery = (RQPQuery)prePlanContent.getFirstChildByType(801017);
        RQPProjectionList rqpProjectionList = (RQPProjectionList)rqpQuery.getFirstChildByType(801016);
        V5Query v5Query = (V5Query)prePlanContent.getFirstChildByType(101006);
        V5Selection v5Selection = (V5Selection)v5Query.getFirstChildByType(101009);
        for (IXQEQueryNode projection : projections = rqpProjectionList.getChildren()) {
            RQPDataItem dataItem = (RQPDataItem)projection;
            V5DataItem v5DataItem = v5Selection.getDataItemByRefName(dataItem.getName());
            String originalMetadataIdentifierValue = (String)v5DataItem.getPropertyValue("originalMetadataIdentifier");
            dataItem.setPropertyValue("originalMetadataIdentifier", originalMetadataIdentifierValue);
        }
        prePlanContent.removeFromIndex();
        prePlanContent.move(prePlan);
        Object cachingResult = node.getPropertyValue("cachingResult");
        if (cachingResult != null) {
            ((PrePlanResult)cachingResult).endCaching(environment, prePlan);
        }
        node.detach();
        node.removeFromIndex();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        this.traceNodeCondition(true, "The V5PREPLAN will be moved out of the query tree.", xqeTrace);
        return true;
    }
}

