/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDetailFilterList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqe.rsapi.IRSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.Governors;
import java.util.List;
import java.util.Locale;

public class MDOLogger {
    private static final String NEWLINE = "\r\n";
    private static final XQELogger TRACE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MasterDetailOptimization", LogLevel.INFO);

    public static boolean isMDODiagnosticOn(IPlanningEnvironment planningEnvironment) {
        return TRACE_LOGGER.isOn(LogLevel.INFO);
    }

    public static boolean isKeyTransformationSeverity(IPlanningEnvironment planningEnvironment) {
        int maxSeverityLevel = planningEnvironment.getRequestEnvironment().getMaxSeverityLevel();
        return maxSeverityLevel == 2;
    }

    public static void logMDOFeedback(PlanningEnvironment planningEnvironment, IXQEQueryNode masterDetailLink, MasterDetailLink link) {
        boolean isKeyTransformation = MDOLogger.isKeyTransformationSeverity(planningEnvironment);
        boolean isMDODiagnosticOn = MDOLogger.isMDODiagnosticOn(planningEnvironment);
        if (isKeyTransformation || isMDODiagnosticOn) {
            String logMsg1 = null;
            String logMsg2 = null;
            Governors.MasterDetailOptimization value = masterDetailLink.getGovernors().getMasterDetailOptimization();
            Locale locale = XQEMessages.getCurrProductLocale();
            logMsg1 = XQEMessages.getMessage(XQEMessageKeys.MDO_GovernorValue, locale, value.toString());
            if (value.equals((Object)Governors.MasterDetailOptimization.CACHE_RELATIONAL_DETAIL_QUERY) && link.isParameterLink()) {
                IMessageKey.Param1 message = XQEMessageKeys.MDO_NotSupportedForDataItemToParameterLink;
                String detailQueryName = link.getDetailQueryName();
                logMsg2 = XQEMessages.getMessage(message, locale, detailQueryName);
            }
            if (isKeyTransformation) {
                ((ExecutionEnvironment)planningEnvironment.getExecutionEnvironment()).addMDONag(logMsg1);
                if (logMsg2 != null) {
                    ((ExecutionEnvironment)planningEnvironment.getExecutionEnvironment()).addMDONag(logMsg2);
                }
            }
            if (isMDODiagnosticOn) {
                MDOLogger.logToXQELog(logMsg1);
                if (logMsg2 != null) {
                    MDOLogger.logToXQELog(logMsg2);
                }
            }
        }
    }

    public static void logMDOWillBeApplied(PlanningEnvironment environment, List<IXQEQueryNode> masterDetailFilters) {
        boolean isKeyTransformation = MDOLogger.isKeyTransformationSeverity(environment);
        boolean isMDODiagnosticOn = MDOLogger.isMDODiagnosticOn(environment);
        if (isKeyTransformation || isMDODiagnosticOn) {
            String logMsg = null;
            IXQEQueryNode filter = masterDetailFilters.get(0);
            IXQEQueryNode comparisonNode = filter.getFirstChildByType(201013);
            comparisonNode.setPropertyValue("useQueryReuse", Boolean.TRUE);
            String linkName = (String)comparisonNode.getPropertyValue("masterDetailLinkName");
            MasterDetailProvider mdProvider = ((RequestEnvironment)environment.getRequestEnvironment()).getMasterDetailProvider();
            MasterDetailLink mdLink = mdProvider.getLink(linkName);
            String detailQueryName = mdLink.getDetailQueryNameOrig();
            String detailQrdName = mdLink.getDetailQrdName();
            String masterQueryName = mdLink.getMasterQueryNameOrig();
            String masterQrdName = mdLink.getMasterQrdName();
            IMessageKey.Param4 message = XQEMessageKeys.MDO_EnabledOnDetailDataItem;
            Locale locale = XQEMessages.getCurrProductLocale();
            logMsg = XQEMessages.getMessage(message, locale, detailQueryName, detailQrdName, masterQueryName, masterQrdName);
            if (isKeyTransformation) {
                ((ExecutionEnvironment)environment.getExecutionEnvironment()).addMDONag(logMsg);
            }
            if (isMDODiagnosticOn) {
                MDOLogger.logToXQELog(logMsg);
            }
        }
    }

    public static void logDetailDataItemNotProjected(PlanningEnvironment environment, IXQEQueryNode comparisonNode) {
        Object property;
        boolean isKeyTransformation = MDOLogger.isKeyTransformationSeverity(environment);
        boolean isMDODiagnosticOn = MDOLogger.isMDODiagnosticOn(environment);
        if ((isKeyTransformation || isMDODiagnosticOn) && (property = comparisonNode.getPropertyValue("masterDetailLinkName")) != null) {
            String linkName = (String)property;
            MasterDetailProvider mdProvider = ((RequestEnvironment)environment.getRequestEnvironment()).getMasterDetailProvider();
            MasterDetailLink mdLink = mdProvider.getLink(linkName);
            String linkNameForMessage = mdLink.getNameForMessage();
            String detailItemNameForMessage = mdLink.getDetailNameForMessage();
            String detailQueryName = mdLink.getDetailQueryNameOrig();
            String detailQrdName = mdLink.getDetailQrdName();
            IMessageKey.Param4 message = XQEMessageKeys.MDO_DisabledDetailDataItemMustBeProjected;
            Locale locale = XQEMessages.getCurrProductLocale();
            String logMsg = XQEMessages.getMessage(message, locale, detailQueryName, detailQrdName, detailItemNameForMessage, linkNameForMessage);
            ((ExecutionEnvironment)environment.getExecutionEnvironment()).addMDONag(logMsg);
        }
    }

    public static void logMDODisabledAllDataItemMustBeProjected(PlanningEnvironment planningEnvironment, List<IXQEQueryNode> masterDetailFilters) {
        boolean isKeyTransformation = MDOLogger.isKeyTransformationSeverity(planningEnvironment);
        boolean isMDODiagnosticOn = MDOLogger.isMDODiagnosticOn(planningEnvironment);
        if (isKeyTransformation || isMDODiagnosticOn) {
            RequestEnvironment requestEnvironment = (RequestEnvironment)planningEnvironment.getRequestEnvironment();
            IXQEQueryNode masterDetailFilter = masterDetailFilters.get(0);
            IXQEQueryNode comparisonNode = masterDetailFilter.getFirstChildByType(201013);
            String linkName = (String)comparisonNode.getPropertyValue("masterDetailLinkName");
            MasterDetailLink mdLink = requestEnvironment.getMasterDetailProvider().getLink(linkName);
            String detailQueryName = mdLink.getDetailQueryNameOrig();
            String detailQrdName = mdLink.getDetailQrdName();
            Locale locale = XQEMessages.getCurrProductLocale();
            IMessageKey.Param2 message = XQEMessageKeys.MDO_DisabledAllDetailDataItemMustBeProjected;
            String logMsg = XQEMessages.getMessage(message, locale, detailQueryName, detailQrdName);
            if (isKeyTransformation) {
                ((ExecutionEnvironment)planningEnvironment.getExecutionEnvironment()).addMDONag(logMsg);
            }
            if (isMDODiagnosticOn) {
                MDOLogger.logToXQELog(logMsg);
            }
        }
    }

    public static void logMDODisabledNoDataItemToDataItemLink(PlanningEnvironment planningEnvironment, RQPDetailFilterList filterList) {
        boolean isKeyTransformation = MDOLogger.isKeyTransformationSeverity(planningEnvironment);
        boolean isMDODiagnosticOn = MDOLogger.isMDODiagnosticOn(planningEnvironment);
        if (isKeyTransformation || isMDODiagnosticOn) {
            RQPQuery rqpQuery = (RQPQuery)filterList.getAncestorOfType(801017);
            Locale locale = XQEMessages.getCurrProductLocale();
            String logMsg = XQEMessages.getMessage(XQEMessageKeys.MDO_DisabledNoDataItemToDataItemLink, locale, rqpQuery.getName());
            if (isKeyTransformation) {
                ((ExecutionEnvironment)planningEnvironment.getExecutionEnvironment()).addMDONag(logMsg);
            }
            if (isMDODiagnosticOn) {
                MDOLogger.logToXQELog(logMsg);
            }
        }
    }

    public static void logMDODisabledLocalCacheNo(PlanningEnvironment planningEnvironment, IXQEQueryNode rqpSQL) {
        boolean isKeyTransformation = MDOLogger.isKeyTransformationSeverity(planningEnvironment);
        boolean isMDODiagnosticOn = MDOLogger.isMDODiagnosticOn(planningEnvironment);
        if (isKeyTransformation || isMDODiagnosticOn) {
            IRSAPIDataset dataSet = (IRSAPIDataset)rqpSQL.getAncestorOfType(401005);
            String queryName = dataSet.getRefQueryName();
            Locale locale = XQEMessages.getCurrProductLocale();
            String logMsg = XQEMessages.getMessage(XQEMessageKeys.MDO_DisabledLocalCacheNo, locale, queryName);
            if (isKeyTransformation) {
                ((ExecutionEnvironment)planningEnvironment.getExecutionEnvironment()).addMDONag(logMsg);
            }
            if (isMDODiagnosticOn) {
                MDOLogger.logToXQELog(logMsg);
            }
        }
    }

    public static void logMDODisabledQueryReuseSwitchFalse(PlanningEnvironment planningEnvironment) {
        boolean isKeyTransformation = MDOLogger.isKeyTransformationSeverity(planningEnvironment);
        boolean isMDODiagnosticOn = MDOLogger.isMDODiagnosticOn(planningEnvironment);
        if (isKeyTransformation || isMDODiagnosticOn) {
            Locale locale = XQEMessages.getCurrProductLocale();
            String logMsg = XQEMessages.getMessage(XQEMessageKeys.MDO_DisabledQueryReuseSwitchFalse, locale);
            if (isKeyTransformation) {
                ((ExecutionEnvironment)planningEnvironment.getExecutionEnvironment()).addMDONag(logMsg);
            }
            if (isMDODiagnosticOn) {
                MDOLogger.logToXQELog(logMsg);
            }
        }
    }

    public static void logMDODisabledNotGroupBy(PlanningEnvironment planningEnvironment, RQPQuery rqpQuery) {
        boolean isKeyTransformation = MDOLogger.isKeyTransformationSeverity(planningEnvironment);
        boolean isMDODiagnosticOn = MDOLogger.isMDODiagnosticOn(planningEnvironment);
        if (isKeyTransformation || isMDODiagnosticOn) {
            IRSAPIDataset dataSet = (IRSAPIDataset)rqpQuery.getAncestorOfType(401005);
            Locale locale = XQEMessages.getCurrProductLocale();
            String logMsg = XQEMessages.getMessage(XQEMessageKeys.MDO_DisabledDueToNonGrouped, locale, rqpQuery.getName(), dataSet.getName());
            if (isKeyTransformation) {
                ((ExecutionEnvironment)planningEnvironment.getExecutionEnvironment()).addMDONag(logMsg);
            }
            if (isMDODiagnosticOn) {
                MDOLogger.logToXQELog(logMsg);
            }
        }
    }

    public static void logMDODisabledParameters(PlanningEnvironment planningEnvironment, IXQEQueryNode rqpNode) {
        boolean isKeyTransformation = MDOLogger.isKeyTransformationSeverity(planningEnvironment);
        boolean isMDODiagnosticOn = MDOLogger.isMDODiagnosticOn(planningEnvironment);
        if (isKeyTransformation || isMDODiagnosticOn) {
            IRSAPIDataset dataSet = (IRSAPIDataset)rqpNode.getAncestorOfType(401005);
            Locale locale = XQEMessages.getCurrProductLocale();
            String logMsg = XQEMessages.getMessage(XQEMessageKeys.MDO_DisabledDueToParameter, locale, dataSet.getRefQueryName(), dataSet.getName());
            if (isKeyTransformation) {
                ((ExecutionEnvironment)planningEnvironment.getExecutionEnvironment()).addMDONag(logMsg);
            }
            if (isMDODiagnosticOn) {
                MDOLogger.logToXQELog(logMsg);
            }
        }
    }

    public static void logMDODisabledUDF(PlanningEnvironment planningEnvironment, IXQEQueryNode rqpSqlNode) {
        boolean isKeyTransformation = MDOLogger.isKeyTransformationSeverity(planningEnvironment);
        boolean isMDODiagnosticOn = MDOLogger.isMDODiagnosticOn(planningEnvironment);
        if (isKeyTransformation || isMDODiagnosticOn) {
            IRSAPIDataset dataSet = (IRSAPIDataset)rqpSqlNode.getAncestorOfType(401005);
            Locale locale = XQEMessages.getCurrProductLocale();
            String logMsg = XQEMessages.getMessage(XQEMessageKeys.MDO_DisabledDueToUDF, locale, dataSet.getRefQueryName(), dataSet.getName());
            if (isKeyTransformation) {
                ((ExecutionEnvironment)planningEnvironment.getExecutionEnvironment()).addMDONag(logMsg);
            }
            if (isMDODiagnosticOn) {
                MDOLogger.logToXQELog(logMsg);
            }
        }
    }

    public static void logMDOCognosSQL(PlanningEnvironment planningEnvironment, RSAPIDataset rsapiDataset, String cognosSQL) {
        boolean isKeyTransformation = MDOLogger.isKeyTransformationSeverity(planningEnvironment);
        boolean isMDODiagnosticOn = MDOLogger.isMDODiagnosticOn(planningEnvironment);
        if (isKeyTransformation || isMDODiagnosticOn) {
            String logMsg = null;
            if (null != rsapiDataset && rsapiDataset.getSqlToMessageFolder()) {
                IMessageKey.Param3 message = XQEMessageKeys.MDO_CognosSQL;
                String queryName = rsapiDataset.getRefQueryName();
                String qrdName = rsapiDataset.getName();
                StringBuilder temp = new StringBuilder();
                temp.append(NEWLINE);
                temp.append(cognosSQL);
                cognosSQL = temp.toString();
                Locale locale = XQEMessages.getCurrProductLocale();
                logMsg = XQEMessages.getMessage(message, locale, queryName, qrdName, cognosSQL);
            }
            if (logMsg != null) {
                if (isKeyTransformation) {
                    ((ExecutionEnvironment)planningEnvironment.getExecutionEnvironment()).addMDONag(logMsg);
                }
                if (isMDODiagnosticOn) {
                    MDOLogger.logToXQELog(logMsg);
                }
            }
        }
    }

    public static void logMDONativeSQL(IPlanningEnvironment planningEnvironment, IRSAPIDataset rsapiDataset, String nativeSQL) {
        boolean isKeyTransformation = MDOLogger.isKeyTransformationSeverity(planningEnvironment);
        boolean isMDODiagnosticOn = MDOLogger.isMDODiagnosticOn(planningEnvironment);
        if (isKeyTransformation || isMDODiagnosticOn) {
            String logMsg = null;
            if (null != rsapiDataset && rsapiDataset.getSqlToMessageFolder()) {
                IMessageKey.Param3 message = XQEMessageKeys.MDO_NativeSQL;
                String queryName = rsapiDataset.getRefQueryName();
                String qrdName = rsapiDataset.getName();
                StringBuilder temp = new StringBuilder();
                temp.append(NEWLINE);
                temp.append(nativeSQL);
                nativeSQL = temp.toString();
                Locale locale = XQEMessages.getCurrProductLocale();
                logMsg = XQEMessages.getMessage(message, locale, queryName, qrdName, nativeSQL);
            }
            if (logMsg != null) {
                if (isKeyTransformation) {
                    planningEnvironment.getExecutionEnvironment().addMDONag(logMsg);
                }
                if (isMDODiagnosticOn) {
                    MDOLogger.logToXQELog(logMsg);
                }
            }
        }
    }

    public static void logToXQELog(String text) {
        TRACE_LOGGER.log(LogLevel.INFO, text);
    }
}

