/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util.determinants;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDeterminant;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Determinants {
    private List<DeterminantInfo> mNeededDetInfos = new ArrayList<DeterminantInfo>();
    private Set<IMetadata> mUnProvidedIds = new TreeSet<IMetadata>();

    public void instantiate(Set<IMetadata> itemIds, boolean useOneDeterminant) {
        this.mNeededDetInfos.clear();
        this.mUnProvidedIds.clear();
        HashMap<IMetadata, Set<IMetadata>> qsToItemIds = new HashMap<IMetadata, Set<IMetadata>>();
        for (IMetadata iMetadata : itemIds) {
            Determinants.recordQuerySubjectReferences(iMetadata, qsToItemIds);
        }
        for (Map.Entry entry : qsToItemIds.entrySet()) {
            IQuerySubject qs = (IQuerySubject)entry.getKey();
            if (!(qs instanceof IQuerySubject)) continue;
            List<IDeterminant> determinantIds = qs.getDeterminants();
            if (useOneDeterminant) {
                this.findDeterminant(determinantIds, (Set)entry.getValue());
                continue;
            }
            this.findDeterminantSet(determinantIds, (Set)entry.getValue());
        }
        if (!this.mNeededDetInfos.isEmpty() && !this.mUnProvidedIds.isEmpty()) {
            String name = "";
            for (IMetadata unProvidedId : this.mUnProvidedIds) {
                if (!(unProvidedId instanceof IQueryItem)) continue;
                if (name.length() > 0) {
                    name = name + ", ";
                }
                name = name + unProvidedId.getV5UniqueName();
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_QueryItemNotReferencedAnyDeterminants, name);
        }
    }

    public void getKeysAndAttributes(List<IMetadata> keys, List<IMetadata> attrs) {
        for (DeterminantInfo detInfo : this.mNeededDetInfos) {
            for (IMetadata key : detInfo.mKeyIds) {
                if (keys.contains(key)) continue;
                keys.add(key);
            }
            for (IMetadata attr : detInfo.mAttrIds) {
                if (keys.contains(attr) || attrs.contains(attr)) continue;
                attrs.add(attr);
            }
        }
    }

    public void getKeysAndAttributes(Set<IMetadata> items) {
        for (DeterminantInfo detInfo : this.mNeededDetInfos) {
            items.addAll(detInfo.mKeyIds);
            items.addAll(detInfo.mAttrIds);
        }
    }

    public void getDeterminantKeys(IMetadata itemId, Set<IMetadata> keySet) {
        for (DeterminantInfo detInfo : this.mNeededDetInfos) {
            if (!detInfo.mKeyIds.contains(itemId) && !detInfo.mAttrIds.contains(itemId)) continue;
            keySet.addAll(detInfo.mKeyIds);
        }
    }

    public boolean mustGroupBy() {
        if (this.mNeededDetInfos.isEmpty()) {
            return false;
        }
        boolean bGroup = this.mNeededDetInfos.get(0).mCanGroup;
        for (DeterminantInfo detInfo : this.mNeededDetInfos) {
            if (bGroup == detInfo.mCanGroup) continue;
            bGroup = true;
            break;
        }
        return bGroup;
    }

    public static void recordQuerySubjectReferences(IMetadata modelItemId, Map<IMetadata, Set<IMetadata>> qsToItemIds) {
        if (!(modelItemId instanceof IQueryItem)) {
            return;
        }
        IQuerySubject qs = ((IQueryItem)modelItemId).getQuerySubject();
        if (!(qs instanceof IQuerySubject)) {
            return;
        }
        if (!qsToItemIds.containsKey(qs)) {
            TreeSet<IMetadata> itemIds = new TreeSet<IMetadata>();
            itemIds.add(modelItemId);
            qsToItemIds.put(qs, itemIds);
        } else {
            qsToItemIds.get(qs).add(modelItemId);
        }
    }

    private void findDeterminant(List<IDeterminant> detIds, Set<IMetadata> itemsNeeded) {
        IDeterminant bestMatchDeterminant = null;
        IDeterminant identifiesRowDeterminant = null;
        for (IDeterminant det : detIds) {
            if (!det.getIdentifiesRow() && !det.getCanGroup()) continue;
            if (identifiesRowDeterminant != null && det.getIdentifiesRow()) {
                identifiesRowDeterminant = det;
            }
            List<IQueryItem> keys = det.getKeys();
            List<IQueryItem> attrs = det.getAttributes();
            TreeSet<IQueryItem> detColumns = new TreeSet<IQueryItem>();
            detColumns.addAll(keys);
            detColumns.addAll(attrs);
            if (detColumns.containsAll(itemsNeeded)) {
                bestMatchDeterminant = det;
                break;
            }
            if (bestMatchDeterminant == null) {
                bestMatchDeterminant = det;
                continue;
            }
            if (!Determinants.determinantAtHigherLevel(det, bestMatchDeterminant)) continue;
            bestMatchDeterminant = det;
        }
        if (bestMatchDeterminant == null && identifiesRowDeterminant != null) {
            bestMatchDeterminant = identifiesRowDeterminant;
        }
        if (bestMatchDeterminant != null) {
            DeterminantInfo info = new DeterminantInfo();
            info.mDet = bestMatchDeterminant;
            info.mKeyIds.addAll(bestMatchDeterminant.getKeys());
            info.mAttrIds.addAll(bestMatchDeterminant.getAttributes());
            info.mCanGroup = bestMatchDeterminant.getCanGroup();
            info.mIdentifiesRow = bestMatchDeterminant.getIdentifiesRow();
            this.mNeededDetInfos.add(info);
        }
    }

    public static boolean determinantAtHigherLevel(IDeterminant det1, IDeterminant det2) {
        List<IQueryItem> detKeys2;
        if (!det1.getIdentifiesRow() && det2.getIdentifiesRow()) {
            return true;
        }
        if (det1.getIdentifiesRow() && !det2.getIdentifiesRow()) {
            return false;
        }
        List<IQueryItem> detKeys1 = det1.getKeys();
        if (detKeys1.containsAll(detKeys2 = det2.getKeys())) {
            return true;
        }
        if (detKeys2.containsAll(detKeys1)) {
            return false;
        }
        return Determinants.determinantFirstInTheList(detKeys1.get(0).getQuerySubject(), det1, det2);
    }

    public static boolean determinantFirstInTheList(IMetadata qs, IDeterminant det1, IDeterminant det2) {
        List<IDeterminant> dets = ((IQuerySubject)qs).getDeterminants();
        for (IDeterminant det : dets) {
            if (det == det1) {
                return true;
            }
            if (det != det2) continue;
            return false;
        }
        return false;
    }

    public IDeterminant getOneDeterminant() {
        if (this.mNeededDetInfos.isEmpty()) {
            return null;
        }
        return this.mNeededDetInfos.get(0).mDet;
    }

    private void findDeterminantSet(List<IDeterminant> detIds, Set<IMetadata> itemsNeeded) {
        TreeSet itemsNeeded0 = (TreeSet)((TreeSet)itemsNeeded).clone();
        IDeterminant uniqueDet = null;
        for (IDeterminant det : detIds) {
            if (det.getIdentifiesRow() && uniqueDet == null) {
                uniqueDet = det;
            }
            List<IQueryItem> keyIds = det.getKeys();
            List<IQueryItem> attrIds = det.getAttributes();
            DeterminantInfo info = new DeterminantInfo();
            Iterator itemsIter = itemsNeeded0.iterator();
            while (itemsIter.hasNext()) {
                IMetadata item = (IMetadata)itemsIter.next();
                if (keyIds.contains(item)) {
                    info.mKeyIds.add(item);
                    itemsIter.remove();
                    continue;
                }
                if (!attrIds.contains(item)) continue;
                info.mAttrIds.add(item);
                itemsIter.remove();
            }
            if (info.mKeyIds.isEmpty() && info.mAttrIds.isEmpty()) continue;
            info.mCanGroup = det.getCanGroup();
            if (info.mCanGroup) {
                info.mKeyIds.addAll(keyIds);
            }
            info.mIdentifiesRow = det.getIdentifiesRow();
            if (info.mIdentifiesRow) {
                info.mAttrIds.clear();
                info.mKeyIds.clear();
                info.mKeyIds.addAll(keyIds);
                for (IMetadata anItemsNeeded : itemsNeeded) {
                    if (info.mKeyIds.contains(anItemsNeeded)) continue;
                    info.mAttrIds.add(anItemsNeeded);
                }
                itemsNeeded0.clear();
                this.mNeededDetInfos.clear();
            }
            this.mNeededDetInfos.add(info);
            if (!itemsNeeded0.isEmpty()) continue;
            return;
        }
        if (!itemsNeeded0.isEmpty()) {
            if (uniqueDet != null) {
                DeterminantInfo info = new DeterminantInfo();
                info.mCanGroup = uniqueDet.getCanGroup();
                info.mIdentifiesRow = uniqueDet.getIdentifiesRow();
                info.mKeyIds.addAll(uniqueDet.getKeys());
                info.mAttrIds.addAll(itemsNeeded);
                this.mNeededDetInfos.clear();
                this.mNeededDetInfos.add(info);
            } else {
                this.mUnProvidedIds.addAll(itemsNeeded0);
            }
        }
    }

    public static void getQueryItemsAtOrAboveTheDeterminant(IMetadata qs, IDeterminant det, List<IMetadata> queryItems, List<IMetadata> keys) {
        IQuerySubject querySubject = null;
        querySubject = qs.getObjectType() == MetadataType.SHORTCUT ? (IQuerySubject)((IShortcut)qs).getTarget() : (IQuerySubject)qs;
        List<IDeterminant> determinants = querySubject.getDeterminants();
        for (IDeterminant dt : determinants) {
            List<IQueryItem> detKeys = dt.getKeys();
            List<IQueryItem> detAttrs = dt.getAttributes();
            queryItems.addAll(detKeys);
            queryItems.addAll(detAttrs);
            keys.addAll(detKeys);
            if (dt != det) continue;
            return;
        }
    }

    class DeterminantInfo {
        private IDeterminant mDet = null;
        private List<IMetadata> mKeyIds = new ArrayList<IMetadata>();
        private List<IMetadata> mAttrIds = new ArrayList<IMetadata>();
        private boolean mCanGroup = false;
        private boolean mIdentifiesRow = false;

        DeterminantInfo() {
        }
    }
}

