/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import java.sql.Connection;
import java.sql.SQLException;

public enum ConnectionType {
    DB2_Z,
    DB2_LUW,
    Oracle,
    Netezza;


    public static ConnectionType getConnectionTypeFor(Connection con) {
        ConnectionType conType = null;
        try {
            if (con != null) {
                String dbProductVersion;
                String url = con.getMetaData().getURL();
                conType = url.contains("oracle") ? Oracle : (url.contains("netezza") ? Netezza : ((dbProductVersion = con.getMetaData().getDatabaseProductVersion().toLowerCase()).indexOf("DSN") != -1 ? DB2_Z : DB2_LUW));
            }
        }
        catch (SQLException e) {
            conType = null;
        }
        return conType;
    }

    public static ConnectionType getConnectionTypeForURL(String url) {
        ConnectionType conType = null;
        if (url != null) {
            String tmpURL = url.toLowerCase();
            conType = tmpURL.contains(":oracle") ? Oracle : (tmpURL.contains(":netezza") ? Netezza : DB2_LUW);
        }
        return conType;
    }

    public String getDriverClassName() {
        String name = null;
        if (Oracle.equals((Object)this)) {
            name = "oracle.jdbc.OracleDriver";
        } else if (Netezza.equals((Object)this)) {
            name = "org.netezza.Driver";
        } else if (DB2_LUW.equals((Object)this) || DB2_Z.equals((Object)this)) {
            name = "com.ibm.db2.jcc.DB2Driver";
        }
        return name;
    }
}

