/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.bibushandler.datasource.DataSourceCapabilities;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.json.JSONAssemblyHelper;
import com.cognos.xqe.data.model.CapabilitiesKey;
import com.cognos.xqe.data.model.CapabilitiesKeyParts;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.IDataProvider;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.providers.relational.TraceRelationalDataProvider;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConnection;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCDataProvider;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.concurrent.Gate;
import com.cognos.xqerdp.flint.FlintDataProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import net.minidev.json.JSONObject;

public class ConnectionUtil {
    public static final char SEMICOLON = ';';
    public static final String SEMICOLON_STR = ";";
    public static final String EQUALS_STR = "=";
    public static final String JSON_CONNSTR_SIGNATURE = ";LOCAL;JSON;";
    private static final ConcurrentMap<CapabilitiesKey, Gate> CAPABILITIES_GATE = new ConcurrentHashMap<CapabilitiesKey, Gate>();
    private static final long DEFAULT_WAIT_TIME = 20L;

    public static void connect(IExecutionEnvironment env, IDataSource dataSource) {
        if (ConnectionUtil.setCollationSequenceFromCache(env, dataSource)) {
            return;
        }
        ConnectionUtil.getCapabilitiesFromColumnarConnection(dataSource);
        IPooledConnection pooledConnection = ConnectionUtil.getPooledConnection(env, dataSource);
        AbstractConnection connection = (AbstractConnection)pooledConnection.getConnection();
        if (connection != null) {
            env.registerDataSourceCollationInformation(connection.getDatabaseCollationSequence(), connection.getConnectionCollationSequence());
        }
        pooledConnection.returnConnection();
    }

    public static boolean getDatabaseCharsetFromCache(IExecutionEnvironment env, IDataSource dataSource, String[] r) {
        Pair p = ConnectionUtil.getCollationSequenceAndCharsetFromCache(env, dataSource);
        if (p != null) {
            r[0] = (String)p.getSecond();
            return true;
        }
        return false;
    }

    private static boolean setCollationSequenceFromCache(IExecutionEnvironment env, IDataSource dataSource) {
        Pair p = ConnectionUtil.getCollationSequenceAndCharsetFromCache(env, dataSource);
        if (p == null) {
            return false;
        }
        env.registerDataSourceCollationInformation((String)p.getFirst(), null);
        return true;
    }

    private static Pair getCollationSequenceAndCharsetFromCache(IExecutionEnvironment env, IDataSource dataSource) {
        if (!DataSourceTypeEnum.isJDBC(dataSource.getType()) && !DataSourceTypeEnum.isFlint(dataSource.getType())) {
            return null;
        }
        IDataProvider provider = ProviderManager.getInstance().getProvider(dataSource.getType());
        if (provider instanceof TraceRelationalDataProvider) {
            provider = ((TraceRelationalDataProvider)provider).getProvider();
        }
        if (!(provider instanceof JDBCDataProvider) && !(provider instanceof FlintDataProvider)) {
            return null;
        }
        if (provider instanceof FlintDataProvider) {
            ConnectionUtil.getCapabilitiesFromColumnarConnection(dataSource);
            return ((FlintDataProvider)provider).getDBCollationSequenceAndCharset(ConnectionUtil.getConnectionString(dataSource), null);
        }
        IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
        if (dsConnection == null || !dsConnection.isModelConnection()) {
            return null;
        }
        IDataSourceCapabilities capabilities = ConnectionUtil.getCapabilitiesFromJDBCConnection(env, dataSource);
        if (capabilities == null) {
            return null;
        }
        dataSource.setCapabilities(capabilities);
        String userId = null;
        if (dsConnection.hasResolvedSignon()) {
            IDataSourceConnectionSignon dataSourceConnectionSignon = dsConnection.getSignon();
            if (dataSourceConnectionSignon == null || !(dataSourceConnectionSignon instanceof IUsernamePasswordSignon)) {
                return null;
            }
            userId = ((IUsernamePasswordSignon)dataSourceConnectionSignon).getUserName();
        } else {
            userId = dsConnection.getDBUserNameFromConnectionElementOrCredential();
        }
        if (userId == null) {
            return null;
        }
        return ((JDBCDataProvider)provider).getDBCollationSequenceAndCharset(ConnectionUtil.getConnectionString(dataSource), userId);
    }

    public static AbstractConnection getConnection(IExecutionEnvironment env, IDataSource dataSource) {
        return (AbstractConnection)ConnectionUtil.getPooledConnection(env, dataSource).getConnection();
    }

    public static IPooledConnection getPooledConnection(IExecutionEnvironment env, IDataSource dataSource) {
        IDataProvider provider = ProviderManager.getInstance().getProvider(dataSource.getType());
        ConnectionParameters parameters = ConnectionUtil.createConnectionParameters(env.getRequestEnvironment().getRunLocale(), dataSource);
        IPooledConnection pooledConnection = provider.borrowConnection(parameters, env);
        return pooledConnection;
    }

    public static ConnectionParameters createConnectionParameters(Locale runLocale, IDataSource dataSource) {
        ConnectionParameters parameters = new ConnectionParameters();
        parameters.put(new DataSourceParameter(dataSource));
        parameters.put(new RunLocaleParameter(runLocale, false));
        return parameters;
    }

    public static String getConnectionString(IDataSource dataSource) {
        IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
        return dsConnection.getConnectionString(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDataSourceCapabilities getCapabilitiesFromJDBCConnection(IExecutionEnvironment executionEnv, IDataSource dataSource) throws DataSourceException {
        CapabilitiesKey capabilitiesKey;
        if (!DataSourceTypeEnum.isJDBC(dataSource.getType())) {
            return null;
        }
        String connectionString = ConnectionUtil.getConnectionString(dataSource);
        ProviderCapabilites providerCapabilitesInstance = ProviderCapabilites.getInstance();
        IDataSourceCapabilities capabilities = providerCapabilitesInstance.getCapabilities(capabilitiesKey = new CapabilitiesKey(null, null, null, connectionString));
        if (capabilities == null) {
            Gate newGate = new Gate();
            Gate gate = CAPABILITIES_GATE.putIfAbsent(capabilitiesKey, newGate);
            if (gate == null) {
                newGate.close();
            } else {
                try {
                    gate.await(20L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                capabilities = providerCapabilitesInstance.getCapabilities(capabilitiesKey);
                if (capabilities != null) {
                    return capabilities;
                }
            }
            IPooledConnection pooledConnection = null;
            try {
                pooledConnection = ConnectionUtil.getPooledConnection(executionEnv, dataSource);
                JDBCConnection jdbcConnection = (JDBCConnection)pooledConnection.getConnection();
                capabilities = jdbcConnection.getCapabilities();
            }
            finally {
                if (pooledConnection != null) {
                    pooledConnection.returnConnection();
                }
                if ((gate = (Gate)CAPABILITIES_GATE.remove(capabilitiesKey)) != null) {
                    gate.open();
                }
            }
        }
        return capabilities;
    }

    public static IDataSourceCapabilities getCapabilitiesFromColumnarConnection(IDataSource dataSource) {
        if (!DataSourceTypeEnum.isColumnar(dataSource.getType()) && !DataSourceTypeEnum.isFlint(dataSource.getType())) {
            return null;
        }
        return ConnectionUtil.getCapabilitiesFromNonJDBCConnection(dataSource);
    }

    public static IDataSourceCapabilities getCapabilitiesFromDummyDataSource(IDataSource dataSource) {
        if (dataSource.getMetadataProperties().get("isDummy") == null) {
            return null;
        }
        return ConnectionUtil.getCapabilitiesFromNonJDBCConnection(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IDataSourceCapabilities getCapabilitiesFromNonJDBCConnection(IDataSource dataSource) {
        CapabilitiesKey capabilitiesKey;
        ProviderCapabilites providerCapabilitesInstance = ProviderCapabilites.getInstance();
        IDataSourceCapabilities capabilities = providerCapabilitesInstance.getCapabilities(capabilitiesKey = new CapabilitiesKey(dataSource.getType(), CapabilitiesKeyParts.NULL_KEY_PARTS, null));
        if (capabilities == null) {
            Gate newGate = new Gate();
            Gate gate = CAPABILITIES_GATE.putIfAbsent(capabilitiesKey, newGate);
            if (gate == null) {
                newGate.close();
            } else {
                try {
                    gate.await(20L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                capabilities = providerCapabilitesInstance.getCapabilities(capabilitiesKey);
                if (capabilities != null) {
                    dataSource.setCapabilities(capabilities);
                    return capabilities;
                }
            }
            try {
                capabilities = new DataSourceCapabilities(dataSource);
            }
            finally {
                gate = (Gate)CAPABILITIES_GATE.remove(capabilitiesKey);
                if (gate != null) {
                    gate.open();
                }
            }
        }
        dataSource.setCapabilities(capabilities);
        return capabilities;
    }

    public static final boolean pointsToAnAssemblyOfConnections(String connectionString) {
        String[] assemblyKeyValuePair = ConnectionUtil.extractKeyValuePair(connectionString, "ASSEMBLY");
        return assemblyKeyValuePair != null && assemblyKeyValuePair[1].compareToIgnoreCase("TRUE") == 0;
    }

    public static final String[] extractKeyValuePair(String connectionString, String key) {
        if (connectionString == null || key == null) {
            return null;
        }
        int kvStartIndx = connectionString.indexOf(key);
        if (kvStartIndx != -1) {
            int kvEndIndx = connectionString.indexOf(59, kvStartIndx);
            String[] keyValuePair = new String[]{};
            keyValuePair = kvEndIndx != -1 ? connectionString.substring(kvStartIndx, kvEndIndx).split(EQUALS_STR) : connectionString.substring(kvStartIndx).split(EQUALS_STR);
            if (keyValuePair.length == 2) {
                return keyValuePair;
            }
        }
        return null;
    }

    public static final Map<String, Object> extractKeyValuePairs(String connectionString, Collection<String> keys) {
        if (keys == null) {
            return null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String key : keys) {
            String[] keyValuePair = ConnectionUtil.extractKeyValuePair(connectionString, key);
            if (keyValuePair == null) continue;
            properties.put(keyValuePair[0], keyValuePair[1]);
        }
        if (properties.isEmpty()) {
            return null;
        }
        return properties;
    }

    public static final Map<String, Object> extractKeyValuePairs(String connectionString) {
        if (connectionString == null) {
            return null;
        }
        String[] tokens = connectionString.split(SEMICOLON_STR);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String token : tokens) {
            if (!token.contains(EQUALS_STR)) continue;
            String key = token.substring(0, token.indexOf(EQUALS_STR));
            String value = token.substring(key.length() + 1);
            properties.put(key, value);
        }
        if (properties.isEmpty()) {
            return null;
        }
        return properties;
    }

    public static final String generateConnectionString(JSONAssemblyHelper jsonAssembly, JSONObject jsonDataset) {
        if (jsonAssembly == null || jsonDataset == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(JSON_CONNSTR_SIGNATURE);
        sb.append("URL");
        sb.append(EQUALS_STR);
        sb.append(jsonAssembly.getDatasetURL(jsonDataset));
        if (jsonAssembly.getDatasetSchema(jsonDataset) != null) {
            sb.append(';');
            sb.append("SCHEMA");
            sb.append(EQUALS_STR);
            sb.append(jsonAssembly.getDatasetSchema(jsonDataset).toString());
        }
        if (jsonAssembly.getRequestMethod(jsonDataset) != null) {
            sb.append(';');
            sb.append("METHOD");
            sb.append(EQUALS_STR);
            sb.append(jsonAssembly.getRequestMethod(jsonDataset).toString());
        }
        if (jsonAssembly.getData(jsonDataset) != null) {
            sb.append(';');
            sb.append("DATA");
            sb.append(EQUALS_STR);
            sb.append(jsonAssembly.getData(jsonDataset).toString());
        }
        if (jsonAssembly.getDatasetMimeType(jsonDataset) != null) {
            sb.append(';');
            sb.append("MIME_TYPE");
            sb.append(EQUALS_STR);
            sb.append(jsonAssembly.getDatasetMimeType(jsonDataset).toString());
        }
        if (jsonAssembly.getDatasetPathExpression(jsonDataset, null) != null) {
            sb.append(';');
            sb.append("PATH");
            sb.append(EQUALS_STR);
            sb.append(jsonAssembly.getDatasetPathExpression(jsonDataset, null).toString());
        }
        return sb.toString();
    }
}

